/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.metrics.storage;

import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.storage.RecordedDeviation;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class MetricsPersister {
    public static final Path a = Paths.get("debug/profiling", new String[0]);
    public static final String b = "metrics";
    public static final String c = "deviations";
    public static final String d = "profiling.txt";
    private static final Logger e = LogUtils.getLogger();
    private final String f;

    public MetricsPersister(String rootFolderName) {
        this.f = rootFolderName;
    }

    public Path a(Set<MetricSampler> samplers, Map<MetricSampler, List<RecordedDeviation>> deviations, MethodProfilerResults results) {
        try {
            Files.createDirectories(a, new FileAttribute[0]);
        }
        catch (IOException var8) {
            throw new UncheckedIOException(var8);
        }
        try {
            Path path = Files.createTempDirectory("minecraft-profiling", new FileAttribute[0]);
            path.toFile().deleteOnExit();
            Files.createDirectories(a, new FileAttribute[0]);
            Path path1 = path.resolve(this.f);
            Path path2 = path1.resolve(b);
            this.a(samplers, path2);
            if (!deviations.isEmpty()) {
                this.a(deviations, path1.resolve(c));
            }
            this.a(results, path1);
            return path;
        }
        catch (IOException var7) {
            throw new UncheckedIOException(var7);
        }
    }

    private void a(Set<MetricSampler> samplers, Path path) {
        if (samplers.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one sampler to persist");
        }
        Map<MetricCategory, List<MetricSampler>> map = samplers.stream().collect(Collectors.groupingBy(MetricSampler::e));
        map.forEach((metricCategory, list) -> this.a((MetricCategory)((Object)metricCategory), (List<MetricSampler>)list, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(MetricCategory category, List<MetricSampler> samplers, Path path) {
        Path path1 = path.resolve(SystemUtils.a(category.a(), MinecraftKey::b) + ".csv");
        BufferedWriter writer = null;
        try {
            Files.createDirectories(path1.getParent(), new FileAttribute[0]);
            writer = Files.newBufferedWriter(path1, StandardCharsets.UTF_8, new OpenOption[0]);
            CSVWriter.a builder = CSVWriter.a();
            builder.a("@tick");
            for (MetricSampler metricSampler : samplers) {
                builder.a(metricSampler.d());
            }
            CSVWriter csvOutput = builder.a(writer);
            List list = samplers.stream().map(MetricSampler::f).collect(Collectors.toList());
            int min = list.stream().mapToInt(MetricSampler.b::a).summaryStatistics().getMin();
            int max = list.stream().mapToInt(MetricSampler.b::b).summaryStatistics().getMax();
            for (int i2 = min; i2 <= max; ++i2) {
                int i1 = i2;
                Stream<String> stream = list.stream().map(samplerResult -> String.valueOf(samplerResult.a(i1)));
                Object[] objects = Stream.concat(Stream.of(String.valueOf(i2)), stream).toArray(String[]::new);
                csvOutput.a(objects);
            }
            e.info("Flushed metrics to {}", (Object)path1);
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (Exception var18) {
            e.error("Could not save profiler results to {}", (Object)path1, (Object)var18);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    private void a(Map<MetricSampler, List<RecordedDeviation>> deviations, Path path) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss.SSS", Locale.UK).withZone(ZoneId.systemDefault());
        deviations.forEach((metricSampler, list) -> list.forEach(recordedDeviation -> {
            String string = dateTimeFormatter.format(recordedDeviation.a);
            Path path1 = path.resolve(SystemUtils.a(metricSampler.d(), MinecraftKey::b)).resolve(String.format(Locale.ROOT, "%d@%s.txt", recordedDeviation.b, string));
            recordedDeviation.c.a(path1);
        }));
    }

    private void a(MethodProfilerResults results, Path outputPath) {
        results.a(outputPath.resolve(d));
    }
}

