/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;

public class WeightedRandom2 {
    private WeightedRandom2() {
    }

    public static <T> int a(List<T> elements, ToIntFunction<T> weightGetter) {
        long l2 = 0L;
        for (T object : elements) {
            l2 += (long)weightGetter.applyAsInt(object);
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l2;
    }

    public static <T> Optional<T> a(RandomSource random, List<T> elements, int totalWeight, ToIntFunction<T> weightGetter) {
        if (totalWeight < 0) {
            throw SystemUtils.b(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int randomInt = random.a(totalWeight);
        return WeightedRandom2.a(elements, randomInt, weightGetter);
    }

    public static <T> Optional<T> a(List<T> elements, int index, ToIntFunction<T> weightGetter) {
        for (T object : elements) {
            if ((index -= weightGetter.applyAsInt(object)) >= 0) continue;
            return Optional.of(object);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> a(RandomSource random, List<T> elements, ToIntFunction<T> weightGetter) {
        return WeightedRandom2.a(random, elements, WeightedRandom2.a(elements, weightGetter), weightGetter);
    }
}

