/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import org.jspecify.annotations.Nullable;

public class ParallelMapTransform {
    private static final int a = 16;

    public static <K, U, V> CompletableFuture<Map<K, V>> a(Map<K, U> inputs, BiFunction<K, U, @Nullable V> operation, int maxTasksPerBatch, Executor executor) {
        int size = inputs.size();
        if (size == 0) {
            return CompletableFuture.completedFuture(Map.of());
        }
        if (size == 1) {
            Map.Entry<K, U> entry = inputs.entrySet().iterator().next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            return CompletableFuture.supplyAsync(() -> {
                Object object = operation.apply(key, value);
                return object != null ? Map.of(key, object) : Map.of();
            }, executor);
        }
        d splitterBase = size <= maxTasksPerBatch ? new c<K, U, V>(operation, size) : new a<K, U, V>(operation, size, maxTasksPerBatch);
        return splitterBase.a(inputs, executor);
    }

    public static <K, U, V> CompletableFuture<Map<K, V>> a(Map<K, U> inputs, BiFunction<K, U, @Nullable V> operation, Executor executor) {
        int i2 = SystemUtils.g() * 16;
        return ParallelMapTransform.a(inputs, operation, i2, executor);
    }

    static class c<K, U, V>
    extends d<K, U, V> {
        c(BiFunction<K, U, V> operation, int size) {
            super(operation, size, size);
        }

        @Override
        protected int a(int batchIndex) {
            return 1;
        }

        @Override
        protected CompletableFuture<?> a(b<K, U, V> container, int lastScheduledIndex, int currentIndex, Executor executor) {
            assert (lastScheduledIndex + 1 == currentIndex);
            return CompletableFuture.runAsync(() -> container.a(lastScheduledIndex), executor);
        }

        @Override
        protected CompletableFuture<Map<K, V>> a(CompletableFuture<?> future, b<K, U, V> container) {
            return future.thenApply(object -> {
                HashMap map = new HashMap(container.a());
                for (int i2 = 0; i2 < container.a(); ++i2) {
                    container.a(i2, map);
                }
                return map;
            });
        }
    }

    static class a<K, U, V>
    extends d<K, U, V> {
        private final Map<K, V> c;
        private final int d;
        private final int e;

        a(BiFunction<K, U, V> operation, int containerSize, int numBatches) {
            super(operation, containerSize, numBatches);
            this.c = new HashMap(containerSize);
            this.d = MathHelper.f(containerSize, numBatches);
            int i2 = this.d * numBatches;
            int i1 = i2 - containerSize;
            this.e = numBatches - i1;
            assert (this.e > 0 && this.e <= numBatches);
        }

        @Override
        protected CompletableFuture<?> a(b<K, U, V> container, int lastScheduledIndex, int currentIndex, Executor executor) {
            int i2 = currentIndex - lastScheduledIndex;
            assert (i2 == this.d || i2 == this.d - 1);
            return CompletableFuture.runAsync(net.minecraft.util.thread.ParallelMapTransform$a.a(this.c, lastScheduledIndex, currentIndex, container), executor);
        }

        @Override
        protected int a(int batchIndex) {
            return batchIndex < this.e ? this.d : this.d - 1;
        }

        private static <K, U, V> Runnable a(Map<K, V> result, int lastScheduledIndex, int currentIndex, b<K, U, V> container) {
            return () -> {
                for (int i2 = lastScheduledIndex; i2 < currentIndex; ++i2) {
                    container.a(i2);
                }
                Map map = result;
                synchronized (map) {
                    for (int i1 = lastScheduledIndex; i1 < currentIndex; ++i1) {
                        container.a(i1, result);
                    }
                }
            };
        }

        @Override
        protected CompletableFuture<Map<K, V>> a(CompletableFuture<?> future, b<K, U, V> container) {
            Map map = this.c;
            return future.thenApply(object -> map);
        }
    }

    static abstract class d<K, U, V> {
        private int a;
        private int c;
        private final CompletableFuture<?>[] d;
        private int e;
        private final b<K, U, V> f;

        d(BiFunction<K, U, V> operation, int containerSize, int numBatches) {
            this.f = new b<K, U, V>(operation, containerSize);
            this.d = new CompletableFuture[numBatches];
        }

        private int a() {
            return this.c - this.a;
        }

        public CompletableFuture<Map<K, V>> a(Map<K, U> inputs, Executor executor) {
            inputs.forEach((key, value) -> {
                this.f.a(this.c++, key, value);
                if (this.a() == this.a(this.e)) {
                    this.d[this.e++] = this.a(this.f, this.a, this.c, executor);
                    this.a = this.c;
                }
            });
            assert (this.c == this.f.a());
            assert (this.a == this.c);
            assert (this.e == this.d.length);
            return this.a(CompletableFuture.allOf(this.d), this.f);
        }

        protected abstract int a(int var1);

        protected abstract CompletableFuture<?> a(b<K, U, V> var1, int var2, int var3, Executor var4);

        protected abstract CompletableFuture<Map<K, V>> a(CompletableFuture<?> var1, b<K, U, V> var2);
    }

    record b<K, U, V>(BiFunction<K, U, V> a, @Nullable Object[] b, @Nullable Object[] c) {
        private final BiFunction<K, U, V> a;
        private final @Nullable Object[] b;
        private final @Nullable Object[] c;

        public b(BiFunction<K, U, V> operation, int size) {
            this(operation, new Object[size], new Object[size]);
        }

        public void a(int index, K key, U value) {
            this.b[index] = key;
            this.c[index] = value;
        }

        private @Nullable K b(int index) {
            return (K)this.b[index];
        }

        private @Nullable V c(int index) {
            return (V)this.c[index];
        }

        private @Nullable U d(int index) {
            return (U)this.c[index];
        }

        public void a(int index) {
            this.c[index] = this.a.apply(this.b(index), this.d(index));
        }

        public void a(int index, Map<K, V> outputMap) {
            V object = this.c(index);
            if (object != null) {
                K object1 = this.b(index);
                outputMap.put(object1, object);
            }
        }

        public int a() {
            return this.b.length;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "operation;keys;values", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "operation;keys;values", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "operation;keys;values", "a", "b", "c"}, this, o2);
        }

        public BiFunction<K, U, V> b() {
            return this.a;
        }

        public @Nullable Object[] c() {
            return this.b;
        }

        public @Nullable Object[] d() {
            return this.c;
        }
    }
}

