/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Reference2FloatMap;
import it.unimi.dsi.fastutil.objects.Reference2FloatMaps;
import it.unimi.dsi.fastutil.objects.Reference2FloatOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RecreatingSimpleRegionStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class WorldUpgrader
implements AutoCloseable {
    static final Logger a = LogUtils.getLogger();
    private static final ThreadFactory b = new ThreadFactoryBuilder().setDaemon(true).build();
    private static final String c = "new_";
    static final IChatBaseComponent d = IChatBaseComponent.c("optimizeWorld.stage.upgrading.poi");
    static final IChatBaseComponent e = IChatBaseComponent.c("optimizeWorld.stage.finished.poi");
    static final IChatBaseComponent f = IChatBaseComponent.c("optimizeWorld.stage.upgrading.entities");
    static final IChatBaseComponent g = IChatBaseComponent.c("optimizeWorld.stage.finished.entities");
    static final IChatBaseComponent h = IChatBaseComponent.c("optimizeWorld.stage.upgrading.chunks");
    static final IChatBaseComponent i = IChatBaseComponent.c("optimizeWorld.stage.finished.chunks");
    final IRegistry<WorldDimension> j;
    final Set<ResourceKey<World>> k;
    final boolean l;
    final boolean m;
    final Convertable.ConversionSession n;
    private final Thread o;
    final DataFixer p;
    volatile boolean q = true;
    private volatile boolean r;
    volatile float s;
    volatile int t;
    volatile int u;
    volatile int v;
    volatile int w;
    final Reference2FloatMap<ResourceKey<World>> x = Reference2FloatMaps.synchronize((Reference2FloatMap)new Reference2FloatOpenHashMap());
    volatile IChatBaseComponent y = IChatBaseComponent.c("optimizeWorld.stage.counting");
    static final Pattern z = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    final WorldPersistentData A;

    public WorldUpgrader(Convertable.ConversionSession levelStorage, DataFixer dataFixer, SaveData worldData, IRegistryCustom registryAccess, boolean eraseCache, boolean recreateRegionFiles) {
        this.j = registryAccess.f(Registries.bF);
        this.k = Stream.of(levelStorage.dimensionType).map(Registries::a).collect(Collectors.toUnmodifiableSet());
        this.l = eraseCache;
        this.p = dataFixer;
        this.n = levelStorage;
        this.A = new WorldPersistentData(this.n.a(World.h).resolve("data"), dataFixer, registryAccess);
        this.m = recreateRegionFiles;
        this.o = b.newThread(this::i);
        this.o.setUncaughtExceptionHandler((thread, throwable) -> {
            a.error("Error upgrading world", throwable);
            this.y = IChatBaseComponent.c("optimizeWorld.stage.failed");
            this.r = true;
        });
        this.o.start();
    }

    public void a() {
        this.q = false;
        try {
            this.o.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void i() {
        long millis = SystemUtils.c();
        a.info("Upgrading entities");
        new d(this).a();
        a.info("Upgrading POIs");
        new f(this).a();
        a.info("Upgrading blocks");
        new b().a();
        this.A.b();
        millis = SystemUtils.c() - millis;
        a.info("World optimizaton finished after {} seconds", (Object)(millis / 1000L));
        this.r = true;
    }

    public boolean b() {
        return this.r;
    }

    public Set<ResourceKey<World>> c() {
        return this.k;
    }

    public float a(ResourceKey<World> level) {
        return this.x.getFloat(level);
    }

    public float d() {
        return this.s;
    }

    public int e() {
        return this.t;
    }

    public int f() {
        return this.v;
    }

    public int g() {
        return this.w;
    }

    public IChatBaseComponent h() {
        return this.y;
    }

    @Override
    public void close() {
        this.A.close();
    }

    static Path a(Path path) {
        return path.resolveSibling(c + path.getFileName().toString());
    }

    class d
    extends g {
        d(WorldUpgrader this$0) {
            super(DataFixTypes.v, "entities", f, g);
        }

        @Override
        protected NBTTagCompound a(SimpleRegionStorage regionStorage, NBTTagCompound chunkTag) {
            return regionStorage.a(chunkTag, -1);
        }
    }

    class f
    extends g {
        f(WorldUpgrader this$0) {
            super(DataFixTypes.t, "poi", d, e);
        }

        @Override
        protected NBTTagCompound a(SimpleRegionStorage regionStorage, NBTTagCompound chunkTag) {
            return regionStorage.a(chunkTag, 1945);
        }
    }

    class b
    extends a {
        b() {
            super(DataFixTypes.d, "chunk", "region", h, i);
        }

        @Override
        protected boolean a(SimpleRegionStorage regionStorage, ChunkCoordIntPair chunkPos, ResourceKey<World> dimension) {
            NBTTagCompound compoundTag = regionStorage.d(chunkPos).join().orElse(null);
            if (compoundTag != null) {
                boolean flag;
                int dataVersion = GameProfileSerializer.f(compoundTag);
                ChunkGenerator chunkGenerator = WorldUpgrader.this.j.g(Registries.b(dimension)).b();
                NBTTagCompound compoundTag1 = regionStorage.upgradeChunkTag(compoundTag, -1, PlayerChunkMap.a(Registries.b(dimension), chunkGenerator.c()), null);
                ChunkCoordIntPair chunkPos1 = new ChunkCoordIntPair(compoundTag1.b("xPos", 0), compoundTag1.b("zPos", 0));
                if (!chunkPos1.equals(chunkPos)) {
                    a.warn("Chunk {} has invalid position {}", (Object)chunkPos, (Object)chunkPos1);
                }
                boolean bl = flag = dataVersion < SharedConstants.b().a().b();
                if (WorldUpgrader.this.l) {
                    flag = flag || compoundTag1.b("Heightmaps");
                    compoundTag1.r("Heightmaps");
                    flag = flag || compoundTag1.b("isLightOn");
                    compoundTag1.r("isLightOn");
                    NBTTagList listOrEmpty = compoundTag1.p("sections");
                    for (int i2 = 0; i2 < listOrEmpty.size(); ++i2) {
                        Optional<NBTTagCompound> compound = listOrEmpty.a(i2);
                        if (compound.isEmpty()) continue;
                        NBTTagCompound compoundTag2 = compound.get();
                        flag = flag || compoundTag2.b("BlockLight");
                        compoundTag2.r("BlockLight");
                        flag = flag || compoundTag2.b("SkyLight");
                        compoundTag2.r("SkyLight");
                    }
                }
                if (flag || WorldUpgrader.this.m) {
                    if (this.a != null) {
                        this.a.join();
                    }
                    this.a = regionStorage.a(chunkPos, compoundTag1);
                    return true;
                }
            }
            return false;
        }

        @Override
        protected SimpleRegionStorage a(RegionStorageInfo regionStorageInfo, Path path) {
            Supplier<LegacyTagFixer> legacyTagFixer = PersistentStructureLegacy.a(regionStorageInfo.b(), () -> WorldUpgrader.this.A, WorldUpgrader.this.p);
            return WorldUpgrader.this.m ? new RecreatingSimpleRegionStorage(regionStorageInfo.a("source"), path, regionStorageInfo.a("target"), WorldUpgrader.a(path), WorldUpgrader.this.p, true, DataFixTypes.d, legacyTagFixer) : new SimpleRegionStorage(regionStorageInfo, path, WorldUpgrader.this.p, true, DataFixTypes.d, legacyTagFixer);
        }
    }

    abstract class g
    extends a {
        g(DataFixTypes dataFixType, String type, IChatBaseComponent upgradingStatus, IChatBaseComponent finishedStatus) {
            super(dataFixType, type, type, upgradingStatus, finishedStatus);
        }

        @Override
        protected SimpleRegionStorage a(RegionStorageInfo regionStorageInfo, Path path) {
            return WorldUpgrader.this.m ? new RecreatingSimpleRegionStorage(regionStorageInfo.a("source"), path, regionStorageInfo.a("target"), WorldUpgrader.a(path), WorldUpgrader.this.p, true, this.b, LegacyTagFixer.a) : new SimpleRegionStorage(regionStorageInfo, path, WorldUpgrader.this.p, true, this.b);
        }

        @Override
        protected boolean a(SimpleRegionStorage regionStorage, ChunkCoordIntPair chunkPos, ResourceKey<World> dimension) {
            NBTTagCompound compoundTag = regionStorage.d(chunkPos).join().orElse(null);
            if (compoundTag != null) {
                boolean flag;
                int dataVersion = GameProfileSerializer.f(compoundTag);
                NBTTagCompound compoundTag1 = this.a(regionStorage, compoundTag);
                boolean bl = flag = dataVersion < SharedConstants.b().a().b();
                if (flag || WorldUpgrader.this.m) {
                    if (this.a != null) {
                        this.a.join();
                    }
                    this.a = regionStorage.a(chunkPos, compoundTag1);
                    return true;
                }
            }
            return false;
        }

        protected abstract NBTTagCompound a(SimpleRegionStorage var1, NBTTagCompound var2);
    }

    record e(RegionFile a, List<ChunkCoordIntPair> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "file;chunksToUpgrade", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "file;chunksToUpgrade", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "file;chunksToUpgrade", "a", "b"}, this, o2);
        }
    }

    record c(ResourceKey<World> a, SimpleRegionStorage b, ListIterator<e> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "dimensionKey;storage;files", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "dimensionKey;storage;files", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "dimensionKey;storage;files", "a", "b", "c"}, this, o2);
        }
    }

    abstract class a {
        private final IChatBaseComponent d;
        private final IChatBaseComponent e;
        private final String f;
        private final String g;
        protected @Nullable CompletableFuture<Void> a;
        protected final DataFixTypes b;

        a(DataFixTypes dataFixType, String type, String folderName, IChatBaseComponent upgradingStatus, IChatBaseComponent finishedStatus) {
            this.b = dataFixType;
            this.f = type;
            this.g = folderName;
            this.d = upgradingStatus;
            this.e = finishedStatus;
        }

        public void a() {
            WorldUpgrader.this.u = 0;
            WorldUpgrader.this.t = 0;
            WorldUpgrader.this.v = 0;
            WorldUpgrader.this.w = 0;
            List<c> dimensionsToUpgrade = this.b();
            if (WorldUpgrader.this.t != 0) {
                float f2 = WorldUpgrader.this.u;
                WorldUpgrader.this.y = this.d;
                while (WorldUpgrader.this.q) {
                    boolean flag = false;
                    float f1 = 0.0f;
                    for (c dimensionToUpgrade : dimensionsToUpgrade) {
                        ResourceKey<World> resourceKey = dimensionToUpgrade.a;
                        ListIterator<e> listIterator = dimensionToUpgrade.c;
                        SimpleRegionStorage simpleRegionStorage = dimensionToUpgrade.b;
                        if (listIterator.hasNext()) {
                            e fileToUpgrade = listIterator.next();
                            boolean flag1 = true;
                            for (ChunkCoordIntPair chunkPos : fileToUpgrade.b) {
                                flag1 = flag1 && this.a(resourceKey, simpleRegionStorage, chunkPos);
                                flag = true;
                            }
                            if (WorldUpgrader.this.m) {
                                if (flag1) {
                                    this.a(fileToUpgrade.a);
                                } else {
                                    a.error("Failed to convert region file {}", (Object)fileToUpgrade.a.a());
                                }
                            }
                        }
                        float f22 = (float)listIterator.nextIndex() / f2;
                        WorldUpgrader.this.x.put(resourceKey, f22);
                        f1 += f22;
                    }
                    WorldUpgrader.this.s = f1;
                    if (flag) continue;
                    break;
                }
                WorldUpgrader.this.y = this.e;
                for (c dimensionToUpgrade1 : dimensionsToUpgrade) {
                    try {
                        dimensionToUpgrade1.b.close();
                    }
                    catch (Exception var14) {
                        a.error("Error upgrading chunk", (Throwable)var14);
                    }
                }
            }
        }

        private List<c> b() {
            ArrayList list = Lists.newArrayList();
            for (ResourceKey<World> resourceKey : WorldUpgrader.this.k) {
                RegionStorageInfo regionStorageInfo = new RegionStorageInfo(WorldUpgrader.this.n.f(), resourceKey, this.f);
                Path path = WorldUpgrader.this.n.a(resourceKey).resolve(this.g);
                SimpleRegionStorage simpleRegionStorage = this.a(regionStorageInfo, path);
                ListIterator<e> filesToProcess = this.b(regionStorageInfo, path);
                list.add(new c(resourceKey, simpleRegionStorage, filesToProcess));
            }
            return list;
        }

        protected abstract SimpleRegionStorage a(RegionStorageInfo var1, Path var2);

        private ListIterator<e> b(RegionStorageInfo regionStorageInfo, Path path) {
            List<e> allChunkPositions = net.minecraft.util.worldupdate.WorldUpgrader$a.c(regionStorageInfo, path);
            WorldUpgrader.this.u += allChunkPositions.size();
            WorldUpgrader.this.t += allChunkPositions.stream().mapToInt(fileToUpgrade -> fileToUpgrade.b.size()).sum();
            return allChunkPositions.listIterator();
        }

        private static List<e> c(RegionStorageInfo regionStorageInfo, Path path) {
            File[] files = path.toFile().listFiles((directory, filename) -> filename.endsWith(".mca"));
            if (files == null) {
                return List.of();
            }
            ArrayList list = Lists.newArrayList();
            for (File file : files) {
                Matcher matcher = z.matcher(file.getName());
                if (!matcher.matches()) continue;
                int i2 = Integer.parseInt(matcher.group(1)) << 5;
                int i1 = Integer.parseInt(matcher.group(2)) << 5;
                ArrayList list1 = Lists.newArrayList();
                try (RegionFile regionFile = new RegionFile(regionStorageInfo, file.toPath(), path, true);){
                    for (int i22 = 0; i22 < 32; ++i22) {
                        for (int i3 = 0; i3 < 32; ++i3) {
                            ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(i22 + i2, i3 + i1);
                            if (!regionFile.b(chunkPos)) continue;
                            list1.add(chunkPos);
                        }
                    }
                    if (list1.isEmpty()) continue;
                    list.add(new e(regionFile, list1));
                }
                catch (Throwable var18) {
                    a.error("Failed to read chunks from region file {}", (Object)file.toPath(), (Object)var18);
                }
            }
            return list;
        }

        private boolean a(ResourceKey<World> dimension, SimpleRegionStorage regionStorage, ChunkCoordIntPair chunkPos) {
            boolean flag = false;
            try {
                flag = this.a(regionStorage, chunkPos, dimension);
            }
            catch (CompletionException | ReportedException var7) {
                Throwable cause = var7.getCause();
                if (!(cause instanceof IOException)) {
                    throw var7;
                }
                a.error("Error upgrading chunk {}", (Object)chunkPos, (Object)cause);
            }
            if (flag) {
                ++WorldUpgrader.this.v;
            } else {
                ++WorldUpgrader.this.w;
            }
            return flag;
        }

        protected abstract boolean a(SimpleRegionStorage var1, ChunkCoordIntPair var2, ResourceKey<World> var3);

        private void a(RegionFile regionFile) {
            if (WorldUpgrader.this.m) {
                if (this.a != null) {
                    this.a.join();
                }
                Path path = regionFile.a();
                Path parent = path.getParent();
                Path path1 = WorldUpgrader.a(parent).resolve(path.getFileName().toString());
                try {
                    if (path1.toFile().exists()) {
                        Files.delete(path);
                        Files.move(path1, path, new CopyOption[0]);
                    } else {
                        a.error("Failed to replace an old region file. New file {} does not exist.", (Object)path1);
                    }
                }
                catch (IOException var6) {
                    a.error("Failed to replace an old region file", (Throwable)var6);
                }
            }
        }
    }
}

