/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;

public class InventorySubcontainer
implements IInventory,
AutoRecipeOutput {
    private final int b;
    public final NonNullList<ItemStack> c;
    private @Nullable List<IInventoryListener> d;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;
    protected @Nullable InventoryHolder bukkitOwner;
    private @Nullable Supplier<? extends InventoryHolder> bukkitOwnerCreator;

    @Override
    public List<ItemStack> getContents() {
        return this.c;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ap_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public @Nullable InventoryHolder getOwner() {
        if (this.bukkitOwner == null && this.bukkitOwnerCreator != null) {
            this.bukkitOwner = this.bukkitOwnerCreator.get();
        }
        return this.bukkitOwner;
    }

    @Override
    public @Nullable Location getLocation() {
        InventoryHolder inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof BlockInventoryHolder) {
            BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)inventoryHolder;
            return blockInventoryHolder.getBlock().getLocation();
        }
        inventoryHolder = this.bukkitOwner;
        if (inventoryHolder instanceof Entity) {
            Entity entity = (Entity)inventoryHolder;
            return entity.getLocation();
        }
        return null;
    }

    public InventorySubcontainer(InventorySubcontainer original) {
        this(original.b);
        for (int slot = 0; slot < original.b; ++slot) {
            this.c.set(slot, original.c.get(slot).v());
        }
    }

    public InventorySubcontainer(int size) {
        this(size, null);
    }

    public InventorySubcontainer(Supplier<? extends InventoryHolder> bukkitOwnerCreator, int size) {
        this(size);
        this.bukkitOwnerCreator = bukkitOwnerCreator;
    }

    public InventorySubcontainer(int size, @Nullable InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.b = size;
        this.c = NonNullList.a(size, ItemStack.l);
    }

    public InventorySubcontainer(ItemStack ... items) {
        this.b = items.length;
        this.c = NonNullList.a(ItemStack.l, items);
    }

    public void a(IInventoryListener listener) {
        if (this.d == null) {
            this.d = Lists.newArrayList();
        }
        this.d.add(listener);
    }

    public void b(IInventoryListener listener) {
        if (this.d != null) {
            this.d.remove(listener);
        }
    }

    @Override
    public ItemStack a(int index) {
        return index >= 0 && index < this.c.size() ? this.c.get(index) : ItemStack.l;
    }

    public List<ItemStack> g() {
        List<ItemStack> list = this.c.stream().filter(stack -> !stack.f()).collect(Collectors.toList());
        this.a();
        return list;
    }

    @Override
    public ItemStack a(int index, int count) {
        ItemStack itemStack = ContainerUtil.a(this.c, index, count);
        if (!itemStack.f()) {
            this.e();
        }
        return itemStack;
    }

    public ItemStack a(Item item, int amount) {
        ItemStack itemStack = new ItemStack(item, 0);
        for (int i2 = this.b - 1; i2 >= 0; --i2) {
            ItemStack item1 = this.a(i2);
            if (!item1.h().equals(item)) continue;
            int i1 = amount - itemStack.N();
            ItemStack itemStack1 = item1.a(i1);
            itemStack.g(itemStack1.N());
            if (itemStack.N() == amount) break;
        }
        if (!itemStack.f()) {
            this.e();
        }
        return itemStack;
    }

    public ItemStack b(ItemStack stack) {
        if (stack.f()) {
            return ItemStack.l;
        }
        ItemStack itemStack = stack.v();
        this.e(itemStack);
        if (itemStack.f()) {
            return ItemStack.l;
        }
        this.d(itemStack);
        return itemStack.f() ? ItemStack.l : itemStack;
    }

    public boolean c(ItemStack stack) {
        boolean flag = false;
        for (ItemStack itemStack : this.c) {
            if (!itemStack.f() && (!ItemStack.c(itemStack, stack) || itemStack.N() >= itemStack.k())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack b(int index) {
        ItemStack itemStack = this.c.get(index);
        if (itemStack.f()) {
            return ItemStack.l;
        }
        this.c.set(index, ItemStack.l);
        return itemStack;
    }

    @Override
    public void a(int index, ItemStack stack) {
        this.c.set(index, stack);
        stack.f(this.f_(stack));
        this.e();
    }

    @Override
    public int b() {
        return this.b;
    }

    @Override
    public boolean c() {
        for (ItemStack itemStack : this.c) {
            if (itemStack.f()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void e() {
        if (this.d != null) {
            for (IInventoryListener containerListener : this.d) {
                containerListener.a(this);
            }
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    @Override
    public void a() {
        this.c.clear();
        this.e();
    }

    @Override
    public void fillStackedContents(StackedItemContents stackedContents) {
        for (ItemStack itemStack : this.c) {
            stackedContents.b(itemStack);
        }
    }

    public String toString() {
        return this.c.stream().filter(stack -> !stack.f()).collect(Collectors.toList()).toString();
    }

    private void d(ItemStack stack) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            ItemStack item = this.a(i2);
            if (!item.f()) continue;
            this.a(i2, stack.g());
            return;
        }
    }

    private void e(ItemStack stack) {
        for (int i2 = 0; i2 < this.b; ++i2) {
            ItemStack item = this.a(i2);
            if (!ItemStack.c(item, stack)) continue;
            this.a(stack, item);
            if (!stack.f()) continue;
            return;
        }
    }

    private void a(ItemStack stack, ItemStack other) {
        int maxStackSize = this.f_(other);
        int min = Math.min(stack.N(), maxStackSize - other.N());
        if (min > 0) {
            other.g(min);
            stack.h(min);
            this.e();
        }
    }

    public void a(ValueInput.a<ItemStack> input) {
        this.a();
        for (ItemStack itemStack : input) {
            this.b(itemStack);
        }
    }

    public void a(ValueOutput.a<ItemStack> output) {
        for (int i2 = 0; i2 < this.b(); ++i2) {
            ItemStack item = this.a(i2);
            if (item.f()) continue;
            output.a(item);
        }
    }

    public NonNullList<ItemStack> h() {
        return this.c;
    }
}

