/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;

public class RandomSequences
extends PersistentBase {
    public static final Codec<RandomSequences> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("salt").forGetter(RandomSequences::b), (App)Codec.BOOL.optionalFieldOf("include_world_seed", (Object)true).forGetter(RandomSequences::c), (App)Codec.BOOL.optionalFieldOf("include_sequence_id", (Object)true).forGetter(RandomSequences::d), (App)Codec.unboundedMap(MinecraftKey.a, RandomSequence.a).fieldOf("sequences").forGetter(randomSequences -> randomSequences.f)).apply((Applicative)instance, RandomSequences::new));
    public static final SavedDataType<RandomSequences> b = new SavedDataType<RandomSequences>("random_sequences", RandomSequences::new, a, DataFixTypes.n);
    private int c;
    private boolean d = true;
    private boolean e = true;
    private final Map<MinecraftKey, RandomSequence> f = new Object2ObjectOpenHashMap();

    public RandomSequences() {
    }

    private RandomSequences(int salt, boolean includeWorldSeed, boolean includeSequenceId, Map<MinecraftKey, RandomSequence> sequences) {
        this.c = salt;
        this.d = includeWorldSeed;
        this.e = includeSequenceId;
        this.f.putAll(sequences);
    }

    public RandomSource a(MinecraftKey location, long seed) {
        RandomSource randomSource = this.f.computeIfAbsent(location, identifier -> this.c((MinecraftKey)identifier, seed)).a();
        return new a(randomSource);
    }

    private RandomSequence c(MinecraftKey location, long seed) {
        return this.b(location, seed, this.c, this.d, this.e);
    }

    private RandomSequence b(MinecraftKey location, long seed, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        long l2 = (includeWorldSeed ? seed : 0L) ^ (long)salt;
        return new RandomSequence(l2, includeSequenceId ? Optional.of(location) : Optional.empty());
    }

    public void a(BiConsumer<MinecraftKey, RandomSequence> action) {
        this.f.forEach(action);
    }

    public void a(int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        this.c = salt;
        this.d = includeWorldSeed;
        this.e = includeSequenceId;
    }

    public int a() {
        int size = this.f.size();
        this.f.clear();
        return size;
    }

    public void b(MinecraftKey sequence, long seed) {
        this.f.put(sequence, this.c(sequence, seed));
    }

    public void a(MinecraftKey sequence, long seed, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        this.f.put(sequence, this.b(sequence, seed, salt, includeWorldSeed, includeSequenceId));
    }

    private int b() {
        return this.c;
    }

    private boolean c() {
        return this.d;
    }

    private boolean d() {
        return this.e;
    }

    class a
    implements RandomSource {
        private final RandomSource c;

        a(RandomSource random) {
            this.c = random;
        }

        @Override
        public RandomSource d() {
            RandomSequences.this.u();
            return this.c.d();
        }

        @Override
        public PositionalRandomFactory e() {
            RandomSequences.this.u();
            return this.c.e();
        }

        @Override
        public void b(long seed) {
            RandomSequences.this.u();
            this.c.b(seed);
        }

        @Override
        public int f() {
            RandomSequences.this.u();
            return this.c.f();
        }

        @Override
        public int a(int bound) {
            RandomSequences.this.u();
            return this.c.a(bound);
        }

        @Override
        public long g() {
            RandomSequences.this.u();
            return this.c.g();
        }

        @Override
        public boolean h() {
            RandomSequences.this.u();
            return this.c.h();
        }

        @Override
        public float i() {
            RandomSequences.this.u();
            return this.c.i();
        }

        @Override
        public double j() {
            RandomSequences.this.u();
            return this.c.j();
        }

        @Override
        public double k() {
            RandomSequences.this.u();
            return this.c.k();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof a)) return false;
            a dirtyMarkingRandomSource = (a)other;
            if (!this.c.equals(dirtyMarkingRandomSource.c)) return false;
            return true;
        }
    }
}

