/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import org.jspecify.annotations.Nullable;

public final class EnvironmentAttributeMap {
    public static final EnvironmentAttributeMap a = new EnvironmentAttributeMap(Map.of());
    public static final Codec<EnvironmentAttributeMap> b = Codec.lazyInitialized(() -> Codec.dispatchedMap(EnvironmentAttributes.T, SystemUtils.b(b::a)).xmap(EnvironmentAttributeMap::new, environmentAttributeMap -> environmentAttributeMap.e));
    public static final Codec<EnvironmentAttributeMap> c = b.xmap(EnvironmentAttributeMap::a, EnvironmentAttributeMap::a);
    public static final Codec<EnvironmentAttributeMap> d = b.validate(environmentAttributeMap -> {
        List<EnvironmentAttribute> list = environmentAttributeMap.b().stream().filter(environmentAttribute -> !environmentAttribute.e()).toList();
        return !list.isEmpty() ? DataResult.error(() -> "The following attributes cannot be positional: " + String.valueOf(list)) : DataResult.success((Object)environmentAttributeMap);
    });
    final Map<EnvironmentAttribute<?>, b<?, ?>> e;

    private static EnvironmentAttributeMap a(EnvironmentAttributeMap attributes) {
        return new EnvironmentAttributeMap(Map.copyOf(Maps.filterKeys(attributes.e, EnvironmentAttribute::d)));
    }

    EnvironmentAttributeMap(Map<EnvironmentAttribute<?>, b<?, ?>> entries) {
        this.e = entries;
    }

    public static a a() {
        return new a();
    }

    public <Value> @Nullable b<Value, ?> a(EnvironmentAttribute<Value> attribute) {
        return this.e.get(attribute);
    }

    public <Value> Value a(EnvironmentAttribute<Value> attribute, Value value) {
        b<Value, ?> entry = this.a(attribute);
        return entry != null ? entry.a(value) : value;
    }

    public boolean b(EnvironmentAttribute<?> attribute) {
        return this.e.containsKey(attribute);
    }

    public Set<EnvironmentAttribute<?>> b() {
        return this.e.keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof EnvironmentAttributeMap)) return false;
        EnvironmentAttributeMap environmentAttributeMap = (EnvironmentAttributeMap)other;
        if (!this.e.equals(environmentAttributeMap.e)) return false;
        return true;
    }

    public int hashCode() {
        return this.e.hashCode();
    }

    public String toString() {
        return this.e.toString();
    }

    public static class a {
        private final Map<EnvironmentAttribute<?>, b<?, ?>> a = new HashMap();

        a() {
        }

        public a a(EnvironmentAttributeMap attributes) {
            this.a.putAll(attributes.e);
            return this;
        }

        public <Value, Parameter> a a(EnvironmentAttribute<Value> attribute, AttributeModifier<Value, Parameter> modifier, Parameter argument) {
            attribute.a().a(modifier);
            this.a.put(attribute, new b<Value, Parameter>(argument, modifier));
            return this;
        }

        public <Value> a a(EnvironmentAttribute<Value> attribute, Value value) {
            return this.a(attribute, AttributeModifier.a(), value);
        }

        public EnvironmentAttributeMap a() {
            return this.a.isEmpty() ? a : new EnvironmentAttributeMap(Map.copyOf(this.a));
        }
    }

    public record b<Value, Argument>(Argument a, AttributeModifier<Value, Argument> b) {
        private static <Value> Codec<b<Value, ?>> a(EnvironmentAttribute<Value> attribute) {
            Codec codec = attribute.a().c().dispatch("modifier", b::b, SystemUtils.b((T attributeModifier) -> net.minecraft.world.attribute.EnvironmentAttributeMap$b.a(attribute, attributeModifier)));
            return Codec.either(attribute.c(), (Codec)codec).xmap(either -> either.map(object -> new b(object, AttributeModifier.a()), entry -> entry), entry -> entry.b == AttributeModifier.a() ? Either.left(entry.a()) : Either.right(entry));
        }

        private static <Value, Argument> MapCodec<b<Value, Argument>> a(EnvironmentAttribute<Value> attribute, AttributeModifier<Value, Argument> modifier) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)modifier.argumentCodec(attribute).fieldOf("argument").forGetter(b::a)).apply((Applicative)instance, object -> new b(object, modifier)));
        }

        public Value a(Value value) {
            return this.b.apply(value, this.a);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "argument;modifier", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "argument;modifier", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "argument;modifier", "a", "b"}, this, o2);
        }
    }
}

