/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeLayer;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributeReader;
import net.minecraft.world.attribute.SpatialAttributeInterpolator;
import net.minecraft.world.attribute.WeatherAttributes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.timeline.Timeline;
import org.jspecify.annotations.Nullable;

public class EnvironmentAttributeSystem
implements EnvironmentAttributeReader {
    private final Map<EnvironmentAttribute<?>, b<?>> b = new Reference2ObjectOpenHashMap();

    EnvironmentAttributeSystem(Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> layersByAttribute) {
        layersByAttribute.forEach((attribute, layers) -> this.b.put((EnvironmentAttribute<?>)attribute, this.a((EnvironmentAttribute)attribute, (List<? extends EnvironmentAttributeLayer<?>>)layers)));
    }

    private <Value> b<Value> a(EnvironmentAttribute<Value> attribute, List<? extends EnvironmentAttributeLayer<?>> untypedLayers) {
        Object e2;
        ArrayList list = new ArrayList(untypedLayers);
        Value object = attribute.b();
        while (!list.isEmpty() && (e2 = list.getFirst()) instanceof EnvironmentAttributeLayer.a) {
            EnvironmentAttributeLayer.a constant = (EnvironmentAttributeLayer.a)e2;
            object = constant.applyConstant(object);
            list.removeFirst();
        }
        boolean flag = list.stream().anyMatch(environmentAttributeLayer -> environmentAttributeLayer instanceof EnvironmentAttributeLayer.b);
        return new b<Value>(attribute, object, List.copyOf(list), flag);
    }

    public static a a() {
        return new a();
    }

    static void a(a builder, World level) {
        IRegistryCustom registryAccess = level.J_();
        BiomeManager biomeManager = level.H_();
        LongSupplier longSupplier = level::al;
        EnvironmentAttributeSystem.a(builder, level.F_());
        EnvironmentAttributeSystem.a(builder, registryAccess.f(Registries.aS), biomeManager);
        level.F_().q().forEach(holder -> builder.a((Holder<Timeline>)holder, longSupplier));
        if (level.am()) {
            WeatherAttributes.a(builder, WeatherAttributes.a.a(level));
        }
    }

    private static void a(a builder, DimensionManager dimensionType) {
        builder.a(dimensionType.p());
    }

    private static void a(a builder, HolderLookup<BiomeBase> biomes, BiomeManager biomeManager) {
        Stream stream = biomes.c().flatMap(reference -> ((BiomeBase)reference.a()).g().b().stream()).distinct();
        stream.forEach(environmentAttribute -> EnvironmentAttributeSystem.a(builder, environmentAttribute, biomeManager));
    }

    private static <Value> void a(a builder, EnvironmentAttribute<Value> attribute, BiomeManager biomeManager) {
        builder.a(attribute, (Value baseValue, Vec3D pos, SpatialAttributeInterpolator biomeInterpolator) -> {
            if (biomeInterpolator != null && attribute.f()) {
                return biomeInterpolator.a(attribute, baseValue);
            }
            Holder<BiomeBase> noiseBiomeAtPosition = biomeManager.a(pos.g, pos.h, pos.i);
            return noiseBiomeAtPosition.a().g().a(attribute, baseValue);
        });
    }

    public void b() {
        this.b.values().forEach(b::a);
    }

    private <Value> @Nullable b<Value> d(EnvironmentAttribute<Value> attribute) {
        return this.b.get(attribute);
    }

    @Override
    public <Value> Value a(EnvironmentAttribute<Value> attribute) {
        if (SharedConstants.aX && attribute.e()) {
            throw new IllegalStateException("Position must always be provided for positional attribute " + String.valueOf(attribute));
        }
        b<Value> valueSampler = this.d(attribute);
        return valueSampler == null ? attribute.b() : valueSampler.b();
    }

    @Override
    public <Value> Value a(EnvironmentAttribute<Value> attribute, Vec3D pos, @Nullable SpatialAttributeInterpolator biomeInterpolator) {
        b<Value> valueSampler = this.d(attribute);
        return valueSampler == null ? attribute.b() : valueSampler.a(pos, biomeInterpolator);
    }

    @VisibleForTesting
    <Value> Value b(EnvironmentAttribute<Value> attribute) {
        b<Value> valueSampler = this.d(attribute);
        return valueSampler != null ? valueSampler.b : attribute.b();
    }

    @VisibleForTesting
    boolean c(EnvironmentAttribute<?> attribute) {
        b<?> valueSampler = this.d(attribute);
        return valueSampler != null && valueSampler.d;
    }

    static class b<Value> {
        private final EnvironmentAttribute<Value> a;
        final Value b;
        private final List<EnvironmentAttributeLayer<Value>> c;
        final boolean d;
        private @Nullable Value e;
        private int f;

        b(EnvironmentAttribute<Value> attribute, Value baseValue, List<EnvironmentAttributeLayer<Value>> layers, boolean isAffectedByPosition) {
            this.a = attribute;
            this.b = baseValue;
            this.c = layers;
            this.d = isAffectedByPosition;
        }

        public void a() {
            this.e = null;
            ++this.f;
        }

        public Value b() {
            if (this.e != null) {
                return this.e;
            }
            Value object = this.c();
            this.e = object;
            return object;
        }

        public Value a(Vec3D vec3, @Nullable SpatialAttributeInterpolator biomeInterpolator) {
            return !this.d ? this.b() : this.b(vec3, biomeInterpolator);
        }

        private Value b(Vec3D vec3, @Nullable SpatialAttributeInterpolator biomeInterpolator) {
            Value object = this.b;
            for (EnvironmentAttributeLayer<Value> environmentAttributeLayer : this.c) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer2;
                Objects.requireNonNull(environmentAttributeLayer);
                int n2 = 0;
                object = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.a.class, EnvironmentAttributeLayer.c.class, EnvironmentAttributeLayer.b.class}, environmentAttributeLayer2, n2)) {
                    case 0 -> {
                        EnvironmentAttributeLayer.a constant = (EnvironmentAttributeLayer.a)environmentAttributeLayer2;
                        yield constant.applyConstant(object);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.c timeBased = (EnvironmentAttributeLayer.c)environmentAttributeLayer2;
                        yield timeBased.applyTimeBased(object, this.f);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.b positional = (EnvironmentAttributeLayer.b)environmentAttributeLayer2;
                        yield positional.applyPositional(object, Objects.requireNonNull(vec3), biomeInterpolator);
                    }
                    default -> throw new MatchException(null, null);
                };
            }
            return this.a.a(object);
        }

        private Value c() {
            Value object = this.b;
            for (EnvironmentAttributeLayer<Value> environmentAttributeLayer : this.c) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer2;
                Objects.requireNonNull(environmentAttributeLayer);
                int n2 = 0;
                object = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.a.class, EnvironmentAttributeLayer.c.class, EnvironmentAttributeLayer.b.class}, environmentAttributeLayer2, n2)) {
                    case 0 -> {
                        EnvironmentAttributeLayer.a constant = (EnvironmentAttributeLayer.a)environmentAttributeLayer2;
                        yield constant.applyConstant(object);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.c timeBased = (EnvironmentAttributeLayer.c)environmentAttributeLayer2;
                        yield timeBased.applyTimeBased(object, this.f);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.b positional = (EnvironmentAttributeLayer.b)environmentAttributeLayer2;
                        yield object;
                    }
                    default -> throw new MatchException(null, null);
                };
            }
            return this.a.a(object);
        }
    }

    public static class a {
        private final Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> a = new HashMap();

        a() {
        }

        public a a(World level) {
            EnvironmentAttributeSystem.a(this, level);
            return this;
        }

        public a a(EnvironmentAttributeMap attributes) {
            for (EnvironmentAttribute<?> environmentAttribute : attributes.b()) {
                this.a(environmentAttribute, attributes);
            }
            return this;
        }

        private <Value> a a(EnvironmentAttribute<Value> attribute, EnvironmentAttributeMap attributes) {
            EnvironmentAttributeMap.b<Value, ?> entry = attributes.a(attribute);
            if (entry == null) {
                throw new IllegalArgumentException("Missing attribute " + String.valueOf(attribute));
            }
            return this.a(attribute, entry::a);
        }

        public <Value> a a(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer.a<Value> layer) {
            return this.a(attribute, (EnvironmentAttributeLayer<Value>)layer);
        }

        public <Value> a a(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer.c<Value> layer) {
            return this.a(attribute, (EnvironmentAttributeLayer<Value>)layer);
        }

        public <Value> a a(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer.b<Value> layer) {
            return this.a(attribute, (EnvironmentAttributeLayer<Value>)layer);
        }

        private <Value> a a(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer<Value> layer) {
            this.a.computeIfAbsent(attribute, environmentAttribute -> new ArrayList()).add(layer);
            return this;
        }

        public a a(Holder<Timeline> timeline, LongSupplier dayTimeGetter) {
            for (EnvironmentAttribute<?> environmentAttribute : timeline.a().c()) {
                this.a(timeline, environmentAttribute, dayTimeGetter);
            }
            return this;
        }

        private <Value> void a(Holder<Timeline> timeline, EnvironmentAttribute<Value> attribute, LongSupplier dayTimeGetter) {
            this.a(attribute, timeline.a().a(attribute, dayTimeGetter));
        }

        public EnvironmentAttributeSystem a() {
            return new EnvironmentAttributeSystem(this.a);
        }
    }
}

