/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;

public interface LerpFunction<T> {
    public static LerpFunction<Float> a() {
        return MathHelper::h;
    }

    public static LerpFunction<Float> a(float maxDelta) {
        return (delta, start, end) -> {
            float f2 = MathHelper.f(end.floatValue() - start.floatValue());
            return Float.valueOf(Math.abs(f2) >= maxDelta ? end.floatValue() : start.floatValue() + delta * f2);
        };
    }

    public static <T> LerpFunction<T> b() {
        return (delta, start, end) -> start;
    }

    public static <T> LerpFunction<T> b(float threshold) {
        return (delta, start, end) -> delta >= threshold ? end : start;
    }

    public static LerpFunction<Integer> c() {
        return ARGB::a;
    }

    public T apply(float var1, T var2, T var3);
}

