/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute.modifier;

import com.mojang.serialization.Codec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.LerpFunction;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.attribute.modifier.FloatWithAlpha;

public interface FloatModifier<Argument>
extends AttributeModifier<Float, Argument> {
    public static final FloatModifier<FloatWithAlpha> e = new FloatModifier<FloatWithAlpha>(){

        public Float a(Float subject, FloatWithAlpha argument) {
            return Float.valueOf(MathHelper.h(argument.b(), subject.floatValue(), argument.a()));
        }

        @Override
        public Codec<FloatWithAlpha> argumentCodec(EnvironmentAttribute<Float> attribute) {
            return FloatWithAlpha.a;
        }

        @Override
        public LerpFunction<FloatWithAlpha> argumentKeyframeLerp(EnvironmentAttribute<Float> attribute) {
            return (delta, start, end) -> new FloatWithAlpha(MathHelper.h(delta, start.a(), end.a()), MathHelper.h(delta, start.b(), end.b()));
        }
    };
    public static final FloatModifier<Float> f = Float::sum;
    public static final FloatModifier<Float> g = (_float, _float1) -> Float.valueOf(_float.floatValue() - _float1.floatValue());
    public static final FloatModifier<Float> h = (_float, _float1) -> Float.valueOf(_float.floatValue() * _float1.floatValue());
    public static final FloatModifier<Float> i = Math::min;
    public static final FloatModifier<Float> j = Math::max;

    @FunctionalInterface
    public static interface a
    extends FloatModifier<Float> {
        @Override
        default public Codec<Float> argumentCodec(EnvironmentAttribute<Float> attribute) {
            return Codec.FLOAT;
        }

        @Override
        default public LerpFunction<Float> argumentKeyframeLerp(EnvironmentAttribute<Float> attribute) {
            return LerpFunction.a();
        }
    }
}

