/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import io.papermc.paper.event.entity.EntityEffectTickEvent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.InstantMobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.jspecify.annotations.Nullable;

class HealOrHarmMobEffect
extends InstantMobEffect {
    private final boolean c;

    public HealOrHarmMobEffect(MobEffectInfo category, int color, boolean isHarm) {
        super(category, color);
        this.c = isHarm;
    }

    @Override
    public boolean a(WorldServer level, EntityLiving entity, int amplifier) {
        if (this.c == entity.eY()) {
            entity.heal(Math.max(4 << amplifier, 0), EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            entity.a(level, entity.en().q(), (float)(6 << amplifier));
        }
        return true;
    }

    @Override
    public void a(WorldServer level, @Nullable Entity source, @Nullable Entity indirectSource, EntityLiving entity, int amplifier, double health) {
        if (!new EntityEffectTickEvent((LivingEntity)entity.getBukkitLivingEntity(), CraftPotionEffectType.minecraftToBukkit(this), amplifier).callEvent()) {
            return;
        }
        if (this.c == entity.eY()) {
            int i2 = (int)(health * (double)(4 << amplifier) + 0.5);
            entity.heal(i2, EntityRegainHealthEvent.RegainReason.MAGIC);
        } else {
            int i3 = (int)(health * (double)(6 << amplifier) + 0.5);
            if (source == null) {
                entity.a(level, entity.en().q(), (float)i3);
            } else {
                entity.a(level, entity.en().c(source, indirectSource), (float)i3);
            }
        }
    }
}

