/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityEffectTickEvent;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionEffectType;
import org.bukkit.entity.LivingEntity;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger f = LogUtils.getLogger();
    public static final int a = -1;
    public static final int b = 0;
    public static final int c = 255;
    public static final Codec<MobEffect> d = RecordCodecBuilder.create(instance -> instance.group((App)MobEffectList.a.fieldOf("id").forGetter(MobEffect::c), (App)net.minecraft.world.effect.MobEffect$b.a.forGetter(MobEffect::l)).apply((Applicative)instance, MobEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MobEffect> e = StreamCodec.a(MobEffectList.b, MobEffect::c, net.minecraft.world.effect.MobEffect$b.b, MobEffect::l, MobEffect::new);
    private final Holder<MobEffectList> g;
    private int h;
    private int i;
    private boolean j;
    private boolean k;
    private boolean l;
    public @Nullable MobEffect m;
    private final a n = new a();

    public MobEffect(Holder<MobEffectList> effect) {
        this(effect, 0, 0);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration) {
        this(effect, duration, 0);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier) {
        this(effect, duration, amplifier, false, true);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier, boolean ambient, boolean visible) {
        this(effect, duration, amplifier, ambient, visible, visible);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        this(effect, duration, amplifier, ambient, visible, showIcon, null);
    }

    public MobEffect(Holder<MobEffectList> effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon, @Nullable MobEffect hiddenEffect) {
        this.g = effect;
        this.h = duration;
        this.i = MathHelper.a(amplifier, 0, 255);
        this.j = ambient;
        this.k = visible;
        this.l = showIcon;
        this.m = hiddenEffect;
    }

    public MobEffect(MobEffect other) {
        this.g = other.g;
        this.a(other);
    }

    private MobEffect(Holder<MobEffectList> effect, b details) {
        this(effect, details.b(), details.a(), details.c(), details.d(), details.e(), details.f().map(details1 -> new MobEffect(effect, (b)details1)).orElse(null));
    }

    private b l() {
        return new b(this.e(), this.d(), this.f(), this.g(), this.h(), Optional.ofNullable(this.m).map(MobEffect::l));
    }

    public float a(EntityLiving entity, float delta) {
        return this.n.a(entity, delta);
    }

    public ParticleParam a() {
        return this.g.a().a(this);
    }

    void a(MobEffect effectInstance) {
        this.h = effectInstance.h;
        this.i = effectInstance.i;
        this.j = effectInstance.j;
        this.k = effectInstance.k;
        this.l = effectInstance.l;
    }

    public boolean b(MobEffect other) {
        if (!this.g.equals(other.g)) {
            f.warn("This method should only be called for matching effects!");
        }
        boolean flag = false;
        if (other.i > this.i) {
            if (other.e(this)) {
                MobEffect mobEffectInstance = this.m;
                this.m = new MobEffect(this);
                this.m.m = mobEffectInstance;
            }
            this.i = other.i;
            this.h = other.h;
            flag = true;
        } else if (this.e(other)) {
            if (other.i == this.i) {
                this.h = other.h;
                flag = true;
            } else if (this.m == null) {
                this.m = new MobEffect(other);
            } else {
                this.m.b(other);
            }
        }
        if (!other.j && this.j || flag) {
            this.j = other.j;
            flag = true;
        }
        if (other.k != this.k) {
            this.k = other.k;
            flag = true;
        }
        if (other.l != this.l) {
            this.l = other.l;
            flag = true;
        }
        return flag;
    }

    public boolean e(MobEffect other) {
        return !this.b() && (this.h < other.h || other.b());
    }

    public boolean b() {
        return this.h == -1;
    }

    public boolean a(int duration) {
        return !this.b() && this.h <= duration;
    }

    public MobEffect a(float scale) {
        MobEffect mobEffectInstance = new MobEffect(this);
        mobEffectInstance.h = mobEffectInstance.a(duration -> Math.max(MathHelper.b((float)duration * scale), 1));
        return mobEffectInstance;
    }

    public int a(Int2IntFunction mapper) {
        return !this.b() && this.h != 0 ? mapper.applyAsInt(this.h) : this.h;
    }

    public Holder<MobEffectList> c() {
        return this.g;
    }

    public int d() {
        return this.h;
    }

    public int e() {
        return this.i;
    }

    public boolean f() {
        return this.j;
    }

    public boolean g() {
        return this.k;
    }

    public boolean h() {
        return this.l;
    }

    public boolean a(WorldServer level, EntityLiving entity, Runnable onEffectUpdated) {
        int i2;
        if (!this.m()) {
            return false;
        }
        int n2 = i2 = this.b() ? entity.at : this.h;
        if (this.g.a().a(i2, this.i) && new EntityEffectTickEvent((LivingEntity)entity.getBukkitLivingEntity(), CraftPotionEffectType.minecraftHolderToBukkit(this.g), this.i).callEvent() && !this.g.a().a(level, entity, this.i)) {
            return false;
        }
        this.n();
        if (this.o()) {
            onEffectUpdated.run();
        }
        return this.m();
    }

    public void i() {
        if (this.m()) {
            this.n();
            this.o();
        }
        this.n.b(this);
    }

    private boolean m() {
        return this.b() || this.h > 0;
    }

    private void n() {
        if (this.m != null) {
            this.m.n();
        }
        this.h = this.a(duration -> duration - 1);
    }

    private boolean o() {
        if (this.h == 0 && this.m != null) {
            this.a(this.m);
            this.m = this.m.m;
            return true;
        }
        return false;
    }

    public void a(EntityLiving entity) {
        this.g.a().a(entity, this.i);
    }

    public void a(WorldServer level, EntityLiving entity, Entity.RemovalReason reason) {
        this.g.a().a(level, entity, this.i, reason);
    }

    public void a(WorldServer level, EntityLiving entity, DamageSource damageSource, float amount) {
        this.g.a().a(level, entity, this.i, damageSource, amount);
    }

    public String j() {
        return this.g.a().f();
    }

    public String toString() {
        String string = this.i > 0 ? this.j() + " x " + (this.i + 1) + ", Duration: " + this.p() : this.j() + ", Duration: " + this.p();
        if (!this.k) {
            string = string + ", Particles: false";
        }
        if (!this.l) {
            string = string + ", Show Icon: false";
        }
        return string;
    }

    private String p() {
        return this.b() ? "infinite" : Integer.toString(this.h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof MobEffect)) return false;
        MobEffect mobEffectInstance = (MobEffect)other;
        if (this.h != mobEffectInstance.h) return false;
        if (this.i != mobEffectInstance.i) return false;
        if (this.j != mobEffectInstance.j) return false;
        if (this.k != mobEffectInstance.k) return false;
        if (this.l != mobEffectInstance.l) return false;
        if (!this.g.equals(mobEffectInstance.g)) return false;
        return true;
    }

    public int hashCode() {
        int hashCode = this.g.hashCode();
        hashCode = 31 * hashCode + this.h;
        hashCode = 31 * hashCode + this.i;
        hashCode = 31 * hashCode + (this.j ? 1 : 0);
        hashCode = 31 * hashCode + (this.k ? 1 : 0);
        return 31 * hashCode + (this.l ? 1 : 0);
    }

    public int c(MobEffect other) {
        int i2 = 32147;
        return !(this.d() > 32147 && other.d() > 32147 || this.f() && other.f()) ? ComparisonChain.start().compareFalseFirst(this.f(), other.f()).compareFalseFirst(this.b(), other.b()).compare(this.d(), other.d()).compare(this.c().a().i(), other.c().a().i()).result() : ComparisonChain.start().compare(Boolean.valueOf(this.f()), Boolean.valueOf(other.f())).compare(this.c().a().i(), other.c().a().i()).result();
    }

    public void b(EntityLiving livingEntity) {
        this.g.a().b(livingEntity, this.i);
    }

    public boolean a(Holder<MobEffectList> effect) {
        return this.g.equals(effect);
    }

    public void d(MobEffect effectInstance) {
        this.n.a(effectInstance.n);
    }

    public void k() {
        this.n.a(this);
    }

    static class a {
        private float a;
        private float b;

        a() {
        }

        public void a(MobEffect effectInstance) {
            this.b = this.a = net.minecraft.world.effect.MobEffect$a.c(effectInstance) ? 1.0f : 0.0f;
        }

        public void a(a blendState) {
            this.a = blendState.a;
            this.b = blendState.b;
        }

        public void b(MobEffect effect) {
            float f2;
            this.b = this.a;
            boolean hasEffect = net.minecraft.world.effect.MobEffect$a.c(effect);
            float f3 = f2 = hasEffect ? 1.0f : 0.0f;
            if (this.a != f2) {
                int i2;
                MobEffectList mobEffect = effect.c().a();
                int n2 = i2 = hasEffect ? mobEffect.b() : mobEffect.c();
                if (i2 == 0) {
                    this.a = f2;
                } else {
                    float f1 = 1.0f / (float)i2;
                    this.a += MathHelper.a(f2 - this.a, -f1, f1);
                }
            }
        }

        private static boolean c(MobEffect effect) {
            return !effect.a(effect.c().a().d());
        }

        public float a(EntityLiving entity, float delta) {
            if (entity.eh()) {
                this.b = this.a;
            }
            return MathHelper.h(delta, this.b, this.a);
        }
    }

    static final class b
    extends Record {
        private final int c;
        private final int d;
        private final boolean e;
        private final boolean f;
        private final boolean g;
        private final Optional<b> h;
        public static final MapCodec<b> a = MapCodec.recursive((String)"MobEffectInstance.Details", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.p.optionalFieldOf("amplifier", (Object)0).forGetter(b::a), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(b::b), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(b::c), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(b::d), (App)Codec.BOOL.optionalFieldOf("show_icon").forGetter(details -> Optional.of(details.e())), (App)codec.optionalFieldOf("hidden_effect").forGetter(b::f)).apply((Applicative)instance, b::a)));
        public static final StreamCodec<PacketDataSerializer, b> b = StreamCodec.a(codec -> StreamCodec.a(ByteBufCodecs.h, b::a, ByteBufCodecs.h, b::b, ByteBufCodecs.b, b::c, ByteBufCodecs.b, b::d, ByteBufCodecs.b, b::e, codec.a(ByteBufCodecs::increaseDepth).a(ByteBufCodecs::a), b::f, b::new));

        b(int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, Optional<b> hiddenEffect) {
            this.c = amplifier;
            this.d = duration;
            this.e = ambient;
            this.f = showParticles;
            this.g = showIcon;
            this.h = hiddenEffect;
        }

        private static b a(int amplifier, int duration, boolean ambient, boolean showParticles, Optional<Boolean> showIcon, Optional<b> hiddenEffect) {
            return new b(amplifier, duration, ambient, showParticles, showIcon.orElse(showParticles), hiddenEffect);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "amplifier;duration;ambient;showParticles;showIcon;hiddenEffect", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "amplifier;duration;ambient;showParticles;showIcon;hiddenEffect", "c", "d", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "amplifier;duration;ambient;showParticles;showIcon;hiddenEffect", "c", "d", "e", "f", "g", "h"}, this, o2);
        }

        public int a() {
            return this.c;
        }

        public int b() {
            return this.d;
        }

        public boolean c() {
            return this.e;
        }

        public boolean d() {
            return this.f;
        }

        public boolean e() {
            return this.g;
        }

        public Optional<b> f() {
            return this.h;
        }
    }
}

