/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.util.ARGB;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger o = LogUtils.getLogger();
    public static final int a = -1;
    private static final DataWatcherObject<Integer> p = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> q = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Integer> r = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Vector3fc> s = DataWatcher.a(Display.class, DataWatcherRegistry.J);
    private static final DataWatcherObject<Vector3fc> t = DataWatcher.a(Display.class, DataWatcherRegistry.J);
    private static final DataWatcherObject<Quaternionfc> u = DataWatcher.a(Display.class, DataWatcherRegistry.K);
    private static final DataWatcherObject<Quaternionfc> aN = DataWatcher.a(Display.class, DataWatcherRegistry.K);
    private static final DataWatcherObject<Byte> aO = DataWatcher.a(Display.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> aP = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aQ = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aR = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aS = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aT = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aU = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> aV = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final IntSet aW = IntSet.of((int[])new int[]{s.a(), t.a(), u.a(), aN.a(), aO.a(), aP.a(), aR.a(), aS.a()});
    private static final int aX = 0;
    private static final int aY = 0;
    private static final int aZ = 0;
    private static final float ba = 0.0f;
    private static final float bb = 1.0f;
    private static final float bc = 1.0f;
    private static final float bd = 0.0f;
    private static final float be = 0.0f;
    private static final int bf = -1;
    public static final String b = "teleport_duration";
    public static final String c = "interpolation_duration";
    public static final String d = "start_interpolation";
    public static final String e = "transformation";
    public static final String f = "billboard";
    public static final String g = "brightness";
    public static final String h = "view_range";
    public static final String i = "shadow_radius";
    public static final String j = "shadow_strength";
    public static final String k = "width";
    public static final String l = "height";
    public static final String m = "glow_color_override";
    private long bg = Integer.MIN_VALUE;
    private int bh;
    private float bi;
    private AxisAlignedBB bj;
    private boolean bk = true;
    protected boolean n;
    private boolean bl;
    private boolean bm;
    private @Nullable j bn;
    private final InterpolationHandler bo = new InterpolationHandler((Entity)this, 0);

    public Display(EntityTypes<?> type, World level) {
        super(type, level);
        this.ar = true;
        this.bj = this.dj();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (aU.equals(key) || aT.equals(key)) {
            this.z();
        }
        if (p.equals(key)) {
            this.bl = true;
        }
        if (r.equals(key)) {
            this.bo.a(this.n());
        }
        if (q.equals(key)) {
            this.bm = true;
        }
        if (aW.contains(key.a())) {
            this.n = true;
        }
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    public static Transformation a(DataWatcher synchedEntityData) {
        Vector3fc vector3fc = synchedEntityData.a(s);
        Quaternionfc quaternionfc = synchedEntityData.a(u);
        Vector3fc vector3fc1 = synchedEntityData.a(t);
        Quaternionfc quaternionfc1 = synchedEntityData.a(aN);
        return new Transformation(vector3fc, quaternionfc, vector3fc1, quaternionfc1);
    }

    @Override
    public void g() {
        Entity vehicle = this.dz();
        if (vehicle != null && vehicle.eh()) {
            this.cf();
        }
        if (this.ao().B_()) {
            if (this.bl) {
                this.bl = false;
                int transformationInterpolationDelay = this.m();
                this.bg = this.at + transformationInterpolationDelay;
            }
            if (this.bm) {
                this.bm = false;
                this.bh = this.k();
            }
            if (this.n) {
                this.n = false;
                boolean flag = this.bh != 0;
                this.bn = flag && this.bn != null ? this.a(this.bn, this.bi) : this.A();
                this.a(flag, this.bi);
            }
            this.bo.e();
        }
    }

    @Override
    public InterpolationHandler l_() {
        return this.bo;
    }

    protected abstract void a(boolean var1, float var2);

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(r, 0);
        builder.a(p, 0);
        builder.a(q, 0);
        builder.a(s, new Vector3f());
        builder.a(t, new Vector3f(1.0f, 1.0f, 1.0f));
        builder.a(aN, new Quaternionf());
        builder.a(u, new Quaternionf());
        builder.a(aO, BillboardConstraints.a.a());
        builder.a(aP, -1);
        builder.a(aQ, Float.valueOf(1.0f));
        builder.a(aR, Float.valueOf(0.0f));
        builder.a(aS, Float.valueOf(1.0f));
        builder.a(aT, Float.valueOf(0.0f));
        builder.a(aU, Float.valueOf(0.0f));
        builder.a(aV, -1);
    }

    @Override
    protected void a(ValueInput input) {
        this.a(input.a(e, Transformation.b).orElse(Transformation.a()));
        this.a(input.a(c, 0));
        this.b(input.a(d, 0));
        int intOr = input.a(b, 0);
        this.d(MathHelper.a(intOr, 0, 59));
        this.a(input.a(f, BillboardConstraints.e).orElse(BillboardConstraints.a));
        this.b(input.a(h, 1.0f));
        this.c(input.a(i, 0.0f));
        this.d(input.a(j, 1.0f));
        this.x(input.a(k, 0.0f));
        this.y(input.a(l, 0.0f));
        this.l(input.a(m, -1));
        this.a((Brightness)input.a(g, Brightness.b).orElse(null));
    }

    public void a(Transformation transformation) {
        this.az.a(s, transformation.e());
        this.az.a(u, transformation.f());
        this.az.a(t, transformation.g());
        this.az.a(aN, transformation.h());
    }

    @Override
    protected void a(ValueOutput output) {
        output.a(e, Transformation.b, Display.a(this.az));
        output.a(f, BillboardConstraints.e, this.p());
        output.a(c, this.k());
        output.a(b, this.n());
        output.a(h, this.s());
        output.a(i, this.u());
        output.a(j, this.v());
        output.a(k, this.w());
        output.a(l, this.y());
        output.a(m, this.x());
        output.b(g, Brightness.b, this.q());
    }

    public AxisAlignedBB e() {
        return this.bj;
    }

    public boolean f() {
        return !this.bk;
    }

    @Override
    public EnumPistonReaction n_() {
        return EnumPistonReaction.d;
    }

    @Override
    public boolean m_() {
        return true;
    }

    public @Nullable j i() {
        return this.bn;
    }

    public void a(int transformationInterpolationDuration) {
        this.az.a(q, transformationInterpolationDuration);
    }

    public int k() {
        return this.az.a(q);
    }

    public void b(int transformationInterpolationDelay) {
        this.az.a(p, transformationInterpolationDelay, true);
    }

    public int m() {
        return this.az.a(p);
    }

    private void d(int posRotInterpolationDuration) {
        this.az.a(r, posRotInterpolationDuration);
    }

    private int n() {
        return this.az.a(r);
    }

    public void a(BillboardConstraints billboardConstraints) {
        this.az.a(aO, billboardConstraints.a());
    }

    public BillboardConstraints p() {
        return BillboardConstraints.f.apply(this.az.a(aO).byteValue());
    }

    public void a(@Nullable Brightness brightnessOverride) {
        this.az.a(aP, brightnessOverride != null ? brightnessOverride.a() : -1);
    }

    public @Nullable Brightness q() {
        int i2 = this.az.a(aP);
        return i2 != -1 ? Brightness.c(i2) : null;
    }

    private int r() {
        return this.az.a(aP);
    }

    public void b(float viewRange) {
        this.az.a(aQ, Float.valueOf(viewRange));
    }

    public float s() {
        return this.az.a(aQ).floatValue();
    }

    public void c(float shadowRadius) {
        this.az.a(aR, Float.valueOf(shadowRadius));
    }

    public float u() {
        return this.az.a(aR).floatValue();
    }

    public void d(float shadowStrength) {
        this.az.a(aS, Float.valueOf(shadowStrength));
    }

    public float v() {
        return this.az.a(aS).floatValue();
    }

    public void x(float width) {
        this.az.a(aT, Float.valueOf(width));
    }

    public float w() {
        return this.az.a(aT).floatValue();
    }

    public void y(float height) {
        this.az.a(aU, Float.valueOf(height));
    }

    public int x() {
        return this.az.a(aV);
    }

    public void l(int glowColorOverride) {
        this.az.a(aV, glowColorOverride);
    }

    public float a(float partialTick) {
        float f2;
        int i2 = this.bh;
        if (i2 <= 0) {
            return 1.0f;
        }
        float f3 = (long)this.at - this.bg;
        float f1 = f3 + partialTick;
        this.bi = f2 = MathHelper.a(MathHelper.f(f1, 0.0f, i2), 0.0f, 1.0f);
        return f2;
    }

    public float y() {
        return this.az.a(aU).floatValue();
    }

    @Override
    public void a_(double x2, double y2, double z2) {
        super.a_(x2, y2, z2);
        this.z();
    }

    private void z() {
        float width = this.w();
        float height = this.y();
        this.bk = width == 0.0f || height == 0.0f;
        float f2 = width / 2.0f;
        double x2 = this.dP();
        double y2 = this.dR();
        double z2 = this.dV();
        this.bj = new AxisAlignedBB(x2 - (double)f2, y2, z2 - (double)f2, x2 + (double)f2, y2 + (double)height, z2 + (double)f2);
    }

    @Override
    public boolean a(double distance) {
        return distance < MathHelper.n((double)this.s() * 64.0 * Display.dc());
    }

    @Override
    public int h_() {
        int glowColorOverride = this.x();
        return glowColorOverride != -1 ? glowColorOverride : super.h_();
    }

    private j A() {
        return new j(GenericInterpolator.constant(Display.a(this.az)), this.p(), this.r(), FloatInterpolator.constant(this.u()), FloatInterpolator.constant(this.v()), this.x());
    }

    private j a(j renderState, float partialTick) {
        Transformation transformation = renderState.a.get(partialTick);
        float f2 = renderState.d.get(partialTick);
        float f1 = renderState.e.get(partialTick);
        return new j(new l(transformation, Display.a(this.az)), this.p(), this.r(), new h(f2, this.u()), new h(f1, this.v()), this.x());
    }

    public record j(GenericInterpolator<Transformation> a, BillboardConstraints b, int c, FloatInterpolator d, FloatInterpolator e, int f) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{j.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements INamable {
        public static final /* enum */ BillboardConstraints a = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints b = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints c = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints d = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> e;
        public static final IntFunction<BillboardConstraints> f;
        private final byte g;
        private final String h;
        private static final /* synthetic */ BillboardConstraints[] i;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])i.clone();
        }

        public static BillboardConstraints valueOf(String name) {
            return Enum.valueOf(BillboardConstraints.class, name);
        }

        private BillboardConstraints(byte id, String name) {
            this.h = name;
            this.g = id;
        }

        @Override
        public String c() {
            return this.h;
        }

        byte a() {
            return this.g;
        }

        private static /* synthetic */ BillboardConstraints[] b() {
            return new BillboardConstraints[]{a, b, c, d};
        }

        static {
            i = BillboardConstraints.b();
            e = INamable.a(BillboardConstraints::values);
            f = ByIdMap.a(BillboardConstraints::a, BillboardConstraints.values(), ByIdMap.a.a);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T value) {
            return partialTick -> value;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float value) {
            return partialTick -> value;
        }

        public float get(float var1);
    }

    record l(Transformation a, Transformation b) implements GenericInterpolator<Transformation>
    {
        public Transformation a(float partialTick) {
            return (double)partialTick >= 1.0 ? this.b : this.a.a(this.b, partialTick);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{l.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    record h(float a, float b) implements FloatInterpolator
    {
        @Override
        public float get(float partialTick) {
            return MathHelper.h(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String o = "text";
        private static final String aN = "line_width";
        private static final String aO = "text_opacity";
        private static final String aP = "background";
        private static final String aQ = "shadow";
        private static final String aR = "see_through";
        private static final String aS = "default_background";
        private static final String aT = "alignment";
        public static final byte p = 1;
        public static final byte q = 2;
        public static final byte r = 4;
        public static final byte s = 8;
        public static final byte t = 16;
        private static final byte aU = -1;
        public static final int u = 0x40000000;
        private static final int aV = 200;
        private static final DataWatcherObject<IChatBaseComponent> aW = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.f);
        public static final DataWatcherObject<Integer> aX = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        public static final DataWatcherObject<Integer> aY = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Byte> aZ = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final DataWatcherObject<Byte> ba = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final IntSet bb = IntSet.of((int[])new int[]{aW.a(), aX.a(), aY.a(), aZ.a(), ba.a()});
        private @Nullable CachedInfo bc;
        private @Nullable e bd;

        public TextDisplay(EntityTypes<?> type, World level) {
            super(type, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(aW, IChatBaseComponent.i());
            builder.a(aX, 200);
            builder.a(aY, 0x40000000);
            builder.a(aZ, (byte)-1);
            builder.a(ba, (byte)0);
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (bb.contains(key.a())) {
                this.n = true;
            }
        }

        public IChatBaseComponent m() {
            return this.az.a(aW);
        }

        public void a(IChatBaseComponent text) {
            this.az.a(aW, text);
        }

        @Override
        public int n() {
            return this.az.a(aX);
        }

        @Override
        private void a(int lineWidth) {
            this.az.a(aX, lineWidth);
        }

        public byte p() {
            return this.az.a(aZ);
        }

        public void c(byte textOpacity) {
            this.az.a(aZ, textOpacity);
        }

        public int q() {
            return this.az.a(aY);
        }

        @Override
        private void b(int backgroundColor) {
            this.az.a(aY, backgroundColor);
        }

        public byte r() {
            return this.az.a(ba);
        }

        public void d(byte flags) {
            this.az.a(ba, flags);
        }

        private static byte a(byte flags, ValueInput input, String key, byte mask) {
            return input.a(key, false) ? (byte)(flags | mask) : flags;
        }

        @Override
        protected void a(ValueInput input) {
            super.a(input);
            this.a(input.a(aN, 200));
            this.c(input.a(aO, (byte)-1));
            this.b(input.a(aP, 0x40000000));
            byte b2 = TextDisplay.a((byte)0, input, aQ, (byte)1);
            b2 = TextDisplay.a(b2, input, aR, (byte)2);
            b2 = TextDisplay.a(b2, input, aS, (byte)4);
            Optional<Align> optional = input.a(aT, Align.d);
            if (optional.isPresent()) {
                b2 = switch (optional.get().ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> b2;
                    case 1 -> (byte)(b2 | 8);
                    case 2 -> (byte)(b2 | 0x10);
                };
            }
            this.d(b2);
            Optional<IChatBaseComponent> optional1 = input.a(o, ComponentSerialization.a);
            if (optional1.isPresent()) {
                try {
                    World world = this.ao();
                    if (world instanceof WorldServer) {
                        WorldServer serverLevel = (WorldServer)world;
                        CommandListenerWrapper commandSourceStack = this.d(serverLevel).a(LevelBasedPermissionSet.c);
                        IChatMutableComponent component = ChatComponentUtils.a(commandSourceStack, optional1.get(), (Entity)this, 0);
                        this.a(component);
                    } else {
                        this.a(IChatBaseComponent.i());
                    }
                }
                catch (Exception var8) {
                    o.warn("Failed to parse display entity text {}", optional1, (Object)var8);
                }
            }
        }

        private static void a(byte flags, ValueOutput output, String key, byte mask) {
            output.a(key, (flags & mask) != 0);
        }

        @Override
        protected void a(ValueOutput output) {
            super.a(output);
            output.a(o, ComponentSerialization.a, this.m());
            output.a(aN, this.n());
            output.a(aP, this.q());
            output.a(aO, this.p());
            byte flags = this.r();
            TextDisplay.a(flags, output, aQ, (byte)1);
            TextDisplay.a(flags, output, aR, (byte)2);
            TextDisplay.a(flags, output, aS, (byte)4);
            output.a(aT, Align.d, TextDisplay.a(flags));
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            this.bd = interpolate && this.bd != null ? this.a(this.bd, partialTick) : this.s();
            this.bc = null;
        }

        public @Nullable e k() {
            return this.bd;
        }

        private e s() {
            return new e(this.m(), this.n(), IntInterpolator.constant(this.p()), IntInterpolator.constant(this.q()), this.r());
        }

        private e a(e renderState, float partialTick) {
            int i2 = renderState.d.get(partialTick);
            int i1 = renderState.c.get(partialTick);
            return new e(this.m(), this.n(), new i(i1, this.p()), new ColorInterpolator(i2, this.q()), this.r());
        }

        public CachedInfo a(LineSplitter splitter) {
            if (this.bc == null) {
                this.bc = this.bd != null ? splitter.split(this.bd.a(), this.bd.b()) : new CachedInfo(List.of(), 0);
            }
            return this.bc;
        }

        public static Align a(byte flags) {
            if ((flags & 8) != 0) {
                return Align.b;
            }
            return (flags & 0x10) != 0 ? Align.c : Align.a;
        }

        public static final class Align
        extends Enum<Align>
        implements INamable {
            public static final /* enum */ Align a = new Align("center");
            public static final /* enum */ Align b = new Align("left");
            public static final /* enum */ Align c = new Align("right");
            public static final Codec<Align> d;
            private final String e;
            private static final /* synthetic */ Align[] f;

            public static Align[] values() {
                return (Align[])f.clone();
            }

            public static Align valueOf(String name) {
                return Enum.valueOf(Align.class, name);
            }

            private Align(String name) {
                this.e = name;
            }

            @Override
            public String c() {
                return this.e;
            }

            private static /* synthetic */ Align[] a() {
                return new Align[]{a, b, c};
            }

            static {
                f = Align.a();
                d = INamable.a(Align::values);
            }
        }

        public record e(IChatBaseComponent a, int b, IntInterpolator c, IntInterpolator d, byte e) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this, o2);
            }
        }

        public record CachedInfo(List<CachedLine> a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this, o2);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this, o2);
            }
        }
    }

    record i(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float partialTick) {
            return MathHelper.a(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String o = "item";
        private static final String p = "item_display";
        private static final DataWatcherObject<ItemStack> q = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.h);
        private static final DataWatcherObject<Byte> r = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.a);
        private final SlotAccess s = SlotAccess.a(this::m, this::a);
        private @Nullable a t;

        public ItemDisplay(EntityTypes<?> type, World level) {
            super(type, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(q, ItemStack.l);
            builder.a(r, ItemDisplayContext.a.a());
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (q.equals(key) || r.equals(key)) {
                this.n = true;
            }
        }

        public ItemStack m() {
            return this.az.a(q);
        }

        public void a(ItemStack stack) {
            this.az.a(q, stack);
        }

        public void a(ItemDisplayContext itemTransform) {
            this.az.a(r, itemTransform.a());
        }

        public ItemDisplayContext n() {
            return ItemDisplayContext.l.apply(this.az.a(r).byteValue());
        }

        @Override
        protected void a(ValueInput input) {
            super.a(input);
            this.a(input.a(o, ItemStack.b).orElse(ItemStack.l));
            this.a(input.a(p, ItemDisplayContext.k).orElse(ItemDisplayContext.a));
        }

        @Override
        protected void a(ValueOutput output) {
            super.a(output);
            ItemStack itemStack = this.m();
            if (!itemStack.f()) {
                output.a(o, ItemStack.b, itemStack);
            }
            output.a(p, ItemDisplayContext.k, this.n());
        }

        @Override
        public @Nullable SlotAccess a_(int slot) {
            return slot == 0 ? this.s : null;
        }

        public @Nullable a k() {
            return this.t;
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            ItemStack itemStack = this.m();
            itemStack.a(this);
            this.t = new a(itemStack, this.n());
        }

        public record a(ItemStack a, ItemDisplayContext b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this, o2);
            }
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int value) {
            return partialTick -> value;
        }

        public int get(float var1);
    }

    record ColorInterpolator(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float partialTick) {
            return ARGB.a(partialTick, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String o = "block_state";
        private static final DataWatcherObject<IBlockData> p = DataWatcher.a(BlockDisplay.class, DataWatcherRegistry.i);
        private @Nullable a q;

        public BlockDisplay(EntityTypes<?> type, World level) {
            super(type, level);
        }

        @Override
        protected void a(DataWatcher.a builder) {
            super.a(builder);
            builder.a(p, Blocks.a.m());
        }

        @Override
        public void a(DataWatcherObject<?> key) {
            super.a(key);
            if (key.equals(p)) {
                this.n = true;
            }
        }

        public IBlockData m() {
            return this.az.a(p);
        }

        public void c(IBlockData state) {
            this.az.a(p, state);
        }

        @Override
        protected void a(ValueInput input) {
            super.a(input);
            this.c(input.a(o, IBlockData.a).orElse(Blocks.a.m()));
        }

        @Override
        protected void a(ValueOutput output) {
            super.a(output);
            output.a(o, IBlockData.a, this.m());
        }

        public @Nullable a k() {
            return this.q;
        }

        @Override
        protected void a(boolean interpolate, float partialTick) {
            this.q = new a(this.m());
        }

        public record a(IBlockData a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState", "a"}, this, o2);
            }
        }
    }
}

