/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public abstract class EntityAgeable
extends EntityCreature {
    private static final DataWatcherObject<Boolean> cv = DataWatcher.a(EntityAgeable.class, DataWatcherRegistry.k);
    public static final int a = -24000;
    private static final int cw = 40;
    protected static final int b = 0;
    protected static final int c = 0;
    protected int d = 0;
    protected int e = 0;
    protected int f;
    public boolean ageLocked;

    protected EntityAgeable(EntityTypes<? extends EntityAgeable> type, World level) {
        super((EntityTypes<? extends EntityCreature>)type, level);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        a ageableMobGroupData;
        if (spawnGroupData == null) {
            spawnGroupData = new a(true);
        }
        if ((ageableMobGroupData = (a)spawnGroupData).c() && ageableMobGroupData.a() > 0 && level.G_().i() <= ageableMobGroupData.d()) {
            this.d_(-24000);
        }
        ageableMobGroupData.b();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public abstract @Nullable EntityAgeable a(WorldServer var1, EntityAgeable var2);

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, false);
    }

    public boolean Y_() {
        return false;
    }

    public int Z_() {
        if (this.ao().B_()) {
            return this.az.a(cv) != false ? -1 : 1;
        }
        return this.d;
    }

    public void a(int amount, boolean forced) {
        int age;
        if (this.ageLocked) {
            return;
        }
        int previousAge = age = this.Z_();
        if ((age += amount * 20) > 0) {
            age = 0;
        }
        int i1 = age - previousAge;
        this.d_(age);
        if (forced) {
            this.e += i1;
            if (this.f == 0) {
                this.f = 40;
            }
        }
        if (this.Z_() == 0) {
            this.d_(this.e);
        }
    }

    public void c_(int amount) {
        this.a(amount, false);
    }

    public void d_(int age) {
        int age1 = this.Z_();
        this.d = age;
        if (age1 < 0 && age >= 0 || age1 >= 0 && age < 0) {
            this.az.a(cv, age < 0);
            this.h();
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Age", this.Z_());
        output.a("ForcedAge", this.e);
        output.a("AgeLocked", this.ageLocked);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.d_(input.a("Age", 0));
        this.e = input.a("ForcedAge", 0);
        this.ageLocked = input.a("AgeLocked", false);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cv.equals(key)) {
            this.j_();
        }
        super.a(key);
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.ao().B_() || this.ageLocked) {
            this.j_();
        } else {
            int age = this.Z_();
            if (age < 0) {
                this.d_(++age);
            } else if (age > 0) {
                this.d_(--age);
            }
        }
    }

    @Override
    public void d_() {
        super.d_();
        if (this.ao().B_() || this.ageLocked) {
            if (this.f > 0) {
                if (this.f % 4 == 0) {
                    this.ao().a(Particles.R, this.e(1.0), this.dS() + 0.5, this.h(1.0), 0.0, 0.0, 0.0);
                }
                --this.f;
            }
        } else if (this.cb()) {
            int age = this.Z_();
            if (age < 0) {
                this.d_(++age);
            } else if (age > 0) {
                this.d_(--age);
            }
        }
    }

    protected void h() {
        AbstractBoat abstractBoat;
        Entity entity;
        if (!this.e_() && this.cq() && (entity = this.dz()) instanceof AbstractBoat && !(abstractBoat = (AbstractBoat)entity).C(this)) {
            this.cf();
        }
    }

    @Override
    public boolean e_() {
        return this.Z_() < 0;
    }

    @Override
    public void a_(boolean baby) {
        this.d_(baby ? -24000 : 0);
    }

    public static int d(int ticksUntilAdult) {
        return (int)((float)(ticksUntilAdult / 20) * 0.1f);
    }

    @VisibleForTesting
    public int j() {
        return this.e;
    }

    @VisibleForTesting
    public int k() {
        return this.f;
    }

    public static class a
    implements GroupDataEntity {
        private int a;
        private final boolean b;
        private final float c;

        public a(boolean shouldSpawnBaby, float babySpawnChance) {
            this.b = shouldSpawnBaby;
            this.c = babySpawnChance;
        }

        public a(boolean shouldSpawnBaby) {
            this(shouldSpawnBaby, 0.05f);
        }

        public a(float babySpawnChance) {
            this(true, babySpawnChance);
        }

        public int a() {
            return this.a;
        }

        public void b() {
            ++this.a;
        }

        public boolean c() {
            return this.b;
        }

        public float d() {
            return this.c;
        }
    }
}

