/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int e = 5;
    private static final DataWatcherObject<Float> f = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Boolean> g = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<ParticleParam> h = DataWatcher.a(EntityAreaEffectCloud.class, DataWatcherRegistry.l);
    private static final float i = 32.0f;
    private static final int j = 0;
    private static final int k = 0;
    private static final float l = 0.0f;
    private static final float m = 0.0f;
    private static final float n = 1.0f;
    private static final float o = 0.5f;
    private static final float p = 3.0f;
    public static final float a = 6.0f;
    public static final float b = 0.5f;
    public static final int c = -1;
    public static final int d = 600;
    private static final int q = 20;
    private static final int r = 20;
    private static final ColorParticleOption s = ColorParticleOption.a(Particles.v, -1);
    private @Nullable ParticleParam t;
    public PotionContents u = PotionContents.a;
    private float aN = 1.0f;
    private final Map<Entity, Integer> aO = Maps.newHashMap();
    private int aP = -1;
    public int aQ = 20;
    public int aR = 20;
    public int aS = 0;
    public float aT = 0.0f;
    public float aU = 0.0f;
    public @Nullable EntityReference<EntityLiving> aV;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> type, World level) {
        super(type, level);
        this.ar = true;
    }

    public EntityAreaEffectCloud(World level, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.f, level);
        this.a_(x2, y2, z2);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(f, Float.valueOf(3.0f));
        builder.a(g, false);
        builder.a(h, s);
    }

    public void a(float radius) {
        if (!this.ao().B_()) {
            this.aD().a(f, Float.valueOf(MathHelper.a(radius, 0.0f, 32.0f)));
        }
    }

    @Override
    public void j_() {
        double x2 = this.dP();
        double y2 = this.dR();
        double z2 = this.dV();
        super.j_();
        this.a_(x2, y2, z2);
    }

    public float c() {
        return this.aD().a(f).floatValue();
    }

    public void a(PotionContents potionContents) {
        this.u = potionContents;
        this.q();
    }

    public void a(@Nullable ParticleParam customParticle) {
        this.t = customParticle;
        this.q();
    }

    public void b(float potionDurationScale) {
        this.aN = potionDurationScale;
    }

    private void q() {
        if (this.t != null) {
            this.az.a(h, this.t);
        } else {
            int i2 = ARGB.g(this.u.b());
            this.az.a(h, ColorParticleOption.a(s.a(), i2));
        }
    }

    public void a(MobEffect effectInstance) {
        this.a(this.u.a(effectInstance));
    }

    public ParticleParam e() {
        return this.aD().a(h);
    }

    protected void a(boolean waiting) {
        this.aD().a(g, waiting);
    }

    public boolean f() {
        return this.aD().a(g);
    }

    public int h() {
        return this.aP;
    }

    public void a(int duration) {
        this.aP = duration;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.at >= this.aQ + this.aP) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    public void g() {
        super.g();
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel);
        } else {
            this.r();
        }
    }

    private void r() {
        boolean isWaiting = this.f();
        float radius = this.c();
        if (!isWaiting || !this.as.h()) {
            float f2;
            int i2;
            ParticleParam particle = this.e();
            if (isWaiting) {
                i2 = 2;
                f2 = 0.2f;
            } else {
                i2 = MathHelper.d((float)Math.PI * radius * radius);
                f2 = radius;
            }
            for (int i1 = 0; i1 < i2; ++i1) {
                float f1 = this.as.i() * ((float)Math.PI * 2);
                float f22 = MathHelper.a(this.as.i()) * f2;
                double d2 = this.dP() + (double)(MathHelper.b((double)f1) * f22);
                double y2 = this.dR();
                double d1 = this.dV() + (double)(MathHelper.a((double)f1) * f22);
                if (particle.a() == Particles.v) {
                    if (isWaiting && this.as.h()) {
                        this.ao().b(s, d2, y2, d1, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.ao().b(particle, d2, y2, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                if (isWaiting) {
                    this.ao().b(particle, d2, y2, d1, 0.0, 0.0, 0.0);
                    continue;
                }
                this.ao().b(particle, d2, y2, d1, (0.5 - this.as.j()) * 0.15, 0.01f, (0.5 - this.as.j()) * 0.15);
            }
        }
    }

    private void a(WorldServer level) {
        if (this.aP != -1 && this.at - this.aQ >= this.aP) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag;
            boolean isWaiting = this.f();
            boolean bl = flag = this.at < this.aQ;
            if (isWaiting != flag) {
                this.a(flag);
            }
            if (!flag) {
                float radius = this.c();
                if (this.aU != 0.0f) {
                    if ((radius += this.aU) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.a(radius);
                }
                if (this.at % 5 == 0) {
                    this.aO.entrySet().removeIf(victim -> this.at >= (Integer)victim.getValue());
                    if (!this.u.c()) {
                        this.aO.clear();
                    } else {
                        ArrayList list = new ArrayList();
                        this.u.a(list::add, this.aN);
                        List<EntityLiving> entitiesOfClass = this.ao().a(EntityLiving.class, this.dj());
                        if (!entitiesOfClass.isEmpty()) {
                            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>();
                            for (EntityLiving livingEntity : entitiesOfClass) {
                                double d1;
                                double d2;
                                double d22;
                                if (this.aO.containsKey(livingEntity) || !livingEntity.gl()) continue;
                                if (list.stream().noneMatch(livingEntity::b) || !((d22 = (d2 = livingEntity.dP() - this.dP()) * d2 + (d1 = livingEntity.dV() - this.dV()) * d1) <= (double)(radius * radius))) continue;
                                entities.add((LivingEntity)livingEntity.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    EntityLiving livingEntity = ((CraftLivingEntity)entity).getHandle();
                                    this.aO.put(livingEntity, this.at + this.aR);
                                    for (MobEffect mobEffectInstance : list) {
                                        if (mobEffectInstance.c().a().a()) {
                                            mobEffectInstance.c().a().a(level, this, this.n(), livingEntity, mobEffectInstance.e(), 0.5);
                                            continue;
                                        }
                                        livingEntity.addEffect(new MobEffect(mobEffectInstance), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.aT != 0.0f) {
                                        if ((radius += this.aT) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.a(radius);
                                    }
                                    if (this.aS == 0 || this.aP == -1) continue;
                                    this.aP += this.aS;
                                    if (this.aP > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float i() {
        return this.aT;
    }

    public void c(float radiusOnUse) {
        this.aT = radiusOnUse;
    }

    public float j() {
        return this.aU;
    }

    public void d(float radiusPerTick) {
        this.aU = radiusPerTick;
    }

    public int k() {
        return this.aS;
    }

    public void b(int durationOnUse) {
        this.aS = durationOnUse;
    }

    public int m() {
        return this.aQ;
    }

    public void d(int waitTime) {
        this.aQ = waitTime;
    }

    public void a(@Nullable EntityLiving owner) {
        this.aV = EntityReference.a(owner);
    }

    public @Nullable EntityLiving n() {
        return EntityReference.b(this.aV, this.ao());
    }

    @Override
    protected void a(ValueInput input) {
        this.at = input.a("Age", 0);
        this.aP = input.a("Duration", -1);
        this.aQ = input.a("WaitTime", 20);
        this.aR = input.a("ReapplicationDelay", 20);
        this.aS = input.a("DurationOnUse", 0);
        this.aT = input.a("RadiusOnUse", 0.0f);
        this.aU = input.a("RadiusPerTick", 0.0f);
        this.a(input.a("Radius", 3.0f));
        this.aV = EntityReference.a(input, "Owner");
        this.a((ParticleParam)input.a("custom_particle", Particles.bl).orElse(null));
        this.a(input.a("potion_contents", PotionContents.c).orElse(PotionContents.a));
        this.aN = input.a("potion_duration_scale", 1.0f);
    }

    @Override
    protected void a(ValueOutput output) {
        output.a("Age", this.at);
        output.a("Duration", this.aP);
        output.a("WaitTime", this.aQ);
        output.a("ReapplicationDelay", this.aR);
        output.a("DurationOnUse", this.aS);
        output.a("RadiusOnUse", this.aT);
        output.a("RadiusPerTick", this.aU);
        output.a("Radius", this.c());
        output.b("custom_particle", Particles.bl, this.t);
        EntityReference.a(this.aV, output, "Owner");
        if (!this.u.equals(PotionContents.a)) {
            output.a("potion_contents", PotionContents.c, this.u);
        }
        if (this.aN != 1.0f) {
            output.a("potion_duration_scale", this.aN);
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (f.equals(key)) {
            this.j_();
        }
        super.a(key);
    }

    @Override
    public EnumPistonReaction n_() {
        return EnumPistonReaction.d;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return EntitySize.b(this.c() * 2.0f, 0.5f);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        if (component == DataComponents.Y) {
            return EntityAreaEffectCloud.c(component, this.u);
        }
        return component == DataComponents.Z ? EntityAreaEffectCloud.c(component, Float.valueOf(this.aN)) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.Y);
        this.a(componentGetter, DataComponents.Z);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.Y) {
            this.a(EntityAreaEffectCloud.c(DataComponents.Y, value));
            return true;
        }
        if (component == DataComponents.Z) {
            this.b(EntityAreaEffectCloud.c(DataComponents.Z, value).floatValue());
            return true;
        }
        return super.b(component, value);
    }
}

