/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityAttachments {
    private final Map<EntityAttachment, List<Vec3D>> a;

    EntityAttachments(Map<EntityAttachment, List<Vec3D>> attachments) {
        this.a = attachments;
    }

    public static EntityAttachments a(float width, float height) {
        return EntityAttachments.a().a(width, height);
    }

    public static a a() {
        return new a();
    }

    public EntityAttachments a(float xScale, float yScale, float zScale) {
        return new EntityAttachments(SystemUtils.a(EntityAttachment.class, entityAttachment -> {
            ArrayList<Vec3D> list = new ArrayList<Vec3D>();
            for (Vec3D vec3 : this.a.get(entityAttachment)) {
                list.add(vec3.d(xScale, yScale, zScale));
            }
            return list;
        }));
    }

    public @Nullable Vec3D a(EntityAttachment attachment, int index, float yRot) {
        List<Vec3D> list = this.a.get((Object)attachment);
        return index >= 0 && index < list.size() ? EntityAttachments.a(list.get(index), yRot) : null;
    }

    public Vec3D b(EntityAttachment attachment, int index, float yRot) {
        Vec3D nullable = this.a(attachment, index, yRot);
        if (nullable == null) {
            throw new IllegalStateException("Had no attachment point of type: " + String.valueOf((Object)attachment) + " for index: " + index);
        }
        return nullable;
    }

    public Vec3D a(EntityAttachment attachment) {
        List<Vec3D> list = this.a.get((Object)attachment);
        if (list != null && !list.isEmpty()) {
            Vec3D vec3 = Vec3D.c;
            for (Vec3D vec31 : list) {
                vec3 = vec3.e(vec31);
            }
            return vec3.c((double)(1.0f / (float)list.size()));
        }
        throw new IllegalStateException("No attachment points of type: PASSENGER");
    }

    public Vec3D c(EntityAttachment attachment, int index, float yRot) {
        List<Vec3D> list = this.a.get((Object)attachment);
        if (list.isEmpty()) {
            throw new IllegalStateException("Had no attachment points of type: " + String.valueOf((Object)attachment));
        }
        Vec3D vec3 = list.get(MathHelper.a(index, 0, list.size() - 1));
        return EntityAttachments.a(vec3, yRot);
    }

    private static Vec3D a(Vec3D point, float yRot) {
        return point.b(-yRot * ((float)Math.PI / 180));
    }

    public static class a {
        private final Map<EntityAttachment, List<Vec3D>> a = new EnumMap<EntityAttachment, List<Vec3D>>(EntityAttachment.class);

        a() {
        }

        public a a(EntityAttachment attachment, float x2, float y2, float z2) {
            return this.a(attachment, new Vec3D(x2, y2, z2));
        }

        public a a(EntityAttachment attachment, Vec3D pos) {
            this.a.computeIfAbsent(attachment, entityAttachment -> new ArrayList(1)).add(pos);
            return this;
        }

        public EntityAttachments a(float width, float height) {
            Map<EntityAttachment, List<Vec3D>> map = SystemUtils.a(EntityAttachment.class, entityAttachment -> {
                List<Vec3D> list = this.a.get(entityAttachment);
                return list == null ? entityAttachment.a(width, height) : List.copyOf(list);
            });
            return new EntityAttachments(map);
        }
    }
}

