/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.entity.ai.PaperCustomGoal;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DespawnRange;
import io.papermc.paper.util.PaperCodecs;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugBrainDump;
import net.minecraft.util.debug.DebugGoalInfo;
import net.minecraft.util.debug.DebugPathInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int r = 1;
    private static final BaseBlockPosition e = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> cu = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float s = 0.15f;
    public static final float t = 0.1087f;
    public static final float cc = 3.0f;
    public static final float cd = 0.55f;
    public static final float ce = 0.5f;
    public static final float cf = 0.25f;
    public static final int cg = 2;
    private static final double cv = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean cw = false;
    private static final boolean cx = false;
    private static final boolean cy = false;
    private static final boolean cz = false;
    protected static final MinecraftKey ch = MinecraftKey.b("random_spawn_bonus");
    public static final String ci = "drop_chances";
    public static final String cj = "LeftHanded";
    public static final String ck = "CanPickUpLoot";
    public static final String cl = "NoAI";
    public int cm;
    protected int cn;
    protected ControllerLook co;
    protected ControllerMove cp;
    protected ControllerJump cq;
    private final EntityAIBodyControl cA;
    protected NavigationAbstract cr;
    public PathfinderGoalSelector cs;
    public @Nullable PathfinderGoalFloat goalFloat;
    public PathfinderGoalSelector ct;
    private @Nullable EntityLiving cB;
    private final EntitySenses cC;
    private DropChances cD = DropChances.d;
    private boolean cE = false;
    private boolean cF = false;
    private final Map<PathType, Float> cG = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> cH = Optional.empty();
    public long cI;
    private @Nullable Leashable.a cJ;
    private BlockPosition cK = BlockPosition.c;
    private int cL = -1;
    public boolean aware = true;
    public TriState despawnInPeacefulOverride = TriState.NOT_SET;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> type, World level) {
        super((EntityTypes<? extends EntityLiving>)type, level);
        this.cs = new PathfinderGoalSelector();
        this.ct = new PathfinderGoalSelector();
        this.co = new ControllerLook(this);
        this.cp = new ControllerMove(this);
        this.cq = new ControllerJump(this);
        this.cA = this.I();
        this.cr = this.b(level);
        this.cC = new EntitySenses(this);
        if (level instanceof WorldServer) {
            this.D();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.cF = persistenceRequired;
    }

    @Override
    protected void D() {
    }

    public static AttributeProvider.Builder E() {
        return EntityLiving.ex().a(GenericAttributes.o, 16.0);
    }

    protected NavigationAbstract b(World level) {
        return new Navigation(this, level);
    }

    protected boolean F() {
        return false;
    }

    public float a(PathType pathType) {
        EntityInsentient mob;
        Entity entity = this.dA();
        EntityInsentient mob1 = entity instanceof EntityInsentient && (mob = (EntityInsentient)entity).F() ? mob : this;
        Float _float = mob1.cG.get((Object)pathType);
        return _float == null ? pathType.a() : _float.floatValue();
    }

    public void a(PathType pathType, float malus) {
        this.cG.put(pathType, Float.valueOf(malus));
    }

    public void G() {
    }

    public void H() {
    }

    protected EntityAIBodyControl I() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook J() {
        return this.co;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.cs.inactiveTick()) {
            this.cs.a();
        }
        if (this.ct.inactiveTick()) {
            this.ct.a();
        }
    }

    public ControllerMove K() {
        ControllerMove controllerMove;
        Entity entity = this.dA();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            controllerMove = mob.K();
        } else {
            controllerMove = this.cp;
        }
        return controllerMove;
    }

    public ControllerJump L() {
        return this.cq;
    }

    public NavigationAbstract N() {
        NavigationAbstract navigationAbstract;
        Entity entity = this.dA();
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            navigationAbstract = mob.N();
        } else {
            navigationAbstract = this.cr;
        }
        return navigationAbstract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public @Nullable EntityLiving dl() {
        Entity firstPassenger = this.do();
        if (this.gG()) return null;
        if (!(firstPassenger instanceof EntityInsentient)) return null;
        EntityInsentient mob = (EntityInsentient)firstPassenger;
        if (!firstPassenger.ct()) return null;
        EntityInsentient entityInsentient = mob;
        return entityInsentient;
    }

    public EntitySenses P() {
        return this.cC;
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.cB;
    }

    protected final @Nullable EntityLiving Q() {
        return this.ev().c(MemoryModuleType.p).orElse(null);
    }

    public void g(@Nullable EntityLiving target) {
        this.setTarget(target, EntityTargetEvent.TargetReason.UNKNOWN);
    }

    public boolean setTarget(@Nullable EntityLiving target, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTargetEvent.TargetReason reason) {
        if (this.ag_() == target) {
            return false;
        }
        if (reason != null) {
            EntityTargetLivingEntityEvent event;
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.ag_() != null && target == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.ag_().cb() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.ao().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (target != null) {
                ctarget = (CraftLivingEntity)target.getBukkitEntity();
            }
            if (!(event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason)).callEvent()) {
                return false;
            }
            target = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.cB = target;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return type != EntityTypes.ah;
    }

    public boolean g(ItemStack stack) {
        return false;
    }

    public void R() {
        this.c(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)0);
    }

    public int S() {
        return 80;
    }

    public void T() {
        this.b(this.W());
    }

    @Override
    public void aJ() {
        super.aJ();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("mobBaseTick");
        if (this.cb() && this.as.a(1000) < this.cm++) {
            this.k();
            this.T();
        }
        profilerFiller.c();
    }

    @Override
    protected void g(DamageSource damageSource) {
        this.k();
        super.g(damageSource);
    }

    private void k() {
        this.cm = -this.S();
    }

    @Override
    protected int f(WorldServer level) {
        if (this.cn > 0) {
            int i2 = this.cn;
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                ItemStack itemBySlot;
                if (!equipmentSlot.g() || (itemBySlot = this.a(equipmentSlot)).f() || !(this.cD.b(equipmentSlot) <= 1.0f)) continue;
                i2 += 1 + this.as.a(3);
            }
            return i2;
        }
        return this.cn;
    }

    public void U() {
        if (this.ao().B_()) {
            this.fu();
        } else {
            this.ao().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 20) {
            this.U();
        } else {
            super.b(id);
        }
    }

    @Override
    public void g() {
        super.g();
        if (!this.ao().B_() && this.at % 5 == 0) {
            this.V();
        }
    }

    protected void V() {
        boolean flag = !(this.dl() instanceof EntityInsentient);
        boolean flag1 = !(this.dz() instanceof AbstractBoat);
        this.cs.a(PathfinderGoal.Type.a, flag);
        this.cs.a(PathfinderGoal.Type.c, flag && flag1);
        this.cs.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected void D(float yBodyRot) {
        this.cA.a();
    }

    public @Nullable SoundEffect W() {
        return null;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(ck, this.gn());
        output.a("PersistenceRequired", this.cF);
        if (!this.cD.equals(DropChances.d)) {
            output.a(ci, DropChances.e, this.cD);
        }
        this.a(output, this.cJ);
        if (this.gF()) {
            output.a("home_radius", this.cL);
            output.a("home_pos", BlockPosition.a, this.cK);
        }
        output.a(cj, this.gH());
        this.cH.ifPresent(resourceKey -> output.a("DeathLootTable", LootTable.a, resourceKey));
        if (this.cI != 0L) {
            output.a("DeathLootTableSeed", this.cI);
        }
        if (this.gG()) {
            output.a(cl, this.gG());
        }
        output.a("Bukkit.Aware", this.aware);
        if (this.despawnInPeacefulOverride != TriState.NOT_SET) {
            output.a("Paper.DespawnInPeacefulOverride", this.despawnInPeacefulOverride.name());
        }
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        boolean canPickUpLoot = input.a(ck, false);
        if (EntityInsentient.isLevelAtLeast(input, 1) || canPickUpLoot) {
            this.b_(canPickUpLoot);
        }
        boolean persistenceRequired = input.a("PersistenceRequired", false);
        if (EntityInsentient.isLevelAtLeast(input, 1) || persistenceRequired) {
            this.cF = persistenceRequired;
        }
        this.cD = input.a(ci, DropChances.e).orElse(DropChances.d);
        this.b(input);
        this.cL = input.a("home_radius", -1);
        if (this.cL >= 0) {
            this.cK = input.a("home_pos", BlockPosition.a).orElse(BlockPosition.c);
        }
        this.v(input.a(cj, false));
        this.cH = input.a("DeathLootTable", LootTable.a);
        this.cI = input.a("DeathLootTableSeed", 0L);
        this.u(input.a(cl, false));
        this.aware = input.a("Bukkit.Aware", true);
        this.despawnInPeacefulOverride = EntityInsentient.readDespawnInPeacefulOverride(input);
    }

    public static TriState readDespawnInPeacefulOverride(ValueInput input) {
        return input.a("Paper.DespawnInPeacefulOverride", PaperCodecs.TRI_STATE_CODEC).orElse(TriState.NOT_SET);
    }

    @Override
    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        super.b(level, damageSource, playerKill);
        this.cH = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> er() {
        return this.cH.isPresent() ? this.cH : super.er();
    }

    @Override
    public long fc() {
        return this.cI;
    }

    public void I(float amount) {
        this.bP = amount;
    }

    public void J(float amount) {
        this.bO = amount;
    }

    public void K(float amount) {
        this.bN = amount;
    }

    @Override
    public void C(float speed) {
        super.C(speed);
        this.I(speed);
    }

    public void X() {
        this.N().n();
        this.K(0.0f);
        this.J(0.0f);
        this.C(0.0f);
        this.m(0.0, 0.0, 0.0);
        this.gM();
    }

    @Override
    public void d_() {
        super.d_();
        if (this.ay().a(TagsEntity.e)) {
            this.p();
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("looting");
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.gn() && this.cb() && !this.bJ && serverLevel.U().a(GameRules.F).booleanValue()) {
                BaseBlockPosition pickupReach = this.Z();
                for (EntityItem itemEntity : this.ao().a(EntityItem.class, this.dj().c(pickupReach.u(), pickupReach.v(), pickupReach.w()))) {
                    if (itemEntity.eh() || itemEntity.e().f() || itemEntity.n() || !this.c(serverLevel, itemEntity.e()) || !itemEntity.canMobPickup) continue;
                    this.a(serverLevel, itemEntity);
                }
            }
        }
        profilerFiller.c();
    }

    protected EnumItemSlot Y() {
        return EnumItemSlot.f;
    }

    private void p() {
        if (this.cb() && this.gL()) {
            EnumItemSlot equipmentSlot = this.Y();
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (!itemBySlot.f()) {
                if (itemBySlot.m()) {
                    Item item = itemBySlot.h();
                    itemBySlot.b(itemBySlot.o() + this.as.a(2));
                    if (itemBySlot.o() >= itemBySlot.p()) {
                        this.a(item, equipmentSlot);
                        this.a(equipmentSlot, ItemStack.l);
                    }
                }
            } else {
                this.e(8.0f);
            }
        }
    }

    public boolean gL() {
        if (!this.ao().B_() && this.ao().c().a(EnvironmentAttributes.P, this.dI()).booleanValue()) {
            boolean flag;
            float lightLevelDependentMagicValue = this.bO();
            BlockPosition blockPos = BlockPosition.a(this.dP(), this.dT(), this.dV());
            boolean bl = flag = this.bA() || this.aJ || this.aK;
            if (lightLevelDependentMagicValue > 0.5f && this.as.i() * 30.0f < (lightLevelDependentMagicValue - 0.4f) * 2.0f && !flag && this.ao().k(blockPos)) {
                return true;
            }
        }
        return false;
    }

    protected BaseBlockPosition Z() {
        return e;
    }

    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.e();
        ItemStack itemStack = this.equipItemIfPossible(level, item.v(), entity);
        if (!itemStack.f()) {
            this.a(entity);
            this.a((Entity)entity, itemStack.N());
            item.h(itemStack.N());
            if (item.f()) {
                entity.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer level, ItemStack stack) {
        return this.equipItemIfPossible(level, stack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer level, ItemStack stack, @Nullable EntityItem entity) {
        boolean canPickup;
        EnumItemSlot equipmentSlotForItem = this.f(stack);
        if (!this.a(stack, equipmentSlotForItem)) {
            return ItemStack.l;
        }
        ItemStack itemBySlot = this.a(equipmentSlotForItem);
        boolean canReplaceCurrentItem = this.a(stack, itemBySlot, equipmentSlotForItem);
        if (equipmentSlotForItem.f() && !canReplaceCurrentItem) {
            equipmentSlotForItem = EnumItemSlot.a;
            itemBySlot = this.a(equipmentSlotForItem);
            canReplaceCurrentItem = itemBySlot.f();
        }
        boolean bl = canPickup = canReplaceCurrentItem && this.h(stack);
        if (entity != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entity, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d2 = this.cD.b(equipmentSlotForItem);
            if (!itemBySlot.f() && (double)Math.max(this.as.i() - 0.1f, 0.0f) < d2) {
                this.forceDrops = true;
                this.a(level, itemBySlot);
                this.forceDrops = false;
            }
            ItemStack itemStack = equipmentSlotForItem.a(stack);
            this.b(equipmentSlotForItem, itemStack);
            return itemStack;
        }
        return ItemStack.l;
    }

    protected void b(EnumItemSlot slot, ItemStack stack) {
        this.a(slot, stack);
        this.g(slot);
        this.cF = true;
    }

    protected boolean b_(EntityHuman player) {
        return !this.cr();
    }

    public void g(EnumItemSlot slot) {
        this.cD = this.cD.a(slot);
    }

    protected boolean a(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (currentItem.f()) {
            return true;
        }
        return slot.f() ? this.b(newItem, currentItem, slot) : slot == EnumItemSlot.a && this.c(newItem, currentItem, slot);
    }

    private boolean b(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        if (EnchantmentManager.a(currentItem, EnchantmentEffectComponents.F)) {
            return false;
        }
        double approximateAttributeWith = this.a(newItem, GenericAttributes.b, slot);
        double approximateAttributeWith1 = this.a(currentItem, GenericAttributes.b, slot);
        double approximateAttributeWith2 = this.a(newItem, GenericAttributes.c, slot);
        double approximateAttributeWith3 = this.a(currentItem, GenericAttributes.c, slot);
        if (approximateAttributeWith != approximateAttributeWith1) {
            return approximateAttributeWith > approximateAttributeWith1;
        }
        return approximateAttributeWith2 != approximateAttributeWith3 ? approximateAttributeWith2 > approximateAttributeWith3 : this.b(newItem, currentItem);
    }

    private boolean c(ItemStack newItem, ItemStack currentItem, EnumItemSlot slot) {
        double approximateAttributeWith1;
        double approximateAttributeWith;
        TagKey<Item> preferredWeaponType = this.aa();
        if (preferredWeaponType != null) {
            if (currentItem.a(preferredWeaponType) && !newItem.a(preferredWeaponType)) {
                return false;
            }
            if (!currentItem.a(preferredWeaponType) && newItem.a(preferredWeaponType)) {
                return true;
            }
        }
        return (approximateAttributeWith = this.a(newItem, GenericAttributes.d, slot)) != (approximateAttributeWith1 = this.a(currentItem, GenericAttributes.d, slot)) ? approximateAttributeWith > approximateAttributeWith1 : this.b(newItem, currentItem);
    }

    private double a(ItemStack item, Holder<AttributeBase> attribute, EnumItemSlot slot) {
        double d2 = this.fw().b(attribute) ? this.j(attribute) : 0.0;
        ItemAttributeModifiers itemAttributeModifiers = item.a(DataComponents.r, ItemAttributeModifiers.a);
        return itemAttributeModifiers.a(attribute, d2, slot);
    }

    public boolean b(ItemStack candidate, ItemStack existing) {
        int damageValue1;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = existing.a(DataComponents.o, ItemEnchantments.a).b();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = candidate.a(DataComponents.o, ItemEnchantments.a).b();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int damageValue = candidate.o();
        return damageValue != (damageValue1 = existing.o()) ? damageValue < damageValue1 : candidate.c(DataComponents.h) && !existing.c(DataComponents.h);
    }

    public boolean h(ItemStack stack) {
        return true;
    }

    public boolean c(WorldServer level, ItemStack stack) {
        return this.h(stack);
    }

    public @Nullable TagKey<Item> aa() {
        return null;
    }

    public boolean i(double distanceToClosestPlayer) {
        return true;
    }

    public boolean ab() {
        return this.cq();
    }

    public final boolean shouldDespawnInPeaceful() {
        return this.despawnInPeacefulOverride.toBooleanOrElse(!this.ay().isTypeAllowedInPeaceful());
    }

    @Override
    public void dW() {
        if (this.ao().av() == EnumDifficulty.a && this.shouldDespawnInPeaceful()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.gA() && !this.ab()) {
            EntityHuman nearestPlayer = this.ao().findNearbyPlayer(this, -1.0, IEntitySelector.PLAYER_AFFECTS_SPAWNING);
            if (nearestPlayer != null) {
                WorldConfiguration.Entities.Spawning.DespawnRangePair despawnRangePair = this.ao().paperConfig().entities.spawning.despawnRanges.get(this.ay().f());
                DespawnRange.Shape shape = this.ao().paperConfig().entities.spawning.despawnRangeShape;
                double dy = Math.abs(nearestPlayer.dR() - this.dR());
                double dySqr = MathHelper.n(dy);
                double dxSqr = MathHelper.n(nearestPlayer.dP() - this.dP());
                double dzSqr = MathHelper.n(nearestPlayer.dV() - this.dV());
                double distanceSquared = dxSqr + dzSqr + dySqr;
                if (despawnRangePair.hard().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy) && this.i(distanceSquared)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                if (despawnRangePair.soft().shouldDespawn(shape, dxSqr, dySqr, dzSqr, dy)) {
                    if (this.bK > 600 && this.as.a(800) == 0 && this.i(distanceSquared)) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    }
                } else {
                    this.bK = 0;
                }
            }
        } else {
            this.bK = 0;
        }
    }

    @Override
    protected final void fV() {
        ++this.bK;
        if (!this.aware) {
            if (this.goalFloat != null) {
                if (this.goalFloat.b()) {
                    this.goalFloat.a();
                }
                this.L().b();
            }
            return;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("sensing");
        this.cC.a();
        profilerFiller.c();
        int i2 = this.at + this.aA();
        if (i2 % 2 != 0 && this.at > 1) {
            profilerFiller.a("targetSelector");
            this.ct.a(false);
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.cs.a(false);
            profilerFiller.c();
        } else {
            profilerFiller.a("targetSelector");
            this.ct.a();
            profilerFiller.c();
            profilerFiller.a("goalSelector");
            this.cs.a();
            profilerFiller.c();
        }
        profilerFiller.a("navigation");
        this.cr.d();
        profilerFiller.c();
        profilerFiller.a("mob tick");
        this.a((WorldServer)this.ao());
        profilerFiller.c();
        profilerFiller.a("controls");
        profilerFiller.a("move");
        this.cp.a();
        profilerFiller.b("look");
        this.co.a();
        profilerFiller.b("jump");
        this.cq.b();
        profilerFiller.c();
        profilerFiller.c();
    }

    protected void a(WorldServer level) {
    }

    public int ac() {
        return 40;
    }

    public int ae() {
        return 75;
    }

    protected void af() {
        float f2 = this.ae();
        float yHeadRot = this.cS();
        float f1 = MathHelper.f(this.bC - yHeadRot);
        float f22 = MathHelper.a(MathHelper.f(this.bC - yHeadRot), -f2, f2);
        float f3 = yHeadRot + f1 - f22;
        this.r(f3);
    }

    public int ai() {
        return 10;
    }

    public void a(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
        double d2;
        double d3 = entity.dP() - this.dP();
        double d1 = entity.dV() - this.dV();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            d2 = livingEntity.dT() - this.dT();
        } else {
            d2 = (entity.dj().b + entity.dj().e) / 2.0 - this.dT();
        }
        double squareRoot = Math.sqrt(d3 * d3 + d1 * d1);
        float f2 = (float)(MathHelper.d(d1, d3) * 180.0 / 3.1415927410125732) - 90.0f;
        float f1 = (float)(-(MathHelper.d(d2, squareRoot) * 180.0 / 3.1415927410125732));
        this.w(this.a(this.ee(), f1, maxXRotIncrease));
        this.v(this.a(this.ec(), f2, maxYRotIncrease));
    }

    private float a(float angle, float targetAngle, float maxIncrease) {
        float f2 = MathHelper.f(targetAngle - angle);
        if (f2 > maxIncrease) {
            f2 = maxIncrease;
        }
        if (f2 < -maxIncrease) {
            f2 = -maxIncrease;
        }
        return angle + f2;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        BlockPosition blockPos = pos.e();
        return EntitySpawnReason.a(spawnReason) || level.a_(blockPos).a((IBlockAccess)level, blockPos, entityType);
    }

    public boolean a(GeneratorAccess level, EntitySpawnReason spawnReason) {
        return true;
    }

    public boolean a(IWorldReader level) {
        return !level.d(this.dj()) && level.f(this);
    }

    public int aj() {
        return 4;
    }

    public boolean q(int size) {
        return false;
    }

    @Override
    public int cW() {
        if (this.ag_() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eZ() - this.fq() * 0.33f);
        if ((i2 -= (3 - this.ao().av().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    public ItemStack ak() {
        return this.a(EnumItemSlot.g);
    }

    public boolean al() {
        return this.i(EnumItemSlot.h);
    }

    public boolean am() {
        return this.i(EnumItemSlot.g);
    }

    private boolean i(EnumItemSlot slot) {
        return this.d(slot) && this.a(this.a(slot), slot);
    }

    public void i(ItemStack stack) {
        this.b(EnumItemSlot.g, stack);
    }

    public IInventory h(final EnumItemSlot slot) {
        return new ContainerSingleItem(){
            private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();
            private int maxStackSize = 99;

            @Override
            public ItemStack g() {
                return EntityInsentient.this.a(slot);
            }

            @Override
            public void b(ItemStack item) {
                EntityInsentient.this.a(slot, item);
                if (!item.f()) {
                    EntityInsentient.this.g(slot);
                    EntityInsentient.this.gz();
                }
            }

            @Override
            public void e() {
            }

            @Override
            public boolean a(EntityHuman player) {
                return player.dz() == EntityInsentient.this || player.b((Entity)EntityInsentient.this, 4.0);
            }

            @Override
            public int ap_() {
                return this.maxStackSize;
            }

            @Override
            public List<ItemStack> getContents() {
                return Arrays.asList(this.g());
            }

            @Override
            public void onOpen(CraftHumanEntity player) {
                this.viewers.add(player);
            }

            @Override
            public void onClose(CraftHumanEntity player) {
                this.viewers.remove(player);
            }

            @Override
            public List<HumanEntity> getViewers() {
                return this.viewers;
            }

            @Override
            public @Nullable InventoryHolder getOwner() {
                CraftEntity craftEntity = EntityInsentient.this.getBukkitEntity();
                if (craftEntity instanceof InventoryHolder) {
                    InventoryHolder inventoryHolder = (InventoryHolder)craftEntity;
                    return inventoryHolder;
                }
                return null;
            }

            @Override
            public void setMaxStackSize(int size) {
                this.maxStackSize = size;
            }

            @Override
            public Location getLocation() {
                return EntityInsentient.this.getBukkitEntity().getLocation();
            }
        };
    }

    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return false;
    }

    @Override
    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
        super.a(level, damageSource, recentlyHit);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            if (this.shouldSkipLoot(equipmentSlot)) continue;
            ItemStack itemBySlot = this.a(equipmentSlot);
            float f2 = this.cD.b(equipmentSlot);
            if (f2 == 0.0f) continue;
            boolean isPreserved = this.cD.c(equipmentSlot);
            Object object = damageSource.d();
            if (object instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)object;
                object = this.ao();
                if (object instanceof WorldServer) {
                    WorldServer serverLevel = (WorldServer)object;
                    f2 = EnchantmentManager.a(serverLevel, livingEntity, damageSource, f2);
                }
            }
            if (itemBySlot.f() || EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.E) || !recentlyHit && !isPreserved || !(this.as.i() < f2)) continue;
            if (!isPreserved && itemBySlot.m()) {
                itemBySlot.b(itemBySlot.p() - this.as.a(1 + this.as.a(Math.max(itemBySlot.p() - 3, 1))));
            }
            this.a(level, itemBySlot);
            if (this.clearEquipmentSlots) {
                this.a(equipmentSlot, ItemStack.l);
                continue;
            }
            this.clearedEquipmentSlots.add(equipmentSlot);
        }
    }

    public DropChances an() {
        return this.cD;
    }

    public void b(WorldServer level) {
        this.a(level, (ItemStack itemStack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer level, Predicate<ItemStack> filter) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (itemBySlot.f()) continue;
            if (!filter.test(itemBySlot)) {
                set.add(equipmentSlot);
                continue;
            }
            if (!this.cD.c(equipmentSlot)) continue;
            this.a(equipmentSlot, ItemStack.l);
            this.forceDrops = true;
            this.a(level, itemBySlot);
            this.forceDrops = false;
        }
        return set;
    }

    private LootParams h(WorldServer level) {
        return new LootParams.a(level).a(LootContextParameters.h, this.dI()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmentTable) {
        this.a(equipmentTable.a(), equipmentTable.b());
    }

    public void a(ResourceKey<LootTable> equipmentLootTable, Map<EnumItemSlot, Float> slotDropChances) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(equipmentLootTable, this.h(serverLevel), slotDropChances);
        }
    }

    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (random.i() < 0.15f * difficulty.d()) {
            int randomInt = random.a(3);
            int i2 = 1;
            while ((float)i2 <= 3.0f) {
                if (random.i() < 0.1087f) {
                    ++randomInt;
                }
                ++i2;
            }
            float f2 = this.ao().av() == EnumDifficulty.d ? 0.1f : 0.25f;
            boolean flag = true;
            for (EnumItemSlot equipmentSlot : cu) {
                Item equipmentForSlot;
                ItemStack itemBySlot = this.a(equipmentSlot);
                if (!flag && random.i() < f2) break;
                flag = false;
                if (!itemBySlot.f() || (equipmentForSlot = EntityInsentient.a(equipmentSlot, randomInt)) == null) continue;
                this.a(equipmentSlot, new ItemStack(equipmentForSlot));
            }
        }
    }

    public static @Nullable Item a(EnumItemSlot slot, int chance) {
        switch (slot) {
            case f: {
                if (chance == 0) {
                    return Items.re;
                }
                if (chance == 1) {
                    return Items.ri;
                }
                if (chance == 2) {
                    return Items.ry;
                }
                if (chance == 3) {
                    return Items.rm;
                }
                if (chance == 4) {
                    return Items.rq;
                }
                if (chance == 5) {
                    return Items.ru;
                }
            }
            case e: {
                if (chance == 0) {
                    return Items.rf;
                }
                if (chance == 1) {
                    return Items.rj;
                }
                if (chance == 2) {
                    return Items.rz;
                }
                if (chance == 3) {
                    return Items.rn;
                }
                if (chance == 4) {
                    return Items.rr;
                }
                if (chance == 5) {
                    return Items.rv;
                }
            }
            case d: {
                if (chance == 0) {
                    return Items.rg;
                }
                if (chance == 1) {
                    return Items.rk;
                }
                if (chance == 2) {
                    return Items.rA;
                }
                if (chance == 3) {
                    return Items.ro;
                }
                if (chance == 4) {
                    return Items.rs;
                }
                if (chance == 5) {
                    return Items.rw;
                }
            }
            case c: {
                if (chance == 0) {
                    return Items.rh;
                }
                if (chance == 1) {
                    return Items.rl;
                }
                if (chance == 2) {
                    return Items.rB;
                }
                if (chance == 3) {
                    return Items.rp;
                }
                if (chance == 4) {
                    return Items.rt;
                }
                if (chance != 5) break;
                return Items.rx;
            }
        }
        return null;
    }

    protected void a(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.b(level, random, difficulty);
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            this.a(level, random, equipmentSlot, difficulty);
        }
    }

    protected void b(WorldAccess level, RandomSource random, DifficultyDamageScaler difficulty) {
        this.a(level, EnumItemSlot.a, random, 0.25f, difficulty);
    }

    protected void a(WorldAccess level, RandomSource random, EnumItemSlot slot, DifficultyDamageScaler difficulty) {
        this.a(level, slot, random, 0.5f, difficulty);
    }

    private void a(WorldAccess level, EnumItemSlot slot, RandomSource random, float enchantChance, DifficultyDamageScaler difficulty) {
        ItemStack itemBySlot = this.a(slot);
        if (!itemBySlot.f() && random.i() < enchantChance * difficulty.d()) {
            EnchantmentManager.a(itemBySlot, level.J_(), VanillaEnchantmentProviders.a, difficulty, random);
            this.a(slot, itemBySlot);
        }
    }

    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        AttributeModifiable attributeInstance = Objects.requireNonNull(this.h(GenericAttributes.o));
        if (!attributeInstance.b(ch)) {
            attributeInstance.d(new AttributeModifier(ch, random.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.v(random.i() < 0.05f);
        return spawnGroupData;
    }

    public void gz() {
        this.cF = true;
    }

    @Override
    public void a(EnumItemSlot slot, float chance) {
        this.cD = this.cD.a(slot, chance);
    }

    @Override
    public boolean gn() {
        return this.cE;
    }

    public void b_(boolean canPickUpLoot) {
        this.cE = canPickUpLoot;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return this.gn();
    }

    public boolean gA() {
        return this.cF;
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        if (!this.cb()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult interactionResult = this.c(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        EnumInteractionResult interactionResult1 = super.a(player, hand);
        if (interactionResult1 != EnumInteractionResult.e) {
            return interactionResult1;
        }
        interactionResult = this.b(player, hand);
        if (interactionResult.a()) {
            this.a(GameEvent.r, (Entity)player);
            return interactionResult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.xa) && (interactionResult = itemInHand.a(player, (EntityLiving)this, hand)).a()) {
            return interactionResult;
        }
        Item item = itemInHand.h();
        if (item instanceof ItemMonsterEgg) {
            ItemMonsterEgg spawnEggItem = (ItemMonsterEgg)item;
            if (this.ao() instanceof WorldServer) {
                Optional<EntityInsentient> optional = spawnEggItem.a(player, this, this.ay(), (WorldServer)this.ao(), this.dI(), itemInHand);
                optional.ifPresent(mob -> this.a(player, (EntityInsentient)mob));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman player, EntityInsentient child) {
    }

    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        int count = stack.N();
        UseRemainder useRemainder = stack.a(DataComponents.A);
        stack.a(1, (EntityLiving)player);
        if (useRemainder != null) {
            ItemStack itemStack = useRemainder.a(stack, count, player.gv(), player::b);
            player.a(hand, itemStack);
        }
    }

    public boolean gB() {
        return this.a(this.dK());
    }

    public boolean a(BlockPosition pos) {
        return this.cL == -1 || this.cK.j(pos) < (double)(this.cL * this.cL);
    }

    public boolean a(Vec3D pos) {
        return this.cL == -1 || this.cK.b(pos) < (double)(this.cL * this.cL);
    }

    public void a(BlockPosition pos, int radius) {
        this.cK = pos;
        this.cL = radius;
    }

    public BlockPosition gC() {
        return this.cK;
    }

    public int gD() {
        return this.cL;
    }

    public void gE() {
        this.cL = -1;
    }

    public boolean gF() {
        return this.cL != -1;
    }

    public <T extends EntityInsentient> @Nullable T a(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, conversionParams, spawnReason, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public <T extends EntityInsentient> @Nullable T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.a<T> afterConversion, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTransformEvent.TransformReason transformReason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, conversionParams, spawnReason, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    public <T extends EntityInsentient> @Nullable T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, EntitySpawnReason spawnReason, ConversionParams.CancellingAfterConversion<T> afterConversion, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTransformEvent.TransformReason transformReason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        if (this.eh()) {
            return null;
        }
        EntityInsentient mob = (EntityInsentient)entityType.a(this.ao(), spawnReason);
        if (mob == null) {
            return null;
        }
        conversionParams.a().a(this, mob, conversionParams);
        if (!afterConversion.finalizeConversionOrCancel(mob)) {
            return null;
        }
        if (transformReason == null) {
            return (T)mob;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, mob, transformReason).isCancelled()) {
            return null;
        }
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.addFreshEntity(mob, creatureSpawnReason);
        }
        if (conversionParams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)mob;
    }

    public <T extends EntityInsentient> @Nullable T a(EntityTypes<T> entityType, ConversionParams conversionParams, ConversionParams.a<T> afterConversion) {
        return this.convertTo(entityType, conversionParams, afterConversion, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public <T extends EntityInsentient> @Nullable T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, ConversionParams.a<T> afterConversion, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTransformEvent.TransformReason transformReason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return (T)this.convertTo(entityType, conversionParams, (T e2) -> {
            afterConversion.finalizeConversion(e2);
            return true;
        }, transformReason, creatureSpawnReason);
    }

    public <T extends EntityInsentient> @Nullable T convertTo(EntityTypes<T> entityType, ConversionParams conversionParams, ConversionParams.CancellingAfterConversion<T> afterConversion, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTransformEvent.TransformReason transformReason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CreatureSpawnEvent.SpawnReason creatureSpawnReason) {
        return this.convertTo(entityType, conversionParams, EntitySpawnReason.i, afterConversion, transformReason, creatureSpawnReason);
    }

    @Override
    public @Nullable Leashable.a T_() {
        return this.cJ;
    }

    private void gM() {
        if (this.cJ != null) {
            this.cJ.d = 0.0;
        }
    }

    @Override
    public void a(@Nullable Leashable.a leashData) {
        this.cJ = leashData;
    }

    @Override
    public void s() {
        if (this.T_() == null) {
            this.gE();
        }
    }

    @Override
    public void y() {
        Leashable.super.y();
        this.cs.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean aj_() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean force, boolean triggerEvents) {
        boolean flag = super.a(entity, force, triggerEvents);
        if (flag && this.S_()) {
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN, true);
            if (!event.callEvent()) {
                return flag;
            }
            if (event.isDropLeash()) {
                this.o();
            } else {
                this.r();
            }
        }
        return flag;
    }

    @Override
    public boolean dy() {
        return super.dy() && !this.gG();
    }

    public void u(boolean noAi) {
        byte b2 = this.az.a(a);
        this.az.a(a, noAi ? (byte)(b2 | 1) : (byte)(b2 & 0xFFFFFFFE));
    }

    public void v(boolean leftHanded) {
        byte b2 = this.az.a(a);
        this.az.a(a, leftHanded ? (byte)(b2 | 2) : (byte)(b2 & 0xFFFFFFFD));
    }

    public void w(boolean aggressive) {
        byte b2 = this.az.a(a);
        this.az.a(a, aggressive ? (byte)(b2 | 4) : (byte)(b2 & 0xFFFFFFFB));
    }

    public boolean gG() {
        return (this.az.a(a) & 1) != 0;
    }

    public boolean gH() {
        return (this.az.a(a) & 2) != 0;
    }

    public boolean gI() {
        return (this.az.a(a) & 4) != 0;
    }

    public void a_(boolean baby) {
    }

    @Override
    public EnumMainHand at() {
        return this.gH() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean h(EntityLiving entity) {
        double d1;
        double d2;
        AttackRange attackRange = this.fA().a(DataComponents.F);
        if (attackRange == null) {
            d2 = cv;
            d1 = 0.0;
        } else {
            d2 = attackRange.b(this);
            d1 = attackRange.a(this);
        }
        AxisAlignedBB hitbox = entity.fh();
        return this.j(d2).c(hitbox) && (d1 <= 0.0 || !this.j(d1).c(hitbox));
    }

    protected AxisAlignedBB j(double horizontalExpansion) {
        AxisAlignedBB aabb;
        Entity vehicle = this.dz();
        if (vehicle != null) {
            AxisAlignedBB boundingBox = vehicle.dj();
            AxisAlignedBB boundingBox1 = this.dj();
            aabb = new AxisAlignedBB(Math.min(boundingBox1.a, boundingBox.a), boundingBox1.b, Math.min(boundingBox1.c, boundingBox.c), Math.max(boundingBox1.d, boundingBox.d), boundingBox1.e, Math.max(boundingBox1.f, boundingBox.f));
        } else {
            aabb = this.dj();
        }
        return aabb.c(horizontalExpansion, 0.0, horizontalExpansion);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        float f2 = (float)this.i(GenericAttributes.d);
        ItemStack weaponItem = this.eq();
        DamageSource damageSource = weaponItem.a((EntityLiving)this, () -> this.en().b(this));
        f2 = EnchantmentManager.a(level, weaponItem, target, damageSource, f2);
        f2 += weaponItem.h().a(target, f2, damageSource);
        Vec3D deltaMovement = target.dN();
        boolean flag = target.a(level, damageSource, f2);
        if (flag) {
            this.a(target, this.b(target, damageSource), deltaMovement);
            if (target instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)target;
                weaponItem.a(livingEntity, (EntityLiving)this);
            }
            EnchantmentManager.a(level, target, damageSource);
            this.C(target);
            this.fN();
        }
        this.fi();
        return flag;
    }

    @Override
    protected void c(TagKey<FluidType> fluidTag) {
        if (this.N().p()) {
            super.c(fluidTag);
        } else {
            this.k(this.dN().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gJ() {
        this.d((PathfinderGoal goal) -> true);
        this.ev().g();
    }

    public void d(Predicate<PathfinderGoal> filter) {
        this.cs.a(filter);
    }

    @Override
    protected void cV() {
        super.cV();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (itemBySlot.f()) continue;
            itemBySlot.e(0);
        }
    }

    @Override
    public @Nullable ItemStack dZ() {
        ItemMonsterEgg spawnEggItem = ItemMonsterEgg.a(this.ay());
        return spawnEggItem == null ? null : new ItemStack(spawnEggItem);
    }

    @Override
    protected void a(Holder<AttributeBase> attribute) {
        super.a(attribute);
        if (attribute.a(GenericAttributes.o) || attribute.a(GenericAttributes.G)) {
            this.N().f();
        }
    }

    @Override
    public void a(WorldServer level, DebugValueSource.a registrar) {
        registrar.a(DebugSubscriptions.f, () -> {
            PathEntity path = this.N().j();
            return path != null && path.k() != null ? new DebugPathInfo(path.n(), this.N().q()) : null;
        });
        registrar.a(DebugSubscriptions.e, () -> {
            Set<PathfinderGoalWrapped> availableGoals = this.cs.b();
            ArrayList<DebugGoalInfo.a> list = new ArrayList<DebugGoalInfo.a>(availableGoals.size());
            availableGoals.forEach(wrappedGoal -> {
                Object object;
                int n2 = wrappedGoal.i();
                boolean bl = wrappedGoal.h();
                PathfinderGoal patt0$temp = wrappedGoal.k();
                if (patt0$temp instanceof PaperCustomGoal) {
                    PaperCustomGoal customGoal = (PaperCustomGoal)patt0$temp;
                    object = customGoal.getHandle().getClass().getSimpleName() + "*";
                } else {
                    object = wrappedGoal.k().getClass().getSimpleName();
                }
                list.add(new DebugGoalInfo.a(n2, bl, (String)object));
            });
            return new DebugGoalInfo(list);
        });
        if (!this.ca.i()) {
            registrar.a(DebugSubscriptions.c, () -> DebugBrainDump.a(level, this));
        }
    }

    public float gK() {
        return 1.0f;
    }
}

