/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityLightning
extends Entity {
    private static final int b = 2;
    private static final double c = 3.0;
    private static final double d = 15.0;
    public int e = 2;
    public long a;
    public int f;
    public boolean g;
    private @Nullable EntityPlayer h;
    private final Set<Entity> i = Sets.newHashSet();
    private int j;
    public boolean isEffect;

    public EntityLightning(EntityTypes<? extends EntityLightning> type, World level) {
        super(type, level);
        this.a = this.as.g();
        this.f = this.as.a(3) + 1;
    }

    public void a(boolean visualOnly) {
        this.g = visualOnly;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.d;
    }

    public @Nullable EntityPlayer e() {
        return this.h;
    }

    public void b(@Nullable EntityPlayer cause) {
        this.h = cause;
    }

    private void k() {
        BlockPosition strikePosition = this.m();
        IBlockData blockState = this.ao().a_(strikePosition);
        Block block = blockState.b();
        if (block instanceof LightningRodBlock) {
            LightningRodBlock lightningRodBlock = (LightningRodBlock)block;
            lightningRodBlock.c(blockState, this.ao(), strikePosition);
        }
    }

    @Override
    public void g() {
        List<Entity> entities;
        super.g();
        if (!this.isEffect && this.e == 2) {
            if (this.ao().B_()) {
                this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.qg, SoundCategory.d, 10000.0f, 0.8f + this.as.i() * 0.2f, false);
                this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.qf, SoundCategory.d, 2.0f, 0.5f + this.as.i() * 0.2f, false);
            } else {
                EnumDifficulty difficulty = this.ao().av();
                if (difficulty == EnumDifficulty.c || difficulty == EnumDifficulty.d) {
                    this.a(4);
                }
                this.k();
                EntityLightning.clearCopperOnLightningStrike(this.ao(), this.m(), this);
                this.c(GameEvent.G);
            }
        }
        --this.e;
        if (this.e < 0) {
            if (this.f == 0) {
                if (this.ao() instanceof WorldServer) {
                    entities = this.ao().a((Entity)this, new AxisAlignedBB(this.dP() - 15.0, this.dR() - 15.0, this.dV() - 15.0, this.dP() + 15.0, this.dR() + 6.0 + 15.0, this.dV() + 15.0), (? super Entity entity1) -> entity1.cb() && !this.i.contains(entity1));
                    for (EntityPlayer serverPlayer : ((WorldServer)this.ao()).a((? super EntityPlayer player) -> player.f(this) < 256.0f)) {
                        CriterionTriggers.X.a(serverPlayer, this, entities);
                    }
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            } else if (this.e < -this.as.a(10)) {
                --this.f;
                this.e = 1;
                this.a = this.as.g();
                this.a(0);
            }
        }
        if (this.e >= 0 && !this.isEffect) {
            if (!(this.ao() instanceof WorldServer)) {
                this.ao().c(2);
            } else if (!this.g && !this.isEffect) {
                entities = this.ao().a((Entity)this, new AxisAlignedBB(this.dP() - 3.0, this.dR() - 3.0, this.dV() - 3.0, this.dP() + 3.0, this.dR() + 6.0 + 3.0, this.dV() + 3.0), Entity::cb);
                for (Entity entity : entities) {
                    entity.a((WorldServer)this.ao(), this);
                }
                this.i.addAll(entities);
                if (this.h != null) {
                    CriterionTriggers.F.a(this.h, entities);
                }
            }
        }
    }

    private BlockPosition m() {
        Vec3D vec3 = this.dI();
        return BlockPosition.a(vec3.g, vec3.h - 1.0E-6, vec3.i);
    }

    private void a(int extraIgnitions) {
        BlockPosition var7;
        WorldServer serverLevel;
        World world;
        if (!this.g && !this.isEffect && (world = this.ao()) instanceof WorldServer && (serverLevel = (WorldServer)world).j(var7 = this.dK())) {
            IBlockData state = BlockFireAbstract.a(serverLevel, var7);
            if (serverLevel.a_(var7).l() && state.a((IWorldReader)serverLevel, var7) && !CraftEventFactory.callBlockIgniteEvent(this.ao(), var7, this).isCancelled()) {
                serverLevel.c(var7, state);
                ++this.j;
            }
            for (int i2 = 0; i2 < extraIgnitions; ++i2) {
                BlockPosition blockPos1 = var7.b(this.as.a(3) - 1, this.as.a(3) - 1, this.as.a(3) - 1);
                state = BlockFireAbstract.a(serverLevel, blockPos1);
                if (!serverLevel.a_(blockPos1).l() || !state.a((IWorldReader)serverLevel, blockPos1) || CraftEventFactory.callBlockIgniteEvent(this.ao(), blockPos1, this).isCancelled()) continue;
                serverLevel.c(blockPos1, state);
                ++this.j;
            }
        }
    }

    private static void clearCopperOnLightningStrike(World level, BlockPosition pos, Entity lightning) {
        IBlockData blockState = level.a_(pos);
        boolean flag = HoneycombItem.b.get().get((Object)blockState.b()) != null;
        boolean flag1 = blockState.b() instanceof WeatheringCopper;
        if (flag1 || flag) {
            IBlockData newBlockState;
            if (flag1 && CraftEventFactory.callEntityChangeBlockEvent(lightning, pos, newBlockState = WeatheringCopper.c(level.a_(pos)))) {
                level.c(pos, newBlockState);
            }
            BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
            int i2 = level.y.a(3) + 3;
            for (int i1 = 0; i1 < i2; ++i1) {
                int i22 = level.y.a(8) + 1;
                EntityLightning.randomWalkCleaningCopper(level, pos, mutableBlockPos, i22, lightning);
            }
        }
    }

    private static void randomWalkCleaningCopper(World level, BlockPosition pos, BlockPosition.MutableBlockPosition mutable, int steps, Entity lightning) {
        Optional<BlockPosition> optional;
        mutable.g(pos);
        for (int i2 = 0; i2 < steps && !(optional = EntityLightning.randomStepCleaningCopper(level, mutable, lightning)).isEmpty(); ++i2) {
            mutable.g(optional.get());
        }
    }

    private static Optional<BlockPosition> randomStepCleaningCopper(World level, BlockPosition pos, Entity lightning) {
        for (BlockPosition blockPos : BlockPosition.a(level.y, 10, pos, 1)) {
            IBlockData blockState = level.a_(blockPos);
            if (!(blockState.b() instanceof WeatheringCopper)) continue;
            WeatheringCopper.b(blockState).ifPresent(blockState1 -> {
                if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockPos, blockState1)) {
                    level.c(blockPos, (IBlockData)blockState1);
                }
            });
            level.c(3002, blockPos, -1);
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    @Override
    public boolean a(double distance) {
        double d2 = 64.0 * EntityLightning.dc();
        return distance < d2 * d2;
    }

    @Override
    protected void a(DataWatcher.a builder) {
    }

    @Override
    protected void a(ValueInput input) {
    }

    @Override
    protected void a(ValueOutput output) {
    }

    public int f() {
        return this.j;
    }

    public Stream<Entity> i() {
        return this.i.stream().filter(Entity::cb);
    }

    @Override
    public final boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return false;
    }
}

