/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityAttemptSpinAttackEvent;
import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.util.TriState;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class EntityLiving
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "active_effects";
    public static final String u = "attributes";
    public static final String aN = "sleeping_pos";
    public static final String aO = "equipment";
    public static final String aP = "Brain";
    public static final String aQ = "FallFlying";
    public static final String aR = "HurtTime";
    public static final String aS = "DeathTime";
    public static final String aT = "HurtByTimestamp";
    public static final String aU = "Health";
    private static final MinecraftKey c = MinecraftKey.b("powder_snow");
    private static final MinecraftKey d = MinecraftKey.b("sprinting");
    private static final AttributeModifier e = new AttributeModifier(d, 0.3f, AttributeModifier.Operation.c);
    public static final int aV = 98;
    public static final int aW = 100;
    public static final int aX = 105;
    public static final int aY = 106;
    public static final int aZ = 100;
    private static final int r = 40;
    public static final double ba = 0.003;
    public static final double bb = 0.08;
    public static final int bc = 20;
    protected static final float bd = 0.98f;
    private static final int s = 10;
    private static final int t = 2;
    public static final float be = 0.42f;
    protected static final float bf = 0.4f;
    protected static final int bg = 20;
    private static final double cc = 128.0;
    protected static final int bh = 1;
    protected static final int bi = 2;
    public static final int bj = 4;
    protected static final DataWatcherObject<Byte> bk = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Float> cd = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<List<ParticleParam>> ce = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.m);
    private static final DataWatcherObject<Boolean> cf = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Integer> cg = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<BlockPosition>> ci = DataWatcher.a(EntityLiving.class, DataWatcherRegistry.p);
    private static final int cj = 15;
    protected static final EntitySize bl = EntitySize.c(0.2f, 0.2f).b(0.2f);
    public static final float bm = 0.5f;
    public static final float bn = 0.5f;
    private static final float ck = 0.04f;
    public static final Predicate<EntityLiving> bo = entity -> {
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            ItemStack itemBySlot = player.a(EnumItemSlot.f);
            return !itemBySlot.a(TagsItem.cP);
        }
        return true;
    };
    private static final Dynamic<?> cl = new Dynamic(JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMapBase cm;
    public CombatTracker cn = new CombatTracker(this);
    public final Map<Holder<MobEffectList>, MobEffect> co = Maps.newHashMap();
    private final Map<EnumItemSlot, ItemStack> cp = SystemUtils.a(EnumItemSlot.class, (K slot) -> ItemStack.l);
    public boolean bp;
    private boolean cq = false;
    public EnumHand bq;
    public int br;
    public int bs;
    public int bt;
    public int bu;
    public int bv;
    public int bw;
    public float bx;
    public float by;
    protected int bz;
    protected int bA;
    public final WalkAnimationState bB = new WalkAnimationState();
    public float bC;
    public float bD;
    public float bE;
    public float bF;
    public final ElytraAnimationState bG = new ElytraAnimationState(this);
    public @Nullable EntityReference<EntityHuman> bH;
    public int bI;
    protected boolean bJ;
    protected int bK;
    public float bL;
    public boolean bM;
    public float bN;
    public float bO;
    public float bP;
    protected InterpolationHandler bQ = new InterpolationHandler(this);
    protected double bR;
    protected int bS;
    public boolean cr = true;
    public @Nullable EntityReference<EntityLiving> cs;
    public int ct;
    private @Nullable EntityLiving cu;
    private int cv;
    private float cw;
    private int cx;
    private float cy;
    protected ItemStack bT = ItemStack.l;
    public int bU;
    protected int bV;
    private long cz = Integer.MIN_VALUE;
    private BlockPosition cA;
    private Optional<BlockPosition> cB = Optional.empty();
    private @Nullable DamageSource cC;
    private long cD;
    protected int bW;
    protected float bX;
    protected @Nullable ItemStack bY;
    protected @Nullable Object2LongMap<Entity> bZ;
    private float cE;
    private float cF;
    protected BehaviorController<?> ca;
    protected boolean cG;
    private final EnumMap<EnumItemSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> cH = new EnumMap(EnumItemSlot.class);
    protected final EntityEquipment cb;
    private Waypoint.a cI = new Waypoint.a();
    public int expToDrop;
    public List<Entity.DefaultDrop> drops = new ArrayList<Entity.DefaultDrop>();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    public int invulnerableDuration = 20;
    private boolean isTickingEffects = false;
    private final List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EnumItemSlot> clearedEquipmentSlots = new HashSet<EnumItemSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    protected EntityLiving(EntityTypes<? extends EntityLiving> type, net.minecraft.world.level.World level) {
        super(type, level);
        this.cm = new AttributeMapBase(AttributeDefaults.a(type));
        this.craftAttributes = new CraftAttributeMap(this.cm);
        this.az.a(cd, Float.valueOf(this.fq()));
        this.cb = this.eu();
        this.W = true;
        this.aH();
        this.v(this.as.i() * ((float)Math.PI * 2));
        this.bE = this.ec();
        this.ca = this.a(cl);
    }

    @Override
    public @Nullable EntityLiving et() {
        return this;
    }

    @Contract(pure=true)
    protected EntityEquipment eu() {
        return new EntityEquipment();
    }

    public BehaviorController<?> ev() {
        return this.ca;
    }

    protected BehaviorController.b<?> ew() {
        return BehaviorController.a(ImmutableList.of(), ImmutableList.of());
    }

    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return this.ew().a(dynamic);
    }

    @Override
    public void c(WorldServer level) {
        this.a(level, this.en().y(), Float.MAX_VALUE);
    }

    public boolean a(EntityTypes<?> entityType) {
        return true;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        builder.a(bk, (byte)0);
        builder.a(ce, List.of());
        builder.a(cf, false);
        builder.a(cg, 0);
        builder.a(ch, 0);
        builder.a(cd, Float.valueOf(1.0f));
        builder.a(ci, Optional.empty());
    }

    public static AttributeProvider.Builder ex() {
        return AttributeProvider.a().a(GenericAttributes.u).a(GenericAttributes.r).a(GenericAttributes.x).a(GenericAttributes.b).a(GenericAttributes.c).a(GenericAttributes.t).a(GenericAttributes.D).a(GenericAttributes.A).a(GenericAttributes.p).a(GenericAttributes.z).a(GenericAttributes.m).a(GenericAttributes.q).a(GenericAttributes.y).a(GenericAttributes.i).a(GenericAttributes.k).a(GenericAttributes.H).a(GenericAttributes.w).a(GenericAttributes.e).a(GenericAttributes.j).a(GenericAttributes.I);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
        net.minecraft.world.level.World world;
        if (!this.by()) {
            this.bH();
        }
        if ((world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (onGround && this.an > 0.0) {
                this.b(serverLevel, pos);
                double d2 = Math.max(0, MathHelper.c(this.i(this.an)));
                if (d2 > 0.0 && !state.l()) {
                    double d1;
                    double x2 = this.dP();
                    double y1 = this.dR();
                    double z2 = this.dV();
                    BlockPosition blockPos = this.dK();
                    if (pos.u() != blockPos.u() || pos.w() != blockPos.w()) {
                        d1 = x2 - (double)pos.u() - 0.5;
                        double d22 = z2 - (double)pos.w() - 0.5;
                        double max = Math.max(Math.abs(d1), Math.abs(d22));
                        x2 = (double)pos.u() + 0.5 + d1 / max * 0.5;
                        z2 = (double)pos.w() + 0.5 + d22 / max * 0.5;
                    }
                    d1 = Math.min((double)0.2f + d2 / 15.0, 2.5);
                    int i2 = (int)(150.0 * d1);
                    if (this instanceof EntityPlayer) {
                        serverLevel.sendParticlesSource((EntityPlayer)this, new ParticleParamBlock(Particles.b, state), false, false, x2, y1, z2, i2, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        serverLevel.a(new ParticleParamBlock(Particles.b, state), x2, y1, z2, i2, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                }
            }
        }
        super.a(y2, onGround, state, pos);
        if (onGround) {
            this.cB = Optional.empty();
        }
    }

    public boolean ey() {
        return this.ay().a(TagsEntity.n);
    }

    public float b(float partialTick) {
        return MathHelper.h(partialTick, this.cF, this.cE);
    }

    public boolean ez() {
        return this.dN().b() < (double)1.0E-5f && this.bB();
    }

    @Override
    public void aJ() {
        EntityLiving lastHurtByMob;
        net.minecraft.world.level.World world;
        net.minecraft.world.level.World world2;
        this.bx = this.by;
        if (this.ay) {
            this.gp().ifPresent(this::a);
        }
        if ((world2 = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world2;
            EnchantmentManager.b(serverLevel, this);
        }
        super.aJ();
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("livingEntityBaseTick");
        if (this.cb() && (world = this.ao()) instanceof WorldServer) {
            double damagePerBlock;
            double d2;
            WorldServer serverLevel1 = (WorldServer)world;
            boolean flag = this instanceof EntityHuman;
            if (this.cc()) {
                this.a(serverLevel1, this.en().g(), 1.0f);
            } else if (flag && !serverLevel1.w().a(this.dj()) && (d2 = serverLevel1.w().a(this) + serverLevel1.w().o()) < 0.0 && (damagePerBlock = serverLevel1.w().p()) > 0.0) {
                this.a(serverLevel1, this.en().x(), (float)Math.max(1, MathHelper.c(-d2 * damagePerBlock)));
            }
            if (((Entity)this).a(TagsFluid.a) && !serverLevel1.a_(BlockPosition.a(this.dP(), this.dT(), this.dV())).a(Blocks.oa)) {
                boolean flag1;
                boolean bl = flag1 = !this.ey() && !MobEffectUtil.c(this) && (!flag || !((EntityHuman)this).gL().a);
                if (flag1) {
                    this.j(this.l(this.cK()));
                    if (this.eA()) {
                        this.j(0);
                        serverLevel1.a((Entity)this, (byte)67);
                        this.a(serverLevel1, this.en().i(), 2.0f);
                    }
                } else if (this.cK() < this.cJ() && MobEffectUtil.d(this)) {
                    this.j(this.m(this.cK()));
                }
                if (this.cq() && this.dz() != null && this.dz().cs()) {
                    this.cf();
                }
            } else if (this.cK() < this.cJ()) {
                this.j(this.m(this.cK()));
            }
            BlockPosition blockPos = this.dK();
            if (!Objects.equal((Object)this.cA, (Object)blockPos)) {
                this.cA = blockPos;
                this.b(serverLevel1, blockPos);
            }
        }
        if (this.bu > 0) {
            --this.bu;
        }
        if (this.ax > 0 && !(this instanceof EntityPlayer)) {
            --this.ax;
        }
        if (this.fa() && this.ao().h(this)) {
            this.eH();
        }
        if (this.bI > 0) {
            --this.bI;
        } else {
            this.bH = null;
        }
        if (this.cu != null && !this.cu.cb()) {
            this.cu = null;
        }
        if ((lastHurtByMob = this.eK()) != null) {
            if (!lastHurtByMob.cb()) {
                this.a((EntityLiving)null);
            } else if (this.at - this.ct > 100) {
                this.a((EntityLiving)null);
            }
        }
        this.eR();
        this.bF = this.bE;
        this.bD = this.bC;
        this.ab = this.ec();
        this.ac = this.ee();
        profilerFiller.c();
    }

    protected boolean eA() {
        return this.cK() <= -20;
    }

    @Override
    protected float bi() {
        return MathHelper.h((float)this.i(GenericAttributes.w), super.bi(), 1.0f);
    }

    public float eB() {
        return 0.0f;
    }

    protected void eC() {
        AttributeModifiable attribute = this.h(GenericAttributes.x);
        if (attribute != null && attribute.a(c) != null) {
            attribute.c(c);
        }
    }

    protected void eD() {
        int ticksFrozen;
        if (!this.bJ().l() && (ticksFrozen = this.cM()) > 0) {
            AttributeModifiable attribute = this.h(GenericAttributes.x);
            if (attribute == null) {
                return;
            }
            float f2 = -0.05f * this.cN();
            attribute.b(new AttributeModifier(c, f2, AttributeModifier.Operation.a));
        }
    }

    protected void b(WorldServer level, BlockPosition pos) {
        EnchantmentManager.a(level, this);
    }

    public boolean e_() {
        return false;
    }

    public float eE() {
        return this.e_() ? 0.5f : 1.0f;
    }

    public final float eF() {
        AttributeMapBase attributes = this.fw();
        return attributes == null ? 1.0f : this.c((float)attributes.c(GenericAttributes.A));
    }

    protected float c(float scale) {
        return scale;
    }

    public boolean eG() {
        return true;
    }

    protected void eH() {
        ++this.bw;
        if (this.bw >= 20 && !this.ao().B_() && !this.eh()) {
            this.ao().a((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean eI() {
        return !this.e_();
    }

    protected boolean e(WorldServer level) {
        return !this.e_() && level.U().a(GameRules.D) != false;
    }

    protected int l(int currentAirSupply) {
        AttributeModifiable attribute = this.h(GenericAttributes.y);
        double value = attribute != null ? attribute.g() : 0.0;
        return value > 0.0 && this.as.j() >= 1.0 / (value + 1.0) ? currentAirSupply : currentAirSupply - 1;
    }

    protected int m(int currentAirSupply) {
        return Math.min(currentAirSupply + 4, this.cJ());
    }

    public final int a(WorldServer level, @Nullable Entity killer) {
        return EnchantmentManager.a(level, killer, (Entity)this, this.f(level));
    }

    protected int f(WorldServer level) {
        return 0;
    }

    protected boolean eJ() {
        return false;
    }

    public @Nullable EntityLiving eK() {
        return EntityReference.b(this.cs, this.ao());
    }

    public @Nullable EntityHuman eL() {
        return EntityReference.c(this.bH, this.ao());
    }

    @Override
    public EntityLiving f_() {
        return this.eK();
    }

    public int eM() {
        return this.ct;
    }

    public void a(EntityHuman player, int memoryTime) {
        this.a(EntityReference.a(player), memoryTime);
    }

    public void a(UUID uuid, int memoryTime) {
        this.a(EntityReference.a(uuid), memoryTime);
    }

    private void a(EntityReference<EntityHuman> player, int memoryTime) {
        this.bH = player;
        this.bI = memoryTime;
    }

    public void a(@Nullable EntityLiving livingEntity) {
        this.cs = EntityReference.a(livingEntity);
        this.ct = this.at;
    }

    public @Nullable EntityLiving eN() {
        return this.cu;
    }

    public int eO() {
        return this.cv;
    }

    public void C(Entity entity) {
        this.cu = entity instanceof EntityLiving ? (EntityLiving)entity : null;
        this.cv = this.at;
    }

    public int eP() {
        return this.bK;
    }

    public void n(int noActionTime) {
        this.bK = noActionTime;
    }

    public boolean eQ() {
        return !this.frictionState.toBooleanOrElse(!this.cq);
    }

    public void r(boolean discardFriction) {
        this.cq = discardFriction;
    }

    protected boolean b(EnumItemSlot slot) {
        return true;
    }

    public void a(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem) {
        this.onEquipItem(slot, oldItem, newItem, false);
    }

    public void onEquipItem(EnumItemSlot slot, ItemStack oldItem, ItemStack newItem, boolean silent) {
        if (!(this.ao().B_() || this.au() || ItemStack.c(oldItem, newItem) || this.ay)) {
            Equippable equippable = newItem.a(DataComponents.H);
            if (!this.bq() && equippable != null && slot == equippable.b() && !silent) {
                this.ao().a(null, this.dP(), this.dR(), this.dV(), this.a(slot, newItem, equippable), this.dB(), 1.0f, 1.0f, this.as.g());
            }
            if (this.b(slot)) {
                this.c(equippable != null ? GameEvent.v : GameEvent.S);
            }
        }
    }

    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return equippable.c();
    }

    @Override
    public void remove(Entity.RemovalReason reason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityRemoveEvent.Cause eventCause) {
        net.minecraft.world.level.World world;
        if ((reason == Entity.RemovalReason.a || reason == Entity.RemovalReason.b) && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, reason);
        }
        super.remove(reason, eventCause);
        this.ca.a();
    }

    @Override
    public void b(Entity.RemovalReason reason) {
        super.b(reason);
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.j().c(this);
        }
    }

    protected void a(WorldServer level, Entity.RemovalReason removalReason) {
        for (MobEffect mobEffectInstance : this.eW()) {
            mobEffectInstance.a(level, this, removalReason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.co.clear();
    }

    @Override
    protected void a(ValueOutput output) {
        if (this.frictionState != TriState.NOT_SET) {
            output.a("Paper.FrictionState", this.frictionState.toString());
        }
        output.a(aU, this.eZ());
        output.a(aR, (short)this.bu);
        output.a(aT, this.ct);
        output.a(aS, (short)this.bw);
        output.a("AbsorptionAmount", this.fX());
        output.a(u, AttributeModifiable.a.b, this.fw().d());
        if (!this.co.isEmpty()) {
            output.a(b, MobEffect.d.listOf(), List.copyOf(this.co.values()));
        }
        output.a(aQ, this.gj());
        this.gp().ifPresent(blockPos -> output.a(aN, BlockPosition.a, blockPos));
        DataResult dataResult = this.ca.a(DynamicOpsNBT.a).map(tag -> new Dynamic<NBTBase>(DynamicOpsNBT.a, (NBTBase)tag));
        dataResult.resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(dynamic -> output.a(aP, Codec.PASSTHROUGH, dynamic));
        if (this.bH != null) {
            this.bH.a(output, "last_hurt_by_player");
            output.a("last_hurt_by_player_memory_time", this.bI);
        }
        if (this.cs != null) {
            this.cs.a(output, "last_hurt_by_mob");
            output.a("ticks_since_last_hurt_by_mob", this.at - this.ct);
        }
        if (!this.cb.a()) {
            output.a(aO, EntityEquipment.a, this.cb);
        }
        if (this.cI.a()) {
            output.a("locator_bar_icon", Waypoint.a.a, this.cI);
        }
    }

    public final @Nullable EntityItem a(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        return this.drop(stack, randomizeMotion, includeThrower, true, null);
    }

    public @Nullable EntityItem drop(ItemStack stack, boolean randomizeMotion, boolean includeThrower, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        if (stack.f()) {
            return null;
        }
        if (this.ao().B_()) {
            this.a(EnumHand.a);
            return null;
        }
        EntityItem itemEntity = this.b(stack, randomizeMotion, includeThrower);
        if (itemEntity != null) {
            CraftEntity craftEntity;
            if (entityOperation != null) {
                entityOperation.accept((Item)itemEntity.getBukkitEntity());
            }
            if (callEvent && (craftEntity = this.getBukkitEntity()) instanceof Player) {
                Player player = (Player)craftEntity;
                Item drop = (Item)itemEntity.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack inHandItem = player.getInventory().getItemInMainHand();
                    if (includeThrower && inHandItem.getAmount() == 0) {
                        player.getInventory().setItemInMainHand(drop.getItemStack());
                    } else if (includeThrower && inHandItem.isSimilar(drop.getItemStack()) && inHandItem.getAmount() < inHandItem.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        inHandItem.setAmount(inHandItem.getAmount() + 1);
                        player.getInventory().setItemInMainHand(inHandItem);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.ao().b(itemEntity);
        }
        return itemEntity;
    }

    @Override
    protected void a(ValueInput input) {
        float absorptionAmount = input.a("AbsorptionAmount", 0.0f);
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.G(absorptionAmount);
        input.g("Paper.FrictionState").ifPresent(frictionState -> {
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                a.error("Unknown friction state {} for {}", frictionState, (Object)this);
            }
        });
        if (this.ao() != null && !this.ao().B_()) {
            input.a(u, AttributeModifiable.a.b).ifPresent(this.fw()::a);
        }
        List list = input.a(b, MobEffect.d.listOf()).orElse(List.of());
        this.co.clear();
        for (MobEffect mobEffectInstance : list) {
            this.co.put(mobEffectInstance.c(), mobEffectInstance);
            this.cr = true;
        }
        input.a("Bukkit.MaxHealth", Codec.DOUBLE).ifPresent(maxHealth -> this.h(GenericAttributes.u).a((double)maxHealth));
        this.x(input.a(aU, this.fq()));
        this.bu = input.a(aR, (short)0);
        this.bw = input.a(aS, (short)0);
        this.ct = input.a(aT, 0);
        input.g("Team").ifPresent(string -> {
            boolean flag;
            Scoreboard scoreboard = this.ao().ab();
            ScoreboardTeam playerTeam = scoreboard.b((String)string);
            if (!this.ao().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
                playerTeam = null;
            }
            boolean bl = flag = playerTeam != null && scoreboard.a(this.cZ(), playerTeam);
            if (!flag) {
                a.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", string);
            }
        });
        this.b(7, input.a(aQ, false));
        input.a(aN, BlockPosition.a).ifPresentOrElse(blockPos -> {
            if (this.dI().c(blockPos.u(), blockPos.v(), blockPos.w()) < (double)MathHelper.i(16)) {
                this.g((BlockPosition)blockPos);
                this.az.a(Entity.aE, EntityPose.c);
                if (!this.ay) {
                    this.a((BlockPosition)blockPos);
                }
            }
        }, this::gq);
        input.a(aP, Codec.PASSTHROUGH).ifPresent(dynamic -> {
            this.ca = this.a((Dynamic<?>)((Object)dynamic));
        });
        this.bH = EntityReference.a(input, "last_hurt_by_player");
        this.bI = input.a("last_hurt_by_player_memory_time", 0);
        this.cs = EntityReference.a(input, "last_hurt_by_mob");
        this.ct = input.a("ticks_since_last_hurt_by_mob", 0) + this.at;
        this.cb.a(input.a(aO, EntityEquipment.a).orElseGet(EntityEquipment::new));
        this.cI = input.a("locator_bar_icon", Waypoint.a.a).orElseGet(Waypoint.a::new);
    }

    @Override
    public void aI() {
        super.aI();
        this.k();
    }

    protected void eR() {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Iterator<Object> iterator = this.co.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder holder = (Holder)iterator.next();
                    MobEffect mobEffectInstance = this.co.get(holder);
                    if (!mobEffectInstance.a(serverLevel, this, () -> this.a(mobEffectInstance, true, null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.c(List.of(mobEffectInstance));
                        continue;
                    }
                    if (mobEffectInstance.d() % 600 != 0) continue;
                    this.a(mobEffectInstance, false, null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect effect : this.effectsToProcess) {
                if (effect.effect != null) {
                    this.addEffect(effect.effect, effect.cause);
                    continue;
                }
                this.removeEffect(effect.type, effect.cause);
            }
            this.effectsToProcess.clear();
        } else {
            for (MobEffect mobEffectInstance1 : this.co.values()) {
                mobEffectInstance1.i();
            }
            List<ParticleParam> list = this.az.a(ce);
            if (!list.isEmpty()) {
                int i1;
                boolean flag = this.az.a(cf);
                int i2 = this.cG() ? 15 : 4;
                int n2 = i1 = flag ? 5 : 1;
                if (this.as.a(i2 * i1) == 0) {
                    this.ao().a(SystemUtils.a(list, this.as), this.e(0.5), this.dS(), this.h(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    private void k() {
        if (this.cr) {
            this.M();
            this.D();
            this.cr = false;
        }
    }

    protected void M() {
        if (this.co.isEmpty()) {
            this.eU();
            this.l(false);
        } else {
            this.l(this.d(MobEffects.n));
            this.p();
        }
    }

    private void p() {
        List<ParticleParam> list = this.co.values().stream().filter(MobEffect::g).map(MobEffect::a).toList();
        this.az.a(ce, list);
        this.az.a(cf, EntityLiving.d(this.co.values()));
    }

    @Override
    private void D() {
        boolean isCurrentlyGlowing = this.cF();
        if (this.i(6) != isCurrentlyGlowing) {
            this.b(6, isCurrentlyGlowing);
        }
    }

    public double D(@Nullable Entity lookingEntity) {
        double d2 = 1.0;
        if (this.cx()) {
            d2 *= 0.8;
        }
        if (this.cG()) {
            float armorCoverPercentage = this.fB();
            if (armorCoverPercentage < 0.1f) {
                armorCoverPercentage = 0.1f;
            }
            d2 *= 0.7 * (double)armorCoverPercentage;
        }
        if (lookingEntity != null) {
            ItemStack itemBySlot = this.a(EnumItemSlot.f);
            EntityTypes<?> type = lookingEntity.ay();
            if (type == EntityTypes.bn && itemBySlot.a(Items.wx) || type == EntityTypes.bW && itemBySlot.a(Items.wA) || type == EntityTypes.aZ && itemBySlot.a(Items.wD) || type == EntityTypes.ba && itemBySlot.a(Items.wD) || type == EntityTypes.I && itemBySlot.a(Items.wB)) {
                d2 *= 0.5;
            }
        }
        return d2;
    }

    public boolean c(EntityLiving target) {
        return (!(target instanceof EntityHuman) || this.ao().av() != EnumDifficulty.a) && target.eS();
    }

    public boolean eS() {
        return !this.cU() && this.eT();
    }

    public boolean eT() {
        return !this.au() && this.cb();
    }

    public static boolean d(Collection<MobEffect> effects) {
        for (MobEffect mobEffectInstance : effects) {
            if (!mobEffectInstance.g() || mobEffectInstance.f()) continue;
            return false;
        }
        return true;
    }

    protected void eU() {
        this.az.a(ce, List.of());
    }

    public boolean eV() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.ao().B_()) {
            return false;
        }
        if (this.co.isEmpty()) {
            return false;
        }
        LinkedList<MobEffect> toRemove = new LinkedList<MobEffect>();
        Iterator<MobEffect> iterator = this.co.values().iterator();
        while (iterator.hasNext()) {
            MobEffect effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.c(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffect> eW() {
        return this.co.values();
    }

    public Map<Holder<MobEffectList>, MobEffect> eX() {
        return this.co;
    }

    public boolean d(Holder<MobEffectList> effect) {
        return this.co.containsKey(effect);
    }

    public @Nullable MobEffect e(Holder<MobEffectList> effect) {
        return this.co.get(effect);
    }

    public float a(Holder<MobEffectList> effect, float partialTick) {
        MobEffect effect1 = this.e(effect);
        return effect1 != null ? effect1.a(this, partialTick) : 0.0f;
    }

    public final boolean a(MobEffect effectInstance) {
        return this.b(effectInstance, (Entity)null);
    }

    public boolean addEffect(MobEffect effectInstance, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, null, cause);
    }

    public boolean b(MobEffect effectInstance, @Nullable Entity entity) {
        return this.addEffect(effectInstance, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, entity, cause, true);
    }

    public boolean addEffect(MobEffect effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effectInstance, cause));
            return true;
        }
        if (!this.b(effectInstance)) {
            return false;
        }
        MobEffect mobEffectInstance = this.co.get(effectInstance.c());
        boolean flag = false;
        boolean override = false;
        boolean addAsHiddenEffect = false;
        if (mobEffectInstance != null) {
            override = new MobEffect(mobEffectInstance).b(effectInstance);
            boolean bl = addAsHiddenEffect = mobEffectInstance.e() > effectInstance.e() && mobEffectInstance.e(effectInstance);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, effectInstance, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobEffectInstance == null) {
            this.co.put(effectInstance.c(), effectInstance);
            this.a(effectInstance, entity);
            flag = true;
            effectInstance.b(this);
        } else if (override) {
            mobEffectInstance.b(effectInstance);
            this.a(mobEffectInstance, true, entity);
            flag = true;
        } else if (addAsHiddenEffect) {
            if (mobEffectInstance.m == null) {
                mobEffectInstance.m = new MobEffect(effectInstance);
            } else {
                mobEffectInstance.m.b(effectInstance);
            }
        }
        effectInstance.a(this);
        return flag;
    }

    public boolean b(MobEffect effectInstance) {
        if (this.ay().a(TagsEntity.H)) {
            return !effectInstance.a(MobEffects.M);
        }
        return this.ay().a(TagsEntity.G) ? !effectInstance.a(MobEffects.L) : !this.ay().a(TagsEntity.x) || !effectInstance.a(MobEffects.j) && !effectInstance.a(MobEffects.s);
    }

    public void c(MobEffect effectInstance, @Nullable Entity entity) {
        if (this.b(effectInstance)) {
            MobEffect mobEffectInstance = this.co.put(effectInstance.c(), effectInstance);
            if (mobEffectInstance == null) {
                this.a(effectInstance, entity);
            } else {
                effectInstance.d(mobEffectInstance);
                this.a(effectInstance, true, entity);
            }
        }
    }

    public boolean eY() {
        return this.ay().a(TagsEntity.y);
    }

    public final @Nullable MobEffect f(Holder<MobEffectList> effect) {
        return this.removeEffectNoUpdate(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public @Nullable MobEffect removeEffectNoUpdate(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effect, cause));
            return null;
        }
        MobEffect effectInstance = this.co.get(effect);
        if (effectInstance == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effectInstance, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.co.remove(effect);
    }

    public boolean g(Holder<MobEffectList> effect) {
        return this.removeEffect(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffectList> effect, EntityPotionEffectEvent.Cause cause) {
        MobEffect mobEffectInstance = this.removeEffectNoUpdate(effect, cause);
        if (mobEffectInstance != null) {
            this.c(List.of(mobEffectInstance));
            return true;
        }
        return false;
    }

    protected void a(MobEffect effectInstance, @Nullable Entity entity) {
        if (!this.ao().B_()) {
            this.cr = true;
            effectInstance.c().a().a(this.fw(), effectInstance.e());
            this.c(effectInstance);
        }
    }

    public void c(MobEffect effectInstance) {
        for (Entity entity : this.dn()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            serverPlayer.g.b(new PacketPlayOutEntityEffect(this.aA(), effectInstance, false));
        }
    }

    protected void a(MobEffect effectInstance, boolean forced, @Nullable Entity entity) {
        if (!this.ao().B_()) {
            this.cr = true;
            if (forced) {
                MobEffectList mobEffect = effectInstance.c().a();
                mobEffect.a(this.fw());
                mobEffect.a(this.fw(), effectInstance.e());
                this.E();
            }
            this.c(effectInstance);
        }
    }

    protected void c(Collection<MobEffect> effects) {
        if (!this.ao().B_()) {
            this.cr = true;
            for (MobEffect mobEffectInstance : effects) {
                mobEffectInstance.c().a().a(this.fw());
                for (Entity entity : this.dn()) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer serverPlayer = (EntityPlayer)entity;
                    serverPlayer.g.b(new PacketPlayOutRemoveEntityEffect(this.aA(), mobEffectInstance.c()));
                }
            }
            this.E();
        }
    }

    private void E() {
        Set<AttributeModifiable> attributesToUpdate = this.fw().b();
        for (AttributeModifiable attributeInstance : attributesToUpdate) {
            this.a(attributeInstance.a());
        }
        attributesToUpdate.clear();
    }

    protected void a(Holder<AttributeBase> attribute) {
        net.minecraft.world.level.World maxHealth3;
        if (attribute.a(GenericAttributes.u)) {
            float maxHealth2 = this.fq();
            if (this.eZ() > maxHealth2) {
                this.x(maxHealth2);
            }
        } else if (attribute.a(GenericAttributes.t)) {
            float maxHealth3 = this.fr();
            if (this.fX() > maxHealth3) {
                this.F(maxHealth3);
            }
        } else if (attribute.a(GenericAttributes.A)) {
            this.j_();
        } else if (attribute.a(GenericAttributes.I) && (maxHealth3 = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)maxHealth3;
            ServerWaypointManager waypointManager = serverLevel.j();
            if (this.cm.c(attribute) > 0.0) {
                waypointManager.a(this);
            } else {
                waypointManager.c(this);
            }
        }
    }

    public void d(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float amount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(amount, regainReason, false);
    }

    public void heal(float amount, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float health = this.eZ();
        if (health > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)amount, regainReason, isFastRegen);
            if (this.valid) {
                this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.x((float)((double)this.eZ() + event.getAmount()));
            }
        }
    }

    public float eZ() {
        EntityLiving entityLiving = this;
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            return (float)player.getBukkitEntity().getHealth();
        }
        return this.az.a(cd).floatValue();
    }

    public void x(float health) {
        if (Float.isNaN(health)) {
            health = this.fq();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.da() + " had NaN health set");
            }
        }
        if (this instanceof EntityPlayer) {
            CraftPlayer player = ((EntityPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.az.a(cd, Float.valueOf(MathHelper.a(health, 0.0f, this.fq())));
    }

    public boolean fa() {
        return this.eZ() <= 0.0f;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag2;
        boolean flag;
        if (this.a(level, damageSource)) {
            return false;
        }
        if (this.eh() || this.bJ || this.eZ() <= 0.0f) {
            return false;
        }
        if (damageSource.a(DamageTypeTags.i) && this.d(MobEffects.l)) {
            return false;
        }
        if (this.gr()) {
            this.gs();
        }
        this.bK = 0;
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        ItemStack useItem = this.gb();
        float originAmount = amount;
        float f1 = this.applyItemBlocking(level, damageSource, amount, true);
        boolean bl = flag = f1 > 0.0f;
        if (Float.isNaN(amount) || Float.isInfinite(amount)) {
            amount = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.ax > (float)this.invulnerableDuration / 2.0f && !damageSource.a(DamageTypeTags.e)) {
            if (amount <= this.bL) {
                return false;
            }
            event = this.handleEntityDamage(damageSource, amount, this.bL);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originAmount == 0.0f) {
                return false;
            }
            this.bL = amount;
            flag1 = false;
        } else {
            event = this.handleEntityDamage(damageSource, amount, 0.0f);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof EntityPlayer && event.getDamage() == 0.0 && originAmount == 0.0f) {
                return false;
            }
            this.bL = amount;
            this.ax = this.invulnerableDuration;
            this.bu = this.bv = 10;
        }
        this.e(damageSource);
        this.f(damageSource);
        if (flag1) {
            BlocksAttacks blocksAttacks = useItem.a(DataComponents.M);
            if (flag && blocksAttacks != null) {
                blocksAttacks.a(level, this);
            } else {
                level.a((Entity)this, damageSource);
            }
            if (!damageSource.a(DamageTypeTags.r) && !flag) {
                this.bT();
            }
            if (!damageSource.a(DamageTypeTags.z)) {
                double d2 = 0.0;
                double d1 = 0.0;
                Entity entity2 = damageSource.c();
                if (entity2 instanceof IProjectile) {
                    IProjectile projectile = (IProjectile)entity2;
                    DoubleDoubleImmutablePair doubleDoubleImmutablePair = projectile.a(this, damageSource);
                    d2 = -doubleDoubleImmutablePair.leftDouble();
                    d1 = -doubleDoubleImmutablePair.rightDouble();
                } else if (damageSource.i() != null) {
                    d2 = damageSource.i().a() - this.dP();
                    d1 = damageSource.i().c() - this.dV();
                }
                if (Math.abs(d2) > 200.0) {
                    d2 = Math.random() - Math.random();
                }
                if (Math.abs(d1) > 200.0) {
                    d1 = Math.random() - Math.random();
                }
                this.knockback(0.4f, d2, d1, damageSource.c(), damageSource.c() == null ? EntityKnockbackEvent.Cause.DAMAGE : EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                if (!flag) {
                    this.a(d2, d1);
                }
            }
        }
        if (this.fa()) {
            if (!this.j(damageSource)) {
                this.silentDeath = !flag1;
                this.a(damageSource);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.g(damageSource);
            this.i(damageSource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.cC = damageSource;
            this.cD = this.ao().au();
            for (MobEffect mobEffectInstance : this.eW()) {
                mobEffectInstance.a(level, this, damageSource, amount);
            }
        }
        if ((entity = this) instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            CriterionTriggers.i.a(serverPlayer, damageSource, originAmount, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                serverPlayer.a(StatisticList.M, Math.round(f1 * 10.0f));
            }
        }
        if ((entity = damageSource.d()) instanceof EntityPlayer) {
            EntityPlayer serverPlayerx = (EntityPlayer)entity;
            CriterionTriggers.h.a(serverPlayerx, this, damageSource, originAmount, amount, flag);
        }
        return flag2;
    }

    public float b(WorldServer level, DamageSource damageSource, float damageAmount) {
        return this.applyItemBlocking(level, damageSource, damageAmount, false);
    }

    public float applyItemBlocking(WorldServer level, DamageSource damageSource, float damageAmount, boolean dryRun) {
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemBlockingWith = this.gh();
        if (itemBlockingWith == null) {
            return 0.0f;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.M);
        if (blocksAttacks != null) {
            if (!blocksAttacks.f().map(damageSource::a).orElse(false).booleanValue()) {
                double acos;
                EntityArrow abstractArrow;
                Entity entity = damageSource.c();
                if (entity instanceof EntityArrow && (abstractArrow = (EntityArrow)entity).x() > 0) {
                    return 0.0f;
                }
                Vec3D sourcePosition = damageSource.i();
                if (sourcePosition != null) {
                    Vec3D vec3 = this.c(0.0f, this.cS());
                    Vec3D vec31 = sourcePosition.d(this.dI());
                    vec31 = new Vec3D(vec31.g, 0.0, vec31.i).d();
                    acos = Math.acos(vec31.b(vec3));
                } else {
                    acos = 3.1415927410125732;
                }
                float f2 = blocksAttacks.a(damageSource, damageAmount, acos);
                if (!dryRun) {
                    EntityLiving livingEntity;
                    Entity entity2;
                    blocksAttacks.a(this.ao(), itemBlockingWith, this, this.ga(), f2);
                    if (f2 > 0.0f && !damageSource.a(DamageTypeTags.j) && (entity2 = damageSource.c()) instanceof EntityLiving && (livingEntity = (EntityLiving)entity2).g(this) <= MathHelper.n(200.0)) {
                        this.a(level, livingEntity);
                    }
                }
                return f2;
            }
        }
        return 0.0f;
    }

    public boolean canBlockAttack(DamageSource damageSource, float damageAmount) {
        if (damageAmount <= 0.0f) {
            return false;
        }
        ItemStack itemBlockingWith = this.gh();
        if (itemBlockingWith == null) {
            return false;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.M);
        if (blocksAttacks != null) {
            if (!blocksAttacks.f().map(damageSource::a).orElse(false).booleanValue()) {
                EntityArrow abstractArrow;
                Entity entity = damageSource.c();
                return !(entity instanceof EntityArrow) || (abstractArrow = (EntityArrow)entity).x() <= 0;
            }
        }
        return false;
    }

    public float resolveBlockedDamage(DamageSource damageSource, float damageAmount) {
        double acos;
        Vec3D sourcePosition = damageSource.i();
        if (sourcePosition != null) {
            Vec3D vec3 = this.c(0.0f, this.cS());
            Vec3D vec31 = sourcePosition.d(this.dI());
            vec31 = new Vec3D(vec31.g, 0.0, vec31.i).d();
            acos = Math.acos(vec31.b(vec3));
        } else {
            acos = 3.1415927410125732;
        }
        BlocksAttacks blocksAttacks = this.gh().a(DataComponents.M);
        return blocksAttacks.a(damageSource, damageAmount, acos);
    }

    public void blockingItemEffects(WorldServer level, DamageSource damageSource, float f2) {
        EntityLiving livingEntity;
        Entity entity;
        ItemStack itemBlockingWith = this.gh();
        if (itemBlockingWith == null) {
            return;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.a(DataComponents.M);
        if (blocksAttacks == null) {
            return;
        }
        blocksAttacks.a(this.ao(), itemBlockingWith, this, this.ga(), f2);
        if (f2 > 0.0f && !damageSource.a(DamageTypeTags.j) && (entity = damageSource.c()) instanceof EntityLiving && (livingEntity = (EntityLiving)entity).g(this) <= MathHelper.n(200.0)) {
            this.a(level, livingEntity);
        }
    }

    public void i(DamageSource damageSource) {
        if (damageSource.a(DamageTypes.Q)) {
            SoundCategory soundSource = this instanceof EntityHuman ? SoundCategory.h : SoundCategory.f;
            this.ao().a(null, this.dI().g, this.dI().h, this.dI().i, SoundEffects.CP, soundSource);
        }
    }

    protected void e(DamageSource damageSource) {
        Entity entity = damageSource.d();
        if (entity instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)entity;
            if (!(damageSource.a(DamageTypeTags.q) || damageSource.a(DamageTypes.J) && this.ay().a(TagsEntity.F))) {
                this.a(livingEntity);
            }
        }
    }

    protected @Nullable EntityHuman f(DamageSource damageSource) {
        EntityWolf wolf;
        Entity entity = damageSource.d();
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            this.a(player, 100);
        } else if (entity instanceof EntityWolf && (wolf = (EntityWolf)entity).p()) {
            if (wolf.ae_() != null) {
                this.a(wolf.ae_().c(), 100);
            } else {
                this.bH = null;
                this.bI = 0;
            }
        }
        return EntityReference.c(this.bH, this.ao());
    }

    private float computeAmountFromEntityDamageEvent(EntityDamageEvent event) {
        float amount = 0.0f;
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        return amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
    }

    protected void a(WorldServer level, EntityLiving entity) {
        entity.d(this);
    }

    protected void d(EntityLiving entity) {
        entity.knockback(0.5, entity.dP() - this.dP(), entity.dV() - this.dV(), this, EntityKnockbackEvent.Cause.SHIELD_BLOCK);
    }

    private boolean j(DamageSource damageSource) {
        if (damageSource.a(DamageTypeTags.d)) {
            return false;
        }
        ItemStack itemStack = null;
        DeathProtection deathProtection = null;
        EnumHand hand = null;
        ItemStack itemInHand = ItemStack.l;
        for (EnumHand interactionHand : EnumHand.values()) {
            itemInHand = this.b(interactionHand);
            deathProtection = itemInHand.a(DataComponents.L);
            if (deathProtection == null) continue;
            hand = interactionHand;
            itemStack = itemInHand.v();
            break;
        }
        EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemStack == null);
        this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            deathProtection = null;
        } else {
            EntityLiving entityLiving;
            if (!itemInHand.f() && itemStack != null) {
                itemInHand.h(1);
            }
            if (deathProtection == null) {
                deathProtection = DeathProtection.c;
            }
            if (itemStack != null && (entityLiving = this) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                serverPlayer.b(StatisticList.c.b(itemStack.h()));
                CriterionTriggers.C.a(serverPlayer, itemStack);
                itemStack.a((Entity)this, GameEvent.C);
            }
            this.x(1.0f);
            deathProtection.a(itemStack, this);
            this.ao().a((Entity)this, (byte)35);
        }
        return deathProtection != null;
    }

    public @Nullable DamageSource fb() {
        if (this.ao().au() - this.cD > 40L) {
            this.cC = null;
        }
        return this.cC;
    }

    protected void g(DamageSource damageSource) {
        this.b(this.h(damageSource));
    }

    public void b(@Nullable SoundEffect sound) {
        if (sound != null) {
            this.a(sound, this.fC(), this.fD());
        }
    }

    private void g(ItemStack stack) {
        if (!stack.f()) {
            Holder<SoundEffect> holder = stack.a(DataComponents.aB);
            if (holder != null && !this.bq()) {
                this.ao().a(this.dP(), this.dR(), this.dV(), holder.a(), this.dB(), 0.8f, 0.8f + this.ao().y.i() * 0.4f, false);
            }
            this.b(stack, 5);
        }
    }

    public void a(DamageSource damageSource) {
        if (!this.eh() && !this.bJ) {
            Entity entity = damageSource.d();
            EntityLiving killCredit = this.fp();
            this.bJ = true;
            net.minecraft.world.level.World world = this.ao();
            if (world instanceof WorldServer) {
                EntityDeathEvent deathEvent;
                WorldServer serverLevel = (WorldServer)world;
                if (entity instanceof EntityCreeper) {
                    EntityCreeper creeper = (EntityCreeper)entity;
                    creeper.a((WorldServer)this.ao(), this, damageSource);
                }
                if ((deathEvent = this.dropAllDeathLoot(serverLevel, damageSource)) == null || !deathEvent.isCancelled()) {
                    if (this instanceof EntityInsentient) {
                        for (EnumItemSlot slot : this.clearedEquipmentSlots) {
                            this.a(slot, ItemStack.l);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.gr()) {
                        this.gs();
                    }
                    if (!this.ao().B_() && this.i_() && SpigotConfig.logNamedDeaths) {
                        a.info("Named entity {} died: {}", (Object)this, (Object)this.fo().a().getString());
                    }
                    this.fo().c();
                    if (entity != null) {
                        entity.a((WorldServer)this.ao(), this, damageSource);
                    }
                    this.c(GameEvent.p);
                } else {
                    this.bJ = false;
                    this.x((float)deathEvent.getReviveHealth());
                    if (entity instanceof EntityCreeper) {
                        EntityCreeper creeper = (EntityCreeper)entity;
                        if (creeper.cA) {
                            creeper.cA = false;
                        }
                    }
                }
                this.e(killCredit);
            }
            if (this.bJ) {
                this.ao().a((Entity)this, (byte)3);
                this.c(EntityPose.h);
            }
        }
    }

    protected void e(@Nullable EntityLiving entitySource) {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            boolean var6 = false;
            if (this.bJ && entitySource instanceof EntityWither) {
                if (serverLevel.U().a(GameRules.F).booleanValue()) {
                    BlockPosition blockPos = this.dK();
                    IBlockData blockState = Blocks.cn.m();
                    if (this.ao().a_(blockPos).l() && blockState.a((IWorldReader)this.ao(), blockPos)) {
                        var6 = CraftEventFactory.handleBlockFormEvent(this.ao(), blockPos, blockState, 3, this);
                    }
                }
                if (!var6) {
                    EntityItem itemEntity = new EntityItem(this.ao(), this.dP(), this.dR(), this.dV(), new ItemStack(Items.dJ));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    if (!event.callEvent()) {
                        return;
                    }
                    this.ao().b(itemEntity);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(WorldServer level, DamageSource damageSource) {
        boolean flag = this.bI > 0;
        this.g(level);
        if (this.e(level)) {
            this.b(level, damageSource, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.a(level, damageSource, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, damageSource, this.drops, () -> {
            EntityLiving killer = this.fp();
            if (killer != null) {
                killer.a((Entity)this, damageSource);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList<Entity.DefaultDrop>();
        this.b(level, damageSource.d());
        return deathEvent;
    }

    protected void g(WorldServer level) {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward(WorldServer level, @Nullable Entity entity) {
        if (!this.ff() && (this.eJ() || this.bI > 0 && this.eI() && level.U().a(GameRules.D).booleanValue())) {
            return this.a(level, entity);
        }
        return 0;
    }

    protected void b(WorldServer level, @Nullable Entity entity) {
        if (!(this instanceof EntityEnderDragon)) {
            EntityExperienceOrb.awardWithDirection(level, this.dI(), Vec3D.c, this.expToDrop, this instanceof EntityPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, entity, this);
            this.expToDrop = 0;
        }
    }

    protected void a(WorldServer level, DamageSource damageSource, boolean recentlyHit) {
    }

    public long fc() {
        return 0L;
    }

    protected float b(Entity attacker, DamageSource damageSource) {
        float f2;
        float f3 = (float)this.i(GenericAttributes.e);
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            f2 = EnchantmentManager.d(serverLevel, this.eq(), attacker, damageSource, f3) / 2.0f;
        } else {
            f2 = f3 / 2.0f;
        }
        return f2;
    }

    protected void b(WorldServer level, DamageSource damageSource, boolean playerKill) {
        Optional<ResourceKey<LootTable>> lootTable = this.er();
        if (!lootTable.isEmpty()) {
            this.a(level, damageSource, playerKill, lootTable.get());
        }
    }

    public void a(WorldServer level, DamageSource damageSource, boolean playerKill, ResourceKey<LootTable> lootTable) {
        this.a(level, damageSource, playerKill, lootTable, (ItemStack itemStack) -> this.a(level, (ItemStack)itemStack));
    }

    public void a(WorldServer level, DamageSource damageSource, boolean playerKill, ResourceKey<LootTable> lootTable, Consumer<ItemStack> dropConsumer) {
        LootTable lootTable1 = level.s().be().a(lootTable);
        LootParams.a builder = new LootParams.a(level).a(LootContextParameters.a, this).a(LootContextParameters.h, this.dI()).a(LootContextParameters.e, damageSource).b(LootContextParameters.f, damageSource.d()).b(LootContextParameters.g, damageSource.c());
        EntityHuman lastHurtByPlayer = this.eL();
        if (playerKill && lastHurtByPlayer != null) {
            builder = builder.a(LootContextParameters.d, lastHurtByPlayer).a(lastHurtByPlayer.eB());
        }
        LootParams lootParams = builder.a(LootContextParameterSets.g);
        lootTable1.a(lootParams, this.fc(), dropConsumer);
    }

    public boolean a(WorldServer level, ResourceKey<LootTable> lootTable, @Nullable Entity entity, ItemStack tool, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        return this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.c, this).b(LootContextParameters.b, entity).a(LootContextParameters.k, tool).a(LootContextParameterSets.t), dropConsumer);
    }

    public boolean a(WorldServer level, ResourceKey<LootTable> lootTable, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        return this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.h, this.dI()).a(LootContextParameters.a, this).a(LootContextParameterSets.j), dropConsumer);
    }

    protected void a(WorldServer level, ResourceKey<LootTable> lootTable, ItemStack shears, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        this.a(level, lootTable, (LootParams.a builder) -> builder.a(LootContextParameters.h, this.dI()).a(LootContextParameters.a, this).a(LootContextParameters.k, shears).a(LootContextParameterSets.s), dropConsumer);
    }

    protected boolean a(WorldServer level, ResourceKey<LootTable> lootTable, Function<LootParams.a, LootParams> paramsBuilder, BiConsumer<WorldServer, ItemStack> dropConsumer) {
        LootParams lootParams;
        LootTable lootTable1 = level.s().be().a(lootTable);
        ObjectArrayList<ItemStack> randomItems = lootTable1.a(lootParams = paramsBuilder.apply(new LootParams.a(level)));
        if (!randomItems.isEmpty()) {
            randomItems.forEach(itemStack -> dropConsumer.accept(level, (ItemStack)itemStack));
            return true;
        }
        return false;
    }

    public void o(double strength, double x2, double z2) {
        this.knockback(strength, x2, z2, null, EntityKnockbackEvent.Cause.UNKNOWN);
    }

    public void knockback(double strength, double x2, double z2, @Nullable Entity attacker, EntityKnockbackEvent.Cause eventCause) {
        strength *= 1.0 - this.i(GenericAttributes.r);
        Vec3D deltaMovement = this.dN();
        while (x2 * x2 + z2 * z2 < (double)1.0E-5f) {
            x2 = (this.as.j() - this.as.j()) * 0.01;
            z2 = (this.as.j() - this.as.j()) * 0.01;
        }
        Vec3D vec3 = new Vec3D(x2, 0.0, z2).d().c(strength);
        Vec3D finalVelocity = new Vec3D(deltaMovement.g / 2.0 - vec3.g, this.aV() ? Math.min(0.4, deltaMovement.h / 2.0 + strength) : deltaMovement.h, deltaMovement.i / 2.0 - vec3.i);
        Vec3D diff = finalVelocity.d(deltaMovement);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, attacker, eventCause, strength, diff);
        if (event.isCancelled()) {
            return;
        }
        this.aF = true;
        this.k(deltaMovement.b(event.getKnockback().getX(), event.getKnockback().getY(), event.getKnockback().getZ()));
    }

    public void a(double xDistance, double zDistance) {
    }

    public @Nullable SoundEffect h(DamageSource damageSource) {
        return SoundEffects.lU;
    }

    public @Nullable SoundEffect fd() {
        return SoundEffects.lP;
    }

    public SoundEffect q(int height) {
        return height > 4 ? this.fj().b() : this.fj().a();
    }

    public void fe() {
        this.cG = true;
    }

    public boolean ff() {
        return this.cG;
    }

    public float fg() {
        return 0.0f;
    }

    protected AxisAlignedBB fh() {
        AxisAlignedBB boundingBox = this.dj();
        Entity vehicle = this.dz();
        if (vehicle != null) {
            Vec3D passengerRidingPosition = vehicle.n(this);
            return boundingBox.b(Math.max(passengerRidingPosition.h, boundingBox.b));
        }
        return boundingBox;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> c(EnumItemSlot slot) {
        return (Map)this.cH.computeIfAbsent(slot, equipmentSlot -> new Reference2ObjectArrayMap());
    }

    public void fi() {
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            EnchantmentManager.a(serverLevel, (Entity)this);
        }
    }

    public a fj() {
        return new a(SoundEffects.lV, SoundEffects.lN);
    }

    public Optional<BlockPosition> fk() {
        return this.cB;
    }

    public boolean fl() {
        if (this.au()) {
            return false;
        }
        BlockPosition blockPos = this.dK();
        IBlockData inBlockState = this.dL();
        if (this.gj() && inBlockState.a(TagsBlock.bn)) {
            return false;
        }
        if (inBlockState.a(TagsBlock.bd)) {
            this.cB = Optional.of(blockPos);
            return true;
        }
        if (inBlockState.b() instanceof BlockTrapdoor && this.c(blockPos, inBlockState)) {
            this.cB = Optional.of(blockPos);
            return true;
        }
        return false;
    }

    private boolean c(BlockPosition pos, IBlockData state) {
        if (!state.c(BlockTrapdoor.b).booleanValue()) {
            return false;
        }
        IBlockData blockState = this.ao().a_(pos.e());
        return blockState.a(Blocks.dm) && blockState.c(BlockLadder.b) == state.c(BlockFacingHorizontal.f);
    }

    @Override
    public boolean cb() {
        return !this.eh() && this.eZ() > 0.0f && !this.bJ;
    }

    public boolean a(EntityLiving entity, double tolerance, boolean scaleByDistance, boolean visual, double ... yValues) {
        Vec3D vec3 = entity.h(1.0f).d();
        for (double d2 : yValues) {
            Vec3D vec31 = new Vec3D(this.dP() - entity.dP(), d2 - entity.dT(), this.dV() - entity.dV());
            double len = vec31.g();
            vec31 = vec31.d();
            double d1 = vec3.b(vec31);
            double d3 = scaleByDistance ? len : 1.0;
            if (!(d1 > 1.0 - tolerance / d3) || !entity.a(this, visual ? RayTrace.BlockCollisionOption.c : RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, d2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int cW() {
        return this.y(0.0f);
    }

    protected final int y(float distanceOffset) {
        return MathHelper.b(distanceOffset + 3.0f);
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.a(fallDistance, damageMultiplier, damageSource);
        int i2 = this.a(fallDistance, damageMultiplier);
        if (i2 > 0) {
            if (!this.a((WorldServer)this.ao(), damageSource, (float)i2)) {
                return true;
            }
            this.a(this.q(i2), 1.0f, 1.0f);
            this.fm();
            return true;
        }
        return flag;
    }

    protected int a(double fallDistance, float damageMultiplier) {
        if (this.ay().a(TagsEntity.p)) {
            return 0;
        }
        double d2 = this.i(fallDistance);
        return MathHelper.c(d2 * (double)damageMultiplier * this.i(GenericAttributes.m));
    }

    private double i(double fallDistance) {
        return fallDistance + 1.0E-6 - this.i(GenericAttributes.z);
    }

    protected void fm() {
        if (!this.bq()) {
            int floor = MathHelper.c(this.dP());
            int floor1 = MathHelper.c(this.dR() - (double)0.2f);
            int floor2 = MathHelper.c(this.dV());
            IBlockData blockState = this.ao().a_(new BlockPosition(floor, floor1, floor2));
            if (!blockState.l()) {
                SoundEffectType soundType = blockState.A();
                this.a(soundType.g(), soundType.a() * 0.5f, soundType.b() * 0.75f);
            }
        }
    }

    @Override
    public void q(float yaw) {
        this.bu = this.bv = 10;
    }

    public int fn() {
        return MathHelper.c(this.i(GenericAttributes.b));
    }

    protected void c(DamageSource damageSource, float damageAmount) {
    }

    protected void d(DamageSource damageSource, float damageAmount) {
    }

    protected void a(DamageSource damageSource, float damageAmount, EnumItemSlot ... slots) {
        if (!(damageAmount <= 0.0f)) {
            int i2 = (int)Math.max(1.0f, damageAmount / 4.0f);
            for (EnumItemSlot equipmentSlot : slots) {
                ItemStack itemBySlot = this.a(equipmentSlot);
                Equippable equippable = itemBySlot.a(DataComponents.H);
                if (equippable == null || !equippable.i() || !itemBySlot.m() || !itemBySlot.a(damageSource)) continue;
                itemBySlot.a(i2, this, equipmentSlot);
            }
        }
    }

    protected float e(DamageSource damageSource, float damageAmount) {
        if (!damageSource.a(DamageTypeTags.b)) {
            damageAmount = CombatMath.a(this, damageAmount, damageSource, this.fn(), (float)this.i(GenericAttributes.c));
        }
        return damageAmount;
    }

    protected float f(DamageSource damageSource, float damageAmount) {
        float damageProtection;
        if (damageSource.a(DamageTypeTags.f)) {
            return damageAmount;
        }
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        if (damageSource.a(DamageTypeTags.h)) {
            return damageAmount;
        }
        net.minecraft.world.level.World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            damageProtection = EnchantmentManager.b(serverLevel, this, damageSource);
        } else {
            damageProtection = 0.0f;
        }
        if (damageProtection > 0.0f) {
            damageAmount = CombatMath.a(damageAmount, damageProtection);
        }
        return damageAmount;
    }

    private EntityDamageEvent handleEntityDamage(DamageSource damagesource, float amount, float invulnerabilityRelatedLastDamage) {
        float originalDamage = amount;
        com.google.common.base.Function invulnerabilityReductionEquation = mod -> {
            if (invulnerabilityRelatedLastDamage == 0.0f) {
                return 0.0;
            }
            if (mod.floatValue() < invulnerabilityRelatedLastDamage) {
                return 0.0;
            }
            return -invulnerabilityRelatedLastDamage;
        };
        float originalInvulnerabilityReduction = ((Double)invulnerabilityReductionEquation.apply((Object)amount)).floatValue();
        com.google.common.base.Function freezing = mod -> {
            if (damagesource.a(DamageTypeTags.o) && this.ay().a(TagsEntity.m)) {
                return -(mod - mod * 5.0);
            }
            return -0.0;
        };
        float freezingModifier = ((Double)freezing.apply((Object)(amount += originalInvulnerabilityReduction))).floatValue();
        com.google.common.base.Function hardHat = mod -> {
            if (damagesource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                return -(mod - mod * 0.75);
            }
            return -0.0;
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(amount += freezingModifier))).floatValue();
        com.google.common.base.Function blocking = mod -> {
            if (!this.canBlockAttack(damagesource, mod.floatValue())) {
                return 0.0;
            }
            return -this.resolveBlockedDamage(damagesource, mod.floatValue());
        };
        float blockingModifier = ((Double)blocking.apply((Object)(amount += hardHatModifier))).floatValue();
        com.google.common.base.Function armor = mod -> -(mod - (double)this.e(damagesource, mod.floatValue()));
        float armorModifier = ((Double)armor.apply((Object)(amount += blockingModifier))).floatValue();
        com.google.common.base.Function resistance = mod -> {
            if (!damagesource.a(DamageTypeTags.f) && this.d(MobEffects.k) && !damagesource.a(DamageTypeTags.g)) {
                int i2 = (this.e(MobEffects.k).e() + 1) * 5;
                int j2 = 25 - i2;
                float f1 = mod.floatValue() * (float)j2;
                return -(mod - (double)Math.max(f1 / 25.0f, 0.0f));
            }
            return -0.0;
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(amount += armorModifier))).floatValue();
        com.google.common.base.Function magic = mod -> -(mod - (double)this.f(damagesource, mod.floatValue()));
        float magicModifier = ((Double)magic.apply((Object)(amount += resistanceModifier))).floatValue();
        com.google.common.base.Function absorption = mod -> -Math.max(mod - Math.max(mod - (double)this.fX(), 0.0), 0.0);
        float absorptionModifier = ((Double)absorption.apply((Object)(amount += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, (com.google.common.base.Function<Double, Double>)freezing, (com.google.common.base.Function<Double, Double>)hardHat, (com.google.common.base.Function<Double, Double>)blocking, (com.google.common.base.Function<Double, Double>)armor, (com.google.common.base.Function<Double, Double>)resistance, (com.google.common.base.Function<Double, Double>)magic, (com.google.common.base.Function<Double, Double>)absorption, (damageModifierDoubleMap, damageModifierFunctionMap) -> {
            damageModifierFunctionMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, invulnerabilityReductionEquation);
            damageModifierDoubleMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, Double.valueOf(originalInvulnerabilityReduction));
        });
    }

    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.a(level, damageSource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damageSource.d() instanceof EntityHuman) {
                if (damageSource.d() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)damageSource.d();
                    if (new PlayerAttackEntityCooldownResetEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.I(0.0f)).callEvent()) {
                        player.hg();
                    }
                } else {
                    ((EntityHuman)damageSource.d()).hg();
                }
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof EntityPlayer) {
                    ((EntityPlayer)this).a(StatisticList.O, Math.round(f3 * 10.0f));
                } else if (damageSource.d() instanceof EntityPlayer) {
                    ((EntityPlayer)damageSource.d()).a(StatisticList.K, Math.round(f3 * 10.0f));
                }
            }
            if (damageSource.a(DamageTypeTags.a) && !this.a(EnumItemSlot.f).f()) {
                float helmetDamage = (float)event.getDamage();
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                this.d(damageSource, helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING));
            }
            if (!damageSource.a(DamageTypeTags.b)) {
                float armorDamage = (float)event.getDamage();
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
                this.c(damageSource, armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.blockingItemEffects(level, damageSource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof EntityHuman;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.F(Math.max(this.fX() - absorptionModifier, 0.0f));
            float f1 = absorptionModifier;
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = this) instanceof EntityHuman) {
                EntityHuman player = (EntityHuman)entity;
                player.a(StatisticList.N, Math.round(f1 * 10.0f));
            }
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = damageSource.d()) instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                serverPlayer.a(StatisticList.J, Math.round(f1 * 10.0f));
            }
            if (amount > 0.0f || !human) {
                if (human) {
                    ((EntityHuman)this).causeFoodExhaustion(damageSource.a(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (amount < 3.4028235E37f) {
                        ((EntityHuman)this).a(StatisticList.L, Math.round(amount * 10.0f));
                    }
                }
                this.fo().a(damageSource, amount);
                this.x(this.eZ() - amount);
                if (!human) {
                    this.F(this.fX() - amount);
                }
                this.c(GameEvent.o);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof EntityPlayer) {
                    CriterionTriggers.i.a((EntityPlayer)this, damageSource, originalDamage, amount, true);
                    f1 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f1 > 0.0f && f1 < 3.4028235E37f) {
                        ((EntityPlayer)this).a(StatisticList.M, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damageSource.d() instanceof EntityPlayer) {
                    CriterionTriggers.h.a((EntityPlayer)damageSource.d(), this, damageSource, originalDamage, amount, true);
                }
                return !GlobalConfiguration.get().unsupportedSettings.skipVanillaDamageTickWhenShieldBlocked;
            }
            return true;
        }
        return true;
    }

    public CombatTracker fo() {
        return this.cn;
    }

    public @Nullable EntityLiving fp() {
        if (this.bH != null) {
            return this.bH.a(this.ao(), EntityHuman.class);
        }
        return this.cs != null ? this.cs.a(this.ao(), EntityLiving.class) : null;
    }

    public final float fq() {
        return (float)this.i(GenericAttributes.u);
    }

    public final float fr() {
        return (float)this.i(GenericAttributes.t);
    }

    public final int fs() {
        return this.az.a(cg);
    }

    public final void o(int count) {
        this.setArrowCount(count, false);
    }

    public final void setArrowCount(int count, boolean reset) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.fs(), count, reset);
        if (event.isCancelled()) {
            return;
        }
        this.az.a(cg, event.getNewAmount());
    }

    public final int ft() {
        return this.az.a(ch);
    }

    public final void p(int stingerCount) {
        this.az.a(ch, stingerCount);
    }

    private int F() {
        ItemStack itemInHand = this.b(EnumHand.a);
        int duration = itemInHand.L().b();
        if (MobEffectUtil.a(this)) {
            return duration - (1 + MobEffectUtil.b(this));
        }
        return this.d(MobEffects.d) ? duration + (1 + this.e(MobEffects.d).e()) * 2 : duration;
    }

    public void a(EnumHand hand) {
        this.a(hand, false);
    }

    public void a(EnumHand hand, boolean updateSelf) {
        if (!this.bp || this.br >= this.F() / 2 || this.br < 0) {
            this.br = -1;
            this.bp = true;
            this.bq = hand;
            if (this.ao() instanceof WorldServer) {
                PacketPlayOutAnimation clientboundAnimatePacket = new PacketPlayOutAnimation(this, hand == EnumHand.a ? 0 : 3);
                ChunkProviderServer chunkSource = ((WorldServer)this.ao()).p();
                if (updateSelf) {
                    chunkSource.a(this, clientboundAnimatePacket);
                } else {
                    chunkSource.b(this, clientboundAnimatePacket);
                }
            }
        }
    }

    @Override
    public void c(DamageSource damageSource) {
        this.bB.a(1.5f);
        this.ax = this.invulnerableDuration;
        this.bu = this.bv = 10;
        SoundEffect hurtSound = this.h(damageSource);
        if (hurtSound != null) {
            this.a(hurtSound, this.fC(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
        }
        this.cC = damageSource;
        this.cD = this.ao().au();
    }

    @Override
    public void b(byte id) {
        switch (id) {
            case 2: {
                this.H();
                break;
            }
            case 3: {
                SoundEffect deathSound = this.fd();
                if (deathSound != null) {
                    this.a(deathSound, this.fC(), (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                }
                if (this instanceof EntityHuman) break;
                this.x(0.0f);
                this.a(this.en().p());
                break;
            }
            case 46: {
                int i2 = 128;
                for (int i1 = 0; i1 < 128; ++i1) {
                    double d2 = (double)i1 / 127.0;
                    float f2 = (this.as.i() - 0.5f) * 0.2f;
                    float f1 = (this.as.i() - 0.5f) * 0.2f;
                    float f22 = (this.as.i() - 0.5f) * 0.2f;
                    double d1 = MathHelper.d(d2, this.Y, this.dP()) + (this.as.j() - 0.5) * (double)this.dF() * 2.0;
                    double d22 = MathHelper.d(d2, this.Z, this.dR()) + this.as.j() * (double)this.dG();
                    double d3 = MathHelper.d(d2, this.aa, this.dV()) + (this.as.j() - 0.5) * (double)this.dF() * 2.0;
                    this.ao().a(Particles.ag, d1, d22, d3, (double)f2, (double)f1, f22);
                }
                break;
            }
            case 47: {
                this.g(this.a(EnumItemSlot.a));
                break;
            }
            case 48: {
                this.g(this.a(EnumItemSlot.b));
                break;
            }
            case 49: {
                this.g(this.a(EnumItemSlot.f));
                break;
            }
            case 50: {
                this.g(this.a(EnumItemSlot.e));
                break;
            }
            case 51: {
                this.g(this.a(EnumItemSlot.d));
                break;
            }
            case 52: {
                this.g(this.a(EnumItemSlot.c));
                break;
            }
            case 54: {
                BlockHoney.b(this);
                break;
            }
            case 55: {
                this.I();
                break;
            }
            case 60: {
                this.fu();
                break;
            }
            case 65: {
                this.g(this.a(EnumItemSlot.g));
                break;
            }
            case 67: {
                this.G();
                break;
            }
            case 68: {
                this.g(this.a(EnumItemSlot.h));
                break;
            }
            default: {
                super.b(id);
            }
        }
    }

    public float z(float partialTick) {
        return this.cz < 0L ? 0.0f : (float)(this.ao().au() - this.cz) + partialTick;
    }

    public void fu() {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            double d3 = 10.0;
            this.ao().a(Particles.af, this.e(1.0) - d2 * 10.0, this.dS() - d1 * 10.0, this.h(1.0) - d22 * 10.0, d2, d1, d22);
        }
    }

    private void G() {
        Vec3D deltaMovement = this.dN();
        for (int i2 = 0; i2 < 8; ++i2) {
            double d2 = this.as.a(0.0, 1.0);
            double d1 = this.as.a(0.0, 1.0);
            double d22 = this.as.a(0.0, 1.0);
            this.ao().a(Particles.d, this.dP() + d2, this.dR() + d1, this.dV() + d22, deltaMovement.g, deltaMovement.h, deltaMovement.i);
        }
    }

    private void H() {
        if (this.ao().au() - this.cz > 10L) {
            this.cz = this.ao().au();
            KineticWeapon kineticWeapon = this.bT.a(DataComponents.O);
            if (kineticWeapon != null) {
                kineticWeapon.c(this);
            }
        }
    }

    private void I() {
        ItemStack itemBySlot = this.a(EnumItemSlot.b);
        this.a(EnumItemSlot.b, this.a(EnumItemSlot.a));
        this.a(EnumItemSlot.a, itemBySlot);
    }

    @Override
    protected void aU() {
        this.a(this.en().o(), this.ao().getWorld().getVoidDamageAmount());
    }

    protected void fv() {
        int currentSwingDuration = this.F();
        if (this.bp) {
            ++this.br;
            if (this.br >= currentSwingDuration) {
                this.br = 0;
                this.bp = false;
            }
        } else {
            this.br = 0;
        }
        this.by = (float)this.br / (float)currentSwingDuration;
    }

    public @Nullable AttributeModifiable h(Holder<AttributeBase> attribute) {
        return this.fw().a(attribute);
    }

    public double i(Holder<AttributeBase> attribute) {
        return this.fw().c(attribute);
    }

    public double j(Holder<AttributeBase> attribute) {
        return this.fw().d(attribute);
    }

    public AttributeMapBase fw() {
        return this.cm;
    }

    public ItemStack fx() {
        return this.a(EnumItemSlot.a);
    }

    public ItemStack fy() {
        return this.a(EnumItemSlot.b);
    }

    public ItemStack b(EnumMainHand arm) {
        return this.at() == arm ? this.fx() : this.fy();
    }

    @Override
    public ItemStack eq() {
        return this.fx();
    }

    public AttackRange fz() {
        AttackRange attackRange = this.fA().a(DataComponents.F);
        return attackRange != null ? attackRange : AttackRange.a(this);
    }

    public ItemStack fA() {
        return this.fZ() ? this.gb() : this.fx();
    }

    public boolean b(net.minecraft.world.item.Item item) {
        return this.b((ItemStack itemStack) -> itemStack.a(item));
    }

    public boolean b(Predicate<ItemStack> predicate) {
        return predicate.test(this.fx()) || predicate.test(this.fy());
    }

    public ItemStack b(EnumHand hand) {
        if (hand == EnumHand.a) {
            return this.a(EnumItemSlot.a);
        }
        if (hand == EnumHand.b) {
            return this.a(EnumItemSlot.b);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
    }

    public void a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.a) {
            this.a(EnumItemSlot.a, stack);
        } else {
            if (hand != EnumHand.b) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
            }
            this.a(EnumItemSlot.b, stack);
        }
    }

    public boolean d(EnumItemSlot slot) {
        return !this.a(slot).f();
    }

    public boolean e(EnumItemSlot slot) {
        return true;
    }

    public ItemStack a(EnumItemSlot slot) {
        return this.cb.a(slot);
    }

    public void a(EnumItemSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    public void setItemSlot(EnumItemSlot slot, ItemStack stack, boolean silent) {
        this.onEquipItem(slot, this.cb.a(slot, stack), stack, silent);
    }

    public float fB() {
        int i2 = 0;
        int i1 = 0;
        for (EnumItemSlot equipmentSlot : EquipmentSlotGroup.i) {
            if (equipmentSlot.a() != EnumItemSlot.Function.b) continue;
            ItemStack itemBySlot = this.a(equipmentSlot);
            if (!itemBySlot.f()) {
                ++i1;
            }
            ++i2;
        }
        return i2 > 0 ? (float)i1 / (float)i2 : 0.0f;
    }

    @Override
    public void i(boolean sprinting) {
        super.i(sprinting);
        AttributeModifiable attribute = this.h(GenericAttributes.x);
        attribute.c(e.a());
        if (sprinting) {
            attribute.b(e);
        }
    }

    public float fC() {
        return 1.0f;
    }

    public float fD() {
        return this.e_() ? (this.as.i() - this.as.i()) * 0.2f + 1.5f : (this.as.i() - this.as.i()) * 0.2f + 1.0f;
    }

    protected boolean fE() {
        return this.fa();
    }

    @Override
    public void h(Entity entity) {
        if (!this.gr()) {
            super.h(entity);
        }
    }

    private void H(Entity vehicle) {
        Vec3D vec3;
        if (this.eh()) {
            vec3 = this.dI();
        } else if (!vehicle.eh() && !this.ao().a_(vehicle.dK()).a(TagsBlock.aX)) {
            vec3 = vehicle.b(this);
        } else {
            boolean flag;
            double max = Math.max(this.dR(), vehicle.dR());
            vec3 = new Vec3D(this.dP(), max, this.dV());
            boolean bl = flag = this.dF() <= 4.0f && this.dG() <= 4.0f;
            if (flag) {
                double d2 = (double)this.dG() / 2.0;
                Vec3D vec31 = vec3.b(0.0, d2, 0.0);
                VoxelShape voxelShape = VoxelShapes.a(AxisAlignedBB.a(vec31, this.dF(), this.dG(), this.dF()));
                vec3 = this.ao().a((Entity)this, voxelShape, vec31, (double)this.dF(), (double)this.dG(), (double)this.dF()).map(vec32 -> vec32.b(0.0, -d2, 0.0)).orElse(vec3);
            }
        }
        this.l(vec3.g, vec3.h, vec3.i);
    }

    @Override
    public boolean de() {
        return this.dd();
    }

    protected float fF() {
        return this.A(1.0f);
    }

    protected float A(float multiplier) {
        return (float)this.i(GenericAttributes.q) * multiplier * this.bh() + this.fG();
    }

    public float fG() {
        return this.d(MobEffects.h) ? 0.1f * ((float)this.e(MobEffects.h).e() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void u() {
        float jumpPower = this.fF();
        if (!(jumpPower <= 1.0E-5f)) {
            Vec3D deltaMovement = this.dN();
            long time = System.nanoTime();
            boolean canCrit = true;
            if (this instanceof EntityHuman) {
                canCrit = false;
                if (time - this.lastJumpTime > 250000000L) {
                    this.lastJumpTime = time;
                    canCrit = true;
                }
            }
            this.m(deltaMovement.g, Math.max((double)jumpPower, deltaMovement.h), deltaMovement.i);
            if (this.cA()) {
                float f2 = this.ec() * ((float)Math.PI / 180);
                if (canCrit) {
                    this.l(new Vec3D((double)(-MathHelper.a((double)f2)) * 0.2, 0.0, (double)MathHelper.b((double)f2) * 0.2));
                }
            }
            this.aF = true;
        }
    }

    protected void fH() {
        this.k(this.dN().b(0.0, -0.04f, 0.0));
    }

    protected void c(TagKey<FluidType> fluidTag) {
        this.k(this.dN().b(0.0, 0.04f, 0.0));
    }

    protected float fI() {
        return 0.8f;
    }

    public boolean a(Fluid fluidState) {
        return false;
    }

    @Override
    protected double bs() {
        return this.i(GenericAttributes.p);
    }

    protected double fJ() {
        boolean flag = this.dN().h <= 0.0;
        return flag && this.d(MobEffects.B) ? Math.min(this.bt(), 0.01) : this.bt();
    }

    public void m(Vec3D travelVector) {
        if (this.b(this.ao().b_(this.dK()))) {
            this.o(travelVector);
        } else if (this.gj()) {
            this.p(travelVector);
        } else {
            this.a(travelVector);
        }
    }

    protected boolean b(Fluid fluidState) {
        return (this.by() || this.bN()) && this.eG() && !this.a(fluidState);
    }

    protected void a(Vec3D relative, float amount) {
        this.a(relative, 0.02f, 0.02f, amount);
    }

    protected void a(Vec3D relative, float inWaterAmount, float inLavaAmount, float amount) {
        if (this.by()) {
            this.a(inWaterAmount, relative);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c((double)0.8f));
        } else if (this.bN()) {
            this.a(inLavaAmount, relative);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c(0.5));
        } else {
            this.a(amount, relative);
            this.a(EnumMoveType.a, this.dN());
            this.k(this.dN().c((double)0.91f));
        }
    }

    private void a(Vec3D travelVector) {
        BlockPosition blockPosBelowThatAffectsMyMovement = this.bf();
        float f2 = this.aV() ? this.ao().a_(blockPosBelowThatAffectsMyMovement).b().g() : 1.0f;
        float f1 = f2 * 0.91f;
        Vec3D vec3 = this.b(travelVector, f2);
        double d2 = vec3.h;
        MobEffect effect = this.e(MobEffects.y);
        d2 = effect != null ? (d2 += (0.05 * (double)(effect.e() + 1) - vec3.h) * 0.2) : (!this.ao().B_() || this.ao().H(blockPosBelowThatAffectsMyMovement) ? (d2 -= this.fJ()) : (this.dR() > (double)this.ao().K_() ? -0.1 : 0.0));
        if (this.eQ()) {
            this.m(vec3.g, d2, vec3.i);
        } else {
            float f22 = this instanceof EntityBird ? f1 : 0.98f;
            this.m(vec3.g * (double)f1, d2 * (double)f22, vec3.i * (double)f1);
        }
    }

    private void o(Vec3D travelVector) {
        boolean flag = this.dN().h <= 0.0;
        double y2 = this.dR();
        double effectiveGravity = this.fJ();
        if (this.by()) {
            this.a(travelVector, effectiveGravity, flag, y2);
            this.J();
        } else {
            this.b(travelVector, effectiveGravity, flag, y2);
        }
    }

    protected void a(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        float f2 = this.cA() ? 0.9f : this.fI();
        float f1 = 0.02f;
        float f22 = (float)this.i(GenericAttributes.H);
        if (!this.aV()) {
            f22 *= 0.5f;
        }
        if (f22 > 0.0f) {
            f2 += (0.54600006f - f2) * f22;
            f1 += (this.fM() - f1) * f22;
        }
        if (this.d(MobEffects.D)) {
            f2 = 0.96f;
        }
        this.a(f1, travelVector);
        this.a(EnumMoveType.a, this.dN());
        Vec3D deltaMovement = this.dN();
        if (this.ad && this.fl()) {
            deltaMovement = new Vec3D(deltaMovement.g, 0.2, deltaMovement.i);
        }
        deltaMovement = deltaMovement.d(f2, 0.8f, f2);
        this.k(this.a(gravity, isFalling, deltaMovement));
        this.j(previousY);
    }

    private void b(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        this.a(0.02f, travelVector);
        this.a(EnumMoveType.a, this.dN());
        if (this.b(TagsFluid.b) <= this.dE()) {
            this.k(this.dN().d(0.5, 0.8f, 0.5));
            Vec3D fluidFallingAdjustedMovement = this.a(gravity, isFalling, this.dN());
            this.k(fluidFallingAdjustedMovement);
        } else {
            this.k(this.dN().c(0.5));
        }
        if (gravity != 0.0) {
            this.k(this.dN().b(0.0, -gravity / 4.0, 0.0));
        }
        this.j(previousY);
    }

    private void j(double previousY) {
        Vec3D deltaMovement = this.dN();
        if (this.ad && this.f(deltaMovement.g, deltaMovement.h + (double)0.6f - this.dR() + previousY, deltaMovement.i)) {
            this.m(deltaMovement.g, 0.3f, deltaMovement.i);
        }
    }

    private void J() {
        boolean isCanFloatWhileRidden = this.ay().a(TagsEntity.T);
        if (isCanFloatWhileRidden && this.cr() && this.b(TagsFluid.a) > this.dE()) {
            this.k(this.dN().b(0.0, 0.04f, 0.0));
        }
    }

    private void p(Vec3D travelVector) {
        if (this.fl()) {
            this.a(travelVector);
            this.fK();
        } else {
            Vec3D deltaMovement = this.dN();
            double d2 = deltaMovement.i();
            this.k(this.q(deltaMovement));
            this.a(EnumMoveType.a, this.dN());
            if (!this.ao().B_()) {
                double d1 = this.dN().i();
                this.c(d2, d1);
            }
        }
    }

    public void fK() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    private Vec3D q(Vec3D deltaMovement) {
        double d1;
        Vec3D lookAngle = this.cj();
        float f2 = this.ee() * ((float)Math.PI / 180);
        double squareRoot = Math.sqrt(lookAngle.g * lookAngle.g + lookAngle.i * lookAngle.i);
        double d2 = deltaMovement.i();
        double effectiveGravity = this.fJ();
        double squared = MathHelper.n(Math.cos(f2));
        deltaMovement = deltaMovement.b(0.0, effectiveGravity * (-1.0 + squared * 0.75), 0.0);
        if (deltaMovement.h < 0.0 && squareRoot > 0.0) {
            d1 = deltaMovement.h * -0.1 * squared;
            deltaMovement = deltaMovement.b(lookAngle.g * d1 / squareRoot, d1, lookAngle.i * d1 / squareRoot);
        }
        if (f2 < 0.0f && squareRoot > 0.0) {
            d1 = d2 * (double)(-MathHelper.a((double)f2)) * 0.04;
            deltaMovement = deltaMovement.b(-lookAngle.g * d1 / squareRoot, d1 * 3.2, -lookAngle.i * d1 / squareRoot);
        }
        if (squareRoot > 0.0) {
            deltaMovement = deltaMovement.b((lookAngle.g / squareRoot * d2 - deltaMovement.g) * 0.1, 0.0, (lookAngle.i / squareRoot * d2 - deltaMovement.i) * 0.1);
        }
        return deltaMovement.d(0.99f, 0.98f, 0.99f);
    }

    private void c(double oldSpeed, double newSpeed) {
        double d2;
        float f2;
        if (this.ad && (f2 = (float)((d2 = oldSpeed - newSpeed) * 10.0 - 3.0)) > 0.0f) {
            this.a(this.q((int)f2), 1.0f, 1.0f);
            this.a(this.en().n(), f2);
        }
    }

    private void c(EntityHuman player, Vec3D travelVector) {
        Vec3D riddenInput = this.b(player, travelVector);
        this.a(player, riddenInput);
        if (this.dx()) {
            this.C(this.f(player));
            this.m(riddenInput);
        } else {
            this.k(Vec3D.c);
        }
    }

    protected void a(EntityHuman player, Vec3D travelVector) {
    }

    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return travelVector;
    }

    protected float f(EntityHuman player) {
        return this.fM();
    }

    public void s(boolean includeHeight) {
        float f2 = (float)MathHelper.g(this.dP() - this.Y, includeHeight ? this.dR() - this.Z : 0.0, this.dV() - this.aa);
        if (!this.cq() && this.cb()) {
            this.B(f2);
        } else {
            this.bB.a();
        }
    }

    protected void B(float partialTick) {
        float min = Math.min(partialTick * 4.0f, 1.0f);
        this.bB.a(min, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    private Vec3D b(Vec3D deltaMovement, float friction) {
        this.a(this.I(friction), deltaMovement);
        this.k(this.r(this.dN()));
        this.a(EnumMoveType.a, this.dN());
        Vec3D deltaMovement1 = this.dN();
        if ((this.ad || this.bM) && (this.fl() || this.aK && PowderSnowBlock.a(this))) {
            deltaMovement1 = new Vec3D(deltaMovement1.g, 0.2, deltaMovement1.i);
        }
        return deltaMovement1;
    }

    public Vec3D a(double gravity, boolean isFalling, Vec3D deltaMovement) {
        if (gravity != 0.0 && !this.cA()) {
            double d2 = isFalling && Math.abs(deltaMovement.h - 0.005) >= 0.003 && Math.abs(deltaMovement.h - gravity / 16.0) < 0.003 ? -0.003 : deltaMovement.h - gravity / 16.0;
            return new Vec3D(deltaMovement.g, d2, deltaMovement.i);
        }
        return deltaMovement;
    }

    private Vec3D r(Vec3D deltaMovement) {
        if (this.fl()) {
            this.l();
            float f2 = 0.15f;
            double d2 = MathHelper.a(deltaMovement.g, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.a(deltaMovement.i, (double)-0.15f, (double)0.15f);
            double max = Math.max(deltaMovement.h, (double)-0.15f);
            if (max < 0.0 && !this.dL().a(Blocks.oP) && this.gi() && this instanceof EntityHuman) {
                max = 0.0;
            }
            deltaMovement = new Vec3D(d2, max, d1);
        }
        return deltaMovement;
    }

    private float I(float friction) {
        return this.aV() ? this.fM() * (0.21600002f / (friction * friction * friction)) : this.fL();
    }

    protected float fL() {
        return this.dl() instanceof EntityHuman ? this.fM() * 0.1f : 0.02f;
    }

    public float fM() {
        return this.cw;
    }

    public void C(float speed) {
        this.cw = speed;
    }

    public boolean c(WorldServer level, Entity target) {
        this.C(target);
        return false;
    }

    public void a(Entity target, float strength, Vec3D currentMovement) {
        if (strength > 0.0f && target instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)target;
            livingEntity.knockback(strength, MathHelper.a((double)(this.ec() * ((float)Math.PI / 180))), -MathHelper.b((double)(this.ec() * ((float)Math.PI / 180))), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
            this.k(this.dN().d(0.6, 1.0, 0.6));
        }
    }

    protected void fN() {
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.bK;
    }

    @Override
    public void g() {
        super.g();
        this.N();
        this.P();
        if (!this.ao().B_()) {
            int stingerCount;
            int arrowCount = this.fs();
            if (arrowCount > 0) {
                if (this.bs <= 0) {
                    this.bs = 20 * (30 - arrowCount);
                }
                --this.bs;
                if (this.bs <= 0) {
                    this.o(arrowCount - 1);
                }
            }
            if ((stingerCount = this.ft()) > 0) {
                if (this.bt <= 0) {
                    this.bt = 20 * (30 - stingerCount);
                }
                --this.bt;
                if (this.bt <= 0) {
                    this.p(stingerCount - 1);
                }
            }
            this.K();
            if (this.at % 20 == 0) {
                this.fo().c();
            }
            if (!(!this.gr() || this.av() && this.Q())) {
                this.gs();
            }
        }
        if (!this.eh()) {
            this.d_();
        }
        double d2 = this.dP() - this.Y;
        double d1 = this.dV() - this.aa;
        float f2 = (float)(d2 * d2 + d1 * d1);
        float f1 = this.bC;
        if (f2 > 0.0025000002f) {
            float f22 = (float)MathHelper.d(d1, d2) * 57.295776f - 90.0f;
            float abs = MathHelper.c(MathHelper.f(this.ec()) - f22);
            f1 = 95.0f < abs && abs < 265.0f ? f22 - 180.0f : f22;
        }
        if (this.by > 0.0f) {
            f1 = this.ec();
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("headTurn");
        this.D(f1);
        profilerFiller.c();
        profilerFiller.a("rangeChecks");
        this.ab += (float)Math.round((this.ec() - this.ab) / 360.0f) * 360.0f;
        this.bD += (float)Math.round((this.bC - this.bD) / 360.0f) * 360.0f;
        this.ac += (float)Math.round((this.ee() - this.ac) / 360.0f) * 360.0f;
        this.bF += (float)Math.round((this.bE - this.bF) / 360.0f) * 360.0f;
        profilerFiller.c();
        this.bV = this.gj() ? ++this.bV : 0;
        if (this.gr()) {
            this.w(0.0f);
        }
        this.E();
        this.bG.a();
    }

    public boolean b(Entity entity, int contactCooldownTicks) {
        return this.bZ != null && this.bZ.containsKey((Object)entity) && this.ao().au() - this.bZ.getLong((Object)entity) < (long)contactCooldownTicks;
    }

    public void E(Entity entity) {
        if (this.bZ != null) {
            this.bZ.put((Object)entity, this.ao().au());
        }
    }

    public int c(Predicate<Entity> filter) {
        return this.bZ == null ? 0 : (int)this.bZ.keySet().stream().filter(filter).count();
    }

    public boolean a(EnumItemSlot slot, Entity target, float damageAmount, boolean damage, boolean knockback, boolean dismount) {
        net.minecraft.world.level.World world = this.ao();
        if (!(world instanceof WorldServer)) {
            return false;
        }
        WorldServer serverLevel = (WorldServer)world;
        ItemStack itemBySlot = this.a(slot);
        DamageSource damageSource = itemBySlot.a(this, () -> this.en().b(this));
        float f2 = EnchantmentManager.a(serverLevel, itemBySlot, target, damageSource, damageAmount);
        Vec3D deltaMovement = target.dN();
        boolean flag1 = damage && target.a(serverLevel, damageSource, f2);
        boolean flag = knockback | flag1;
        if (knockback) {
            this.a(target, 0.4f + this.b(target, damageSource), deltaMovement);
        }
        if (dismount && target.cq()) {
            flag = true;
            target.cf();
        }
        if (target instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)target;
            itemBySlot.a(livingEntity, this);
        }
        if (flag1) {
            EnchantmentManager.a(serverLevel, target, damageSource);
        }
        if (!flag) {
            return false;
        }
        this.C(target);
        this.fN();
        return true;
    }

    public void fO() {
    }

    public void K() {
        Map<EnumItemSlot, ItemStack> map = this.L();
        if (map != null) {
            this.a(map);
            if (!map.isEmpty()) {
                this.b(map);
            }
        }
    }

    private @Nullable Map<EnumItemSlot, ItemStack> L() {
        ItemStack itemBySlot;
        Map map = null;
        EnumMap equipmentChanges = null;
        for (EnumItemSlot enumItemSlot : EnumItemSlot.j) {
            ItemStack itemStack = this.cp.get(enumItemSlot);
            if (!this.a(itemStack, itemBySlot = this.a(enumItemSlot))) continue;
            org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemStack);
            org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemBySlot);
            if (this instanceof EntityPlayer && enumItemSlot.a() == EnumItemSlot.Function.b) {
                new PlayerArmorChangeEvent((Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)enumItemSlot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EnumItemSlot.class);
                equipmentChanges = Maps.newEnumMap(EquipmentSlot.class);
            }
            map.put(enumItemSlot, itemBySlot);
            record EquipmentChangeImpl(org.bukkit.inventory.ItemStack oldItem, org.bukkit.inventory.ItemStack newItem) implements EntityEquipmentChangedEvent.EquipmentChange
            {
                private final org.bukkit.inventory.ItemStack oldItem;
                private final org.bukkit.inventory.ItemStack newItem;

                public org.bukkit.inventory.ItemStack oldItem() {
                    return this.oldItem.clone();
                }

                public org.bukkit.inventory.ItemStack newItem() {
                    return this.newItem.clone();
                }
            }
            equipmentChanges.put(CraftEquipmentSlot.getSlot(enumItemSlot), new EquipmentChangeImpl(oldItem, newItem));
            AttributeMapBase attributes = this.fw();
            if (itemStack.f()) continue;
            this.a(itemStack, enumItemSlot, attributes);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EnumItemSlot equipmentSlot1 = (EnumItemSlot)entry.getKey();
                itemBySlot = (ItemStack)entry.getValue();
                if (itemBySlot.f() || itemBySlot.q()) continue;
                itemBySlot.a(equipmentSlot1, (Holder<AttributeBase> holder, AttributeModifier attributeModifier) -> {
                    AttributeModifiable instance = this.cm.a((Holder<AttributeBase>)holder);
                    if (instance != null) {
                        instance.c(attributeModifier.a());
                        instance.b((AttributeModifier)attributeModifier);
                    }
                });
                net.minecraft.world.level.World world = this.ao();
                if (!(world instanceof WorldServer)) continue;
                WorldServer serverLevel = (WorldServer)world;
                EnchantmentManager.a(serverLevel, itemBySlot, this, equipmentSlot1);
            }
            new EntityEquipmentChangedEvent((LivingEntity)this.getBukkitLivingEntity(), equipmentChanges).callEvent();
        }
        return map;
    }

    public boolean a(ItemStack oldItem, ItemStack newItem) {
        return !ItemStack.a(newItem, oldItem);
    }

    private void a(Map<EnumItemSlot, ItemStack> hands) {
        ItemStack itemStack = hands.get(EnumItemSlot.a);
        ItemStack itemStack1 = hands.get(EnumItemSlot.b);
        if (itemStack != null && itemStack1 != null && ItemStack.a(itemStack, this.cp.get(EnumItemSlot.b)) && ItemStack.a(itemStack1, this.cp.get(EnumItemSlot.a))) {
            ((WorldServer)this.ao()).p().b(this, new PacketPlayOutEntityStatus(this, 55));
            hands.remove(EnumItemSlot.a);
            hands.remove(EnumItemSlot.b);
            this.cp.put(EnumItemSlot.a, itemStack.v());
            this.cp.put(EnumItemSlot.b, itemStack1.v());
        }
    }

    private void b(Map<EnumItemSlot, ItemStack> equipment) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipment.size());
        equipment.forEach((equipmentSlot, itemStack) -> {
            ItemStack itemStack1 = itemStack.v();
            list.add(Pair.of((Object)equipmentSlot, (Object)itemStack1));
            this.cp.put((EnumItemSlot)equipmentSlot, itemStack1);
        });
        ((WorldServer)this.ao()).p().b(this, new PacketPlayOutEntityEquipment(this.aA(), list, true));
    }

    protected void D(float yBodyRot) {
        float f2 = MathHelper.f(yBodyRot - this.bC);
        this.bC += f2 * 0.3f;
        float f1 = MathHelper.f(this.ec() - this.bC);
        float maxHeadRotationRelativeToBody = this.fP();
        if (Math.abs(f1) > maxHeadRotationRelativeToBody) {
            this.bC += f1 - (float)MathHelper.m(f1) * maxHeadRotationRelativeToBody;
        }
    }

    protected float fP() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void d_() {
        if (this.cx > 0) {
            --this.cx;
        }
        if (this.ch()) {
            this.l_().e();
        } else if (!this.dx()) {
            this.k(this.dN().c(0.98));
        }
        if (this.bS > 0) {
            this.a(this.bS, this.bR);
            --this.bS;
        }
        this.cb.a((Entity)this);
        deltaMovement = this.dN();
        d = deltaMovement.g;
        d1 = deltaMovement.h;
        d2 = deltaMovement.i;
        if (this.ay().equals(EntityTypes.cb)) {
            if (deltaMovement.j() < 9.0E-6) {
                d = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(deltaMovement.g) < 0.003) {
                d = 0.0;
            }
            if (Math.abs(deltaMovement.i) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(deltaMovement.h) < 0.003) {
            d1 = 0.0;
        }
        this.m(d, d1, d2);
        profilerFiller = Profiler.a();
        profilerFiller.a("ai");
        this.fQ();
        if (this.fE()) {
            this.bM = false;
            this.bN = 0.0f;
            this.bP = 0.0f;
        } else if (this.dy() && !this.ao().B_()) {
            profilerFiller.a("newAi");
            this.fV();
            profilerFiller.c();
        }
        profilerFiller.c();
        profilerFiller.a("jump");
        if (this.bM && this.eG()) {
            fluidHeight = this.bN() != false ? this.b(TagsFluid.b) : this.b(TagsFluid.a);
            flag = this.by() != false && fluidHeight > 0.0;
            fluidJumpThreshold = this.dE();
            if (!flag || this.aV() && !(fluidHeight > fluidJumpThreshold)) {
                if (!this.bN() || this.aV() && !(fluidHeight > fluidJumpThreshold)) {
                    if ((this.aV() || flag && fluidHeight <= fluidJumpThreshold) && this.cx == 0) {
                        if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.u();
                            this.cx = 10;
                        } else {
                            this.t(false);
                        }
                    }
                } else {
                    this.c(TagsFluid.b);
                }
            } else {
                this.c(TagsFluid.a);
            }
        } else {
            this.cx = 0;
        }
        profilerFiller.c();
        profilerFiller.a("travel");
        if (this.gj()) {
            this.fT();
        }
        boundingBox = this.dj();
        vec3 = new Vec3D(this.bN, this.bO, this.bP);
        if (this.d(MobEffects.B) || this.d(MobEffects.y)) {
            this.l();
        }
        if (!((fluidJumpThreshold = this.dl()) instanceof EntityHuman)) ** GOTO lbl-1000
        player = (EntityHuman)fluidJumpThreshold;
        if (this.cb()) {
            this.c(player, vec3);
        } else if (this.dx() && this.dy()) {
            this.m(vec3);
        }
        if (!this.ao().B_() || this.dv()) {
            this.aW();
        }
        if (this.ao().B_()) {
            this.s(this instanceof EntityBird);
        }
        profilerFiller.c();
        fluidJumpThreshold = this.ao();
        if (fluidJumpThreshold instanceof WorldServer) {
            serverLevel = (WorldServer)fluidJumpThreshold;
            profilerFiller.a("freezing");
            if (!(this.aJ && this.ea() || this.freezeLocked)) {
                this.k(Math.max(0, this.cM() - 2));
            }
            this.eC();
            this.eD();
            if (this.at % 40 == 0 && this.cO() && this.ea()) {
                this.a(serverLevel, this.en().v(), 1.0f);
            }
            profilerFiller.c();
        }
        profilerFiller.a("push");
        if (this.bW > 0) {
            --this.bW;
            this.a(boundingBox, this.dj());
        }
        this.q();
        profilerFiller.c();
        if (((WorldServer)this.ao()).hasEntityMoveEvent && !(this instanceof EntityHuman) && (this.Y != this.dP() || this.Z != this.dR() || this.aa != this.dV() || this.ab != this.ec() || this.ac != this.ee())) {
            from = new Location((World)this.ao().getWorld(), this.Y, this.Z, this.aa, this.ab, this.ac);
            to = new Location((World)this.ao().getWorld(), this.dP(), this.dR(), this.dV(), this.ec(), this.ee());
            event = new EntityMoveEvent((LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.a(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.a(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if ((var12_14 = this.ao()) instanceof WorldServer) {
            serverLevel = (WorldServer)var12_14;
            if (this.fR() && this.bA()) {
                this.a(serverLevel, this.en().i(), 1.0f);
            }
        }
    }

    protected void fQ() {
        this.bN *= 0.98f;
        this.bP *= 0.98f;
    }

    public boolean fR() {
        return false;
    }

    public boolean fS() {
        return this.bM;
    }

    protected void fT() {
        this.cQ();
        if (!this.ao().B_()) {
            if (!this.fU()) {
                if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.b(7, false);
                }
                return;
            }
            int i2 = this.bV + 1;
            if (i2 % 10 == 0) {
                int i1 = i2 / 10;
                if (i1 % 2 == 0) {
                    List<EnumItemSlot> list = EnumItemSlot.j.stream().filter(equipmentSlot1 -> EntityLiving.b(this.a((EnumItemSlot)equipmentSlot1), equipmentSlot1)).toList();
                    EnumItemSlot equipmentSlot = SystemUtils.a(list, this.as);
                    this.a(equipmentSlot).a(1, this, equipmentSlot);
                }
                this.c(GameEvent.n);
            }
        }
    }

    protected boolean fU() {
        if (!(this.aV() || this.cq() || this.d(MobEffects.y))) {
            for (EnumItemSlot equipmentSlot : EnumItemSlot.j) {
                if (!EntityLiving.b(this.a(equipmentSlot), equipmentSlot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void fV() {
    }

    protected void q() {
        if (!this.bY()) {
            return;
        }
        ScoreboardTeam team = this.cI();
        if (team != null && ((ScoreboardTeamBase)team).m() == ScoreboardTeamBase.EnumTeamPush.b) {
            return;
        }
        int i2 = ((WorldServer)this.ao()).U().a(GameRules.A);
        if (i2 <= 0 && this.ao().paperConfig().collisions.maxEntityCollisions <= 0) {
            return;
        }
        List<Entity> pushableEntities = this.ao().k(this, this.dj());
        if (!pushableEntities.isEmpty()) {
            net.minecraft.world.level.World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (i2 > 0 && pushableEntities.size() > i2 - 1 && this.as.a(4) == 0) {
                    int i1 = 0;
                    for (Entity entity : pushableEntities) {
                        if (entity.cq()) continue;
                        ++i1;
                    }
                    if (i1 > i2 - 1) {
                        this.a(serverLevel, this.en().h(), 6.0f);
                    }
                }
            }
            this.numCollisions = Math.max(0, this.numCollisions - this.ao().paperConfig().collisions.maxEntityCollisions);
            for (Entity entity1 : pushableEntities) {
                if (this.numCollisions >= this.ao().paperConfig().collisions.maxEntityCollisions) break;
                ++entity1.numCollisions;
                ++this.numCollisions;
                this.F(entity1);
            }
        }
    }

    protected void a(AxisAlignedBB boundingBoxBeforeSpin, AxisAlignedBB boundingBoxAfterSpin) {
        AxisAlignedBB aabb = boundingBoxBeforeSpin.b(boundingBoxAfterSpin);
        List<Entity> entities = this.ao().a_(this, aabb);
        int skippedAttackedEntitiesCounter = 0;
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                EntityPlayer serverPlayer;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer && !(serverPlayer = (EntityPlayer)entityLiving).getBukkitEntity().canSee(entity.getBukkitEntity())) {
                    ++skippedAttackedEntitiesCounter;
                    continue;
                }
                if (!(entity instanceof EntityLiving)) continue;
                if (!new EntityAttemptSpinAttackEvent((LivingEntity)this.getBukkitLivingEntity(), (LivingEntity)((EntityLiving)entity).getBukkitLivingEntity()).callEvent()) {
                    ++skippedAttackedEntitiesCounter;
                    continue;
                }
                this.f((EntityLiving)entity);
                this.bW = 0;
                this.k(this.dN().c(-0.2));
                break;
            }
        }
        if (this.ad && skippedAttackedEntitiesCounter == entities.size()) {
            this.bW = 0;
        }
        if (!this.ao().B_() && this.bW <= 0) {
            this.c(4, false);
            this.bX = 0.0f;
            this.bY = null;
        }
    }

    protected void F(Entity entity) {
        entity.h(this);
    }

    protected void f(EntityLiving target) {
    }

    public boolean fW() {
        return (this.az.a(bk) & 4) != 0;
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity vehicle = this.dz();
        super.stopRiding(suppressCancellation);
        if (vehicle != null && vehicle != this.dz() && !this.ao().B_() && vehicle.valid) {
            this.H(vehicle);
        }
    }

    @Override
    public void t() {
        super.t();
        this.l();
    }

    @Override
    public InterpolationHandler l_() {
        return this.bQ;
    }

    @Override
    public void a(float yRot, int steps) {
        this.bR = yRot;
        this.bS = steps;
    }

    public void t(boolean jumping) {
        this.bM = jumping;
    }

    public void a(EntityItem itemEntity) {
        Entity owner = EntityReference.getEntity(itemEntity.n, this.ao()::getGlobalPlayerByUUID, Entity.class);
        if (owner instanceof EntityPlayer) {
            CriterionTriggers.S.a((EntityPlayer)owner, itemEntity.e(), this);
        }
    }

    public void a(Entity entity, int amount) {
        if (!entity.eh() && !this.ao().B_() && (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityExperienceOrb)) {
            ((WorldServer)this.ao()).p().a(entity, new PacketPlayOutCollect(entity.aA(), this.aA(), amount));
        }
    }

    public boolean G(Entity entity) {
        return this.a(entity, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity.dT());
    }

    public boolean a(Entity entity, RayTrace.BlockCollisionOption block, RayTrace.FluidCollisionOption fluid, double y2) {
        if (entity.ao() != this.ao()) {
            return false;
        }
        Vec3D vec3 = new Vec3D(this.dP(), this.dT(), this.dV());
        Vec3D vec31 = new Vec3D(entity.dP(), y2, entity.dV());
        return !(vec31.g(vec3) > 16384.0) && this.ao().a(new RayTrace(vec3, vec31, block, fluid, this)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    @Override
    public float j(float partialTick) {
        return partialTick == 1.0f ? this.bE : MathHelper.i(partialTick, this.bF, this.bE);
    }

    public float E(float partialTick) {
        float f2 = this.by - this.bx;
        if (f2 < 0.0f) {
            f2 += 1.0f;
        }
        return this.bx + f2 * partialTick;
    }

    @Override
    public boolean bX() {
        return !this.eh() && this.collides;
    }

    @Override
    public boolean bY() {
        return this.isCollidable(this.ao().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.cb() && !this.au() && (ignoreClimbing || !this.fl()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.bY() && this.collides != this.collidableExemptions.contains(entity.cY());
    }

    @Override
    public float cS() {
        return this.bE;
    }

    @Override
    public void r(float rotation) {
        this.bE = rotation;
    }

    @Override
    public void s(float offset) {
        this.bC = offset;
    }

    @Override
    public Vec3D a(EnumDirection.EnumAxis axis, BlockUtil.Rectangle portal) {
        return EntityLiving.n(super.a(axis, portal));
    }

    public static Vec3D n(Vec3D relativePortalPosition) {
        return new Vec3D(relativePortalPosition.g, relativePortalPosition.h, 0.0);
    }

    public float fX() {
        return this.cy;
    }

    public final void F(float absorptionAmount) {
        this.G(!Float.isNaN(absorptionAmount) ? MathHelper.a(absorptionAmount, 0.0f, this.fr()) : 0.0f);
    }

    protected void G(float absorptionAmount) {
        this.cy = absorptionAmount;
    }

    public void g_() {
    }

    public void P_() {
    }

    protected void fY() {
        this.cr = true;
    }

    public abstract EnumMainHand at();

    public boolean fZ() {
        return (this.az.a(bk) & 1) > 0;
    }

    public EnumHand ga() {
        return (this.az.a(bk) & 2) > 0 ? EnumHand.b : EnumHand.a;
    }

    public void resyncUsingItem(EntityPlayer serverPlayer) {
        this.resendPossiblyDesyncedDataValues(List.of(bk), serverPlayer);
    }

    private void N() {
        if (this.fZ()) {
            if (ItemStack.b(this.b(this.ga()), this.bT)) {
                this.bT = this.b(this.ga());
                this.a_(this.bT);
            } else {
                this.gf();
            }
        }
    }

    private @Nullable EntityItem b(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        if (stack.f()) {
            return null;
        }
        double d2 = this.dT() - (double)0.3f;
        EntityItem itemEntity = new EntityItem(this.ao(), this.dP(), d2, this.dV(), stack);
        itemEntity.a(40);
        if (includeThrower) {
            itemEntity.b((Entity)this);
        }
        if (randomizeMotion) {
            float f2 = this.as.i() * 0.5f;
            float f1 = this.as.i() * ((float)Math.PI * 2);
            itemEntity.m(-MathHelper.a((double)f1) * f2, 0.2f, MathHelper.b((double)f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a((double)(this.ee() * ((float)Math.PI / 180)));
            float cos = MathHelper.b((double)(this.ee() * ((float)Math.PI / 180)));
            float sin = MathHelper.a((double)(this.ec() * ((float)Math.PI / 180)));
            float cos1 = MathHelper.b((double)(this.ec() * ((float)Math.PI / 180)));
            float f2 = this.as.i() * ((float)Math.PI * 2);
            float f32 = 0.02f * this.as.i();
            itemEntity.m((double)(-sin * cos * 0.3f) + Math.cos(f2) * (double)f32, -f1 * 0.3f + 0.1f + (this.as.i() - this.as.i()) * 0.1f, (double)(cos1 * cos * 0.3f) + Math.sin(f2) * (double)f32);
        }
        return itemEntity;
    }

    protected void a_(ItemStack usingItem) {
        boolean shouldLagCompensate;
        usingItem.b(this.ao(), this, this.gc());
        boolean bl = shouldLagCompensate = this.bT.c(DataComponents.y) && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (1L + (long)this.totalEatTimeTicks) * 50L * 1000000L;
        if (!(--this.bU != 0 && !shouldLagCompensate || this.ao().B_() || usingItem.x())) {
            this.bU = 0;
            this.Q_();
        }
    }

    private void P() {
        this.cF = this.cE;
        this.cE = this.cC() ? Math.min(1.0f, this.cE + 0.09f) : Math.max(0.0f, this.cE - 0.09f);
    }

    public void c(int key, boolean value) {
        int i2 = this.az.a(bk).byteValue();
        i2 = value ? (i2 |= key) : (i2 &= ~key);
        this.az.a(bk, (byte)i2);
    }

    public void c(EnumHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(EnumHand hand, boolean forceUpdate) {
        ItemStack itemInHand = this.b(hand);
        if (!itemInHand.f() && !this.fZ() || forceUpdate) {
            this.bT = itemInHand;
            this.bU = this.totalEatTimeTicks = itemInHand.a(this);
            this.eatStartTime = System.nanoTime();
            if (!this.ao().B_()) {
                this.c(1, true);
                this.c(2, hand == EnumHand.b);
                this.bT.a((Entity)this, GameEvent.D);
                if (this.bT.c(DataComponents.O)) {
                    this.bZ = new Object2LongOpenHashMap();
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        super.a(key);
        if (ci.equals(key)) {
            if (this.ao().B_()) {
                this.gp().ifPresent(this::a);
            }
        } else if (bk.equals(key) && this.ao().B_()) {
            if (this.fZ() && this.bT.f()) {
                this.bT = this.b(this.ga());
                if (!this.bT.f()) {
                    this.bU = this.bT.a(this);
                }
            } else if (!this.fZ() && !this.bT.f()) {
                this.bT = ItemStack.l;
                this.totalEatTimeTicks = 0;
                this.bU = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchor, Vec3D target) {
        super.a(anchor, target);
        this.bF = this.bE;
        this.bD = this.bC = this.bE;
    }

    @Override
    public float t(float partialTick) {
        return MathHelper.h(partialTick, this.bD, this.bC);
    }

    public void b(ItemStack stack, int amount) {
        for (int i2 = 0; i2 < amount; ++i2) {
            Vec3D vec3 = new Vec3D(((double)this.as.i() - 0.5) * 0.1, (double)this.as.i() * 0.1 + 0.1, 0.0);
            vec3 = vec3.a(-this.ee() * ((float)Math.PI / 180));
            vec3 = vec3.b(-this.ec() * ((float)Math.PI / 180));
            double d2 = (double)(-this.as.i()) * 0.6 - 0.3;
            Vec3D vec31 = new Vec3D(((double)this.as.i() - 0.5) * 0.3, d2, 0.6);
            vec31 = vec31.a(-this.ee() * ((float)Math.PI / 180));
            vec31 = vec31.b(-this.ec() * ((float)Math.PI / 180));
            vec31 = vec31.b(this.dP(), this.dT(), this.dV());
            this.ao().a(new ParticleParamItem(Particles.V, stack), vec31.g, vec31.h, vec31.i, vec3.g, vec3.h + 0.05, vec3.i);
        }
    }

    public void Q_() {
        if (!this.ao().B_() || this.fZ()) {
            EnumHand usedItemHand = this.ga();
            if (!this.bT.equals(this.b(usedItemHand))) {
                this.ge();
            } else if (!this.bT.f() && this.fZ()) {
                ItemStack itemStack;
                this.startUsingItem(this.ga(), true);
                PlayerItemConsumeEvent event = null;
                EntityLiving entityLiving = this;
                if (entityLiving instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.bT);
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(usedItemHand);
                    event = new PlayerItemConsumeEvent((Player)this.getBukkitEntity(), craftItem, hand);
                    this.ao().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.bT.a(DataComponents.z);
                        if (consumable != null) {
                            consumable.cancelUsingItem(serverPlayer, this.bT);
                        }
                        serverPlayer.cn.forceHeldSlot(usedItemHand);
                        serverPlayer.getBukkitEntity().updateScaledHealth();
                        this.gf();
                        return;
                    }
                    itemStack = craftItem.equals((Object)event.getItem()) ? this.bT.a(this.ao(), this) : CraftItemStack.asNMSCopy(event.getItem()).a(this.ao(), this);
                } else {
                    itemStack = this.bT.a(this.ao(), this);
                }
                ItemStack defaultReplacement = itemStack;
                if (event != null && event.getReplacement() != null) {
                    itemStack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemStack != this.bT) {
                    EntityLiving entityLiving2;
                    this.a(usedItemHand, itemStack);
                    if (event != null && event.getReplacement() != null && (entityLiving2 = this) instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)entityLiving2;
                        player.cn.forceHeldSlot(usedItemHand);
                    }
                }
                this.gf();
            }
        }
    }

    public void b(ItemStack stack) {
    }

    public ItemStack gb() {
        return this.bT;
    }

    public int gc() {
        return this.bU;
    }

    public int gd() {
        return this.fZ() ? this.bT.a(this) - this.gc() : 0;
    }

    public float H(float partialTick) {
        return !this.fZ() ? 0.0f : (float)this.gd() + partialTick;
    }

    public void ge() {
        ItemStack itemInHand = this.b(this.ga());
        if (!this.bT.f() && ItemStack.b(itemInHand, this.bT)) {
            this.bT = itemInHand;
            if (this instanceof EntityPlayer) {
                new PlayerStopUsingItemEvent((Player)this.getBukkitEntity(), this.bT.asBukkitMirror(), this.gd()).callEvent();
            }
            this.bT.a(this.ao(), this, this.gc());
            if (this.bT.x()) {
                this.N();
            }
        }
        this.gf();
    }

    public void gf() {
        if (!this.ao().B_()) {
            boolean isUsingItem = this.fZ();
            this.bZ = null;
            this.c(1, false);
            if (isUsingItem) {
                this.bT.a((Entity)this, GameEvent.C);
            }
        }
        this.bT = ItemStack.l;
        this.totalEatTimeTicks = 0;
        this.bU = 0;
        this.eatStartTime = -1L;
    }

    public boolean gg() {
        return this.gh() != null;
    }

    public @Nullable ItemStack gh() {
        int i2;
        if (!this.fZ()) {
            return null;
        }
        BlocksAttacks blocksAttacks = this.bT.a(DataComponents.M);
        if (blocksAttacks != null && (i2 = this.bT.h().a(this.bT, this) - this.bU) >= blocksAttacks.a()) {
            return this.bT;
        }
        return null;
    }

    @Override
    public float getBukkitYaw() {
        return this.cS();
    }

    public MovingObjectPosition getRayTrace(int maxDistance, RayTrace.FluidCollisionOption fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = new Vec3D(this.dP(), this.dR() + (double)this.dk(), this.dV());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3D end = new Vec3D(start.g + dir.getX(), start.h + dir.getY(), start.i + dir.getZ());
        RayTrace raytrace = new RayTrace(start, end, RayTrace.BlockCollisionOption.b, fluidCollisionOption, this);
        return this.ao().a(raytrace);
    }

    public @Nullable MovingObjectPositionEntity getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3D start = this.n(1.0f);
        Vec3D direction = this.cj();
        Vec3D end = start.b(direction.g * (double)maxDistance, direction.h * (double)maxDistance, direction.i * (double)maxDistance);
        List<Entity> entityList = this.ao().a((Entity)this, this.dj().b(direction.g * (double)maxDistance, direction.h * (double)maxDistance, direction.i * (double)maxDistance).c(1.0, 1.0, 1.0), IEntitySelector.f.and(Entity::bX));
        double distance = 0.0;
        MovingObjectPositionEntity result = null;
        for (Entity entity : entityList) {
            Vec3D rayTrace;
            double distanceTo;
            double inflationAmount = entity.ci();
            AxisAlignedBB aabb = entity.dj().c(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3D> rayTraceResult = aabb.b(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.g(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new MovingObjectPositionEntity(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public boolean gi() {
        return this.cu();
    }

    public boolean gj() {
        return this.i(7);
    }

    @Override
    public boolean cC() {
        return super.cC() || !this.gj() && this.d(EntityPose.b);
    }

    public int gk() {
        return this.bV;
    }

    public boolean b(double x2, double y2, double z2, boolean broadcastTeleport) {
        return this.randomTeleport(x2, y2, z2, broadcastTeleport, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double x2, double y2, double z2, boolean broadcastTeleport, PlayerTeleportEvent.TeleportCause cause) {
        EntityLiving entityLiving;
        double x1 = this.dP();
        double y1 = this.dR();
        double z1 = this.dV();
        double d2 = y2;
        boolean flag = false;
        BlockPosition blockPos = BlockPosition.a(x2, y2, z2);
        net.minecraft.world.level.World level = this.ao();
        if (level.H(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.v() > level.K_()) {
                BlockPosition blockPos1 = blockPos.e();
                IBlockData blockState = level.a_(blockPos1);
                if (blockState.d()) {
                    flag1 = true;
                    continue;
                }
                d2 -= 1.0;
                blockPos = blockPos1;
            }
            if (flag1) {
                this.a_(x2, d2, z2);
                if (level.g(this) && !level.d(this.dj())) {
                    flag = true;
                }
                this.a_(x1, y1, z1);
                if (flag) {
                    if (!(this instanceof EntityPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.ao().getWorld(), x1, y1, z1), new Location((World)this.ao().getWorld(), x2, d2, z2));
                        this.ao().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.b(to.getX(), to.getY(), to.getZ());
                    } else if (!((EntityPlayer)this).g.teleport(x2, d2, z2, this.ec(), this.ee(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag) {
            return Optional.of(false);
        }
        if (broadcastTeleport) {
            level.a((Entity)this, (byte)46);
        }
        if (!((entityLiving = this) instanceof EntityCreature)) return Optional.of(true);
        EntityCreature pathfinderMob = (EntityCreature)entityLiving;
        pathfinderMob.N().n();
        return Optional.of(true);
    }

    public boolean gl() {
        return !this.fa();
    }

    public boolean gm() {
        return true;
    }

    public void a(BlockPosition jukebox, boolean partyParrot) {
    }

    public boolean gn() {
        return false;
    }

    @Override
    public final EntitySize a(EntityPose pose) {
        return pose == EntityPose.c ? bl : this.b(pose).a(this.eF());
    }

    protected EntitySize b(EntityPose pose) {
        return this.ay().n().a(this.eE());
    }

    public ImmutableList<EntityPose> go() {
        return ImmutableList.of((Object)EntityPose.a);
    }

    public AxisAlignedBB f(EntityPose pose) {
        EntitySize dimensions = this.a(pose);
        return new AxisAlignedBB(-dimensions.a() / 2.0f, 0.0, -dimensions.a() / 2.0f, dimensions.a() / 2.0f, dimensions.b(), dimensions.a() / 2.0f);
    }

    protected boolean g(EntityPose pose) {
        AxisAlignedBB aabb = this.a(pose).a(this.dI());
        return this.ao().b(this, aabb);
    }

    @Override
    public boolean o(boolean allowPassengers) {
        return super.o(allowPassengers) && !this.gr();
    }

    public Optional<BlockPosition> gp() {
        return this.az.a(ci);
    }

    public void g(BlockPosition pos) {
        this.az.a(ci, Optional.of(pos));
    }

    public void gq() {
        this.az.a(ci, Optional.empty());
    }

    public boolean gr() {
        return this.gp().isPresent();
    }

    public void b(BlockPosition pos) {
        IBlockData blockState;
        if (this.cq()) {
            this.cf();
        }
        if ((blockState = this.ao().a_(pos)).b() instanceof BlockBed) {
            this.ao().a(pos, (IBlockData)blockState.b(BlockBed.c, true), 3);
        }
        this.c(EntityPose.c);
        this.a(pos);
        this.g(pos);
        this.k(Vec3D.c);
        this.aF = true;
    }

    private void a(BlockPosition pos) {
        this.a_((double)pos.u() + 0.5, (double)pos.v() + 0.6875, (double)pos.w() + 0.5);
    }

    private boolean Q() {
        return this.gp().map(blockPos -> this.ao().a_((BlockPosition)blockPos).b() instanceof BlockBed).orElse(false);
    }

    public void gs() {
        this.gp().filter(this.ao()::H).ifPresent(blockPos -> {
            IBlockData blockState = this.ao().a_((BlockPosition)blockPos);
            if (blockState.b() instanceof BlockBed) {
                EnumDirection direction = blockState.c(BlockFacingHorizontal.f);
                this.ao().a((BlockPosition)blockPos, (IBlockData)blockState.b(BlockBed.c, false), 3);
                Vec3D vec31 = BlockBed.a(this.ay(), (ICollisionAccess)this.ao(), blockPos, direction, this.ec()).orElseGet(() -> {
                    BlockPosition blockPos1 = blockPos.d();
                    return new Vec3D((double)blockPos1.u() + 0.5, (double)blockPos1.v() + 0.1, (double)blockPos1.w() + 0.5);
                });
                Vec3D vec32 = Vec3D.c(blockPos).d(vec31).d();
                float f2 = (float)MathHelper.g(MathHelper.d(vec32.i, vec32.g) * 180.0 / 3.1415927410125732 - 90.0);
                this.a_(vec31.g, vec31.h, vec31.i);
                this.v(f2);
                this.w(0.0f);
            }
        });
        Vec3D vec3 = this.dI();
        this.c(EntityPose.a);
        this.a_(vec3.g, vec3.h, vec3.i);
        this.gq();
    }

    public @Nullable EnumDirection gt() {
        BlockPosition blockPos = this.gp().orElse(null);
        return blockPos != null ? BlockBed.a(this.ao(), blockPos) : null;
    }

    @Override
    public boolean cc() {
        return !this.gr() && super.cc();
    }

    public ItemStack d(ItemStack weaponStack) {
        return ItemStack.l;
    }

    public static byte g(EnumItemSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EnumItemSlot.a -> 47;
            case EnumItemSlot.b -> 48;
            case EnumItemSlot.f -> 49;
            case EnumItemSlot.e -> 50;
            case EnumItemSlot.c -> 52;
            case EnumItemSlot.d -> 51;
            case EnumItemSlot.g -> 65;
            case EnumItemSlot.h -> 68;
        };
    }

    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        this.ao().a((Entity)this, EntityLiving.g(slot));
        this.a(this.a(slot), slot, this.cm);
    }

    private void a(ItemStack stack, EnumItemSlot slot, AttributeMapBase attributeMap) {
        stack.a(slot, (Holder<AttributeBase> holder, AttributeModifier attributeModifier) -> {
            AttributeModifiable instance = attributeMap.a((Holder<AttributeBase>)holder);
            if (instance != null) {
                instance.e((AttributeModifier)attributeModifier);
            }
        });
        EnchantmentManager.a(stack, this, slot);
    }

    public final boolean e(ItemStack stack) {
        if (this.cb() && !this.au()) {
            Equippable equippable = stack.a(DataComponents.H);
            if (equippable != null && equippable.g()) {
                EnumItemSlot equipmentSlot = equippable.b();
                return this.e(equipmentSlot) && equippable.a(this.ay()) && this.a(equipmentSlot).f() && this.f(equipmentSlot);
            }
            return false;
        }
        return false;
    }

    protected boolean f(EnumItemSlot slot) {
        return true;
    }

    public final EnumItemSlot f(ItemStack stack) {
        Equippable equippable = stack.a(DataComponents.H);
        return equippable != null && this.e(equippable.b()) ? equippable.b() : EnumItemSlot.a;
    }

    public final boolean a(ItemStack stack, EnumItemSlot slot) {
        Equippable equippable = stack.a(DataComponents.H);
        return equippable == null ? slot == EnumItemSlot.a && this.e(EnumItemSlot.a) : slot == equippable.b() && this.e(equippable.b()) && equippable.a(this.ay());
    }

    private static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return slot != EnumItemSlot.f && slot != EnumItemSlot.a && slot != EnumItemSlot.b ? SlotAccess.a(entity, slot, (ItemStack itemStack) -> itemStack.f() || entity.f((ItemStack)itemStack) == slot) : SlotAccess.a(entity, slot);
    }

    private static @Nullable EnumItemSlot r(int index) {
        if (index == 100 + EnumItemSlot.f.b()) {
            return EnumItemSlot.f;
        }
        if (index == 100 + EnumItemSlot.e.b()) {
            return EnumItemSlot.e;
        }
        if (index == 100 + EnumItemSlot.d.b()) {
            return EnumItemSlot.d;
        }
        if (index == 100 + EnumItemSlot.c.b()) {
            return EnumItemSlot.c;
        }
        if (index == 98) {
            return EnumItemSlot.a;
        }
        if (index == 99) {
            return EnumItemSlot.b;
        }
        if (index == 105) {
            return EnumItemSlot.g;
        }
        return index == 106 ? EnumItemSlot.h : null;
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        EnumItemSlot equipmentSlot = EntityLiving.r(slot);
        return equipmentSlot != null ? EntityLiving.a(this, equipmentSlot) : super.a_(slot);
    }

    @Override
    public boolean ea() {
        if (this.au()) {
            return false;
        }
        for (EnumItemSlot equipmentSlot : EquipmentSlotGroup.i) {
            if (!this.a(equipmentSlot).a(TagsItem.bM)) continue;
            return false;
        }
        return super.ea();
    }

    @Override
    public boolean cF() {
        return !this.ao().B_() && this.d(MobEffects.x) || super.cF();
    }

    @Override
    public float ed() {
        return this.bC;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        double x2 = packet.g();
        double y2 = packet.h();
        double z2 = packet.i();
        float yRot = packet.l();
        float xRot = packet.k();
        this.e(x2, y2, z2);
        this.bC = packet.m();
        this.bE = packet.m();
        this.bD = this.bC;
        this.bF = this.bE;
        this.e(packet.b());
        this.a(packet.e());
        this.a(x2, y2, z2, yRot, xRot);
        this.k(packet.j());
    }

    public float gu() {
        ItemStack weaponItem = this.eq();
        Weapon weapon = weaponItem.a(DataComponents.E);
        return weapon != null && weaponItem == this.fA() ? weapon.b() : 0.0f;
    }

    @Override
    public float eg() {
        float f2 = (float)this.i(GenericAttributes.D);
        return this.dl() instanceof EntityHuman ? Math.max(f2, 1.0f) : f2;
    }

    @Override
    public Vec3D n(Entity entity) {
        return this.dI().e(this.a(entity, this.a(this.aF()), this.eF() * this.eE()));
    }

    protected void a(int steps, double yRot) {
        this.bE = (float)MathHelper.e(1.0 / (double)steps, (double)this.bE, yRot);
    }

    @Override
    public void g(int ticks) {
        super.g(MathHelper.e((double)ticks * this.i(GenericAttributes.i)));
    }

    public boolean gv() {
        return false;
    }

    public boolean a(WorldServer level, DamageSource damageSource) {
        return this.d(damageSource) || EnchantmentManager.a(level, this, damageSource);
    }

    public static boolean b(ItemStack stack, EnumItemSlot slot) {
        if (!stack.c(DataComponents.J)) {
            return false;
        }
        Equippable equippable = stack.a(DataComponents.H);
        return equippable != null && slot == equippable.b() && !stack.r();
    }

    @VisibleForTesting
    public int gw() {
        return this.bI;
    }

    @Override
    public boolean gx() {
        return this.i(GenericAttributes.I) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.c> f(EntityPlayer player) {
        if (this.ay || player == this) {
            return Optional.empty();
        }
        if (WaypointTransmitter.a(this, player)) {
            return Optional.empty();
        }
        Waypoint.a icon = this.cI.a(this);
        if (WaypointTransmitter.b(this, player)) {
            return Optional.of(new WaypointTransmitter.d(this, icon, player));
        }
        return !WaypointTransmitter.a(this.dM(), player) ? Optional.of(new WaypointTransmitter.f(this, icon, player)) : Optional.of(new WaypointTransmitter.e(this, icon, player));
    }

    @Override
    public Waypoint.a gy() {
        return this.cI;
    }

    private static class ProcessableEffect {
        private Holder<MobEffectList> type;
        private MobEffect effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffect effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffectList> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record a(SoundEffect a, SoundEffect b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "small;big", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "small;big", "a", "b"}, this, o2);
        }
    }
}

