/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.cow.EntityMushroomCow;
import net.minecraft.world.entity.animal.equine.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.feline.EntityOcelot;
import net.minecraft.world.entity.animal.fish.EntityTropicalFish;
import net.minecraft.world.entity.animal.fish.EntityWaterAnimal;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.animal.polarbear.EntityPolarBear;
import net.minecraft.world.entity.animal.rabbit.EntityRabbit;
import net.minecraft.world.entity.animal.squid.GlowSquid;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonStray;
import net.minecraft.world.entity.monster.zombie.EntityDrowned;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import org.jspecify.annotations.Nullable;

public class EntityPositionTypes {
    private static final Map<EntityTypes<?>, a> a = Maps.newHashMap();

    private static <T extends EntityInsentient> void a(EntityTypes<T> entityType, SpawnPlacementType spawnPlacementType, HeightMap.Type heightmapType, b<T> predicate) {
        a data = a.put(entityType, new a(heightmapType, spawnPlacementType, predicate));
        if (data != null) {
            throw new IllegalStateException("Duplicate registration for type " + String.valueOf(BuiltInRegistries.g.b(entityType)));
        }
    }

    public static SpawnPlacementType a(EntityTypes<?> entityType) {
        a data = a.get(entityType);
        return data == null ? SpawnPlacementTypes.a : data.b;
    }

    public static boolean a(EntityTypes<?> entityType, IWorldReader level, BlockPosition pos) {
        return EntityPositionTypes.a(entityType).isSpawnPositionOk(level, pos, entityType);
    }

    public static HeightMap.Type b(@Nullable EntityTypes<?> entityType) {
        a data = a.get(entityType);
        return data == null ? HeightMap.Type.f : data.a;
    }

    public static <T extends Entity> boolean a(EntityTypes<T> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        a data = a.get(entityType);
        return data == null || data.c.test(entityType, level, spawnReason, pos, random);
    }

    static {
        EntityPositionTypes.a(EntityTypes.j, SpawnPlacementTypes.b, HeightMap.Type.f, Axolotl::a);
        EntityPositionTypes.a(EntityTypes.D, SpawnPlacementTypes.b, HeightMap.Type.f, EntityWaterAnimal::c);
        EntityPositionTypes.a(EntityTypes.L, SpawnPlacementTypes.b, HeightMap.Type.f, AgeableWaterCreature::b);
        EntityPositionTypes.a(EntityTypes.O, SpawnPlacementTypes.b, HeightMap.Type.f, EntityDrowned::c);
        EntityPositionTypes.a(EntityTypes.an, SpawnPlacementTypes.b, HeightMap.Type.f, EntityGuardian::b);
        EntityPositionTypes.a(EntityTypes.bf, SpawnPlacementTypes.b, HeightMap.Type.f, EntityWaterAnimal::c);
        EntityPositionTypes.a(EntityTypes.bi, SpawnPlacementTypes.b, HeightMap.Type.f, EntityWaterAnimal::c);
        EntityPositionTypes.a(EntityTypes.bz, SpawnPlacementTypes.b, HeightMap.Type.f, AgeableWaterCreature::b);
        EntityPositionTypes.a(EntityTypes.bI, SpawnPlacementTypes.b, HeightMap.Type.f, EntityTropicalFish::b);
        EntityPositionTypes.a(EntityTypes.g, SpawnPlacementTypes.d, HeightMap.Type.f, Armadillo::c);
        EntityPositionTypes.a(EntityTypes.m, SpawnPlacementTypes.d, HeightMap.Type.f, EntityBat::b);
        EntityPositionTypes.a(EntityTypes.q, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::c);
        EntityPositionTypes.a(EntityTypes.s, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.t, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::c);
        EntityPositionTypes.a(EntityTypes.v, SpawnPlacementTypes.d, HeightMap.Type.f, Camel::c);
        EntityPositionTypes.a(EntityTypes.w, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.y, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.C, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.G, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.I, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.M, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.R, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.S, SpawnPlacementTypes.d, HeightMap.Type.f, EntityEndermite::b);
        EntityPositionTypes.a(EntityTypes.T, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.af, SpawnPlacementTypes.d, HeightMap.Type.f, Frog::c);
        EntityPositionTypes.a(EntityTypes.ah, SpawnPlacementTypes.d, HeightMap.Type.f, EntityGhast::b);
        EntityPositionTypes.a(EntityTypes.ai, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.aj, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.al, SpawnPlacementTypes.b, HeightMap.Type.f, GlowSquid::a);
        EntityPositionTypes.a(EntityTypes.am, SpawnPlacementTypes.d, HeightMap.Type.f, Goat::c);
        EntityPositionTypes.a(EntityTypes.aq, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.ar, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.au, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.aC, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.aE, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMagmaCube::b);
        EntityPositionTypes.a(EntityTypes.aK, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMushroomCow::c);
        EntityPositionTypes.a(EntityTypes.aL, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.aM, SpawnPlacementTypes.b, HeightMap.Type.f, AbstractNautilus::c);
        EntityPositionTypes.a(EntityTypes.aP, SpawnPlacementTypes.d, HeightMap.Type.e, EntityOcelot::c);
        EntityPositionTypes.a(EntityTypes.aW, SpawnPlacementTypes.d, HeightMap.Type.e, EntityParrot::c);
        EntityPositionTypes.a(EntityTypes.aY, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.ao, SpawnPlacementTypes.d, HeightMap.Type.f, EntityHoglin::c);
        EntityPositionTypes.a(EntityTypes.aZ, SpawnPlacementTypes.d, HeightMap.Type.f, EntityPiglin::b);
        EntityPositionTypes.a(EntityTypes.bb, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonsterPatrolling::b);
        EntityPositionTypes.a(EntityTypes.bc, SpawnPlacementTypes.d, HeightMap.Type.f, EntityPolarBear::c);
        EntityPositionTypes.a(EntityTypes.bg, SpawnPlacementTypes.d, HeightMap.Type.f, EntityRabbit::c);
        EntityPositionTypes.a(EntityTypes.bj, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.bm, SpawnPlacementTypes.d, HeightMap.Type.f, EntitySilverfish::b);
        EntityPositionTypes.a(EntityTypes.bn, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bo, SpawnPlacementTypes.d, HeightMap.Type.f, EntityHorseSkeleton::c);
        EntityPositionTypes.a(EntityTypes.bp, SpawnPlacementTypes.d, HeightMap.Type.f, EntitySlime::c);
        EntityPositionTypes.a(EntityTypes.bt, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bw, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bA, SpawnPlacementTypes.d, HeightMap.Type.f, EntitySkeletonStray::c);
        EntityPositionTypes.a(EntityTypes.aV, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::b);
        EntityPositionTypes.a(EntityTypes.bB, SpawnPlacementTypes.c, HeightMap.Type.f, EntityStrider::c);
        EntityPositionTypes.a(EntityTypes.bJ, SpawnPlacementTypes.d, HeightMap.Type.f, EntityTurtle::c);
        EntityPositionTypes.a(EntityTypes.bL, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bQ, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bR, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bS, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bU, SpawnPlacementTypes.d, HeightMap.Type.f, EntityWolf::c);
        EntityPositionTypes.a(EntityTypes.bV, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::c);
        EntityPositionTypes.a(EntityTypes.H, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bW, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bX, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.ca, SpawnPlacementTypes.d, HeightMap.Type.f, EntityPigZombie::b);
        EntityPositionTypes.a(EntityTypes.bZ, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.x, SpawnPlacementTypes.d, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.Q, SpawnPlacementTypes.b, HeightMap.Type.f, EntityGuardian::b);
        EntityPositionTypes.a(EntityTypes.W, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.ae, SpawnPlacementTypes.a, HeightMap.Type.f, EntityFox::c);
        EntityPositionTypes.a(EntityTypes.as, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.aU, SpawnPlacementTypes.a, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.aX, SpawnPlacementTypes.a, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bh, SpawnPlacementTypes.d, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bk, SpawnPlacementTypes.a, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bG, SpawnPlacementTypes.a, HeightMap.Type.f, EntityAnimal::b);
        EntityPositionTypes.a(EntityTypes.bK, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bM, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::a);
        EntityPositionTypes.a(EntityTypes.bN, SpawnPlacementTypes.d, HeightMap.Type.f, EntityInsentient::a);
        EntityPositionTypes.a(EntityTypes.bO, SpawnPlacementTypes.a, HeightMap.Type.f, EntityMonster::a);
    }

    record a(HeightMap.Type a, SpawnPlacementType b, b<?> c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "heightMap;placement;predicate", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "heightMap;placement;predicate", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "heightMap;placement;predicate", "a", "b", "c"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface b<T extends Entity> {
        public boolean test(EntityTypes<T> var1, WorldAccess var2, EntitySpawnReason var3, BlockPosition var4, RandomSource var5);
    }
}

