/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.jspecify.annotations.Nullable;

public interface Leashable {
    public static final String g = "leash";
    public static final double h = 12.0;
    public static final double i = 6.0;
    public static final double j = 16.0;
    public static final Vec3D k = new Vec3D(0.8, 0.2, 0.8);
    public static final float l = 0.7f;
    public static final double m = 10.0;
    public static final double n = 0.11;
    public static final List<Vec3D> o = ImmutableList.of((Object)new Vec3D(0.0, 0.5, 0.5));
    public static final List<Vec3D> p = ImmutableList.of((Object)new Vec3D(0.0, 0.5, 0.0));
    public static final List<Vec3D> q = ImmutableList.of((Object)new Vec3D(-0.5, 0.5, 0.5), (Object)new Vec3D(-0.5, 0.5, -0.5), (Object)new Vec3D(0.5, 0.5, -0.5), (Object)new Vec3D(0.5, 0.5, 0.5));

    public @Nullable a T_();

    public void a(@Nullable a var1);

    default public boolean S_() {
        return this.T_() != null && this.T_().b != null;
    }

    default public boolean ai_() {
        return this.T_() != null;
    }

    default public boolean b_(Entity entity) {
        return this != entity && !(this.b(entity) > this.w()) && this.aj_();
    }

    default public double b(Entity entity) {
        return entity.dj().f().f(((Entity)((Object)this)).dj().f());
    }

    default public boolean aj_() {
        return true;
    }

    default public void b_(int delayedLeashHolderId) {
        this.a(new a(delayedLeashHolderId));
        Leashable.a((Entity)((Object)this), false, false);
    }

    default public void b(ValueInput input) {
        a leashData = input.a(g, a.a).orElse(null);
        if (this.T_() != null && leashData == null) {
            this.r();
        }
        this.a(leashData);
    }

    default public void a(ValueOutput output, @Nullable a leashData) {
        if (leashData != null && leashData.b != null && leashData.b.pluginRemoved) {
            return;
        }
        output.b(g, a.a, leashData);
    }

    private static <E extends Entity> void b(E entity, a leashData) {
        World world;
        if (leashData.c != null && (world = entity.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            Optional<UUID> optional = leashData.c.left();
            Optional<BlockPosition> optional1 = leashData.c.right();
            if (optional.isPresent()) {
                Entity entity1 = serverLevel.d(optional.get());
                if (entity1 != null) {
                    Leashable.a(entity, entity1, true);
                    return;
                }
            } else if (optional1.isPresent()) {
                Leashable.a(entity, EntityLeash.b(serverLevel, optional1.get()), true);
                return;
            }
            if (entity.at > 100) {
                entity.forceDrops = true;
                entity.a(serverLevel, Items.wZ);
                entity.forceDrops = false;
                ((Leashable)((Object)entity)).a(null);
            }
        }
    }

    default public void o() {
        Leashable.a((Entity)((Object)this), true, true);
    }

    default public void r() {
        Leashable.a((Entity)((Object)this), true, false);
    }

    default public void s() {
    }

    private static <E extends Entity> void a(E entity, boolean broadcastPacket, boolean dropItem) {
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData != null && leashData.b != null) {
            ((Leashable)((Object)entity)).a(null);
            ((Leashable)((Object)entity)).s();
            World world = entity.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                if (dropItem) {
                    entity.forceDrops = true;
                    entity.a(serverLevel, Items.wZ);
                    entity.forceDrops = false;
                }
                if (broadcastPacket) {
                    serverLevel.p().b(entity, new PacketPlayOutAttachEntity(entity, null));
                }
                leashData.b.b((Leashable)((Object)entity));
            }
        }
    }

    public static <E extends Entity> void a_(WorldServer level, E entity) {
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData != null && leashData.c != null) {
            Leashable.b(entity, leashData);
        }
        if (leashData != null && leashData.b != null) {
            Entity leashHolder;
            if (!entity.av() || !leashData.b.av()) {
                EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), !entity.cb() ? EntityUnleashEvent.UnleashReason.PLAYER_UNLEASH : EntityUnleashEvent.UnleashReason.HOLDER_GONE, level.U().a(GameRules.k) != false && !entity.pluginRemoved);
                event.callEvent();
                if (event.isDropLeash()) {
                    ((Leashable)((Object)entity)).o();
                } else {
                    ((Leashable)((Object)entity)).r();
                }
            }
            if ((leashHolder = ((Leashable)((Object)entity)).C()) != null && leashHolder.ao() == entity.ao()) {
                double d2 = ((Leashable)((Object)entity)).b(leashHolder);
                ((Leashable)((Object)entity)).d(leashHolder);
                if (d2 > ((Leashable)((Object)entity)).leashSnapDistanceOrConfig()) {
                    ((Leashable)((Object)entity)).y();
                } else if (d2 > ((Leashable)((Object)entity)).x() - (double)leashHolder.dF() - (double)entity.dF() && ((Leashable)((Object)entity)).a(leashHolder, leashData)) {
                    ((Leashable)((Object)entity)).v();
                } else {
                    ((Leashable)((Object)entity)).e(leashHolder);
                }
                entity.v((float)((double)entity.ec() - leashData.d));
                leashData.d *= (double)Leashable.c(entity);
            }
        }
    }

    default public void v() {
        Entity entity = (Entity)((Object)this);
        entity.cQ();
    }

    default public double leashSnapDistanceOrConfig() {
        Leashable leashable = this;
        if (!(leashable instanceof Entity)) {
            return this.w();
        }
        Entity entity = (Entity)((Object)leashable);
        return entity.ao().paperConfig().misc.maxLeashDistance.or(this.w());
    }

    default public double w() {
        return 12.0;
    }

    default public double x() {
        return 6.0;
    }

    public static <E extends Entity> float c(E entity) {
        if (entity.aV()) {
            return entity.ao().a_(entity.bf()).b().g() * 0.91f;
        }
        return entity.bB() ? 0.8f : 0.91f;
    }

    default public void d(Entity entity) {
        entity.a(this);
    }

    default public void y() {
        boolean dropLeash = true;
        Leashable leashable = this;
        if (leashable instanceof Entity) {
            Entity entity = (Entity)((Object)leashable);
            EntityUnleashEvent event = new EntityUnleashEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), EntityUnleashEvent.UnleashReason.DISTANCE, true);
            if (!event.callEvent()) {
                return;
            }
            Entity leashHolder = this.C();
            World level = leashHolder.ao();
            dropLeash = event.isDropLeash();
            level.a(null, leashHolder.dP(), leashHolder.dR(), leashHolder.dV(), SoundEffects.qd, SoundCategory.g, 1.0f, 1.0f);
        }
        if (dropLeash) {
            this.o();
        } else {
            this.r();
        }
    }

    default public void e(Entity entity) {
    }

    default public boolean a(Entity entity, a leashData) {
        boolean flag = entity.dY() && this.z();
        List<b> list = Leashable.a((Entity)((Object)this), entity, flag ? q : o, flag ? q : p);
        if (list.isEmpty()) {
            return false;
        }
        b wrench = b.a(list).a(flag ? 0.25 : 1.0);
        leashData.d += 10.0 * wrench.b();
        Vec3D vec3 = Leashable.g(entity).d(((Entity)((Object)this)).ag());
        ((Entity)((Object)this)).l(wrench.a().h(k).e(vec3.c(0.11)));
        return true;
    }

    private static Vec3D g(Entity holder) {
        EntityInsentient mob;
        return holder instanceof EntityInsentient && (mob = (EntityInsentient)holder).gG() ? Vec3D.c : holder.ag();
    }

    private static <E extends Entity> List<b> a(E entity, Entity leashHolder, List<Vec3D> entityAttachmentPoint, List<Vec3D> leasherAttachmentPoint) {
        double d2 = ((Leashable)((Object)entity)).x();
        Vec3D holderMovement = Leashable.g(entity);
        float f2 = entity.ec() * ((float)Math.PI / 180);
        Vec3D vec3 = new Vec3D(entity.dF(), entity.dG(), entity.dF());
        float f1 = leashHolder.ec() * ((float)Math.PI / 180);
        Vec3D vec31 = new Vec3D(leashHolder.dF(), leashHolder.dG(), leashHolder.dF());
        ArrayList<b> list = new ArrayList<b>();
        for (int i2 = 0; i2 < entityAttachmentPoint.size(); ++i2) {
            Vec3D vec32 = entityAttachmentPoint.get(i2).h(vec3).b(-f2);
            Vec3D vec33 = entity.dI().e(vec32);
            Vec3D vec34 = leasherAttachmentPoint.get(i2).h(vec31).b(-f1);
            Vec3D vec35 = leashHolder.dI().e(vec34);
            Leashable.a(vec35, vec33, d2, holderMovement, vec32).ifPresent(list::add);
        }
        return list;
    }

    private static Optional<b> a(Vec3D entityAttachmentPoint, Vec3D leasherAttachmentPoint, double elasticDistance, Vec3D knownMovement, Vec3D relativeAttachmentPoint) {
        boolean flag;
        double d2 = leasherAttachmentPoint.f(entityAttachmentPoint);
        if (d2 < elasticDistance) {
            return Optional.empty();
        }
        Vec3D vec3 = entityAttachmentPoint.d(leasherAttachmentPoint).d().c(d2 - elasticDistance);
        double d1 = b.a(relativeAttachmentPoint, vec3);
        boolean bl = flag = knownMovement.b(vec3) >= 0.0;
        if (flag) {
            vec3 = vec3.c((double)0.3f);
        }
        return Optional.of(new b(vec3, d1));
    }

    default public boolean z() {
        return false;
    }

    default public Vec3D[] A() {
        return Leashable.a((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3D[] a(Entity entity, double zOffset, double z2, double x2, double y2) {
        float bbWidth = entity.dF();
        double d2 = zOffset * (double)bbWidth;
        double d1 = z2 * (double)bbWidth;
        double d22 = x2 * (double)bbWidth;
        double d3 = y2 * (double)entity.dG();
        return new Vec3D[]{new Vec3D(-d22, d3, d1 + d2), new Vec3D(-d22, d3, -d1 + d2), new Vec3D(d22, d3, -d1 + d2), new Vec3D(d22, d3, d1 + d2)};
    }

    default public Vec3D a_(float partialTick) {
        return this.B();
    }

    default public Vec3D B() {
        Entity entity = (Entity)((Object)this);
        return new Vec3D(0.0, entity.dk(), entity.dF() * 0.4f);
    }

    default public void a_(Entity leashHolder, boolean broadcastPacket) {
        if (this != leashHolder) {
            Leashable.a((Entity)((Object)this), leashHolder, broadcastPacket);
        }
    }

    private static <E extends Entity> void a(E entity, Entity leashHolder, boolean broadcastPacket) {
        World world;
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData == null) {
            leashData = new a(leashHolder);
            ((Leashable)((Object)entity)).a(leashData);
        } else {
            Entity entity1 = leashData.b;
            leashData.a(leashHolder);
            if (entity1 != null && entity1 != leashHolder) {
                entity1.b((Leashable)((Object)entity));
            }
        }
        if (broadcastPacket && (world = entity.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            serverLevel.p().b(entity, new PacketPlayOutAttachEntity(entity, leashHolder));
        }
        if (entity.cq()) {
            entity.cf();
        }
    }

    default public @Nullable Entity C() {
        return Leashable.h((Entity)((Object)this));
    }

    private static <E extends Entity> @Nullable Entity h(E entity) {
        Entity var3;
        a leashData = ((Leashable)((Object)entity)).T_();
        if (leashData == null) {
            return null;
        }
        if (leashData.e != 0 && entity.ao().B_() && (var3 = entity.ao().a(leashData.e)) instanceof Entity) {
            leashData.a(var3);
        }
        return leashData.b;
    }

    public static List<Leashable> c_(Entity entity) {
        return Leashable.a(entity, (Leashable leashable) -> leashable.C() == entity);
    }

    public static List<Leashable> a(Entity entity, Predicate<Leashable> predicate) {
        return Leashable.a(entity.ao(), entity.dj().f(), predicate);
    }

    public static List<Leashable> a(World level, Vec3D pos, Predicate<Leashable> predicate) {
        double d2 = 32.0;
        AxisAlignedBB aabb = AxisAlignedBB.a(pos, 32.0, 32.0, 32.0);
        return level.a(Entity.class, aabb, entity -> {
            Leashable leashable;
            return entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity));
        }).stream().map(Leashable.class::cast).toList();
    }

    public static final class a {
        public static final Codec<a> a = Codec.xor((Codec)UUIDUtil.a.fieldOf("UUID").codec(), BlockPosition.a).xmap(a::new, leashData -> {
            Entity patt0$temp = leashData.b;
            if (patt0$temp instanceof EntityLeash) {
                EntityLeash leashFenceKnotEntity = (EntityLeash)patt0$temp;
                return Either.right(leashFenceKnotEntity.i());
            }
            return leashData.b != null ? Either.left(leashData.b.cY()) : Objects.requireNonNull(leashData.c, "Invalid LeashData had no attachment");
        });
        int e;
        public @Nullable Entity b;
        public @Nullable Either<UUID, BlockPosition> c;
        public double d;

        private a(Either<UUID, BlockPosition> delayedLeashInfo) {
            this.c = delayedLeashInfo;
        }

        a(Entity leashHolder) {
            this.b = leashHolder;
        }

        a(int delayedLeashHolderId) {
            this.e = delayedLeashHolderId;
        }

        public void a(Entity leashHolder) {
            this.b = leashHolder;
            this.c = null;
            this.e = 0;
        }
    }

    public static final class b
    extends Record {
        private final Vec3D b;
        private final double c;
        static b a = new b(Vec3D.c, 0.0);

        public b(Vec3D force, double torque) {
            this.b = force;
            this.c = torque;
        }

        static double a(Vec3D attachmentPoint, Vec3D force) {
            return attachmentPoint.i * force.g - attachmentPoint.g * force.i;
        }

        static b a(List<b> wrenches) {
            if (wrenches.isEmpty()) {
                return a;
            }
            double d2 = 0.0;
            double d1 = 0.0;
            double d22 = 0.0;
            double d3 = 0.0;
            for (b wrench : wrenches) {
                Vec3D vec3 = wrench.b;
                d2 += vec3.g;
                d1 += vec3.h;
                d22 += vec3.i;
                d3 += wrench.c;
            }
            return new b(new Vec3D(d2, d1, d22), d3);
        }

        public b a(double scale) {
            return new b(this.b.c(scale), this.c * scale);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "force;torque", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "force;torque", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "force;torque", "b", "c"}, this, o2);
        }

        public Vec3D a() {
            return this.b;
        }

        public double b() {
            return this.c;
        }
    }
}

