/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;

public interface SlotAccess {
    public ItemStack a();

    public boolean a(ItemStack var1);

    public static SlotAccess a(final Supplier<ItemStack> getter, final Consumer<ItemStack> setter) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return (ItemStack)getter.get();
            }

            @Override
            public boolean a(ItemStack carried) {
                setter.accept(carried);
                return true;
            }
        };
    }

    public static SlotAccess a(final EntityLiving entity, final EnumItemSlot slot, final Predicate<ItemStack> stackFilter) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return entity.a(slot);
            }

            @Override
            public boolean a(ItemStack carried) {
                if (!stackFilter.test(carried)) {
                    return false;
                }
                entity.a(slot, carried);
                return true;
            }
        };
    }

    public static SlotAccess a(EntityLiving entity, EnumItemSlot slot) {
        return SlotAccess.a(entity, slot, stack -> true);
    }

    public static SlotAccess a(final List<ItemStack> items, final int slotIndex) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return (ItemStack)items.get(slotIndex);
            }

            @Override
            public boolean a(ItemStack carried) {
                items.set(slotIndex, carried);
                return true;
            }
        };
    }
}

