/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BehaviorController<E extends EntityLiving> {
    static final Logger a = LogUtils.getLogger();
    private final Supplier<Codec<BehaviorController<E>>> b;
    private static final int c = 20;
    private final Map<MemoryModuleType<?>, Optional<? extends ExpirableMemory<?>>> d = Maps.newHashMap();
    private final Map<SensorType<? extends Sensor<? super E>>, Sensor<? super E>> e = Maps.newLinkedHashMap();
    private final Map<Integer, Map<Activity, Set<BehaviorControl<? super E>>>> f = Maps.newTreeMap();
    private @Nullable EnvironmentAttribute<Activity> g;
    private final Map<Activity, Set<Pair<MemoryModuleType<?>, MemoryStatus>>> h = Maps.newHashMap();
    private final Map<Activity, Set<MemoryModuleType<?>>> i = Maps.newHashMap();
    private Set<Activity> j = Sets.newHashSet();
    private final Set<Activity> k = Sets.newHashSet();
    private Activity l = Activity.b;
    private long m = -9999L;

    public static <E extends EntityLiving> b<E> a(Collection<? extends MemoryModuleType<?>> memoryTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes) {
        return new b(memoryTypes, sensorTypes);
    }

    public static <E extends EntityLiving> Codec<BehaviorController<E>> b(final Collection<? extends MemoryModuleType<?>> memoryTypes, final Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes) {
        final MutableObject mutableObject = new MutableObject();
        mutableObject.setValue((Object)new MapCodec<BehaviorController<E>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return memoryTypes.stream().flatMap(memoryModuleType -> memoryModuleType.a().map(codec -> BuiltInRegistries.A.b((MemoryModuleType<?>)memoryModuleType)).stream()).map(identifier -> ops.createString(identifier.toString()));
            }

            public <T> DataResult<BehaviorController<E>> decode(DynamicOps<T> ops, MapLike<T> input) {
                MutableObject mutableObject1 = new MutableObject((Object)DataResult.success((Object)ImmutableList.builder()));
                input.entries().forEach(pair -> {
                    DataResult dataResult = BuiltInRegistries.A.q().parse(ops, pair.getFirst());
                    DataResult dataResult1 = dataResult.flatMap(memoryModuleType -> this.a((MemoryModuleType)memoryModuleType, ops, (Object)pair.getSecond()));
                    mutableObject1.setValue((Object)((DataResult)mutableObject1.get()).apply2(ImmutableList.Builder::add, dataResult1));
                });
                ImmutableList list = ((DataResult)mutableObject1.get()).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).map(ImmutableList.Builder::build).orElseGet(ImmutableList::of);
                return DataResult.success(new BehaviorController(memoryTypes, sensorTypes, (ImmutableList<a<?>>)list, mutableObject));
            }

            private <T, U> DataResult<a<U>> a(MemoryModuleType<U> memoryModuleType, DynamicOps<T> dynamicOps, T object) {
                return memoryModuleType.a().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No codec for memory: " + String.valueOf(memoryModuleType))).flatMap(codec -> codec.parse(dynamicOps, object)).map(expirableValue -> new a(memoryModuleType, Optional.of(expirableValue)));
            }

            public <T> RecordBuilder<T> a(BehaviorController<E> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                input.j().forEach(memoryValue -> memoryValue.a(ops, prefix));
                return prefix;
            }
        }.fieldOf("memories").codec());
        return (Codec)mutableObject.get();
    }

    public BehaviorController(Collection<? extends MemoryModuleType<?>> memoryModuleTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes, ImmutableList<a<?>> memoryValues, Supplier<Codec<BehaviorController<E>>> codec) {
        this.b = codec;
        for (MemoryModuleType<?> memoryModuleType : memoryModuleTypes) {
            this.d.put(memoryModuleType, Optional.empty());
        }
        for (SensorType sensorType : sensorTypes) {
            this.e.put(sensorType, (Sensor<E>)sensorType.a());
        }
        for (Sensor sensor : this.e.values()) {
            for (MemoryModuleType<?> memoryModuleType1 : sensor.a()) {
                this.d.put(memoryModuleType1, Optional.empty());
            }
        }
        for (a a2 : memoryValues) {
            a2.a(this);
        }
    }

    public <T> DataResult<T> a(DynamicOps<T> ops) {
        return this.b.get().encodeStart(ops, (Object)this);
    }

    Stream<a<?>> j() {
        return this.d.entrySet().stream().map(memory -> net.minecraft.world.entity.ai.BehaviorController$a.a((MemoryModuleType)memory.getKey(), (Optional)memory.getValue()));
    }

    public boolean a(MemoryModuleType<?> type) {
        return this.a(type, MemoryStatus.a);
    }

    public void a() {
        this.d.keySet().forEach(memoryModuleType -> this.d.put((MemoryModuleType<?>)memoryModuleType, Optional.empty()));
    }

    public <U> void b(MemoryModuleType<U> type) {
        this.a(type, Optional.empty());
    }

    public <U> void a(MemoryModuleType<U> memoryType, @Nullable U memory) {
        this.a(memoryType, Optional.ofNullable(memory));
    }

    public <U> void a(MemoryModuleType<U> memoryType, U memory, long timeToLive) {
        this.b(memoryType, Optional.of(ExpirableMemory.a(memory, timeToLive)));
    }

    public <U> void a(MemoryModuleType<U> memoryType, Optional<? extends U> memory) {
        this.b(memoryType, memory.map(ExpirableMemory::a));
    }

    <U> void b(MemoryModuleType<U> memoryType, Optional<? extends ExpirableMemory<?>> memory) {
        if (this.d.containsKey(memoryType)) {
            if (memory.isPresent() && this.a(memory.get().c())) {
                this.b(memoryType);
            } else {
                this.d.put(memoryType, memory);
            }
        }
    }

    public <U> Optional<U> c(MemoryModuleType<U> type) {
        Optional<ExpirableMemory<?>> optional = this.d.get(type);
        if (optional == null) {
            throw new IllegalStateException("Unregistered memory fetched: " + String.valueOf(type));
        }
        return optional.map(ExpirableMemory::c);
    }

    public <U> @Nullable Optional<U> d(MemoryModuleType<U> type) {
        Optional<ExpirableMemory<?>> optional = this.d.get(type);
        return optional == null ? null : optional.map(ExpirableMemory::c);
    }

    public <U> long e(MemoryModuleType<U> memoryType) {
        Optional<ExpirableMemory<?>> optional = this.d.get(memoryType);
        return optional.map(ExpirableMemory::b).orElse(0L);
    }

    @Deprecated
    @VisibleForDebug
    public Map<MemoryModuleType<?>, Optional<? extends ExpirableMemory<?>>> b() {
        return this.d;
    }

    public <U> boolean b(MemoryModuleType<U> memoryType, U memory) {
        return this.a(memoryType) && this.c(memoryType).filter(object -> object.equals(memory)).isPresent();
    }

    public boolean a(MemoryModuleType<?> memoryType, MemoryStatus memoryStatus) {
        Optional<ExpirableMemory<?>> optional = this.d.get(memoryType);
        return optional != null && (memoryStatus == MemoryStatus.c || memoryStatus == MemoryStatus.a && optional.isPresent() || memoryStatus == MemoryStatus.b && optional.isEmpty());
    }

    public void a(EnvironmentAttribute<Activity> newSchedule) {
        this.g = newSchedule;
    }

    public void a(Set<Activity> newActivities) {
        this.j = newActivities;
    }

    @Deprecated
    @VisibleForDebug
    public Set<Activity> c() {
        return this.k;
    }

    @Deprecated
    @VisibleForDebug
    public List<BehaviorControl<? super E>> d() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map<Activity, Set<BehaviorControl<E>>> map : this.f.values()) {
            for (Set<BehaviorControl<E>> set : map.values()) {
                for (BehaviorControl<E> behaviorControl : set) {
                    if (behaviorControl.a() != Behavior.Status.b) continue;
                    list.add(behaviorControl);
                }
            }
        }
        return list;
    }

    public void e() {
        this.d(this.l);
    }

    public Optional<Activity> f() {
        for (Activity activity : this.k) {
            if (this.j.contains(activity)) continue;
            return Optional.of(activity);
        }
        return Optional.empty();
    }

    public void a(Activity activity) {
        if (this.f(activity)) {
            this.d(activity);
        } else {
            this.e();
        }
    }

    private void d(Activity activity) {
        if (!this.c(activity)) {
            this.e(activity);
            this.k.clear();
            this.k.addAll(this.j);
            this.k.add(activity);
        }
    }

    private void e(Activity activity) {
        for (Activity activity1 : this.k) {
            Set<MemoryModuleType<?>> set;
            if (activity1 == activity || (set = this.i.get(activity1)) == null) continue;
            for (MemoryModuleType<?> memoryModuleType : set) {
                this.b(memoryModuleType);
            }
        }
    }

    public void a(EnvironmentAttributeSystem environmentAttributes, long dayTime, Vec3D pos) {
        if (dayTime - this.m > 20L) {
            Activity activity;
            this.m = dayTime;
            Activity activity2 = activity = this.g != null ? environmentAttributes.a(this.g, pos) : Activity.b;
            if (!this.k.contains(activity)) {
                this.a(activity);
            }
        }
    }

    public void a(List<Activity> activities) {
        for (Activity activity : activities) {
            if (!this.f(activity)) continue;
            this.d(activity);
            break;
        }
    }

    public void b(Activity newFallbackActivity) {
        this.l = newFallbackActivity;
    }

    public void a(Activity activity, int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks) {
        this.a(activity, this.a(priorityStart, tasks));
    }

    public void a(Activity activity, int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks, MemoryModuleType<?> memoryType) {
        ImmutableSet set = ImmutableSet.of((Object)Pair.of(memoryType, (Object)((Object)MemoryStatus.a)));
        ImmutableSet set1 = ImmutableSet.of(memoryType);
        this.a(activity, (ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>>)this.a(priorityStart, tasks), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)set, (Set<MemoryModuleType<?>>)set1);
    }

    public void a(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> tasks) {
        this.a(activity, tasks, (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of(), Sets.newHashSet());
    }

    public void a(Activity activity, int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memoryStatuses) {
        this.a(activity, this.a(priorityStart, tasks), memoryStatuses);
    }

    public void a(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memoryStatuses) {
        this.a(activity, tasks, memoryStatuses, Sets.newHashSet());
    }

    public void a(Activity activity, ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> tasks, Set<Pair<MemoryModuleType<?>, MemoryStatus>> memoryStatuses, Set<MemoryModuleType<?>> memoryTypes) {
        this.h.put(activity, memoryStatuses);
        if (!memoryTypes.isEmpty()) {
            this.i.put(activity, memoryTypes);
        }
        for (Pair pair : tasks) {
            this.f.computeIfAbsent((Integer)pair.getFirst(), integer -> Maps.newHashMap()).computeIfAbsent(activity, activity1 -> Sets.newLinkedHashSet()).add((BehaviorControl)pair.getSecond());
        }
    }

    @VisibleForTesting
    public void g() {
        this.f.clear();
    }

    public boolean c(Activity activity) {
        return this.k.contains(activity);
    }

    public BehaviorController<E> h() {
        BehaviorController<E> brain = new BehaviorController<E>(this.d.keySet(), this.e.keySet(), ImmutableList.of(), this.b);
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> entry : this.d.entrySet()) {
            MemoryModuleType<?> memoryModuleType = entry.getKey();
            if (!entry.getValue().isPresent()) continue;
            brain.d.put(memoryModuleType, entry.getValue());
        }
        return brain;
    }

    public void a(WorldServer level, E entity) {
        this.k();
        this.c(level, entity);
        this.d(level, entity);
        this.e(level, entity);
    }

    private void c(WorldServer level, E brainHolder) {
        for (Sensor<E> sensor : this.e.values()) {
            sensor.b(level, brainHolder);
        }
    }

    private void k() {
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> entry : this.d.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            ExpirableMemory<?> expirableValue = entry.getValue().get();
            if (expirableValue.d()) {
                this.b(entry.getKey());
            }
            expirableValue.a();
        }
    }

    public void b(WorldServer level, E owner) {
        long gameTime = ((Entity)owner).ao().au();
        for (BehaviorControl<E> behaviorControl : this.d()) {
            behaviorControl.g(level, owner, gameTime);
        }
    }

    private void d(WorldServer level, E entity) {
        long gameTime = level.au();
        for (Map<Activity, Set<BehaviorControl<E>>> map : this.f.values()) {
            for (Map.Entry<Activity, Set<BehaviorControl<E>>> entry : map.entrySet()) {
                Activity activity = entry.getKey();
                if (!this.k.contains(activity)) continue;
                for (BehaviorControl<E> behaviorControl : entry.getValue()) {
                    if (behaviorControl.a() != Behavior.Status.a) continue;
                    behaviorControl.e(level, entity, gameTime);
                }
            }
        }
    }

    private void e(WorldServer level, E entity) {
        long gameTime = level.au();
        for (BehaviorControl<E> behaviorControl : this.d()) {
            behaviorControl.f(level, entity, gameTime);
        }
    }

    private boolean f(Activity activity) {
        if (!this.h.containsKey(activity)) {
            return false;
        }
        for (Pair<MemoryModuleType<?>, MemoryStatus> pair : this.h.get(activity)) {
            MemoryStatus memoryStatus;
            MemoryModuleType memoryModuleType = (MemoryModuleType)pair.getFirst();
            if (this.a(memoryModuleType, memoryStatus = (MemoryStatus)((Object)pair.getSecond()))) continue;
            return false;
        }
        return true;
    }

    private boolean a(Object collection) {
        return collection instanceof Collection && ((Collection)collection).isEmpty();
    }

    ImmutableList<? extends Pair<Integer, ? extends BehaviorControl<? super E>>> a(int priorityStart, ImmutableList<? extends BehaviorControl<? super E>> tasks) {
        int i2 = priorityStart;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BehaviorControl behaviorControl : tasks) {
            builder.add((Object)Pair.of((Object)i2++, (Object)behaviorControl));
        }
        return builder.build();
    }

    public boolean i() {
        return this.d.isEmpty() && this.e.isEmpty() && this.f.isEmpty();
    }

    public static final class b<E extends EntityLiving> {
        private final Collection<? extends MemoryModuleType<?>> a;
        private final Collection<? extends SensorType<? extends Sensor<? super E>>> b;
        private final Codec<BehaviorController<E>> c;

        b(Collection<? extends MemoryModuleType<?>> memoryTypes, Collection<? extends SensorType<? extends Sensor<? super E>>> sensorTypes) {
            this.a = memoryTypes;
            this.b = sensorTypes;
            this.c = BehaviorController.b(memoryTypes, sensorTypes);
        }

        public BehaviorController<E> a(Dynamic<?> ops) {
            return this.c.parse(ops).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).orElseGet(() -> new BehaviorController(this.a, this.b, ImmutableList.of(), () -> this.c));
        }
    }

    static final class a<U> {
        private final MemoryModuleType<U> a;
        private final Optional<? extends ExpirableMemory<U>> b;

        static <U> a<U> a(MemoryModuleType<U> memoryType, Optional<? extends ExpirableMemory<?>> memory) {
            return new a<U>(memoryType, memory);
        }

        a(MemoryModuleType<U> type, Optional<? extends ExpirableMemory<U>> value) {
            this.a = type;
            this.b = value;
        }

        void a(BehaviorController<?> brain) {
            brain.b(this.a, this.b);
        }

        public <T> void a(DynamicOps<T> ops, RecordBuilder<T> builder) {
            this.a.a().ifPresent(codec -> this.b.ifPresent(expirableValue -> builder.add(BuiltInRegistries.A.q().encodeStart(ops, this.a), codec.encodeStart(ops, expirableValue))));
        }
    }
}

