/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jspecify.annotations.Nullable;

public class AttributeProvider {
    private final Map<Holder<AttributeBase>, AttributeModifiable> a;

    AttributeProvider(Map<Holder<AttributeBase>, AttributeModifiable> instances) {
        this.a = instances;
    }

    public AttributeModifiable d(Holder<AttributeBase> attribute) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        if (attributeInstance == null) {
            throw new IllegalArgumentException("Can't find attribute " + attribute.g());
        }
        return attributeInstance;
    }

    public double a(Holder<AttributeBase> attribute) {
        return this.d(attribute).g();
    }

    public double b(Holder<AttributeBase> attribute) {
        return this.d(attribute).b();
    }

    public double a(Holder<AttributeBase> attribute, MinecraftKey id) {
        AttributeModifier modifier = this.d(attribute).a(id);
        if (modifier == null) {
            throw new IllegalArgumentException("Can't find modifier " + String.valueOf(id) + " on attribute " + attribute.g());
        }
        return modifier.b();
    }

    public @Nullable AttributeModifiable a(Consumer<AttributeModifiable> onDirty, Holder<AttributeBase> attribute) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        if (attributeInstance == null) {
            return null;
        }
        AttributeModifiable attributeInstance1 = new AttributeModifiable(attribute, onDirty);
        attributeInstance1.a(attributeInstance);
        return attributeInstance1;
    }

    public static Builder a() {
        return new Builder();
    }

    public boolean c(Holder<AttributeBase> attribute) {
        return this.a.containsKey(attribute);
    }

    public boolean b(Holder<AttributeBase> attribute, MinecraftKey id) {
        AttributeModifiable attributeInstance = this.a.get(attribute);
        return attributeInstance != null && attributeInstance.a(id) != null;
    }

    public static class Builder {
        private final ImmutableMap.Builder<Holder<AttributeBase>, AttributeModifiable> a = ImmutableMap.builder();
        private boolean b;

        private AttributeModifiable b(Holder<AttributeBase> attribute) {
            AttributeModifiable attributeInstance = new AttributeModifiable(attribute, attributeInstance1 -> {
                if (this.b) {
                    throw new UnsupportedOperationException("Tried to change value for default attribute instance: " + attribute.g());
                }
            });
            this.a.put(attribute, (Object)attributeInstance);
            return attributeInstance;
        }

        public Builder a(Holder<AttributeBase> attribute) {
            this.b(attribute);
            return this;
        }

        public Builder a(Holder<AttributeBase> attribute, double baseValue) {
            AttributeModifiable attributeInstance = this.b(attribute);
            attributeInstance.a(baseValue);
            return this;
        }

        public AttributeProvider a() {
            this.b = true;
            return new AttributeProvider((Map<Holder<AttributeBase>, AttributeModifiable>)this.a.buildKeepingLast());
        }
    }
}

