/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityInteractEvent;
import org.jspecify.annotations.Nullable;

public class BehaviorInteractDoor {
    private static final int a = 20;
    private static final double b = 3.0;
    private static final double c = 2.0;

    public static BehaviorControl<EntityLiving> a() {
        MutableObject mutableObject = new MutableObject();
        MutableInt mutableInt = new MutableInt(0);
        return BehaviorBuilder.a((BehaviorBuilder.b<E> instance) -> instance.group(instance.b(MemoryModuleType.u), instance.a(MemoryModuleType.w), instance.a(MemoryModuleType.g)).apply((Applicative)instance, (navigationPath, doorsToClose, nearestLivingEntities) -> (level, entity, gameTime) -> {
            PathEntity path = (PathEntity)instance.b(navigationPath);
            Optional<Set<GlobalPos>> optional = instance.a(doorsToClose);
            if (!path.b() && !path.c()) {
                BlockDoor doorBlock1;
                BlockPosition blockPos1;
                IBlockData blockState1;
                if (Objects.equals(mutableObject.get(), path.h())) {
                    mutableInt.setValue(20);
                } else if (mutableInt.decrementAndGet() > 0) {
                    return false;
                }
                mutableObject.setValue((Object)path.h());
                PathPoint previousNode = path.i();
                PathPoint nextNode = path.h();
                BlockPosition blockPos = previousNode.a();
                IBlockData blockState = level.a_(blockPos);
                if (blockState.a(TagsBlock.as, state -> state.b() instanceof BlockDoor)) {
                    BlockDoor doorBlock = (BlockDoor)blockState.b();
                    if (!doorBlock.n(blockState)) {
                        EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(entity.ao(), blockPos));
                        if (!event.callEvent()) {
                            return false;
                        }
                        doorBlock.a(entity, (World)level, blockState, blockPos, true);
                    }
                    optional = BehaviorInteractDoor.a(doorsToClose, optional, level, blockPos);
                }
                if ((blockState1 = level.a_(blockPos1 = nextNode.a())).a(TagsBlock.as, state -> state.b() instanceof BlockDoor) && !(doorBlock1 = (BlockDoor)blockState1.b()).n(blockState1)) {
                    EntityInteractEvent event = new EntityInteractEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(entity.ao(), blockPos1));
                    if (!event.callEvent()) {
                        return false;
                    }
                    doorBlock1.a(entity, (World)level, blockState1, blockPos1, true);
                    optional = BehaviorInteractDoor.a(doorsToClose, optional, level, blockPos1);
                }
                optional.ifPresent(doorPositions -> BehaviorInteractDoor.a(level, entity, previousNode, nextNode, doorPositions, instance.a(nearestLivingEntities)));
                return true;
            }
            return false;
        }));
    }

    public static void a(WorldServer level, EntityLiving entity, @Nullable PathPoint previous, @Nullable PathPoint next, Set<GlobalPos> doorPositions, Optional<List<EntityLiving>> nearestLivingEntities) {
        Iterator<GlobalPos> iterator = doorPositions.iterator();
        while (iterator.hasNext()) {
            GlobalPos globalPos = iterator.next();
            BlockPosition blockPos = globalPos.b();
            if (previous != null && previous.a().equals(blockPos) || next != null && next.a().equals(blockPos)) continue;
            if (BehaviorInteractDoor.a(level, entity, globalPos)) {
                iterator.remove();
                continue;
            }
            IBlockData blockState = level.a_(blockPos);
            if (!blockState.a(TagsBlock.as, state -> state.b() instanceof BlockDoor)) {
                iterator.remove();
                continue;
            }
            BlockDoor doorBlock = (BlockDoor)blockState.b();
            if (!doorBlock.n(blockState)) {
                iterator.remove();
                continue;
            }
            if (BehaviorInteractDoor.a(entity, blockPos, nearestLivingEntities)) {
                iterator.remove();
                continue;
            }
            doorBlock.a(entity, (World)level, blockState, blockPos, false);
            iterator.remove();
        }
    }

    private static boolean a(EntityLiving entity, BlockPosition pos, Optional<List<EntityLiving>> nearestLivingEntities) {
        return !nearestLivingEntities.isEmpty() && nearestLivingEntities.get().stream().filter(nearEntity -> nearEntity.ay() == entity.ay()).filter(nearEntity -> pos.a(nearEntity.dI(), 2.0)).anyMatch(nearEntity -> BehaviorInteractDoor.a(nearEntity.ev(), pos));
    }

    private static boolean a(BehaviorController<?> brain, BlockPosition pos) {
        if (!brain.a(MemoryModuleType.u)) {
            return false;
        }
        PathEntity path = brain.c(MemoryModuleType.u).get();
        if (path.c()) {
            return false;
        }
        PathPoint previousNode = path.i();
        if (previousNode == null) {
            return false;
        }
        PathPoint nextNode = path.h();
        return pos.equals(previousNode.a()) || pos.equals(nextNode.a());
    }

    private static boolean a(WorldServer level, EntityLiving entity, GlobalPos pos) {
        return pos.a() != level.aq() || !pos.b().a(entity.dI(), 3.0);
    }

    private static Optional<Set<GlobalPos>> a(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> doorsToClose, Optional<Set<GlobalPos>> doorPositions, WorldServer level, BlockPosition pos) {
        GlobalPos globalPos = GlobalPos.a(level.aq(), pos);
        return Optional.of(doorPositions.map(set -> {
            set.add(globalPos);
            return set;
        }).orElseGet(() -> {
            HashSet set = Sets.newHashSet((Object[])new GlobalPos[]{globalPos});
            doorsToClose.a(set);
            return set;
        }));
    }
}

