/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3D;

public class ChargeAttack
extends Behavior<EntityAnimal> {
    private final int c;
    private final PathfinderTargetCondition d;
    private final float e;
    private final float f;
    private final double g;
    private final double h;
    private final SoundEffect i;
    private Vec3D j;
    private Vec3D k;

    public ChargeAttack(int timeBetweenAttacks, PathfinderTargetCondition chargeTargeting, float speed, float knockbackForce, double maxChargeDistance, double maxTargetDetectionDistance, SoundEffect chargeSound) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.af, (Object)((Object)MemoryStatus.b), MemoryModuleType.p, (Object)((Object)MemoryStatus.a)));
        this.c = timeBetweenAttacks;
        this.d = chargeTargeting;
        this.e = speed;
        this.f = knockbackForce;
        this.h = maxChargeDistance;
        this.g = maxTargetDetectionDistance;
        this.i = chargeSound;
        this.j = Vec3D.c;
        this.k = Vec3D.c;
    }

    @Override
    protected boolean a(WorldServer level, EntityAnimal owner) {
        return owner.ev().a(MemoryModuleType.p);
    }

    @Override
    protected boolean a(WorldServer level, EntityAnimal entity, long gameTime) {
        EntityTameableAnimal tamableAnimal;
        BehaviorController<Integer> brain = entity.ev();
        Optional<EntityLiving> memory = brain.c(MemoryModuleType.p);
        if (memory.isEmpty()) {
            return false;
        }
        EntityLiving livingEntity = memory.get();
        return !(entity instanceof EntityTameableAnimal && (tamableAnimal = (EntityTameableAnimal)entity).p() || entity.dI().d(this.k).h() >= this.h * this.h || livingEntity.dI().d(entity.dI()).h() >= this.g * this.g || !entity.G(livingEntity) || brain.a(MemoryModuleType.af));
    }

    @Override
    protected void b(WorldServer level, EntityAnimal entity, long gameTime) {
        BehaviorController<?> brain = entity.ev();
        this.k = entity.dI();
        EntityLiving livingEntity = brain.c(MemoryModuleType.p).get();
        Vec3D vec3 = livingEntity.dI().d(entity.dI()).d();
        this.j = vec3.c((double)this.e);
        if (this.a(level, entity, gameTime)) {
            entity.a(this.i);
        }
    }

    @Override
    protected void c(WorldServer level, EntityAnimal owner, long gameTime) {
        BehaviorController<?> brain = owner.ev();
        EntityLiving livingEntity = brain.c(MemoryModuleType.p).orElseThrow();
        owner.a((Entity)livingEntity, 360.0f, 360.0f);
        owner.k(this.j);
        ArrayList list = new ArrayList(1);
        level.a(EntityTypeTest.a(EntityLiving.class), owner.dj(), livingEntity2 -> this.d.a(level, owner, (EntityLiving)livingEntity2), list, 1);
        if (!list.isEmpty()) {
            EntityLiving livingEntity1 = (EntityLiving)list.get(0);
            if (owner.z(livingEntity1)) {
                return;
            }
            this.a(level, owner, livingEntity1);
            this.a(owner, livingEntity1);
            this.d(level, owner, gameTime);
        }
    }

    private void a(WorldServer level, EntityAnimal animal, EntityLiving target) {
        float f2;
        DamageSource damageSource = level.as().b(animal);
        if (target.a(level, damageSource, f2 = (float)animal.i(GenericAttributes.d))) {
            EnchantmentManager.a(level, (Entity)target, damageSource);
        }
    }

    private void a(EntityAnimal animal, EntityLiving target) {
        int i2 = animal.d(MobEffects.a) ? animal.e(MobEffects.a).e() + 1 : 0;
        int i1 = animal.d(MobEffects.b) ? animal.e(MobEffects.b).e() + 1 : 0;
        float f2 = 0.25f * (float)(i2 - i1);
        float f1 = MathHelper.a(this.e * (float)animal.i(GenericAttributes.x), 0.2f, 2.0f) + f2;
        animal.a((Entity)target, f1 * this.f, animal.dN());
    }

    @Override
    protected void d(WorldServer level, EntityAnimal entity, long gameTime) {
        entity.ev().a(MemoryModuleType.af, this.c);
        entity.ev().b(MemoryModuleType.p);
    }
}

