/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Optional;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.phys.Vec3D;

public final class LongJumpUtil {
    public static Optional<Vec3D> a(EntityInsentient mob, Vec3D target, float maxJumpVelocity, int angle, boolean requireClearTransition) {
        Vec3D vec3 = mob.dI();
        Vec3D vec31 = new Vec3D(target.g - vec3.g, 0.0, target.i - vec3.i).d().c(0.5);
        Vec3D vec32 = target.d(vec31);
        Vec3D vec33 = vec32.d(vec3);
        float f2 = (float)angle * (float)Math.PI / 180.0f;
        double atan2 = Math.atan2(vec33.i, vec33.g);
        double d2 = vec33.a(0.0, vec33.h, 0.0).h();
        double squareRoot = Math.sqrt(d2);
        double d1 = vec33.h;
        double gravity = mob.bt();
        double sin = Math.sin(2.0f * f2);
        double d22 = Math.pow(Math.cos(f2), 2.0);
        double sin1 = Math.sin(f2);
        double cos = Math.cos(f2);
        double sin2 = Math.sin(atan2);
        double cos1 = Math.cos(atan2);
        double d3 = d2 * gravity / (squareRoot * sin - 2.0 * d1 * d22);
        if (d3 < 0.0) {
            return Optional.empty();
        }
        double squareRoot1 = Math.sqrt(d3);
        if (squareRoot1 > (double)maxJumpVelocity) {
            return Optional.empty();
        }
        double d4 = squareRoot1 * cos;
        double d5 = squareRoot1 * sin1;
        if (requireClearTransition) {
            int i2 = MathHelper.e(squareRoot / d4) * 2;
            double d6 = 0.0;
            Vec3D vec34 = null;
            EntitySize dimensions = mob.a(EntityPose.g);
            for (int i1 = 0; i1 < i2 - 1; ++i1) {
                double d7 = sin1 / cos * (d6 += squareRoot / (double)i2) - Math.pow(d6, 2.0) * gravity / (2.0 * d3 * Math.pow(cos, 2.0));
                double d8 = d6 * cos1;
                double d9 = d6 * sin2;
                Vec3D vec35 = new Vec3D(vec3.g + d8, vec3.h + d7, vec3.i + d9);
                if (vec34 != null && !LongJumpUtil.a(mob, dimensions, vec34, vec35)) {
                    return Optional.empty();
                }
                vec34 = vec35;
            }
        }
        return Optional.of(new Vec3D(d4 * cos1, d5, d4 * sin2).c((double)0.95f));
    }

    private static boolean a(EntityInsentient mob, EntitySize dimensions, Vec3D startPos, Vec3D endPos) {
        Vec3D vec3 = endPos.d(startPos);
        double d2 = Math.min(dimensions.a(), dimensions.b());
        int ceil = MathHelper.e(vec3.g() / d2);
        Vec3D vec31 = vec3.d();
        Vec3D vec32 = startPos;
        for (int i2 = 0; i2 < ceil; ++i2) {
            Vec3D vec3D = vec32 = i2 == ceil - 1 ? endPos : vec32.e(vec31.c(d2 * (double)0.9f));
            if (mob.ao().a((Entity)mob, dimensions.a(vec32))) continue;
            return false;
        }
        return true;
    }
}

