/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3D;

public class RandomLookAround
extends Behavior<EntityInsentient> {
    private final IntProvider c;
    private final float d;
    private final float e;
    private final float f;

    public RandomLookAround(IntProvider interval, float maxYaw, float minPitch, float maxPitch) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.o, (Object)((Object)MemoryStatus.b), MemoryModuleType.R, (Object)((Object)MemoryStatus.b)));
        if (minPitch > maxPitch) {
            throw new IllegalArgumentException("Minimum pitch is larger than maximum pitch! " + minPitch + " > " + maxPitch);
        }
        this.c = interval;
        this.d = maxYaw;
        this.e = minPitch;
        this.f = maxPitch - minPitch;
    }

    protected void a(WorldServer level, EntityInsentient entity, long gameTime) {
        RandomSource random = entity.ep();
        float f2 = MathHelper.a(random.i() * this.f + this.e, -90.0f, 90.0f);
        float f1 = MathHelper.f(entity.ec() + 2.0f * random.i() * this.d - this.d);
        Vec3D vec3 = Vec3D.a(f2, f1);
        entity.ev().a(MemoryModuleType.o, new BehaviorTarget(entity.bV().e(vec3)));
        entity.ev().a(MemoryModuleType.R, this.c.a(random));
    }
}

