/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.gossip.ReputationType;

public class Reputation {
    public static final Codec<Reputation> a = net.minecraft.world.entity.ai.gossip.Reputation$b.a.listOf().xmap(Reputation::new, gossipContainer -> gossipContainer.decompress());
    public static final int b = 2;
    public final Map<UUID, a> c = new HashMap<UUID, a>();

    public Reputation() {
    }

    private Reputation(List<b> entries) {
        entries.forEach(entry -> this.a((UUID)entry.b).a.put((Object)entry.c, entry.d));
    }

    @VisibleForDebug
    public Map<UUID, Object2IntMap<ReputationType>> a() {
        HashMap map = Maps.newHashMap();
        this.c.keySet().forEach(uuid -> {
            a entityGossips = this.c.get(uuid);
            map.put(uuid, entityGossips.a);
        });
        return map;
    }

    public void b() {
        Iterator<a> iterator = this.c.values().iterator();
        while (iterator.hasNext()) {
            a entityGossips = iterator.next();
            entityGossips.a();
            if (!entityGossips.b()) continue;
            iterator.remove();
        }
    }

    private Stream<b> e() {
        return this.c.entrySet().stream().flatMap(entry -> ((a)entry.getValue()).a((UUID)entry.getKey()));
    }

    private List<b> decompress() {
        ObjectArrayList list = new ObjectArrayList();
        for (Map.Entry<UUID, a> entry : this.c.entrySet()) {
            for (b cur : entry.getValue().decompress(entry.getKey())) {
                if (cur.a() == 0) continue;
                list.add(cur);
            }
        }
        return list;
    }

    private Collection<b> a(RandomSource random, int amount) {
        List<b> list = this.decompress();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] ints = new int[list.size()];
        int i2 = 0;
        for (int i1 = 0; i1 < list.size(); ++i1) {
            b gossipEntry = list.get(i1);
            ints[i1] = (i2 += Math.abs(gossipEntry.a())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int i22 = 0; i22 < amount; ++i22) {
            int randomInt = random.a(i2);
            int i3 = Arrays.binarySearch(ints, randomInt);
            set.add(list.get(i3 < 0 ? -i3 - 1 : i3));
        }
        return set;
    }

    private a a(UUID identifier) {
        return this.c.computeIfAbsent(identifier, uuid -> new a());
    }

    public void a(Reputation container, RandomSource randomSource, int amount) {
        Collection<b> collection = container.a(randomSource, amount);
        collection.forEach(entry -> {
            int i2 = entry.d - entry.c.m;
            if (i2 >= 2) {
                this.a((UUID)entry.b).a.mergeInt((Object)entry.c, i2, Reputation::a);
            }
        });
    }

    public int a(UUID identifier, Predicate<ReputationType> gossip) {
        a entityGossips = this.c.get(identifier);
        return entityGossips != null ? entityGossips.a(gossip) : 0;
    }

    public long a(ReputationType gossipType, DoublePredicate gossipPredicate) {
        return this.c.values().stream().filter(gossips -> gossipPredicate.test(gossips.a.getOrDefault((Object)gossipType, 0) * gossipType.j)).count();
    }

    public void a(UUID identifier, ReputationType gossipType, int gossipValue) {
        a entityGossips = this.a(identifier);
        entityGossips.a.mergeInt((Object)gossipType, gossipValue, (i2, i1) -> this.a(gossipType, i2, i1));
        entityGossips.a(gossipType);
        if (entityGossips.b()) {
            this.c.remove(identifier);
        }
    }

    public void b(UUID identifier, ReputationType gossipType, int gossipValue) {
        this.a(identifier, gossipType, -gossipValue);
    }

    public void a(UUID identifier, ReputationType gossipType) {
        a entityGossips = this.c.get(identifier);
        if (entityGossips != null) {
            entityGossips.b(gossipType);
            if (entityGossips.b()) {
                this.c.remove(identifier);
            }
        }
    }

    public void a(ReputationType gossipType) {
        Iterator<a> iterator = this.c.values().iterator();
        while (iterator.hasNext()) {
            a entityGossips = iterator.next();
            entityGossips.b(gossipType);
            if (!entityGossips.b()) continue;
            iterator.remove();
        }
    }

    public void c() {
        this.c.clear();
    }

    public void a(Reputation other) {
        other.c.forEach((uuid, gossips) -> this.a((UUID)uuid).a.putAll(gossips.a));
    }

    private static int a(int value1, int value2) {
        return Math.max(value1, value2);
    }

    private int a(ReputationType gossipType, int existing, int additive) {
        int i2 = existing + additive;
        return i2 > gossipType.k ? Math.max(gossipType.k, existing) : i2;
    }

    public Reputation d() {
        Reputation gossipContainer = new Reputation();
        gossipContainer.a(this);
        return gossipContainer;
    }

    public static class a {
        final Object2IntMap<ReputationType> a = new Object2IntOpenHashMap();
        private static final ReputationType[] TYPES = ReputationType.values();

        public int a(Predicate<ReputationType> gossipType) {
            int weight = 0;
            for (Object2IntMap.Entry entry : this.a.object2IntEntrySet()) {
                if (!gossipType.test((ReputationType)entry.getKey())) continue;
                weight += entry.getIntValue() * ((ReputationType)entry.getKey()).j;
            }
            return weight;
        }

        public List<b> decompress(UUID uuid) {
            ObjectArrayList list = new ObjectArrayList();
            for (Object2IntMap.Entry entry : this.a.object2IntEntrySet()) {
                list.add(new b(uuid, (ReputationType)entry.getKey(), entry.getIntValue()));
            }
            return list;
        }

        public Stream<b> a(UUID identifier) {
            return this.a.object2IntEntrySet().stream().map(gossip -> new b(identifier, (ReputationType)gossip.getKey(), gossip.getIntValue()));
        }

        public void a() {
            ObjectIterator objectIterator = this.a.object2IntEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
                int i2 = entry.getIntValue() - ((ReputationType)entry.getKey()).l;
                if (i2 < 2) {
                    objectIterator.remove();
                    continue;
                }
                entry.setValue(i2);
            }
        }

        public boolean b() {
            return this.a.isEmpty();
        }

        public void a(ReputationType gossipType) {
            int _int = this.a.getInt((Object)gossipType);
            if (_int > gossipType.k) {
                this.a.put((Object)gossipType, gossipType.k);
            }
            if (_int < 2) {
                this.b(gossipType);
            }
        }

        public void b(ReputationType gossipType) {
            this.a.removeInt((Object)gossipType);
        }

        public com.destroystokyo.paper.entity.villager.Reputation getPaperReputation() {
            EnumMap<com.destroystokyo.paper.entity.villager.ReputationType, Integer> map = new EnumMap<com.destroystokyo.paper.entity.villager.ReputationType, Integer>(com.destroystokyo.paper.entity.villager.ReputationType.class);
            for (Object2IntMap.Entry type : this.a.object2IntEntrySet()) {
                map.put(net.minecraft.world.entity.ai.gossip.Reputation$a.toApi((ReputationType)type.getKey()), type.getIntValue());
            }
            return new com.destroystokyo.paper.entity.villager.Reputation(map);
        }

        public void assignFromPaperReputation(com.destroystokyo.paper.entity.villager.Reputation rep) {
            for (ReputationType type : TYPES) {
                com.destroystokyo.paper.entity.villager.ReputationType api = net.minecraft.world.entity.ai.gossip.Reputation$a.toApi(type);
                if (!rep.hasReputationSet(api)) continue;
                int reputation = rep.getReputation(api);
                if (reputation == 0) {
                    this.a.removeInt((Object)type);
                    continue;
                }
                this.a.put((Object)type, reputation);
            }
        }

        private static com.destroystokyo.paper.entity.villager.ReputationType toApi(ReputationType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case ReputationType.a -> com.destroystokyo.paper.entity.villager.ReputationType.MAJOR_NEGATIVE;
                case ReputationType.b -> com.destroystokyo.paper.entity.villager.ReputationType.MINOR_NEGATIVE;
                case ReputationType.c -> com.destroystokyo.paper.entity.villager.ReputationType.MINOR_POSITIVE;
                case ReputationType.d -> com.destroystokyo.paper.entity.villager.ReputationType.MAJOR_POSITIVE;
                case ReputationType.e -> com.destroystokyo.paper.entity.villager.ReputationType.TRADING;
            };
        }
    }

    record b(UUID b, ReputationType c, int d) {
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("Target").forGetter(b::b), (App)ReputationType.n.fieldOf("Type").forGetter(b::c), (App)ExtraCodecs.r.fieldOf("Value").forGetter(b::d)).apply((Applicative)instance, b::new));

        public int a() {
            return this.d * this.c.j;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "target;type;value", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "target;type;value", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "target;type;value", "b", "c", "d"}, this, o2);
        }
    }
}

