/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.memory;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.sensing.Sensor;

public class NearestVisibleLivingEntities {
    private static final NearestVisibleLivingEntities a = new NearestVisibleLivingEntities();
    private final List<EntityLiving> b;
    private final Predicate<EntityLiving> c;

    private NearestVisibleLivingEntities() {
        this.b = List.of();
        this.c = entity -> false;
    }

    public NearestVisibleLivingEntities(WorldServer level, EntityLiving entity, List<EntityLiving> nearbyEntities) {
        this.b = nearbyEntities;
        Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap(nearbyEntities.size());
        Predicate<EntityLiving> predicate = target -> Sensor.b(level, entity, target);
        this.c = target -> map.computeIfAbsent(target, predicate);
    }

    public static NearestVisibleLivingEntities a() {
        return a;
    }

    public Optional<EntityLiving> a(Predicate<EntityLiving> predicate) {
        for (EntityLiving livingEntity : this.b) {
            if (!predicate.test(livingEntity) || !this.c.test(livingEntity)) continue;
            return Optional.of(livingEntity);
        }
        return Optional.empty();
    }

    public Iterable<EntityLiving> b(Predicate<EntityLiving> predicate) {
        return Iterables.filter(this.b, target -> predicate.test((EntityLiving)target) && this.c.test((EntityLiving)target));
    }

    public Stream<EntityLiving> c(Predicate<EntityLiving> predicate) {
        return this.b.stream().filter(target -> predicate.test((EntityLiving)target) && this.c.test((EntityLiving)target));
    }

    public boolean a(EntityLiving entity) {
        return this.b.contains(entity) && this.c.test(entity);
    }

    public boolean d(Predicate<EntityLiving> predicate) {
        for (EntityLiving livingEntity : this.b) {
            if (!predicate.test(livingEntity) || !this.c.test(livingEntity)) continue;
            return true;
        }
        return false;
    }
}

