/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.jspecify.annotations.Nullable;

public abstract class NavigationAbstract {
    private static final int p = 20;
    private static final int q = 100;
    private static final float r = 0.25f;
    protected final EntityInsentient a;
    protected final World b;
    protected @Nullable PathEntity c;
    protected double d;
    protected int e;
    protected int f;
    protected Vec3D g = Vec3D.c;
    protected BaseBlockPosition h = BaseBlockPosition.i;
    protected long i;
    protected long j;
    protected double k;
    protected float l = 0.5f;
    protected boolean m;
    protected long n;
    protected PathfinderAbstract o;
    private @Nullable BlockPosition s;
    private int t;
    private float u = 1.0f;
    public final Pathfinder v;
    private boolean w;
    private float x = 16.0f;
    private int lastFailure = 0;
    private int pathfindFailures = 0;

    public NavigationAbstract(EntityInsentient mob, World level) {
        this.a = mob;
        this.b = level;
        this.v = this.a(MathHelper.c(mob.j(GenericAttributes.o) * 16.0));
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            ServerDebugSubscribers serverDebugSubscribers = serverLevel.s().bw();
            this.v.a(() -> serverDebugSubscribers.a(DebugSubscriptions.f));
        }
    }

    public void f() {
        int floor = MathHelper.b(this.s() * 16.0f);
        this.v.a(floor);
    }

    public void a(float requiredPathLength) {
        this.x = requiredPathLength;
        this.f();
    }

    private float s() {
        return Math.max((float)this.a.i(GenericAttributes.o), this.x);
    }

    public void g() {
        this.u = 1.0f;
    }

    public void b(float multiplier) {
        this.u = multiplier;
    }

    public @Nullable BlockPosition h() {
        return this.s;
    }

    protected abstract Pathfinder a(int var1);

    public void a(double speedModifier) {
        this.d = speedModifier;
    }

    public void i() {
        if (this.b.au() - this.n > 20L) {
            if (this.s != null) {
                this.c = null;
                this.c = this.a(this.s, this.t);
                this.n = this.b.au();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    public final @Nullable PathEntity a(double x2, double y2, double z2, int reachRange) {
        return this.a(BlockPosition.a(x2, y2, z2), reachRange);
    }

    public @Nullable PathEntity a(Stream<BlockPosition> targets, int reachRange) {
        return this.a(targets.collect(Collectors.toSet()), 8, false, reachRange);
    }

    public @Nullable PathEntity a(Set<BlockPosition> targets, int reachRange) {
        return this.a(targets, 8, false, reachRange);
    }

    public @Nullable PathEntity a(BlockPosition pos, int reachRange) {
        return this.createPath(pos, null, reachRange);
    }

    public @Nullable PathEntity createPath(BlockPosition target, @Nullable Entity entity, int reachRange) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)target), entity, 8, false, reachRange);
    }

    public @Nullable PathEntity a(BlockPosition pos, int reachRange, int followRange) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)pos), 8, false, reachRange, followRange);
    }

    public @Nullable PathEntity a(Entity entity, int reachRange) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)entity.dK()), entity, 16, true, reachRange);
    }

    protected @Nullable PathEntity a(Set<BlockPosition> targets, int regionOffset, boolean offsetUpward, int reachRange) {
        return this.a(targets, regionOffset, offsetUpward, reachRange, this.s());
    }

    protected @Nullable PathEntity a(Set<BlockPosition> targets, int regionOffset, boolean offsetUpward, int reachRange, float followRange) {
        return this.createPath(targets, null, regionOffset, offsetUpward, reachRange, followRange);
    }

    protected @Nullable PathEntity createPath(Set<BlockPosition> targets, @Nullable Entity target, int regionOffset, boolean offsetUpward, int reachRange) {
        return this.createPath(targets, target, regionOffset, offsetUpward, reachRange, this.s());
    }

    protected @Nullable PathEntity createPath(Set<BlockPosition> targets, @Nullable Entity target, int regionOffset, boolean offsetUpward, int reachRange, float followRange) {
        if (targets.isEmpty()) {
            return null;
        }
        if (this.a.dR() < (double)this.b.K_()) {
            return null;
        }
        if (!this.a()) {
            return null;
        }
        if (this.c != null && !this.c.c() && targets.contains(this.s)) {
            return this.c;
        }
        boolean copiedSet = false;
        for (BlockPosition possibleTarget : targets) {
            if (this.a.ao().w().a(possibleTarget) && new EntityPathfindEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), CraftLocation.toBukkit((BaseBlockPosition)possibleTarget, this.a.ao()), (org.bukkit.entity.Entity)(target == null ? null : target.getBukkitEntity())).callEvent()) continue;
            if (!copiedSet) {
                copiedSet = true;
                targets = new HashSet<BlockPosition>(targets);
            }
            targets.remove(possibleTarget);
            if (!targets.isEmpty()) continue;
            return null;
        }
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("pathfind");
        BlockPosition blockPos = offsetUpward ? this.a.dK().d() : this.a.dK();
        int i2 = (int)(followRange + (float)regionOffset);
        ChunkCache pathNavigationRegion = new ChunkCache(this.b, blockPos.b(-i2, -i2, -i2), blockPos.b(i2, i2, i2));
        PathEntity path = this.v.a(pathNavigationRegion, this.a, targets, followRange, reachRange, this.u);
        profilerFiller.c();
        if (path != null && path.l() != null) {
            this.s = path.l();
            this.t = reachRange;
            this.u();
        }
        return path;
    }

    public boolean a(double x2, double y2, double z2, double speedModifier) {
        return this.a(this.a(x2, y2, z2, 1), speedModifier);
    }

    public boolean a(double x2, double y2, double z2, int reachRange, double speedModifier) {
        return this.a(this.a(x2, y2, z2, reachRange), speedModifier);
    }

    public boolean a(Entity entity, double speedModifier) {
        if (this.pathfindFailures > 10 && this.c == null && MinecraftServer.currentTick < this.lastFailure + 40) {
            return false;
        }
        PathEntity path = this.a(entity, 1);
        if (path != null && this.a(path, speedModifier)) {
            this.lastFailure = 0;
            this.pathfindFailures = 0;
            return true;
        }
        ++this.pathfindFailures;
        this.lastFailure = MinecraftServer.currentTick;
        return false;
    }

    public boolean a(@Nullable PathEntity path, double speedModifier) {
        if (path == null) {
            this.c = null;
            return false;
        }
        if (!path.a(this.c)) {
            this.c = path;
        }
        if (this.l()) {
            return false;
        }
        this.e();
        if (this.c.e() <= 0) {
            return false;
        }
        this.d = speedModifier;
        Vec3D tempMobPos = this.b();
        this.f = this.e;
        this.g = tempMobPos;
        return true;
    }

    public @Nullable PathEntity j() {
        return this.c;
    }

    public void d() {
        ++this.e;
        if (this.m) {
            this.i();
        }
        if (!this.l()) {
            Vec3D tempMobPos;
            if (this.a()) {
                this.k();
            } else if (this.c != null && !this.c.c()) {
                tempMobPos = this.b();
                Vec3D nextEntityPos = this.c.a(this.a);
                if (tempMobPos.h > nextEntityPos.h && !this.a.aV() && MathHelper.c(tempMobPos.g) == MathHelper.c(nextEntityPos.g) && MathHelper.c(tempMobPos.i) == MathHelper.c(nextEntityPos.i)) {
                    this.c.a();
                }
            }
            if (!this.l()) {
                tempMobPos = this.c.a(this.a);
                this.a.K().a(tempMobPos.g, this.a(tempMobPos), tempMobPos.i, this.d);
            }
        }
    }

    protected double a(Vec3D pos) {
        BlockPosition blockPos = BlockPosition.a(pos);
        return this.b.a_(blockPos.e()).l() ? pos.h : PathfinderNormal.a(this.b, blockPos);
    }

    protected void k() {
        boolean flag;
        Vec3D tempMobPos = this.b();
        this.l = this.a.dF() > 0.75f ? this.a.dF() / 2.0f : 0.75f - this.a.dF() / 2.0f;
        BlockPosition nextNodePos = this.c.g();
        double abs = Math.abs(this.a.dP() - ((double)nextNodePos.u() + 0.5));
        double abs1 = Math.abs(this.a.dR() - (double)nextNodePos.v());
        double abs2 = Math.abs(this.a.dV() - ((double)nextNodePos.w() + 0.5));
        boolean bl = flag = abs < (double)this.l && abs2 < (double)this.l && abs1 < 1.0;
        if (flag || this.b(this.c.h().l) && this.c(tempMobPos)) {
            this.c.a();
        }
        this.b(tempMobPos);
    }

    private boolean c(Vec3D pos) {
        boolean flag1;
        if (this.c.f() + 1 >= this.c.e()) {
            return false;
        }
        Vec3D vec3 = Vec3D.c(this.c.g());
        if (!pos.a((IPosition)vec3, 2.0)) {
            return false;
        }
        if (this.a(pos, this.c.a(this.a))) {
            return true;
        }
        Vec3D vec31 = Vec3D.c(this.c.d(this.c.f() + 1));
        Vec3D vec32 = vec3.d(pos);
        Vec3D vec33 = vec31.d(pos);
        double d2 = vec32.h();
        double d1 = vec33.h();
        boolean flag = d1 < d2;
        boolean bl = flag1 = d2 < 0.5;
        if (!flag && !flag1) {
            return false;
        }
        Vec3D vec34 = vec32.d();
        Vec3D vec35 = vec33.d();
        return vec35.b(vec34) < 0.0;
    }

    protected void b(Vec3D pos) {
        if (this.e - this.f > 100) {
            float f2 = this.a.fM() >= 1.0f ? this.a.fM() : this.a.fM() * this.a.fM();
            float f1 = f2 * 100.0f * 0.25f;
            if (pos.g(this.g) < (double)(f1 * f1)) {
                this.w = true;
                this.n();
            } else {
                this.w = false;
            }
            this.f = this.e;
            this.g = pos;
        }
        if (this.c != null && !this.c.c()) {
            BlockPosition nextNodePos = this.c.g();
            long gameTime = this.b.au();
            if (nextNodePos.equals(this.h)) {
                this.i += gameTime - this.j;
            } else {
                this.h = nextNodePos;
                double d2 = pos.f(Vec3D.c(this.h));
                double d3 = this.k = this.a.fM() > 0.0f ? d2 / (double)this.a.fM() * 20.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.t();
            }
            this.j = gameTime;
        }
    }

    private void t() {
        this.u();
        this.n();
    }

    private void u() {
        this.h = BaseBlockPosition.i;
        this.i = 0L;
        this.k = 0.0;
        this.w = false;
    }

    public boolean l() {
        return this.c == null || this.c.c();
    }

    public boolean m() {
        return !this.l();
    }

    public void n() {
        this.c = null;
    }

    protected abstract Vec3D b();

    protected abstract boolean a();

    protected void e() {
        if (this.c != null) {
            for (int i2 = 0; i2 < this.c.e(); ++i2) {
                PathPoint node = this.c.a(i2);
                PathPoint node1 = i2 + 1 < this.c.e() ? this.c.a(i2 + 1) : null;
                IBlockData blockState = this.b.a_(new BlockPosition(node.a, node.b, node.c));
                if (!blockState.a(TagsBlock.by)) continue;
                this.c.a(i2, node.a(node.a, node.b + 1, node.c));
                if (node1 == null || node.b < node1.b) continue;
                this.c.a(i2 + 1, node.a(node1.a, node.b + 1, node1.c));
            }
        }
    }

    protected boolean a(Vec3D currentPos, Vec3D nextPos) {
        return false;
    }

    public boolean b(PathType pathType) {
        return pathType != PathType.n && pathType != PathType.p && pathType != PathType.d;
    }

    protected static boolean a(EntityInsentient mob, Vec3D pos1, Vec3D pos2, boolean avoidFluid) {
        Vec3D vec3 = new Vec3D(pos2.g, pos2.h + (double)mob.dG() * 0.5, pos2.i);
        return mob.ao().a(new RayTrace(pos1, vec3, RayTrace.BlockCollisionOption.a, avoidFluid ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, mob)).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean a(BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return this.b.a_(blockPos).s();
    }

    public PathfinderAbstract o() {
        return this.o;
    }

    public void a(boolean canFloat) {
        this.o.c(canFloat);
    }

    public boolean p() {
        return this.o.f();
    }

    public boolean b(BlockPosition pos) {
        if (this.m) {
            return false;
        }
        if (this.c != null && !this.c.c() && this.c.e() != 0) {
            PathPoint endNode = this.c.d();
            Vec3D vec3 = new Vec3D(((double)endNode.a + this.a.dP()) / 2.0, ((double)endNode.b + this.a.dR()) / 2.0, ((double)endNode.c + this.a.dV()) / 2.0);
            return pos.a(vec3, (double)(this.c.e() - this.c.f()));
        }
        return false;
    }

    public float q() {
        return this.l;
    }

    public boolean r() {
        return this.w;
    }

    public abstract boolean c();

    public void e(boolean canOpenDoors) {
        this.o.b(canOpenDoors);
    }
}

