/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiSection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class VillagePlaceSection
implements ChunkSystemPoiSection {
    private static final Logger a = LogUtils.getLogger();
    private final Short2ObjectMap<VillagePlaceRecord> b = new Short2ObjectOpenHashMap();
    private final Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> c = Maps.newHashMap();
    private final Runnable d;
    private boolean e;
    private final Optional<VillagePlaceSection> noAllocOptional = Optional.of(this);

    public final Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> getData() {
        return this.c;
    }

    @Override
    public final boolean moonrise$isEmpty() {
        return this.e && this.b.isEmpty() && this.c.isEmpty();
    }

    @Override
    public final Optional<VillagePlaceSection> moonrise$asOptional() {
        return this.noAllocOptional;
    }

    public VillagePlaceSection(Runnable setDirty) {
        this(setDirty, true, (List<VillagePlaceRecord>)ImmutableList.of());
    }

    VillagePlaceSection(Runnable setDirty, boolean isValid, List<VillagePlaceRecord> records) {
        this.d = setDirty;
        this.e = isValid;
        records.forEach(this::a);
    }

    public a a() {
        return new a(this.e, this.b.values().stream().map(VillagePlaceRecord::a).toList());
    }

    public Stream<VillagePlaceRecord> a(Predicate<Holder<VillagePlaceType>> typePredicate, VillagePlace.Occupancy status) {
        return this.c.entrySet().stream().filter(entry -> typePredicate.test((Holder)entry.getKey())).flatMap(entry -> ((Set)entry.getValue()).stream()).filter(status.a());
    }

    public @Nullable VillagePlaceRecord a(BlockPosition pos, Holder<VillagePlaceType> poiType) {
        VillagePlaceRecord poiRecord = new VillagePlaceRecord(pos, poiType, this.d);
        if (this.a(poiRecord)) {
            a.debug("Added POI of type {} @ {}", (Object)poiType.g(), (Object)pos);
            this.d.run();
            return poiRecord;
        }
        return null;
    }

    private boolean a(VillagePlaceRecord _record) {
        BlockPosition pos = _record.g();
        Holder<VillagePlaceType> poiType = _record.h();
        short s2 = SectionPosition.b(pos);
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)this.b.get(s2);
        if (poiRecord != null) {
            if (poiType.equals(poiRecord.h())) {
                return false;
            }
            SystemUtils.b("POI data mismatch: already registered at " + String.valueOf(pos));
        }
        this.b.put(s2, (Object)_record);
        this.c.computeIfAbsent(poiType, holder -> Sets.newHashSet()).add(_record);
        return true;
    }

    public void a(BlockPosition pos) {
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)this.b.remove(SectionPosition.b(pos));
        if (poiRecord == null) {
            a.error("POI data mismatch: never registered at {}", (Object)pos);
        } else {
            this.c.get(poiRecord.h()).remove(poiRecord);
            a.debug("Removed POI of type {} @ {}", LogUtils.defer(poiRecord::h), LogUtils.defer(poiRecord::g));
            this.d.run();
        }
    }

    @Deprecated
    @VisibleForDebug
    public int b(BlockPosition pos) {
        return this.f(pos).map(VillagePlaceRecord::b).orElse(0);
    }

    public boolean c(BlockPosition pos) {
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)this.b.get(SectionPosition.b(pos));
        if (poiRecord == null) {
            throw SystemUtils.b(new IllegalStateException("POI never registered at " + String.valueOf(pos)));
        }
        boolean flag = poiRecord.d();
        this.d.run();
        return flag;
    }

    public boolean a(BlockPosition pos, Predicate<Holder<VillagePlaceType>> typePredicate) {
        return this.d(pos).filter(typePredicate).isPresent();
    }

    public Optional<Holder<VillagePlaceType>> d(BlockPosition pos) {
        return this.f(pos).map(VillagePlaceRecord::h);
    }

    private Optional<VillagePlaceRecord> f(BlockPosition pos) {
        return Optional.ofNullable((VillagePlaceRecord)this.b.get(SectionPosition.b(pos)));
    }

    public Optional<DebugPoiInfo> e(BlockPosition pos) {
        return this.f(pos).map(DebugPoiInfo::new);
    }

    public void a(Consumer<BiConsumer<BlockPosition, Holder<VillagePlaceType>>> posToTypeConsumer) {
        if (!this.e) {
            Short2ObjectOpenHashMap map = new Short2ObjectOpenHashMap(this.b);
            this.c();
            posToTypeConsumer.accept((arg_0, arg_1) -> this.a((Short2ObjectMap)map, arg_0, arg_1));
            this.e = true;
            this.d.run();
        }
    }

    private void c() {
        this.b.clear();
        this.c.clear();
    }

    boolean b() {
        return this.e;
    }

    private /* synthetic */ void a(Short2ObjectMap map, BlockPosition blockPos, Holder holder) {
        short s2 = SectionPosition.b(blockPos);
        VillagePlaceRecord poiRecord = (VillagePlaceRecord)map.computeIfAbsent(s2, s1 -> new VillagePlaceRecord(blockPos, holder, this.d));
        this.a(poiRecord);
    }

    public static final class a
    extends Record {
        private final boolean b;
        private final List<VillagePlaceRecord.a> c;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.lenientOptionalFieldOf("Valid", (Object)false).forGetter(a::a), (App)VillagePlaceRecord.a.a.listOf().fieldOf("Records").forGetter(a::b)).apply((Applicative)instance, a::new));

        public a(boolean isValid, List<VillagePlaceRecord.a> records) {
            this.b = isValid;
            this.c = records;
        }

        public VillagePlaceSection a(Runnable setDirty) {
            return new VillagePlaceSection(setDirty, this.b, this.c.stream().map(packed -> packed.a(setDirty)).toList());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "isValid;records", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "isValid;records", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "isValid;records", "b", "c"}, this, o2);
        }

        public boolean a() {
            return this.b;
        }

        public List<VillagePlaceRecord.a> b() {
            return this.c;
        }
    }
}

