/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.annotation.DoNotUse;
import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.jspecify.annotations.Nullable;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cy = 6000;
    private static final int cv = 0;
    public int cw = 0;
    public @Nullable EntityReference<EntityPlayer> cx;
    public @Nullable ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World level) {
        super((EntityTypes<? extends EntityAgeable>)type, level);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gW() {
        return EntityInsentient.E().a(GenericAttributes.G, 10.0);
    }

    @Override
    protected void a(WorldServer level) {
        if (this.Z_() != 0) {
            this.cw = 0;
        }
        super.a(level);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.Z_() != 0) {
            this.cw = 0;
        }
        if (this.cw > 0) {
            --this.cw;
            if (this.cw % 10 == 0) {
                double d2 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d22 = this.as.k() * 0.02;
                this.ao().a(Particles.T, this.e(1.0), this.dS() + 0.5, this.h(1.0), d2, d1, d22);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.hc();
        return true;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.a_(pos.e()).a(Blocks.i) ? 10.0f : level.C(pos);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("InLove", this.cw);
        EntityReference.a(this.cx, output, "LoveCause");
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cw = input.a("InLove", 0);
        this.cx = EntityReference.a(input, "LoveCause");
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag = EntitySpawnReason.b(spawnReason) || EntityAnimal.a(level, pos);
        return level.a_(pos.e()).a(TagsBlock.cl) && flag;
    }

    protected static boolean a(IBlockLightAccess level, BlockPosition pos) {
        return level.b(pos, 0) > 8;
    }

    @Override
    public int S() {
        return 120;
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected int f(WorldServer level) {
        return 1 + this.as.a(3);
    }

    public abstract boolean j(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (this.j(itemInHand)) {
            int age = this.Z_();
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                if (age == 0 && this.gY()) {
                    ItemStack breedCopy = itemInHand.v();
                    this.a(player, hand, itemInHand);
                    this.setInLove(serverPlayer, breedCopy);
                    this.gX();
                    return EnumInteractionResult.b;
                }
            }
            if (this.e_()) {
                this.a(player, hand, itemInHand);
                this.a(EntityAnimal.d(-age), true);
                this.gX();
                return EnumInteractionResult.a;
            }
            if (this.ao().B_()) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(player, hand);
    }

    protected void gX() {
    }

    public boolean gY() {
        return this.cw <= 0;
    }

    @Deprecated
    @DoNotUse
    public void h(@Nullable EntityHuman player) {
        this.setInLove(player, null);
    }

    public void setInLove(@Nullable EntityHuman player, @Nullable ItemStack breedItemCopy) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent;
        if (breedItemCopy != null) {
            this.breedItem = breedItemCopy;
        }
        if ((entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600)).isCancelled()) {
            this.breedItem = null;
            return;
        }
        this.cw = entityEnterLoveModeEvent.getTicksInLove();
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            this.cx = EntityReference.a(serverPlayer);
        }
        this.ao().a((Entity)this, (byte)18);
    }

    public void r(int inLove) {
        this.cw = inLove;
    }

    public int gZ() {
        return this.cw;
    }

    public @Nullable EntityPlayer ha() {
        return EntityReference.a(this.cx, this.ao(), EntityPlayer.class);
    }

    public boolean hb() {
        return this.cw > 0;
    }

    public void hc() {
        this.cw = 0;
    }

    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal.getClass() == this.getClass() && this.hb() && otherAnimal.hb();
    }

    public void a(WorldServer level, EntityAnimal partner) {
        EntityAgeable breedOffspring = this.a(level, (EntityAgeable)partner);
        if (breedOffspring != null) {
            breedOffspring.a_(true);
            breedOffspring.b(this.dP(), this.dR(), this.dV(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.ha()).or(() -> Optional.ofNullable(partner.ha())).orElse(null);
            int experience = this.ep().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(breedOffspring, this, partner, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                this.hc();
                partner.hc();
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(level, partner, breedOffspring, experience);
            level.addFreshEntityWithPassengers(breedOffspring, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer level, EntityAnimal animal, @Nullable EntityAgeable baby) {
        this.finalizeSpawnChildFromBreeding(level, animal, baby, this.ep().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer level, EntityAnimal animal, @Nullable EntityAgeable baby, int experience) {
        EntityPlayer player = this.ha();
        if (player == null) {
            player = animal.ha();
        }
        if (player != null) {
            player.a(StatisticList.R);
            CriterionTriggers.p.a(player, this, animal, baby);
        }
        this.d_(6000);
        animal.d_(6000);
        this.hc();
        animal.hc();
        level.a((Entity)this, (byte)18);
        if (experience > 0 && level.U().a(GameRules.D).booleanValue()) {
            level.b(new EntityExperienceOrb(level, this.dI(), Vec3D.c, experience, ExperienceOrb.SpawnReason.BREED, player, baby));
        }
    }

    @Override
    public void b(byte id) {
        if (id == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d2 = this.as.k() * 0.02;
                double d1 = this.as.k() * 0.02;
                double d22 = this.as.k() * 0.02;
                this.ao().a(Particles.T, this.e(1.0), this.dS() + 0.5, this.h(1.0), d2, d1, d22);
            }
        } else {
            super.b(id);
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection motionDirection = this.dh();
        if (motionDirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] ints = DismountUtil.a(motionDirection);
        BlockPosition blockPos = this.dK();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (EntityPose pose : passenger.go()) {
            AxisAlignedBB localBoundsForPose = passenger.f(pose);
            for (int[] ints1 : ints) {
                mutableBlockPos.d(blockPos.u() + ints1[0], blockPos.v(), blockPos.w() + ints1[1]);
                double blockFloorHeight = this.ao().m(mutableBlockPos);
                if (!DismountUtil.a(blockFloorHeight)) continue;
                Vec3D vec3 = Vec3D.a(mutableBlockPos, blockFloorHeight);
                if (!DismountUtil.a(this.ao(), passenger, localBoundsForPose.c(vec3))) continue;
                passenger.c(pose);
                return vec3;
            }
        }
        return super.b(passenger);
    }
}

