/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.allay;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.jspecify.annotations.Nullable;

public class Allay
extends EntityCreature
implements InventoryCarrier,
VibrationSystem {
    private static final BaseBlockPosition e = new BaseBlockPosition(1, 1, 1);
    private static final int cv = 5;
    private static final float cw = 55.0f;
    private static final float cx = 15.0f;
    private static final int cy = 0;
    private static final int cz = 6000;
    private static final int cA = 3;
    public static final int a = 1024;
    private static final DataWatcherObject<Boolean> cB = DataWatcher.a(Allay.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cC = DataWatcher.a(Allay.class, DataWatcherRegistry.k);
    protected static final ImmutableList<SensorType<? extends Sensor<? super Allay>>> b = ImmutableList.of(SensorType.c, SensorType.d, SensorType.f, SensorType.b);
    protected static final ImmutableList<MemoryModuleType<?>> c = ImmutableList.of(MemoryModuleType.u, MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.y, MemoryModuleType.M, MemoryModuleType.aX, MemoryModuleType.aY, MemoryModuleType.aZ, MemoryModuleType.ba, MemoryModuleType.aa, (Object[])new MemoryModuleType[0]);
    public static final ImmutableList<Float> d = ImmutableList.of((Object)Float.valueOf(0.5625f), (Object)Float.valueOf(0.625f), (Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.9375f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.125f), (Object)Float.valueOf(1.25f), (Object)Float.valueOf(1.5f), (Object)Float.valueOf(1.875f), (Object)Float.valueOf(2.0f), (Object)Float.valueOf(2.25f), (Object[])new Float[]{Float.valueOf(2.5f), Float.valueOf(3.0f), Float.valueOf(3.75f), Float.valueOf(4.0f)});
    private final DynamicGameEventListener<VibrationSystem.b> cD;
    private VibrationSystem.a cE;
    private final VibrationSystem.d cF;
    private final DynamicGameEventListener<a> cG;
    private final InventorySubcontainer cH = new InventorySubcontainer(1);
    public @Nullable BlockPosition cI;
    public long cJ = 0L;
    private float cK;
    private float cL;
    private float cM;
    private float cN;
    private float cO;
    public boolean forceDancing = false;

    public Allay(EntityTypes<? extends Allay> type, World level) {
        super((EntityTypes<? extends EntityCreature>)type, level);
        this.cp = new ControllerMoveFlying(this, 20, true);
        this.b_(this.gn());
        this.cF = new b();
        this.cE = new VibrationSystem.a();
        this.cD = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
        this.cG = new DynamicGameEventListener<a>(new a(this.cF.b(), GameEvent.E.a().a()));
    }

    public void setCanDuplicate(boolean canDuplicate) {
        this.az.a(cC, canDuplicate);
    }

    protected BehaviorController.b<Allay> ew() {
        return BehaviorController.a(c, b);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AllayAi.a(this.ew().a(dynamic));
    }

    public BehaviorController<Allay> ev() {
        return super.ev();
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.E().a(GenericAttributes.u, 20.0).a(GenericAttributes.n, 0.1f).a(GenericAttributes.x, 0.1f).a(GenericAttributes.d, 2.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        NavigationFlying flyingPathNavigation = new NavigationFlying(this, level);
        flyingPathNavigation.e(false);
        flyingPathNavigation.a(true);
        flyingPathNavigation.a(48.0f);
        return flyingPathNavigation;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cB, false);
        builder.a(cC, true);
    }

    @Override
    public void m(Vec3D travelVector) {
        this.a(travelVector, this.fM());
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        return !this.H(damageSource.d()) && super.a(level, damageSource, amount);
    }

    @Override
    protected boolean u(Entity entity) {
        return this.H(entity) || super.u(entity);
    }

    private boolean H(@Nullable Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            return false;
        }
        EntityHuman player = (EntityHuman)entity;
        Optional<UUID> memory = this.ev().c(MemoryModuleType.aX);
        return memory.isPresent() && player.cY().equals(memory.get());
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public SoundEffect W() {
        return this.d(EnumItemSlot.a) ? SoundEffects.a : SoundEffects.b;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.d;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.c;
    }

    @Override
    public float fC() {
        return 0.4f;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("allayBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        profilerFiller.a("allayActivityUpdate");
        AllayAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void d_() {
        super.d_();
        if (!this.ao().B_() && this.cb() && this.at % 10 == 0) {
            this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
        }
        if (this.gQ() && this.gV() && this.at % 20 == 0) {
            this.x(false);
            this.cI = null;
        }
        this.gW();
    }

    @Override
    public void g() {
        super.g();
        if (this.ao().B_()) {
            this.cL = this.cK;
            this.cK = this.p() ? MathHelper.a(this.cK + 1.0f, 0.0f, 5.0f) : MathHelper.a(this.cK - 1.0f, 0.0f, 5.0f);
            if (this.gQ()) {
                this.cM += 1.0f;
                this.cO = this.cN;
                this.cN = this.gR() ? (this.cN += 1.0f) : (this.cN -= 1.0f);
                this.cN = MathHelper.a(this.cN, 0.0f, 15.0f);
            } else {
                this.cM = 0.0f;
                this.cN = 0.0f;
                this.cO = 0.0f;
            }
        } else {
            VibrationSystem.c.a(this.ao(), this.cE, this.cF);
            if (this.gM()) {
                this.x(false);
            }
        }
    }

    @Override
    public boolean gn() {
        return !this.gU() && this.p();
    }

    public boolean p() {
        return !this.b(EnumHand.a).f();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return false;
    }

    private boolean gU() {
        return this.ev().a(MemoryModuleType.ba, MemoryStatus.a);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        ItemStack itemInHand1 = this.b(EnumHand.a);
        if (this.gQ() && itemInHand.a(TagsItem.ax) && this.gZ()) {
            Allay allay = this.duplicateAllay();
            if (allay == null) {
                return EnumInteractionResult.a;
            }
            this.ao().a((Entity)this, (byte)18);
            this.ao().a((Entity)player, this, SoundEffects.E, SoundCategory.g, 2.0f, 1.0f);
            this.a(player, itemInHand);
            return EnumInteractionResult.a;
        }
        if (itemInHand1.f() && !itemInHand.f()) {
            ItemStack itemStack = itemInHand.c(1);
            this.a(EnumHand.a, itemStack);
            this.a(player, itemInHand);
            this.ao().a((Entity)player, this, SoundEffects.e, SoundCategory.g, 2.0f, 1.0f);
            this.ev().a(MemoryModuleType.aX, player.cY());
            return EnumInteractionResult.a;
        }
        if (!itemInHand1.f() && hand == EnumHand.a && itemInHand.f()) {
            this.a(EnumItemSlot.a, ItemStack.l);
            this.ao().a((Entity)player, this, SoundEffects.f, SoundCategory.g, 2.0f, 1.0f);
            this.a(EnumHand.a);
            for (ItemStack itemStack1 : this.gP().g()) {
                BehaviorUtil.a((EntityLiving)this, itemStack1, this.dI());
            }
            this.ev().b(MemoryModuleType.aX);
            player.h(itemInHand1);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    public void b(BlockPosition jukeboxPos, boolean jukeboxPlaying) {
        if (jukeboxPlaying) {
            if (!this.gQ()) {
                this.cI = jukeboxPos;
                this.x(true);
            }
        } else if (jukeboxPos.equals(this.cI) || this.cI == null) {
            this.cI = null;
            this.x(false);
        }
    }

    @Override
    public InventorySubcontainer gP() {
        return this.cH;
    }

    @Override
    protected BaseBlockPosition Z() {
        return e;
    }

    @Override
    public boolean c(WorldServer level, ItemStack stack) {
        ItemStack itemInHand = this.b(EnumHand.a);
        return !itemInHand.f() && level.U().a(GameRules.F) != false && this.cH.c(stack) && this.c(itemInHand, stack);
    }

    private boolean c(ItemStack first, ItemStack second) {
        return ItemStack.b(first, second) && !this.d(first, second);
    }

    private boolean d(ItemStack first, ItemStack second) {
        PotionContents potionContents1;
        PotionContents potionContents = first.a(DataComponents.Y);
        return !Objects.equals(potionContents, potionContents1 = second.a(DataComponents.Y));
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        InventoryCarrier.a(level, this, this, entity);
    }

    @Override
    public boolean bp() {
        return !this.aV();
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> listenerConsumer) {
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            listenerConsumer.accept(this.cD, serverLevel);
            listenerConsumer.accept(this.cG, serverLevel);
        }
    }

    public boolean gQ() {
        return this.az.a(cB);
    }

    public void x(boolean dancing) {
        if (!(this.ao().B_() || !this.dy() || dancing && this.gM())) {
            this.az.a(cB, dancing);
        }
    }

    private boolean gV() {
        if (this.forceDancing) {
            return false;
        }
        return this.cI == null || !this.cI.a(this.dI(), (double)GameEvent.E.a().a()) || !this.ao().a_(this.cI).a(Blocks.ew);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cL, this.cK) / 5.0f;
    }

    public boolean gR() {
        float f2 = this.cM % 55.0f;
        return f2 < 15.0f;
    }

    public float M(float partialTick) {
        return MathHelper.h(partialTick, this.cO, this.cN) / 15.0f;
    }

    @Override
    public boolean a(ItemStack oldItem, ItemStack newItem) {
        return !this.c(oldItem, newItem);
    }

    @Override
    protected void g(WorldServer level) {
        super.g(level);
        this.cH.g().forEach(stack -> this.a(level, (ItemStack)stack));
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        if (!itemBySlot.f() && !EnchantmentManager.a(itemBySlot, EnchantmentEffectComponents.E)) {
            this.a(level, itemBySlot);
            this.a(EnumItemSlot.a, ItemStack.l);
        }
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        this.a_(output);
        output.a("listener", VibrationSystem.a.a, this.cE);
        output.a("DuplicationCooldown", this.cJ);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a_(input);
        this.cE = input.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
        this.a(input.a("DuplicationCooldown", 0L));
    }

    @Override
    protected boolean gN() {
        return false;
    }

    private void gW() {
        if (!this.ao().B_() && this.cJ > 0L) {
            this.a(this.cJ - 1L);
        }
    }

    private void a(long duplicationCooldown) {
        this.cJ = duplicationCooldown;
        this.az.a(cC, duplicationCooldown == 0L);
    }

    public @Nullable Allay duplicateAllay() {
        Allay allay = EntityTypes.e.a(this.ao(), EntitySpawnReason.e);
        if (allay != null) {
            allay.f(this.dI());
            allay.gz();
            allay.gY();
            this.gY();
            this.ao().addFreshEntity(allay, CreatureSpawnEvent.SpawnReason.DUPLICATION);
        }
        return allay;
    }

    public void gY() {
        this.a(6000L);
    }

    public boolean gZ() {
        return this.az.a(cC);
    }

    private void a(EntityHuman player, ItemStack stack) {
        stack.a(1, (EntityLiving)player);
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, (double)this.dk() * 0.6, (double)this.dF() * 0.1);
    }

    @Override
    public void b(byte id) {
        if (id == 18) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.ha();
            }
        } else {
            super.b(id);
        }
    }

    private void ha() {
        double d2 = this.as.k() * 0.02;
        double d1 = this.as.k() * 0.02;
        double d22 = this.as.k() * 0.02;
        this.ao().a(Particles.T, this.e(1.0), this.dS() + 0.5, this.h(1.0), d2, d1, d22);
    }

    @Override
    public VibrationSystem.a gS() {
        return this.cE;
    }

    @Override
    public VibrationSystem.d gT() {
        return this.cF;
    }

    class b
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        b() {
            this.c = new EntityPositionSource(Allay.this, Allay.this.dk());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            if (Allay.this.gG()) {
                return false;
            }
            Optional<GlobalPos> memory = Allay.this.ev().c(MemoryModuleType.aY);
            if (memory.isEmpty()) {
                return true;
            }
            GlobalPos globalPos = memory.get();
            return globalPos.a(level.aq(), Allay.this.dK(), 1024) && globalPos.b().equals(pos);
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (gameEvent.a(GameEvent.H)) {
                AllayAi.a(Allay.this, new BlockPosition(pos));
            }
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.e;
        }
    }

    class a
    implements GameEventListener {
        private final PositionSource b;
        private final int c;

        public a(PositionSource listenerSource, int listenerRadius) {
            this.b = listenerSource;
            this.c = listenerRadius;
        }

        @Override
        public PositionSource a() {
            return this.b;
        }

        @Override
        public int b() {
            return this.c;
        }

        @Override
        public boolean a(WorldServer level, Holder<GameEvent> gameEvent, GameEvent.a context, Vec3D pos) {
            if (gameEvent.a(GameEvent.E)) {
                Allay.this.b(BlockPosition.a(pos), true);
                return true;
            }
            if (gameEvent.a(GameEvent.F)) {
                Allay.this.b(BlockPosition.a(pos), false);
                return true;
            }
            return false;
        }
    }
}

