/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.armadillo;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.armadillo.ArmadilloAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jspecify.annotations.Nullable;

public class Armadillo
extends EntityAnimal {
    public static final float cv = 0.6f;
    public static final float cw = 32.5f;
    public static final int cx = 80;
    private static final double cC = 7.0;
    private static final double cD = 2.0;
    private static final DataWatcherObject<a> cE = DataWatcher.a(Armadillo.class, DataWatcherRegistry.F);
    private long cF = 0L;
    public final AnimationState cz = new AnimationState();
    public final AnimationState cA = new AnimationState();
    public final AnimationState cB = new AnimationState();
    private int cG;
    private boolean cH = false;

    public Armadillo(EntityTypes<? extends EntityAnimal> type, World level) {
        super(type, level);
        this.N().a(true);
        this.cG = this.hd();
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.g.a(level, EntitySpawnReason.e);
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 12.0).a(GenericAttributes.x, 0.14);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cE, net.minecraft.world.entity.animal.armadillo.Armadillo$a.a);
    }

    public boolean gP() {
        return this.az.a(cE) != net.minecraft.world.entity.animal.armadillo.Armadillo$a.a;
    }

    public boolean gQ() {
        return this.gS().a(this.cF);
    }

    public boolean gR() {
        return this.gS() == net.minecraft.world.entity.animal.armadillo.Armadillo$a.b && this.cF > (long)net.minecraft.world.entity.animal.armadillo.Armadillo$a.b.b();
    }

    public a gS() {
        return this.az.a(cE);
    }

    public void a(a state) {
        this.az.a(cE, state);
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (cE.equals(key)) {
            this.cF = 0L;
        }
        super.a(key);
    }

    protected BehaviorController.b<Armadillo> ew() {
        return ArmadilloAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return ArmadilloAi.a(this.ew().a(dynamic));
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("armadilloBrain");
        this.ca.a(level, this);
        profilerFiller.c();
        profilerFiller.a("armadilloActivityUpdate");
        ArmadilloAi.a(this);
        profilerFiller.c();
        if (this.cb() && --this.cG <= 0 && this.e(level)) {
            this.forceDrops = true;
            if (this.a(level, LootTables.aJ, this::a)) {
                this.a(SoundEffects.ak, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                this.c(GameEvent.t);
            }
            this.forceDrops = false;
            this.cG = this.hd();
        }
        super.a(level);
    }

    private int hd() {
        return this.as.a(20 * TimeRange.e * 5) + 20 * TimeRange.e * 5;
    }

    @Override
    public void g() {
        super.g();
        if (this.ao().B_()) {
            this.he();
        }
        if (this.gP()) {
            this.af();
        }
        ++this.cF;
    }

    @Override
    public float eE() {
        return this.e_() ? 0.6f : 1.0f;
    }

    private void he() {
        switch (this.gS().ordinal()) {
            case 0: {
                this.cz.a();
                this.cA.a();
                this.cB.a();
                break;
            }
            case 1: {
                this.cz.a();
                this.cA.b(this.at);
                this.cB.a();
                break;
            }
            case 2: {
                this.cz.a();
                this.cA.a();
                if (this.cH) {
                    this.cB.a();
                    this.cH = false;
                }
                if (this.cF == 0L) {
                    this.cB.a(this.at);
                    this.cB.a(net.minecraft.world.entity.animal.armadillo.Armadillo$a.c.b(), 1.0f);
                    break;
                }
                this.cB.b(this.at);
                break;
            }
            case 3: {
                this.cz.b(this.at);
                this.cA.a();
                this.cB.a();
            }
        }
    }

    @Override
    public void b(byte id) {
        if (id == 64 && this.ao().B_()) {
            this.cH = true;
            this.ao().a(this.dP(), this.dR(), this.dV(), SoundEffects.am, this.dB(), 1.0f, 1.0f, false);
        } else {
            super.b(id);
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aR);
    }

    public static boolean c(EntityTypes<Armadillo> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cm) && Armadillo.a(level, pos);
    }

    public boolean i(EntityLiving entity) {
        EntityHuman player;
        return this.dj().c(7.0, 2.0, 7.0).c(entity.dj()) && (entity.ay().a(TagsEntity.d) || this.eK() == entity || entity instanceof EntityHuman && !(player = (EntityHuman)entity).au() && (player.cA() || player.cq()));
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("state", net.minecraft.world.entity.animal.armadillo.Armadillo$a.f, this.gS());
        output.a("scute_time", this.cG);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("state", net.minecraft.world.entity.animal.armadillo.Armadillo$a.f).orElse(net.minecraft.world.entity.animal.armadillo.Armadillo$a.a));
        input.e("scute_time").ifPresent(integer -> {
            this.cG = integer;
        });
    }

    public void gT() {
        if (!this.gP()) {
            this.X();
            this.hc();
            this.c(GameEvent.u);
            this.b(SoundEffects.ai);
            this.a(net.minecraft.world.entity.animal.armadillo.Armadillo$a.b);
        }
    }

    public void gU() {
        if (this.gP()) {
            this.c(GameEvent.u);
            this.b(SoundEffects.al);
            this.a(net.minecraft.world.entity.animal.armadillo.Armadillo$a.a);
        }
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        if (this.gP()) {
            amount = (amount - 1.0f) / 2.0f;
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        if (!this.gG() && !this.fa()) {
            if (damageSource.d() instanceof EntityLiving) {
                this.ev().a(MemoryModuleType.H, true, 80L);
                if (this.gV()) {
                    this.gT();
                }
            } else if (damageSource.a(DamageTypeTags.G)) {
                this.gU();
            }
        }
        return true;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.Aa) && this.a((Entity)player, itemInHand)) {
            itemInHand.a(16, (EntityLiving)player, hand.a());
            return EnumInteractionResult.a;
        }
        return this.gP() ? EnumInteractionResult.d : super.b(player, hand);
    }

    public boolean a(@Nullable Entity entity, ItemStack stack) {
        if (this.e_()) {
            return false;
        }
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.forceDrops = true;
            this.a(serverLevel, LootTables.aV, entity, stack, this::a);
            this.forceDrops = false;
            this.a(SoundEffects.ao);
            this.c(GameEvent.r);
        }
        return true;
    }

    public boolean gV() {
        return !this.gM() && !this.bB() && !this.S_() && !this.cq() && !this.cr();
    }

    @Override
    public boolean gY() {
        return super.gY() && !this.gP();
    }

    @Override
    public SoundEffect W() {
        return this.gP() ? null : SoundEffects.af;
    }

    @Override
    protected void gX() {
        this.b(SoundEffects.ac);
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.ah;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.gP() ? SoundEffects.ae : SoundEffects.ad;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.ag, 0.15f, 1.0f);
    }

    @Override
    public int ae() {
        return this.gP() ? 0 : 32;
    }

    @Override
    protected EntityAIBodyControl I() {
        return new EntityAIBodyControl(this){

            @Override
            public void a() {
                if (!Armadillo.this.gP()) {
                    super.a();
                }
            }
        };
    }

    public static abstract sealed class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a a = new a("idle", false, 0, 0){

            @Override
            public boolean a(long inStateTicks) {
                return false;
            }
        };
        public static final /* enum */ a b = new a("rolling", true, 10, 1){

            @Override
            public boolean a(long inStateTicks) {
                return inStateTicks > 5L;
            }
        };
        public static final /* enum */ a c = new a("scared", true, 50, 2){

            @Override
            public boolean a(long inStateTicks) {
                return true;
            }
        };
        public static final /* enum */ a d = new a("unrolling", true, 30, 3){

            @Override
            public boolean a(long inStateTicks) {
                return inStateTicks < 26L;
            }
        };
        static final Codec<a> f;
        private static final IntFunction<a> g;
        public static final StreamCodec<ByteBuf, a> e;
        private final String h;
        private final boolean i;
        private final int j;
        private final int k;
        private static final /* synthetic */ a[] l;

        public static a[] values() {
            return (a[])l.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(String name, boolean isThreatened, int animationDuration, int id) {
            this.h = name;
            this.i = isThreatened;
            this.j = animationDuration;
            this.k = id;
        }

        @Override
        public String c() {
            return this.h;
        }

        private int d() {
            return this.k;
        }

        public abstract boolean a(long var1);

        public boolean a() {
            return this.i;
        }

        public int b() {
            return this.j;
        }

        private static /* synthetic */ a[] e() {
            return new a[]{a, b, c, d};
        }

        static {
            l = net.minecraft.world.entity.animal.armadillo.Armadillo$a.e();
            f = INamable.a(a::values);
            g = ByIdMap.a(a::d, net.minecraft.world.entity.animal.armadillo.Armadillo$a.values(), ByIdMap.a.a);
            e = ByteBufCodecs.a(g, a::d);
        }
    }
}

