/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.EasingType;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class Axolotl
extends EntityAnimal
implements Bucketable {
    public static final int cv = 200;
    private static final int cG = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> cw = ImmutableList.of(SensorType.c, SensorType.o, SensorType.f, SensorType.q, SensorType.r);
    protected static final ImmutableList<? extends MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.s, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.o, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.L, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.O, MemoryModuleType.C, MemoryModuleType.P, MemoryModuleType.Q, MemoryModuleType.S, MemoryModuleType.V, MemoryModuleType.aa});
    private static final DataWatcherObject<Integer> cH = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cI = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cJ = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double cz = 20.0;
    public static final int cA = 1200;
    private static final int cK = 6000;
    public static final String cB = "Variant";
    private static final int cL = 1800;
    private static final int cM = 2400;
    private static final boolean cN = false;
    public final BinaryAnimator cC = new BinaryAnimator(10, EasingType.x);
    public final BinaryAnimator cD = new BinaryAnimator(10, EasingType.x);
    public final BinaryAnimator cE = new BinaryAnimator(10, EasingType.x);
    public final BinaryAnimator cF = new BinaryAnimator(10, EasingType.x);
    private static final int cO = 100;

    public Axolotl(EntityTypes<? extends Axolotl> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.a(PathType.j, 0.0f);
        this.cp = new d(this);
        this.co = new c(this, 20);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return 0.0f;
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cH, 0);
        builder.a(cI, false);
        builder.a(cJ, false);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a(cB, Variant.i, this.gP());
        output.a("FromBucket", this.a());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a(cB, Variant.i).orElse(Variant.f));
        this.a(input.a("FromBucket", false));
    }

    @Override
    public void T() {
        if (!this.gQ()) {
            super.T();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        boolean flag = false;
        if (spawnReason == EntitySpawnReason.l) {
            return spawnGroupData;
        }
        RandomSource random = level.G_();
        if (spawnGroupData instanceof b) {
            if (((b)spawnGroupData).a() >= 2) {
                flag = true;
            }
        } else {
            spawnGroupData = new b(Variant.a(random), Variant.a(random));
        }
        this.a(((b)spawnGroupData).a(random));
        if (flag) {
            this.d_(-24000);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public void aJ() {
        World world;
        int airSupply = this.cK();
        super.aJ();
        if (!this.gG() && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.a(serverLevel, airSupply);
        }
        if (this.ao().B_()) {
            this.gS();
        }
    }

    private void gS() {
        a animationState = this.gQ() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.a : (this.by() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.b : (this.aV() ? net.minecraft.world.entity.animal.axolotl.Axolotl$a.c : net.minecraft.world.entity.animal.axolotl.Axolotl$a.d));
        this.cC.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.a);
        this.cD.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.b);
        this.cE.a(animationState == net.minecraft.world.entity.animal.axolotl.Axolotl$a.c);
        boolean flag = this.bB.d() || this.ee() != this.ac || this.ec() != this.ab;
        this.cF.a(flag);
    }

    protected void a(WorldServer level, int airSupply) {
        if (this.cb() && !this.bA()) {
            this.j(airSupply - 1);
            if (this.eA()) {
                this.j(0);
                this.a(level, this.en().t(), 2.0f);
            }
        } else {
            this.j(this.cJ());
        }
    }

    public void p() {
        int i2 = this.cK() + 1800;
        this.j(Math.min(i2, this.cJ()));
    }

    @Override
    public int cJ() {
        return this.maxAirTicks;
    }

    public Variant gP() {
        return Variant.a(this.az.a(cH));
    }

    public void a(Variant variant) {
        this.az.a(cH, variant.a());
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aW ? Axolotl.c(component, this.gP()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aW);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aW) {
            this.a(Axolotl.c(DataComponents.aW, value));
            return true;
        }
        return super.b(component, value);
    }

    private static boolean a(RandomSource random) {
        return random.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader level) {
        return level.f(this);
    }

    @Override
    public boolean db() {
        return false;
    }

    public void x(boolean playingDead) {
        this.az.a(cI, playingDead);
    }

    public boolean gQ() {
        return this.az.a(cI);
    }

    @Override
    public boolean a() {
        return this.az.a(cJ);
    }

    @Override
    public void a(boolean fromBucket) {
        this.az.a(cJ, fromBucket);
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        Axolotl axolotl = EntityTypes.j.a(level, EntitySpawnReason.e);
        if (axolotl != null) {
            Variant rareSpawnVariant = Axolotl.a(this.as) ? Variant.b(this.as) : (this.as.h() ? this.gP() : ((Axolotl)partner).gP());
            axolotl.a(rareSpawnVariant);
            axolotl.gz();
        }
        return axolotl;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.bh);
    }

    @Override
    public boolean aj_() {
        return true;
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("axolotlBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        profilerFiller.a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        profilerFiller.c();
        if (!this.gG()) {
            Optional<Integer> memory = this.ev().c(MemoryModuleType.O);
            this.x(memory.isPresent() && memory.get() > 0);
        }
    }

    public static AttributeProvider.Builder gR() {
        return EntityAnimal.gW().a(GenericAttributes.u, 14.0).a(GenericAttributes.x, 1.0).a(GenericAttributes.d, 2.0).a(GenericAttributes.D, 1.0);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new AmphibiousPathNavigation(this, level);
    }

    @Override
    public void fN() {
        this.a(SoundEffects.aN, 1.0f, 1.0f);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        float health = this.eZ();
        if (!this.gG() && this.ao().y.a(3) == 0 && ((float)this.ao().y.a(3) < amount || health / this.fq() < 0.5f) && amount < health && this.by() && (damageSource.d() != null || damageSource.c() != null) && !this.gQ()) {
            this.ca.a(MemoryModuleType.O, 200);
        }
        return super.a(level, damageSource, amount);
    }

    @Override
    public int ac() {
        return 1;
    }

    @Override
    public int ae() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void a(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        stack.a(DataComponents.aW, (DataComponentGetter)this);
        CustomData.a(DataComponents.ag, stack, (NBTTagCompound tag) -> {
            tag.a("Age", this.Z_());
            BehaviorController<Axolotl> brain = this.ev();
            if (brain.a(MemoryModuleType.V)) {
                tag.a("HuntingCooldown", brain.e(MemoryModuleType.V));
            }
        });
    }

    @Override
    public void a(NBTTagCompound tag) {
        Bucketable.a((EntityInsentient)this, tag);
        this.d_(tag.b("Age", 0));
        tag.f("HuntingCooldown").ifPresentOrElse(_long -> this.ev().a(MemoryModuleType.V, true, tag.b("HuntingCooldown", 0L)), () -> this.ev().a(MemoryModuleType.V, Optional.empty()));
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.sv);
    }

    @Override
    public SoundEffect c() {
        return SoundEffects.dw;
    }

    @Override
    public boolean eS() {
        return !this.gQ() && super.eS();
    }

    public static void a(WorldServer level, Axolotl axolotl, EntityLiving target) {
        Entity entity;
        DamageSource lastDamageSource;
        if (target.fa() && (lastDamageSource = target.fb()) != null && (entity = lastDamageSource.d()) != null && entity.ay() == EntityTypes.cb) {
            EntityHuman player = (EntityHuman)entity;
            List<EntityHuman> entitiesOfClass = level.a(EntityHuman.class, axolotl.dj().g(20.0));
            if (entitiesOfClass.contains(player)) {
                axolotl.g(player);
            }
        }
    }

    public void g(EntityHuman player) {
        MobEffect effect = player.e(MobEffects.j);
        if (effect == null || effect.a(2399)) {
            int i2 = effect != null ? effect.d() : 0;
            int min = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, min, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.removeEffect(MobEffects.d, EntityPotionEffectEvent.Cause.AXOLOTL);
    }

    @Override
    public boolean ab() {
        return super.ab() || this.a();
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.aP;
    }

    @Override
    public @Nullable SoundEffect fd() {
        return SoundEffects.aO;
    }

    @Override
    public @Nullable SoundEffect W() {
        return this.by() ? SoundEffects.aR : SoundEffects.aQ;
    }

    @Override
    public SoundEffect bl() {
        return SoundEffects.aS;
    }

    @Override
    public SoundEffect bk() {
        return SoundEffects.aT;
    }

    protected BehaviorController.b<Axolotl> ew() {
        return BehaviorController.a(cx, cw);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.ew().a(dynamic));
    }

    public BehaviorController<Axolotl> ev() {
        return super.ev();
    }

    @Override
    protected void a(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        this.a(this.fM(), travelVector);
        this.a(EnumMoveType.a, this.dN());
        this.k(this.dN().c(0.9));
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.su)) {
            player.a(hand, ItemLiquidUtil.a(stack, player, new ItemStack(Items.sl)));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return !this.a() && !this.i_();
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> entityType, WorldAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cn);
    }

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public d(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.gQ()) {
                super.a();
            }
        }
    }

    class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl mob, int maxYRotFromCenter) {
            super(mob, maxYRotFromCenter);
        }

        @Override
        public void a() {
            if (!Axolotl.this.gQ()) {
                super.a();
            }
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant a = new Variant(0, "lucy", true);
        public static final /* enum */ Variant b = new Variant(1, "wild", true);
        public static final /* enum */ Variant c = new Variant(2, "gold", true);
        public static final /* enum */ Variant d = new Variant(3, "cyan", true);
        public static final /* enum */ Variant e = new Variant(4, "blue", false);
        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final StreamCodec<ByteBuf, Variant> g;
        public static final Codec<Variant> h;
        @Deprecated
        public static final Codec<Variant> i;
        private final int k;
        private final String l;
        private final boolean m;
        private static final /* synthetic */ Variant[] n;

        public static Variant[] values() {
            return (Variant[])n.clone();
        }

        public static Variant valueOf(String name) {
            return Enum.valueOf(Variant.class, name);
        }

        private Variant(int id, String name, boolean common) {
            this.k = id;
            this.l = name;
            this.m = common;
        }

        public int a() {
            return this.k;
        }

        public String b() {
            return this.l;
        }

        @Override
        public String c() {
            return this.l;
        }

        public static Variant a(int id) {
            return j.apply(id);
        }

        public static Variant a(RandomSource random) {
            return Variant.a(random, true);
        }

        public static Variant b(RandomSource random) {
            return Variant.a(random, false);
        }

        private static Variant a(RandomSource random, boolean common) {
            Variant[] variants = (Variant[])Arrays.stream(Variant.values()).filter(variant -> variant.m == common).toArray(Variant[]::new);
            return SystemUtils.a(variants, random);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{a, b, c, d, e};
        }

        static {
            n = Variant.d();
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            g = ByteBufCodecs.a(j, Variant::a);
            h = INamable.a(Variant::values);
            i = Codec.INT.xmap(j::apply, Variant::a);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] a;

        public b(Variant ... types) {
            super(false);
            this.a = types;
        }

        public Variant a(RandomSource random) {
            return this.a[random.a(this.a.length)];
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d};
        }

        static {
            e = net.minecraft.world.entity.animal.axolotl.Axolotl$a.a();
        }
    }
}

