/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.camel;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.jspecify.annotations.Nullable;

public class Camel
extends EntityHorseAbstract {
    public static final float cv = 0.45f;
    public static final int cw = 55;
    public static final int cx = 30;
    private static final float cU = 0.1f;
    private static final float cV = 1.4285f;
    private static final float cW = 22.2222f;
    private static final int cX = 5;
    private static final int cY = 40;
    private static final int cZ = 52;
    private static final int da = 80;
    private static final float db = 1.43f;
    private static final long dc = 0L;
    public static final DataWatcherObject<Boolean> cz = DataWatcher.a(Camel.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Long> cA = DataWatcher.a(Camel.class, DataWatcherRegistry.c);
    public final AnimationState cB = new AnimationState();
    public final AnimationState cC = new AnimationState();
    public final AnimationState cD = new AnimationState();
    public final AnimationState cE = new AnimationState();
    public final AnimationState cF = new AnimationState();
    private static final EntitySize dd = EntitySize.b(EntityTypes.v.l(), EntityTypes.v.m() - 1.43f).b(0.845f);
    private int de = 0;
    private int df = 0;

    public Camel(EntityTypes<? extends Camel> type, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, level);
        this.cp = new c();
        this.co = new b();
        Navigation groundPathNavigation = (Navigation)this.N();
        groundPathNavigation.a(true);
        groundPathNavigation.c(true);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("LastPoseTick", this.az.a(cA));
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        long longOr = input.a("LastPoseTick", 0L);
        if (longOr < 0L) {
            this.c(EntityPose.k);
        }
        this.a(longOr);
    }

    public static AttributeProvider.Builder p() {
        return Camel.hx().a(GenericAttributes.u, 32.0).a(GenericAttributes.x, 0.09f).a(GenericAttributes.q, 0.42f).a(GenericAttributes.D, 1.5);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cz, false);
        builder.a(cA, 0L);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        CamelAi.a(this, level.G_());
        this.b(level.a().au());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static boolean c(EntityTypes<Camel> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cx) && Camel.a(level, pos);
    }

    protected BehaviorController.b<Camel> ew() {
        return CamelAi.a();
    }

    @Override
    protected void D() {
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CamelAi.a(this.ew().a(dynamic));
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return pose == EntityPose.k ? dd.a(this.eE()) : super.b(pose);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("camelBrain");
        BehaviorController<?> brain = this.ev();
        brain.a(level, this);
        profilerFiller.c();
        profilerFiller.a("camelActivityUpdate");
        CamelAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.gQ() && this.de < 50 && (this.aV() || this.bB() || this.cq())) {
            this.x(false);
        }
        if (this.de > 0) {
            --this.de;
            if (this.de == 0) {
                this.ao().a(null, this.dK(), this.gS(), SoundCategory.g, 1.0f, 1.0f);
            }
        }
        if (this.ao().B_()) {
            this.hI();
        }
        if (this.gP()) {
            this.af();
        }
        if (this.hd() && this.by()) {
            this.hk();
        }
    }

    private void hI() {
        if (this.df <= 0) {
            this.df = this.as.a(40) + 80;
            this.cE.a(this.at);
        } else {
            --this.df;
        }
        if (this.he()) {
            this.cD.a();
            this.cF.a();
            if (this.hJ()) {
                this.cB.b(this.at);
                this.cC.a();
            } else {
                this.cB.a();
                this.cC.b(this.at);
            }
        } else {
            this.cB.a();
            this.cC.a();
            this.cF.a(this.gQ(), this.at);
            this.cD.a(this.hf() && this.hl() >= 0L, this.at);
        }
    }

    @Override
    protected void B(float partialTick) {
        float min = this.aF() == EntityPose.a && !this.cF.b() ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.bB.a(min, 0.2f, this.e_() ? 3.0f : 1.0f);
    }

    @Override
    public void m(Vec3D travelVector) {
        if (this.gP() && this.aV()) {
            this.k(this.dN().d(0.0, 1.0, 0.0));
            travelVector = travelVector.d(0.0, 1.0, 0.0);
        }
        super.m(travelVector);
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        if (player.bP > 0.0f && this.hd() && !this.hf()) {
            this.hh();
        }
    }

    public boolean gP() {
        return this.hd() || this.hf();
    }

    @Override
    protected float f(EntityHuman player) {
        float f2 = player.cA() && this.c() == 0 ? 0.1f : 0.0f;
        return (float)this.i(GenericAttributes.x) + f2;
    }

    @Override
    protected Vec2F i(EntityLiving entity) {
        return this.gP() ? new Vec2F(this.ee(), this.ec()) : super.i(entity);
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        return this.gP() ? Vec3D.c : super.b(player, travelVector);
    }

    @Override
    public boolean a() {
        return !this.gP() && super.a();
    }

    @Override
    public void a(int jumpPower) {
        if (this.al() && this.de <= 0 && this.aV()) {
            super.a(jumpPower);
        }
    }

    @Override
    public boolean ef() {
        return true;
    }

    @Override
    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.fF();
        this.l(this.cj().d(1.0, 0.0, 1.0).d().c((double)(22.2222f * playerJumpPendingScale) * this.i(GenericAttributes.x) * (double)this.bi()).b(0.0, (double)(1.4285f * playerJumpPendingScale) * d2, 0.0));
        this.de = 55;
        this.x(true);
        this.aF = true;
    }

    public boolean gQ() {
        return this.az.a(cz);
    }

    public void x(boolean dashing) {
        this.az.a(cz, dashing);
    }

    @Override
    public void b(int jumpPower) {
        this.b(this.gR());
        this.c(GameEvent.u);
        this.x(true);
    }

    protected SoundEffect gR() {
        return SoundEffects.dZ;
    }

    protected SoundEffect gS() {
        return SoundEffects.ea;
    }

    @Override
    public void b() {
    }

    @Override
    public int c() {
        return this.de;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.dY;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.eb;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.ed;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (block.a(TagsBlock.bC)) {
            this.a(SoundEffects.ei, 1.0f, 1.0f);
        } else {
            this.a(SoundEffects.eh, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aP);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (player.gA() && !this.e_()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
        if (interactionResult.a()) {
            return interactionResult;
        }
        if (this.j(itemInHand)) {
            return this.c(player, itemInHand);
        }
        if (this.dn().size() < 2 && !this.e_()) {
            this.g(player);
        }
        return EnumInteractionResult.c;
    }

    @Override
    public void v() {
        super.v();
        if (this.hd() && !this.hf() && this.gT()) {
            this.hh();
        }
    }

    @Override
    public Vec3D[] A() {
        return Leashable.a(this, 0.02, 0.48, 0.25, 0.82);
    }

    public boolean gT() {
        return this.g(this.hd() ? EntityPose.a : EntityPose.k);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack stack) {
        SoundEffect eatingSound;
        boolean isBaby;
        boolean flag1;
        boolean flag;
        if (!this.j(stack)) {
            return false;
        }
        boolean bl = flag = this.eZ() < this.fq();
        if (flag) {
            this.heal(2.0f, EntityRegainHealthEvent.RegainReason.EATING);
        }
        boolean bl2 = flag1 = this.hn() && this.Z_() == 0 && this.gY();
        if (flag1) {
            this.setInLove(player, stack.v());
        }
        if (isBaby = this.e_()) {
            this.ao().a(Particles.R, this.e(1.0), this.dS() + 0.5, this.h(1.0), 0.0, 0.0, 0.0);
            if (!this.ao().B_()) {
                this.c_(10);
            }
        }
        if (!(flag || flag1 || isBaby)) {
            return false;
        }
        if (!this.bq() && (eatingSound = this.gV()) != null) {
            this.ao().a(null, this.dP(), this.dR(), this.dV(), eatingSound, this.dB(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
        this.c(GameEvent.m);
        return true;
    }

    @Override
    protected boolean gU() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(EntityAnimal partner) {
        if (partner == this) return false;
        if (!(partner instanceof Camel)) return false;
        Camel camel = (Camel)partner;
        if (!this.hF()) return false;
        if (!camel.hF()) return false;
        return true;
    }

    public @Nullable Camel b(WorldServer level, EntityAgeable partner) {
        return EntityTypes.v.a(level, EntitySpawnReason.e);
    }

    @Override
    protected SoundEffect gV() {
        return SoundEffects.ec;
    }

    @Override
    public boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.hk();
        return true;
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        int max = Math.max(this.dn().indexOf(entity), 0);
        boolean flag = max == 0;
        float f2 = 0.5f;
        float f1 = (float)(this.eh() ? (double)0.01f : this.a(flag, 0.0f, dimensions, partialTick));
        if (this.dn().size() > 1) {
            if (!flag) {
                f2 = -0.7f;
            }
            if (entity instanceof EntityAnimal) {
                f2 += 0.2f;
            }
        }
        return new Vec3D(0.0, f1, f2 * partialTick).b(-this.ec() * ((float)Math.PI / 180));
    }

    @Override
    public float eE() {
        return this.e_() ? 0.45f : 1.0f;
    }

    private double a(boolean firstPassenger, float partialTick, EntitySize dimensions, float scale) {
        double d2 = dimensions.b() - 0.375f * scale;
        float f2 = scale * 1.43f;
        float f1 = f2 - scale * 0.2f;
        float f22 = f2 - f1;
        boolean isInPoseTransition = this.hf();
        boolean isCamelSitting = this.hd();
        if (isInPoseTransition) {
            float f3;
            int i1;
            int i2;
            int n2 = i2 = isCamelSitting ? 40 : 52;
            if (isCamelSitting) {
                i1 = 28;
                f3 = firstPassenger ? 0.5f : 0.1f;
            } else {
                i1 = firstPassenger ? 24 : 32;
                f3 = firstPassenger ? 0.6f : 0.35f;
            }
            float f4 = MathHelper.a((float)this.hl() + partialTick, 0.0f, (float)i2);
            boolean flag = f4 < (float)i1;
            float f5 = flag ? f4 / (float)i1 : (f4 - (float)i1) / (float)(i2 - i1);
            float f6 = f2 - f3 * f1;
            d2 += isCamelSitting ? (double)MathHelper.h(f5, flag ? f2 : f6, flag ? f6 : f22) : (double)MathHelper.h(f5, flag ? f22 - f2 : f22 - f6, flag ? f22 - f6 : 0.0f);
        }
        if (isCamelSitting && !isInPoseTransition) {
            d2 += (double)f22;
        }
        return d2;
    }

    @Override
    public Vec3D a_(float partialTick) {
        EntitySize dimensions = this.a(this.aF());
        float ageScale = this.eE();
        return new Vec3D(0.0, this.a(true, partialTick, dimensions, ageScale) - (double)(0.2f * ageScale), dimensions.a() * 0.56f);
    }

    @Override
    public int ae() {
        return 30;
    }

    @Override
    protected boolean s(Entity passenger) {
        return this.dn().size() <= 2;
    }

    public boolean hd() {
        return this.az.a(cA) < 0L;
    }

    public boolean he() {
        return this.hl() < 0L != this.hd();
    }

    public boolean hf() {
        long poseTime = this.hl();
        return poseTime < (long)(this.hd() ? 40 : 52);
    }

    private boolean hJ() {
        return this.hd() && this.hl() < 40L && this.hl() >= 0L;
    }

    public void hg() {
        if (!this.hd() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), true).callEvent()) {
            this.b(this.hj());
            this.c(EntityPose.k);
            this.c(GameEvent.u);
            this.a(-this.ao().au());
        }
    }

    public void hh() {
        if (this.hd() && new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            this.b(this.hi());
            this.c(EntityPose.a);
            this.c(GameEvent.u);
            this.a(this.ao().au());
        }
    }

    protected SoundEffect hi() {
        return SoundEffects.eg;
    }

    protected SoundEffect hj() {
        return SoundEffects.ef;
    }

    public void hk() {
        if (this.hd() && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), false).callEvent()) {
            return;
        }
        this.c(EntityPose.a);
        this.c(GameEvent.u);
        this.b(this.ao().au());
    }

    @VisibleForTesting
    public void a(long lastPoseChangeTick) {
        this.az.a(cA, lastPoseChangeTick);
    }

    private void b(long lastPoseChangedTick) {
        this.a(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public long hl() {
        return this.ao().au() - Math.abs(this.az.a(cA));
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? this.hm() : super.a(slot, stack, equippable);
    }

    protected Holder.c<SoundEffect> hm() {
        return SoundEffects.ee;
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (!this.ay && cz.equals(key)) {
            this.de = this.de == 0 ? 55 : this.de;
        }
        super.a(key);
    }

    @Override
    public boolean hn() {
        return true;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.ao().B_()) {
            player.a(this, (IInventory)this.cM);
        }
    }

    @Override
    protected EntityAIBodyControl I() {
        return new a(this);
    }

    class c
    extends ControllerMove {
        public c() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && !Camel.this.S_() && Camel.this.hd() && !Camel.this.hf() && Camel.this.gT()) {
                Camel.this.hh();
            }
            super.a();
        }
    }

    class b
    extends ControllerLook {
        b() {
            super(Camel.this);
        }

        @Override
        public void a() {
            if (!Camel.this.dm()) {
                super.a();
            }
        }
    }

    class a
    extends EntityAIBodyControl {
        public a(Camel mob) {
            super(mob);
        }

        @Override
        public void a() {
            if (!Camel.this.gP()) {
                super.a();
            }
        }
    }
}

