/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.chicken;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.chicken.ChickenVariants;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityChicken
extends EntityAnimal {
    private static final EntitySize cD = EntityTypes.C.n().a(0.5f).b(0.2975f);
    private static final DataWatcherObject<Holder<ChickenVariant>> cE = DataWatcher.a(EntityChicken.class, DataWatcherRegistry.x);
    private static final boolean cF = false;
    public float cv;
    public float cw;
    public float cx;
    public float cz;
    public float cA = 1.0f;
    private float cG = 1.0f;
    public int cB = this.as.a(6000) + 6000;
    public boolean cC = false;

    public EntityChicken(EntityTypes<? extends EntityChicken> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.a(PathType.j, 0.0f);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 1.4));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.0, itemStack -> itemStack.a(TagsItem.aS), false));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cD : super.b(pose);
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 4.0).a(GenericAttributes.x, 0.25);
    }

    @Override
    public void d_() {
        super.d_();
        this.cz = this.cv;
        this.cx = this.cw;
        this.cw += (this.aV() ? -1.0f : 4.0f) * 0.3f;
        this.cw = MathHelper.a(this.cw, 0.0f, 1.0f);
        if (!this.aV() && this.cA < 1.0f) {
            this.cA = 1.0f;
        }
        this.cA *= 0.9f;
        Vec3D deltaMovement = this.dN();
        if (!this.aV() && deltaMovement.h < 0.0) {
            this.k(deltaMovement.d(1.0, 0.6, 1.0));
        }
        this.cv += this.cA * 2.0f;
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.cb() && !this.e_() && !this.gQ() && --this.cB <= 0) {
                this.forceDrops = true;
                if (this.a(serverLevel, LootTables.aI, this::a)) {
                    this.a(SoundEffects.fu, 1.0f, (this.as.i() - this.as.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.t);
                }
                this.forceDrops = false;
                this.cB = this.as.a(6000) + 6000;
            }
        }
    }

    @Override
    protected boolean bp() {
        return this.am > this.cG;
    }

    @Override
    protected void bo() {
        this.cG = this.am + this.cw / 2.0f;
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.fs;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.fv;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.ft;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.fw, 0.15f, 1.0f);
    }

    public @Nullable EntityChicken b(WorldServer level, EntityAgeable partner) {
        EntityChicken chicken = EntityTypes.C.a(level, EntitySpawnReason.e);
        if (chicken != null && partner instanceof EntityChicken) {
            EntityChicken chicken1 = (EntityChicken)partner;
            chicken.b(this.as.h() ? this.gP() : chicken1.gP());
        }
        return chicken;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        VariantUtils.a(SpawnContext.a(level, this.dK()), Registries.aV).ifPresent(this::b);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aS);
    }

    @Override
    protected int f(WorldServer level) {
        return this.gQ() ? 10 : super.f(level);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cE, VariantUtils.a(this.eo(), ChickenVariants.a));
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.cC = input.a("IsChickenJockey", false);
        input.e("EggLayTime").ifPresent(integer -> {
            this.cB = integer;
        });
        VariantUtils.a(input, Registries.aV).ifPresent(this::b);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsChickenJockey", this.cC);
        output.a("EggLayTime", this.cB);
        VariantUtils.a(output, this.gP());
    }

    public void b(Holder<ChickenVariant> variant) {
        this.az.a(cE, variant);
    }

    public Holder<ChickenVariant> gP() {
        return this.az.a(cE);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aQ ? EntityChicken.c(component, new EitherHolder<ChickenVariant>(this.gP())) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aQ);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aQ) {
            Optional<Holder<ChickenVariant>> optional = EntityChicken.c(DataComponents.aQ, value).a(this.eo());
            if (optional.isPresent()) {
                this.b(optional.get());
                return true;
            }
            return false;
        }
        return super.b(component, value);
    }

    @Override
    public boolean i(double distanceToClosestPlayer) {
        return this.gQ();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).bC = this.bC;
        }
    }

    public boolean gQ() {
        return this.cC;
    }

    public void x(boolean isChickenJockey) {
        this.cC = isChickenJockey;
    }
}

