/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.cow;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public abstract class AbstractCow
extends EntityAnimal {
    private static final EntitySize cv = EntityTypes.G.n().a(0.5f).b(0.665f);

    public AbstractCow(EntityTypes<? extends AbstractCow> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
    }

    @Override
    protected void D() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(1, new PathfinderGoalPanic(this, 2.0));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.25, itemStack -> itemStack.a(TagsItem.aE), false));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.cs.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(7, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aE);
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 10.0).a(GenericAttributes.x, 0.2f);
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.hg;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.hi;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.hh;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.hk, 0.15f, 1.0f);
    }

    @Override
    public float fC() {
        return 0.4f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.sk) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(player.ao(), player, this.dK(), this.dK(), null, itemInHand, Items.sq, hand);
            if (event.isCancelled()) {
                player.cn.b();
                return EnumInteractionResult.e;
            }
            player.a(SoundEffects.hj, 1.0f, 1.0f);
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemStack);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cv : super.b(pose);
    }
}

