/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.cow;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.animal.cow.AbstractCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.jspecify.annotations.Nullable;

public class EntityMushroomCow
extends AbstractCow
implements IShearable {
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityMushroomCow.class, DataWatcherRegistry.b);
    private static final int cw = 1024;
    private static final String cx = "stew_effects";
    public @Nullable SuspiciousStewEffects cz;
    private @Nullable UUID cA;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> type, World level) {
        super((EntityTypes<? extends AbstractCow>)type, level);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        return level.a_(pos.e()).a(Blocks.fU) ? 10.0f : level.C(pos);
    }

    public static boolean c(EntityTypes<EntityMushroomCow> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cp) && EntityMushroomCow.a(level, pos);
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        UUID uuid = lightning.cY();
        if (!uuid.equals(this.cA)) {
            this.a(this.gP() == Type.a ? Type.b : Type.a);
            this.cA = uuid;
            this.a(SoundEffects.rc, 2.0f, 1.0f);
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, Type.c.h);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.pU) && !this.e_()) {
            ItemStack itemStack;
            boolean flag = false;
            if (this.cz != null) {
                flag = true;
                itemStack = new ItemStack(Items.yA);
                itemStack.b(DataComponents.aa, this.cz);
                this.cz = null;
            } else {
                itemStack = new ItemStack(Items.qX);
            }
            ItemStack itemStack1 = ItemLiquidUtil.a(itemInHand, player, itemStack, false);
            player.a(hand, itemStack1);
            SoundEffect soundEvent = flag ? SoundEffects.rf : SoundEffects.re;
            this.a(soundEvent, 1.0f, 1.0f);
            return EnumInteractionResult.a;
        }
        if (itemInHand.a(Items.tZ) && this.a()) {
            World itemStack = this.ao();
            if (itemStack instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)itemStack;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, hand.a());
            }
            return EnumInteractionResult.a;
        }
        if (this.gP() == Type.b) {
            Optional<SuspiciousStewEffects> effectsFromItemStack = this.k(itemInHand);
            if (effectsFromItemStack.isEmpty()) {
                return super.b(player, hand);
            }
            if (this.cz != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.ao().a(Particles.ai, this.dP() + this.as.j() / 2.0, this.f(0.5), this.dV() + this.as.j() / 2.0, 0.0, this.as.j() / 5.0, 0.0);
                }
            } else {
                itemInHand.a(1, (EntityLiving)player);
                SpellParticleOption spellParticleOption = SpellParticleOption.a(Particles.q, -1, 1.0f);
                for (int i1 = 0; i1 < 4; ++i1) {
                    this.ao().a(spellParticleOption, this.dP() + this.as.j() / 2.0, this.f(0.5), this.dV() + this.as.j() / 2.0, 0.0, this.as.j() / 5.0, 0.0);
                }
                this.cz = effectsFromItemStack.get();
                this.a(SoundEffects.rd, 2.0f, 1.0f);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public void a(WorldServer level, SoundCategory source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer level, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(level, LootTables.aX, shears, (arg_0, arg_1) -> EntityMushroomCow.lambda$generateDefaultDrops$0((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory source, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.rg, source, 1.0f, 1.0f);
        this.convertTo(EntityTypes.G, ConversionParams.a(this, false, false), (T cow) -> {
            level.a(Particles.x, this.dP(), this.f(0.5), this.dV(), 1, 0.0, 0.0, 0.0, 0.0);
            drops.forEach(drop -> this.spawnAtLocation(level, new EntityItem(this.ao(), this.dP(), this.f(1.0), this.dV(), (ItemStack)drop)));
        }, EntityTransformEvent.TransformReason.SHEARED, CreatureSpawnEvent.SpawnReason.SHEARED);
    }

    @Override
    public boolean a() {
        return this.cb() && !this.e_();
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Type", Type.d, this.gP());
        output.b(cx, SuspiciousStewEffects.c, this.cz);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.a(input.a("Type", Type.d).orElse(Type.c));
        this.cz = input.a(cx, SuspiciousStewEffects.c).orElse(null);
    }

    private Optional<SuspiciousStewEffects> k(ItemStack stack) {
        SuspiciousEffectHolder suspiciousEffectHolder = SuspiciousEffectHolder.a(stack.h());
        return suspiciousEffectHolder != null ? Optional.of(suspiciousEffectHolder.c()) : Optional.empty();
    }

    public void a(Type variant) {
        this.az.a(cv, variant.h);
    }

    public Type gP() {
        return Type.a(this.az.a(cv));
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aM ? EntityMushroomCow.c(component, this.gP()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aM);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aM) {
            this.a(EntityMushroomCow.c(DataComponents.aM, value));
            return true;
        }
        return super.b(component, value);
    }

    public @Nullable EntityMushroomCow b(WorldServer level, EntityAgeable partner) {
        EntityMushroomCow mushroomCow = EntityTypes.aK.a(level, EntitySpawnReason.e);
        if (mushroomCow != null) {
            mushroomCow.a(this.a((EntityMushroomCow)partner));
        }
        return mushroomCow;
    }

    private Type a(EntityMushroomCow partner) {
        Type variant1;
        Type variant = this.gP();
        Type variant2 = variant == (variant1 = partner.gP()) && this.as.a(1024) == 0 ? (variant == Type.b ? Type.a : Type.b) : (this.as.h() ? variant : variant1);
        return variant2;
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$0(List drops, WorldServer ignored, ItemStack stack) {
        for (int i2 = 0; i2 < stack.N(); ++i2) {
            drops.add(stack.c(1));
        }
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type("red", 0, Blocks.cq.m());
        public static final /* enum */ Type b = new Type("brown", 1, Blocks.cp.m());
        public static final Type c;
        public static final Codec<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final String g;
        final int h;
        private final IBlockData i;
        private static final /* synthetic */ Type[] j;

        public static Type[] values() {
            return (Type[])j.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String type, int id, IBlockData blockState) {
            this.g = type;
            this.h = id;
            this.i = blockState;
        }

        public IBlockData a() {
            return this.i;
        }

        @Override
        public String c() {
            return this.g;
        }

        private int b() {
            return this.h;
        }

        static Type a(int id) {
            return f.apply(id);
        }

        private static /* synthetic */ Type[] d() {
            return new Type[]{a, b};
        }

        static {
            j = Type.d();
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::b, Type.values(), ByIdMap.a.c);
            e = ByteBufCodecs.a(f, Type::b);
        }
    }
}

