/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.EntityHorseDonkey;
import net.minecraft.world.entity.animal.equine.EntityHorseMule;
import net.minecraft.world.entity.animal.equine.HorseColor;
import net.minecraft.world.entity.animal.equine.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class EntityHorse
extends EntityHorseAbstract {
    private static final DataWatcherObject<Integer> cv = DataWatcher.a(EntityHorse.class, DataWatcherRegistry.b);
    private static final EntitySize cw = EntityTypes.aq.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.aq.m() + 0.125f, 0.0f)).a(0.5f);
    private static final int cx = 0;

    public EntityHorse(EntityTypes<? extends EntityHorse> type, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, level);
        this.a(PathType.p, -1.0f);
        this.a(PathType.q, -1.0f);
    }

    @Override
    protected void a(RandomSource random) {
        this.h(GenericAttributes.u).a(EntityHorse.a(random::a));
        this.h(GenericAttributes.x).a(EntityHorse.b(random::j));
        this.h(GenericAttributes.q).a(EntityHorse.a(random::j));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cv, 0);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Variant", this.gQ());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.w(input.a("Variant", 0));
    }

    private void w(int typeVariant) {
        this.az.a(cv, typeVariant);
    }

    private int gQ() {
        return this.az.a(cv);
    }

    public void a(HorseColor variant, HorseStyle marking) {
        this.w(variant.a() & 0xFF | marking.a() << 8 & 0xFF00);
    }

    public HorseColor p() {
        return HorseColor.a(this.gQ() & 0xFF);
    }

    private void a(HorseColor variant) {
        this.w(variant.a() & 0xFF | this.gQ() & 0xFFFFFF00);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aT ? EntityHorse.c(component, this.p()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aT);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aT) {
            this.a(EntityHorse.c(DataComponents.aT, value));
            return true;
        }
        return super.b(component, value);
    }

    public HorseStyle gP() {
        return HorseStyle.a((this.gQ() & 0xFF00) >> 8);
    }

    @Override
    protected void a(SoundEffectType soundType) {
        super.a(soundType);
        if (this.as.a(10) == 0) {
            this.a(SoundEffects.oI, soundType.a() * 0.6f, soundType.b());
        }
    }

    @Override
    public SoundEffect W() {
        return SoundEffects.oE;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.oJ;
    }

    @Override
    protected SoundEffect gV() {
        return SoundEffects.oK;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.oM;
    }

    @Override
    protected SoundEffect hw() {
        return SoundEffects.oF;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag;
        boolean bl = flag = !this.e_() && this.hn() && player.gA();
        if (!this.cr() && !flag) {
            ItemStack itemInHand = player.b(hand);
            if (!itemInHand.f()) {
                if (this.j(itemInHand)) {
                    return this.c(player, itemInHand);
                }
                if (!this.hn()) {
                    this.hD();
                    return EnumInteractionResult.a;
                }
            }
            return super.b(player, hand);
        }
        return super.b(player, hand);
    }

    @Override
    public boolean a(EntityAnimal otherAnimal) {
        return otherAnimal != this && (otherAnimal instanceof EntityHorseDonkey || otherAnimal instanceof EntityHorse) && this.hF() && ((EntityHorseAbstract)otherAnimal).hF();
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        if (partner instanceof EntityHorseDonkey) {
            EntityHorseMule mule = EntityTypes.aL.a(level, EntitySpawnReason.e);
            if (mule != null) {
                this.a(partner, mule);
            }
            return mule;
        }
        EntityHorse horse = (EntityHorse)partner;
        EntityHorse horse1 = EntityTypes.aq.a(level, EntitySpawnReason.e);
        if (horse1 != null) {
            int randomInt = this.as.a(9);
            HorseColor variant = randomInt < 4 ? this.p() : (randomInt < 8 ? horse.p() : SystemUtils.a(HorseColor.values(), this.as));
            int randomInt1 = this.as.a(5);
            HorseStyle markings = randomInt1 < 2 ? this.gP() : (randomInt1 < 4 ? horse.gP() : SystemUtils.a(HorseStyle.values(), this.as));
            horse1.a(variant, markings);
            this.a(partner, horse1);
        }
        return horse1;
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }

    @Override
    protected void c(DamageSource damageSource, float damageAmount) {
        this.a(damageSource, damageAmount, EnumItemSlot.g);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        HorseColor variant;
        RandomSource random = level.G_();
        if (spawnGroupData instanceof a) {
            variant = ((a)spawnGroupData).a;
        } else {
            variant = SystemUtils.a(HorseColor.values(), random);
            spawnGroupData = new a(variant);
        }
        this.a(variant, SystemUtils.a(HorseStyle.values(), random));
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cw : super.b(pose);
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor a;

        public a(HorseColor variant) {
            super(true);
            this.a = variant;
        }
    }
}

