/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.inventory.AbstractMountInventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;
import org.jspecify.annotations.Nullable;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements HasCustomInventoryScreen,
OwnableEntity,
IJumpable {
    public static final int cG = 499;
    public static final int cH = 500;
    public static final double cI = 0.15;
    private static final float cv = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float cw = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float cx = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float cz = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float cA = EntityHorseAbstract.a((int i2) -> 0);
    private static final float cB = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float cC = 0.25f;
    private static final float cD = 0.5f;
    private static final PathfinderTargetCondition.a cE = (entity, level) -> {
        EntityHorseAbstract abstractHorse;
        return entity instanceof EntityHorseAbstract && (abstractHorse = (EntityHorseAbstract)entity).hs();
    };
    private static final PathfinderTargetCondition cF = PathfinderTargetCondition.b().a(16.0).d().a(cE);
    private static final DataWatcherObject<Byte> cU = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cV = 2;
    private static final int cW = 8;
    private static final int cX = 16;
    private static final int cY = 32;
    private static final int cZ = 64;
    public static final int cJ = 3;
    private static final int da = 0;
    private static final boolean db = false;
    private static final boolean dc = false;
    private static final boolean dd = false;
    private int de;
    private int df;
    private int dg;
    public int cK;
    public int cL;
    public InventorySubcontainer cM;
    protected int cN = 0;
    protected float cO;
    protected boolean cP;
    private float dh;
    private float di;
    private float dj;
    private float dk;
    private float dl;
    private float dm;
    protected boolean cQ = true;
    protected int cR;
    public @Nullable EntityReference<EntityLiving> dn;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.hv();
    }

    @Override
    protected void D() {
        this.cs.a(1, new a(1.2));
        this.cs.a(1, new PathfinderGoalTame(this, 1.2));
        this.cs.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.cs.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.cs.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.cs.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gU()) {
            this.cs.a(9, new RandomStandGoal(this));
        }
        this.hp();
    }

    protected void hp() {
        this.cs.a(0, new PathfinderGoalFloat(this));
        this.cs.a(3, new PathfinderGoalTempt(this, 1.25, stack -> stack.a(TagsItem.aL), false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cU, (byte)0);
    }

    protected boolean s(int flagId) {
        return (this.az.a(cU) & flagId) != 0;
    }

    protected void d(int flagId, boolean value) {
        byte b2 = this.az.a(cU);
        if (value) {
            this.az.a(cU, (byte)(b2 | flagId));
        } else {
            this.az.a(cU, (byte)(b2 & ~flagId));
        }
    }

    public boolean hn() {
        return this.s(2);
    }

    @Override
    public @Nullable EntityReference<EntityLiving> ae_() {
        return this.dn;
    }

    public void j(@Nullable EntityLiving owner) {
        this.dn = EntityReference.a(owner);
    }

    public void y(boolean tamed) {
        this.d(2, tamed);
    }

    @Override
    public void v() {
        super.v();
        if (this.hq()) {
            this.A(false);
        }
    }

    @Override
    public boolean z() {
        return true;
    }

    @Override
    public Vec3D[] A() {
        return Leashable.a(this, 0.04, 0.52, 0.23, 0.87);
    }

    public boolean hq() {
        return this.s(16);
    }

    public boolean hr() {
        return this.s(32);
    }

    public boolean hs() {
        return this.s(8);
    }

    public void z(boolean breeding) {
        this.d(8, breeding);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.h ? super.e(slot) : this.cb() && !this.e_() && this.hn();
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.a(stack, EnumItemSlot.g)) {
            this.i(stack.b(1, (EntityLiving)player));
        }
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return (slot == EnumItemSlot.g || slot == EnumItemSlot.h) && this.hn() || super.f(slot);
    }

    public int ht() {
        return this.cN;
    }

    public void t(int temper) {
        this.cN = temper;
    }

    public int u(int addedTemper) {
        int i2 = MathHelper.a(this.ht() + addedTemper, 0, this.hy());
        this.t(i2);
        return i2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.cr();
    }

    private void p() {
        SoundEffect eatingSound;
        this.gQ();
        if (!this.bq() && (eatingSound = this.gV()) != null) {
            this.ao().a(null, this.dP(), this.dR(), this.dV(), eatingSound, this.dB(), 1.0f, 1.0f + (this.as.i() - this.as.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0) {
            this.a(SoundEffects.oO, 0.4f, 1.0f);
        }
        if ((i2 = this.a(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        this.b(fallDistance, damageMultiplier, damageSource);
        this.fm();
        return true;
    }

    public final int hu() {
        return AbstractMountInventoryMenu.e(this.ad_());
    }

    public void hv() {
        InventorySubcontainer simpleContainer = this.cM;
        this.cM = new InventorySubcontainer(this.hu(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (simpleContainer != null) {
            int min = Math.min(simpleContainer.b(), this.cM.b());
            for (int i2 = 0; i2 < min; ++i2) {
                ItemStack item = simpleContainer.a(i2);
                if (item.f()) continue;
                this.cM.a(i2, item.v());
            }
        }
    }

    @Override
    protected Holder<SoundEffect> a(EnumItemSlot slot, ItemStack stack, Equippable equippable) {
        return slot == EnumItemSlot.h ? SoundEffects.oP : super.a(slot, stack, equippable);
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        boolean flag = super.a(level, damageSource, amount);
        if (flag && this.as.a(3) == 0) {
            this.hC();
        }
        return flag;
    }

    protected boolean gU() {
        return true;
    }

    protected @Nullable SoundEffect gV() {
        return null;
    }

    protected @Nullable SoundEffect hw() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        if (!block.n()) {
            IBlockData blockState = this.ao().a_(pos.d());
            SoundEffectType soundType = block.A();
            if (blockState.a(Blocks.ep)) {
                soundType = blockState.A();
            }
            if (this.cr() && this.cQ) {
                ++this.cR;
                if (this.cR > 5 && this.cR % 3 == 0) {
                    this.a(soundType);
                } else if (this.cR <= 5) {
                    this.a(SoundEffects.oR, soundType.a() * 0.15f, soundType.b());
                }
            } else if (this.b(soundType)) {
                this.a(SoundEffects.oR, soundType.a() * 0.15f, soundType.b());
            } else {
                this.a(SoundEffects.oQ, soundType.a() * 0.15f, soundType.b());
            }
        }
    }

    private boolean b(SoundEffectType soundType) {
        return soundType == SoundEffectType.b || soundType == SoundEffectType.aW || soundType == SoundEffectType.B || soundType == SoundEffectType.aX || soundType == SoundEffectType.aV;
    }

    protected void a(SoundEffectType soundType) {
        this.a(SoundEffects.oL, soundType.a() * 0.15f, soundType.b());
    }

    public static AttributeProvider.Builder hx() {
        return EntityAnimal.gW().a(GenericAttributes.q, 0.7).a(GenericAttributes.u, 53.0).a(GenericAttributes.x, 0.225f).a(GenericAttributes.D, 1.0).a(GenericAttributes.z, 6.0).a(GenericAttributes.m, 0.5);
    }

    @Override
    public int aj() {
        return 6;
    }

    public int hy() {
        return this.maxDomestication;
    }

    @Override
    public float fC() {
        return 0.8f;
    }

    @Override
    public int S() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.ao().B_() && (!this.cr() || this.z(player)) && this.hn()) {
            player.a(this, (IInventory)this.cM);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (flag) {
            stack.a(1, (EntityLiving)player);
        }
        return (EnumInteractionResult)((Object)(!flag && !this.ao().B_() ? EnumInteractionResult.e : EnumInteractionResult.b));
    }

    protected boolean a(EntityHuman player, ItemStack stack) {
        boolean flag = false;
        float f2 = 0.0f;
        int i2 = 0;
        int i1 = 0;
        if (stack.a(Items.rc)) {
            f2 = 2.0f;
            i2 = 20;
            i1 = 3;
        } else if (stack.a(Items.tE)) {
            f2 = 1.0f;
            i2 = 30;
            i1 = 3;
        } else if (stack.a(Blocks.jb.h())) {
            f2 = 20.0f;
            i2 = 180;
        } else if (stack.a(Items.pV)) {
            f2 = 3.0f;
            i2 = 60;
            i1 = 3;
        } else if (stack.a(Items.dO)) {
            f2 = 3.0f;
            i2 = 0;
            i1 = 3;
        } else if (stack.a(Items.wr)) {
            f2 = 3.0f;
            i2 = 60;
            i1 = 3;
        } else if (stack.a(Items.ww)) {
            f2 = 4.0f;
            i2 = 60;
            i1 = 5;
            if (!this.ao().B_() && this.hn() && this.Z_() == 0 && !this.hb()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        } else if (stack.a(Items.rK) || stack.a(Items.rL)) {
            f2 = 10.0f;
            i2 = 240;
            i1 = 10;
            if (!this.ao().B_() && this.hn() && this.Z_() == 0 && !this.hb()) {
                flag = true;
                this.setInLove(player, stack.v());
            }
        }
        if (this.eZ() < this.fq() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.e_() && i2 > 0) {
            this.ao().a(Particles.R, this.e(1.0), this.dS() + 0.5, this.h(1.0), 0.0, 0.0, 0.0);
            if (!this.ao().B_()) {
                this.c_(i2);
                flag = true;
            }
        }
        if (!(i1 <= 0 || !flag && this.hn() || this.ht() >= this.hy() || this.ao().B_())) {
            this.u(i1);
            flag = true;
        }
        if (flag) {
            this.p();
            this.c(GameEvent.m);
        }
        return flag;
    }

    protected void g(EntityHuman player) {
        this.A(false);
        this.hA();
        if (!this.ao().B_()) {
            player.v(this.ec());
            player.w(this.ee());
            player.o(this);
        }
    }

    @Override
    public boolean fE() {
        return super.fE() && this.cr() && this.al() || this.hq() || this.hr();
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aJ);
    }

    private void gP() {
        this.cK = 1;
    }

    @Override
    protected void g(WorldServer level) {
        super.g(level);
        if (this.cM != null) {
            for (int i2 = 0; i2 < this.cM.b(); ++i2) {
                ItemStack item = this.cM.a(i2);
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.E)) continue;
                this.a(level, item);
            }
        }
    }

    @Override
    public void d_() {
        if (this.as.a(200) == 0) {
            this.gP();
        }
        super.d_();
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (this.cb()) {
                if (this.as.a(900) == 0 && this.bw == 0) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if (this.hz()) {
                    if (!this.hq() && !this.cr() && this.as.a(300) == 0 && serverLevel.a_(this.dK().e()).a(Blocks.i)) {
                        this.A(true);
                    }
                    if (this.hq() && ++this.de > 50) {
                        this.de = 0;
                        this.A(false);
                    }
                }
                this.h(serverLevel);
            }
        }
    }

    protected void h(WorldServer level) {
        EntityHorseAbstract nearestEntity;
        if (this.hs() && this.e_() && !this.hq() && (nearestEntity = level.a(EntityHorseAbstract.class, cF, (EntityLiving)this, this.dP(), this.dR(), this.dV(), this.dj().g(16.0))) != null && this.g((Entity)nearestEntity) > 4.0) {
            this.cr.a((Entity)nearestEntity, 0);
        }
    }

    public boolean hz() {
        return true;
    }

    @Override
    public void g() {
        super.g();
        if (this.df > 0 && ++this.df > 30) {
            this.df = 0;
            this.d(64, false);
        }
        if (this.dg > 0 && --this.dg <= 0) {
            this.hA();
        }
        if (this.cK > 0 && ++this.cK > 8) {
            this.cK = 0;
        }
        if (this.cL > 0) {
            ++this.cL;
            if (this.cL > 300) {
                this.cL = 0;
            }
        }
        this.di = this.dh;
        if (this.hq()) {
            this.dh += (1.0f - this.dh) * 0.4f + 0.05f;
            if (this.dh > 1.0f) {
                this.dh = 1.0f;
            }
        } else {
            this.dh += (0.0f - this.dh) * 0.4f - 0.05f;
            if (this.dh < 0.0f) {
                this.dh = 0.0f;
            }
        }
        this.dk = this.dj;
        if (this.hr()) {
            this.di = this.dh = 0.0f;
            this.dj += (1.0f - this.dj) * 0.4f + 0.05f;
            if (this.dj > 1.0f) {
                this.dj = 1.0f;
            }
        } else {
            this.cP = false;
            this.dj += (0.8f * this.dj * this.dj * this.dj - this.dj) * 0.6f - 0.05f;
            if (this.dj < 0.0f) {
                this.dj = 0.0f;
            }
        }
        this.dm = this.dl;
        if (this.s(64)) {
            this.dl += (1.0f - this.dl) * 0.7f + 0.05f;
            if (this.dl > 1.0f) {
                this.dl = 1.0f;
            }
        } else {
            this.dl += (0.0f - this.dl) * 0.7f - 0.05f;
            if (this.dl < 0.0f) {
                this.dl = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.s(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (this.cr() || this.e_()) {
            return super.b(player, hand);
        }
        if (this.hn() && player.gA()) {
            this.b(player);
            return EnumInteractionResult.a;
        }
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.f()) {
            EnumInteractionResult interactionResult = itemInHand.a(player, (EntityLiving)this, hand);
            if (interactionResult.a()) {
                return interactionResult;
            }
            if (this.a(itemInHand, EnumItemSlot.g) && !this.am()) {
                this.b(player, itemInHand);
                return EnumInteractionResult.a;
            }
        }
        this.g(player);
        return EnumInteractionResult.a;
    }

    private void gQ() {
        if (!this.ao().B_()) {
            this.df = 1;
            this.d(64, true);
        }
    }

    public void A(boolean eating) {
        this.d(16, eating);
    }

    public void v(int standCounter) {
        this.A(false);
        this.d(32, true);
        this.dg = standCounter;
    }

    public void hA() {
        this.d(32, false);
        this.dg = 0;
    }

    public @Nullable SoundEffect hB() {
        return this.W();
    }

    public void hC() {
        if (this.gU() && (this.dy() || !this.ao().B_())) {
            this.v(20);
        }
    }

    public void hD() {
        if (!this.hr() && !this.ao().B_()) {
            this.hC();
            this.b(this.hw());
        }
    }

    public boolean i(EntityHuman player) {
        this.j(player);
        this.y(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.y.a((EntityPlayer)player, this);
        }
        this.ao().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        Vec2F riddenRotation = this.i((EntityLiving)player);
        this.a(riddenRotation.k, riddenRotation.j);
        this.bC = this.bE = this.ec();
        this.ab = this.bE;
        if (this.dv()) {
            if (travelVector.i <= 0.0) {
                this.cR = 0;
            }
            if (this.aV()) {
                if (this.cO > 0.0f && !this.fS()) {
                    this.b(this.cO, travelVector);
                }
                this.cO = 0.0f;
            }
        }
    }

    protected Vec2F i(EntityLiving entity) {
        return new Vec2F(entity.ee() * 0.5f, entity.ec());
    }

    @Override
    protected void q(Entity passenger) {
        super.q(passenger);
        passenger.b(this.j(0.0f), this.i(0.0f));
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        if (this.aV() && this.cO == 0.0f && this.hr() && !this.cP) {
            return Vec3D.c;
        }
        float f2 = player.bN * 0.5f;
        float f1 = player.bP;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float f(EntityHuman player) {
        return (float)this.i(GenericAttributes.x);
    }

    protected void b(float playerJumpPendingScale, Vec3D travelVector) {
        double d2 = this.A(playerJumpPendingScale);
        Vec3D deltaMovement = this.dN();
        this.m(deltaMovement.g, d2, deltaMovement.i);
        this.aF = true;
        if (travelVector.i > 0.0) {
            float sin = MathHelper.a((double)(this.ec() * ((float)Math.PI / 180)));
            float cos = MathHelper.b((double)(this.ec() * ((float)Math.PI / 180)));
            this.k(this.dN().b(-0.4f * sin * playerJumpPendingScale, 0.0, 0.4f * cos * playerJumpPendingScale));
        }
    }

    protected void hE() {
        this.a(SoundEffects.oN, 0.4f, 1.0f);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("EatingHaystack", this.hq());
        output.a("Bred", this.hs());
        output.a("Temper", this.ht());
        output.a("Tame", this.hn());
        EntityReference.a(this.dn, output, "Owner");
        output.a("Bukkit.MaxDomestication", this.maxDomestication);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.A(input.a("EatingHaystack", false));
        this.z(input.a("Bred", false));
        this.t(input.a("Temper", 0));
        this.y(input.a("Tame", false));
        this.dn = EntityReference.a(input, "Owner", this.ao());
        this.maxDomestication = input.a("Bukkit.MaxDomestication", this instanceof EntityLlama ? 30 : 100);
    }

    @Override
    public boolean a(EntityAnimal partner) {
        return false;
    }

    protected boolean hF() {
        return !this.cr() && !this.cq() && this.hn() && !this.e_() && this.eZ() >= this.fq() && this.hb();
    }

    public boolean ho() {
        return false;
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return null;
    }

    protected void a(EntityAgeable parent, EntityHorseAbstract child) {
        this.a(parent, child, GenericAttributes.u, (double)cA, (double)cB);
        this.a(parent, child, GenericAttributes.q, (double)cx, (double)cz);
        this.a(parent, child, GenericAttributes.x, (double)cv, (double)cw);
    }

    private void a(EntityAgeable parent, EntityHorseAbstract child, Holder<AttributeBase> attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.j(attribute), parent.j(attribute), min, max, this.as);
        child.h(attribute).a(d2);
    }

    static double a(double value1, double value2, double min, double max, RandomSource random) {
        double d3;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        value1 = MathHelper.a(value1, min, max);
        value2 = MathHelper.a(value2, min, max);
        double d2 = 0.15 * (max - min);
        double d22 = (value1 + value2) / 2.0;
        double d1 = Math.abs(value1 - value2) + d2 * 2.0;
        double d4 = d22 + d1 * (d3 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d4 > max) {
            double d5 = d4 - max;
            return max - d5;
        }
        if (d4 < min) {
            double d5 = min - d4;
            return min + d5;
        }
        return d4;
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.di, this.dh);
    }

    public float M(float partialTick) {
        return MathHelper.h(partialTick, this.dk, this.dj);
    }

    public float N(float partialTick) {
        return MathHelper.h(partialTick, this.dm, this.dl);
    }

    @Override
    public void a(int jumpPower) {
        if (this.al()) {
            if (jumpPower < 0) {
                jumpPower = 0;
            } else {
                this.cP = true;
                this.hC();
            }
            this.cO = this.e_(jumpPower);
        }
    }

    @Override
    public boolean a() {
        return this.al();
    }

    @Override
    public void b(int jumpPower) {
        float power = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cP = true;
        this.hC();
        this.hE();
    }

    @Override
    public void b() {
    }

    protected void B(boolean tamed) {
        ParticleType particleOptions = tamed ? Particles.T : Particles.ai;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.as.k() * 0.02;
            double d1 = this.as.k() * 0.02;
            double d22 = this.as.k() * 0.02;
            this.ao().a(particleOptions, this.e(1.0), this.dS() + 0.5, this.h(1.0), d2, d1, d22);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 7) {
            this.B(true);
        } else if (id == 6) {
            this.B(false);
        } else {
            super.b(id);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction callback) {
        super.a(passenger, callback);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).bC = this.bC;
        }
    }

    protected static float a(IntUnaryOperator operator) {
        return 15.0f + (float)operator.applyAsInt(8) + (float)operator.applyAsInt(9);
    }

    protected static double a(DoubleSupplier supplier) {
        return (double)0.4f + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2 + supplier.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier supplier) {
        return ((double)0.45f + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3 + supplier.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean fl() {
        return false;
    }

    @Override
    public @Nullable SlotAccess a_(int slot) {
        int i2 = slot - 500;
        return i2 >= 0 && i2 < this.cM.b() ? this.cM.a_(i2) : super.a_(slot);
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityLiving entityLiving;
        Entity entity;
        if (this.al() && (entity = this.do()) instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            entityLiving = player;
        } else {
            entityLiving = super.dl();
        }
        return entityLiving;
    }

    private @Nullable Vec3D a(Vec3D direction, EntityLiving passenger) {
        double d2 = this.dP() + direction.g;
        double d1 = this.dj().b;
        double d22 = this.dV() + direction.i;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose pose : passenger.go()) {
            mutableBlockPos.b(d2, d1, d22);
            double d3 = this.dj().e + 0.75;
            do {
                double blockFloorHeight = this.ao().m(mutableBlockPos);
                if ((double)mutableBlockPos.v() + blockFloorHeight > d3) continue block0;
                if (DismountUtil.a(blockFloorHeight)) {
                    AxisAlignedBB localBoundsForPose = passenger.f(pose);
                    Vec3D vec3 = new Vec3D(d2, (double)mutableBlockPos.v() + blockFloorHeight, d22);
                    if (DismountUtil.a(this.ao(), passenger, localBoundsForPose.c(vec3))) {
                        passenger.c(pose);
                        return vec3;
                    }
                }
                mutableBlockPos.c(EnumDirection.b);
            } while ((double)mutableBlockPos.v() < d3);
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving livingEntity) {
        Vec3D collisionHorizontalEscapeVector = EntityHorseAbstract.a(this.dF(), (double)livingEntity.dF(), this.ec() + (livingEntity.at() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection = this.a(collisionHorizontalEscapeVector, livingEntity);
        if (dismountLocationInDirection != null) {
            return dismountLocationInDirection;
        }
        Vec3D collisionHorizontalEscapeVector1 = EntityHorseAbstract.a(this.dF(), (double)livingEntity.dF(), this.ec() + (livingEntity.at() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D dismountLocationInDirection1 = this.a(collisionHorizontalEscapeVector1, livingEntity);
        return dismountLocationInDirection1 != null ? dismountLocationInDirection1 : this.dI();
    }

    protected void a(RandomSource random) {
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new EntityAgeable.a(0.2f);
        }
        this.a(level.G_());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public boolean a(IInventory oldInventory) {
        return this.cM != oldInventory;
    }

    public int hG() {
        return this.S();
    }

    @Override
    protected Vec3D a(Entity entity, EntitySize dimensions, float partialTick) {
        return super.a(entity, dimensions, partialTick).e(new Vec3D(0.0, 0.15 * (double)this.dk * (double)partialTick, -0.7 * (double)this.dk * (double)partialTick).b(-this.ec() * ((float)Math.PI / 180)));
    }

    public int ad_() {
        return 0;
    }

    class a
    extends PathfinderGoalPanic {
        public a(double speedModifier) {
            super(EntityHorseAbstract.this, speedModifier);
        }

        @Override
        public boolean h() {
            return !EntityHorseAbstract.this.ho() && super.h();
        }
    }
}

