/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.PathfinderGoalHorseTrap;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityHorseSkeleton
extends EntityHorseAbstract {
    private final PathfinderGoalHorseTrap cv = new PathfinderGoalHorseTrap(this);
    private static final int cw = 18000;
    private static final boolean cx = false;
    private static final int cz = 0;
    private static final EntitySize cA = EntityTypes.bo.n().a(EntityAttachments.a().a(EntityAttachment.a, 0.0f, EntityTypes.bo.m() - 0.03125f, 0.0f)).a(0.5f);
    private boolean cB = false;
    public int cC = 0;

    public EntityHorseSkeleton(EntityTypes<? extends EntityHorseSkeleton> type, World level) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, level);
    }

    public static AttributeProvider.Builder p() {
        return EntityHorseSkeleton.hx().a(GenericAttributes.u, 15.0).a(GenericAttributes.x, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return !EntitySpawnReason.a(spawnReason) ? EntityAnimal.b(entityType, level, spawnReason, pos, random) : EntitySpawnReason.b(spawnReason) || EntityHorseSkeleton.a(level, pos);
    }

    @Override
    protected void a(RandomSource random) {
        this.h(GenericAttributes.q).a(EntityHorseSkeleton.a(random::j));
    }

    @Override
    protected void hp() {
    }

    @Override
    public SoundEffect W() {
        return ((Entity)this).a(TagsFluid.a) ? SoundEffects.Ap : SoundEffects.Al;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.Am;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.An;
    }

    @Override
    public SoundEffect bk() {
        if (this.aV()) {
            if (!this.cr()) {
                return SoundEffects.As;
            }
            ++this.cR;
            if (this.cR > 5 && this.cR % 3 == 0) {
                return SoundEffects.Aq;
            }
            if (this.cR <= 5) {
                return SoundEffects.As;
            }
        }
        return SoundEffects.Ao;
    }

    @Override
    protected void g(float volume) {
        if (this.aV()) {
            super.g(0.3f);
        } else {
            super.g(Math.min(0.1f, volume * 25.0f));
        }
    }

    @Override
    protected void hE() {
        if (this.by()) {
            this.a(SoundEffects.Ar, 0.4f, 1.0f);
        } else {
            super.hE();
        }
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cA : super.b(pose);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.gP() && this.cC++ >= 18000) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("SkeletonTrap", this.gP());
        output.a("SkeletonTrapTime", this.cC);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("SkeletonTrap", false));
        this.cC = input.a("SkeletonTrapTime", 0);
    }

    @Override
    protected float fI() {
        return 0.96f;
    }

    public boolean gP() {
        return this.cB;
    }

    public void x(boolean isTrap) {
        if (isTrap != this.cB) {
            this.cB = isTrap;
            if (isTrap) {
                this.cs.a(1, this.cv);
            } else {
                this.cs.a(this.cv);
            }
        }
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.bo.a(level, EntitySpawnReason.e);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return !this.hn() ? EnumInteractionResult.e : super.b(player, hand);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return true;
    }
}

