/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.fox;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import net.minecraft.world.entity.animal.fish.EntityFish;
import net.minecraft.world.entity.animal.fish.EntityFishSchool;
import net.minecraft.world.entity.animal.polarbear.EntityPolarBear;
import net.minecraft.world.entity.animal.rabbit.EntityRabbit;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class EntityFox
extends EntityAnimal {
    private static final DataWatcherObject<Integer> cz = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> cA = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int cB = 1;
    public static final int cv = 4;
    public static final int cw = 8;
    public static final int cx = 16;
    private static final int cC = 32;
    private static final int cD = 64;
    private static final int cE = 128;
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cF = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    public static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> cG = DataWatcher.a(EntityFox.class, DataWatcherRegistry.r);
    static final Predicate<EntityItem> cH = item -> !item.n() && item.cb();
    private static final Predicate<Entity> cI = entity -> {
        EntityLiving livingEntity;
        return entity instanceof EntityLiving && (livingEntity = (EntityLiving)entity).eN() != null && livingEntity.eO() < livingEntity.at + 600;
    };
    static final Predicate<Entity> cJ = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> cK = entity -> !entity.cx() && IEntitySelector.e.test((Entity)entity);
    private static final int cL = 600;
    private static final EntitySize cM = EntityTypes.ae.n().a(0.5f).b(0.2975f);
    private static final Codec<List<EntityReference<EntityLiving>>> cN = EntityReference.a().listOf();
    private static final boolean cO = false;
    private static final boolean cP = false;
    private static final boolean cQ = false;
    private PathfinderGoal cR;
    private PathfinderGoal cU;
    private PathfinderGoal cV;
    private float cW;
    private float cX;
    float cY;
    float cZ;
    private int da;

    public EntityFox(EntityTypes<? extends EntityFox> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.co = new k();
        this.cp = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.b_(true);
        this.N().a(32.0f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cF, Optional.empty());
        builder.a(cG, Optional.empty());
        builder.a(cz, Type.c.a());
        builder.a(cA, (byte)0);
    }

    @Override
    protected void D() {
        this.cR = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, (entity, level) -> entity instanceof EntityChicken || entity instanceof EntityRabbit);
        this.cU = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.cv);
        this.cV = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, (entity, level) -> entity instanceof EntityFishSchool);
        this.cs.a(0, new g());
        this.cs.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.ao()));
        this.cs.a(1, new b());
        this.cs.a(2, new n(2.2));
        this.cs.a(3, new e(this, 1.0));
        this.cs.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entity -> cK.test((Entity)entity) && !this.j((EntityLiving)entity) && !this.hf()));
        this.cs.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, livingEntity -> !((EntityWolf)livingEntity).p() && !this.hf()));
        this.cs.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, livingEntity -> !this.hf()));
        this.cs.a(5, new u());
        this.cs.a(6, new o());
        this.cs.a(6, new s(1.25));
        this.cs.a(7, new l((double)1.2f, true));
        this.cs.a(7, new t());
        this.cs.a(8, new h(this, 1.25));
        this.cs.a(9, new q(32, 200));
        this.cs.a(10, new f((double)1.2f, 12, 1));
        this.cs.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.cs.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.cs.a(11, new p());
        this.cs.a(12, new j(this, EntityHuman.class, 24.0f));
        this.cs.a(13, new r());
        this.ct.a(3, new a(EntityLiving.class, false, false, (entity, level) -> cI.test(entity) && !this.j(entity)));
    }

    @Override
    public void d_() {
        if (!this.ao().B_() && this.cb() && this.dy()) {
            EntityLiving target;
            ++this.da;
            ItemStack itemBySlot = this.a(EnumItemSlot.a);
            if (this.k(itemBySlot)) {
                if (this.da > 600) {
                    ItemStack itemStack = itemBySlot.a(this.ao(), (EntityLiving)this);
                    if (!itemStack.f()) {
                        this.a(EnumItemSlot.a, itemStack);
                    }
                    this.da = 0;
                } else if (this.da > 560 && this.as.i() < 0.1f) {
                    this.gX();
                    this.ao().a((Entity)this, (byte)45);
                }
            }
            if ((target = this.ag_()) == null || !target.cb()) {
                this.z(false);
                this.A(false);
            }
        }
        if (this.gr() || this.fE()) {
            this.bM = false;
            this.bN = 0.0f;
            this.bP = 0.0f;
        }
        super.d_();
        if (this.hf() && this.as.i() < 0.05f) {
            this.a(SoundEffects.kT, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean fE() {
        return this.fa();
    }

    private boolean k(ItemStack stack) {
        return this.l(stack) && this.ag_() == null && this.aV() && !this.gr();
    }

    private boolean l(ItemStack stack) {
        return stack.c(DataComponents.y) && stack.c(DataComponents.z);
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler difficulty) {
        if (random.i() < 0.2f) {
            float randomFloat = random.i();
            ItemStack itemStack = randomFloat < 0.05f ? new ItemStack(Items.qb) : (randomFloat < 0.2f ? new ItemStack(Items.sD) : (randomFloat < 0.4f ? (random.h() ? new ItemStack(Items.wQ) : new ItemStack(Items.wR)) : (randomFloat < 0.6f ? new ItemStack(Items.rc) : (randomFloat < 0.8f ? new ItemStack(Items.sp) : new ItemStack(Items.qZ)))));
            this.a(EnumItemSlot.a, itemStack);
        }
    }

    @Override
    public void b(byte id) {
        if (id == 45) {
            ItemStack itemBySlot = this.a(EnumItemSlot.a);
            if (!itemBySlot.f()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3 = new Vec3D(((double)this.as.i() - 0.5) * 0.1, (double)this.as.i() * 0.1 + 0.1, 0.0).a(-this.ee() * ((float)Math.PI / 180)).b(-this.ec() * ((float)Math.PI / 180));
                    this.ao().a(new ParticleParamItem(Particles.V, itemBySlot), this.dP() + this.cj().g / 2.0, this.dR(), this.dV() + this.cj().i / 2.0, vec3.g, vec3.h + 0.05, vec3.i);
                }
            }
        } else {
            super.b(id);
        }
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.x, 0.3f).a(GenericAttributes.u, 10.0).a(GenericAttributes.d, 2.0).a(GenericAttributes.z, 5.0).a(GenericAttributes.o, 32.0);
    }

    public @Nullable EntityFox b(WorldServer level, EntityAgeable partner) {
        EntityFox fox = EntityTypes.ae.a(level, EntitySpawnReason.e);
        if (fox != null) {
            fox.a(this.as.h() ? this.gP() : ((EntityFox)partner).gP());
        }
        return fox;
    }

    public static boolean c(EntityTypes<EntityFox> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.ct) && EntityFox.a(level, pos);
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        Holder<BiomeBase> biome = level.z(this.dK());
        Type variant = Type.a(biome);
        boolean flag = false;
        if (spawnGroupData instanceof i) {
            i foxGroupData = (i)spawnGroupData;
            variant = foxGroupData.a;
            if (foxGroupData.a() >= 2) {
                flag = true;
            }
        } else {
            spawnGroupData = new i(variant);
        }
        this.a(variant);
        if (flag) {
            this.d_(-24000);
        }
        if (level instanceof WorldServer) {
            this.gV();
        }
        this.a(level.G_(), difficulty);
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    private void gV() {
        if (this.gP() == Type.a) {
            this.ct.a(4, this.cR);
            this.ct.a(4, this.cU);
            this.ct.a(6, this.cV);
        } else {
            this.ct.a(4, this.cV);
            this.ct.a(6, this.cR);
            this.ct.a(6, this.cU);
        }
    }

    @Override
    protected void gX() {
        this.a(SoundEffects.kX, 1.0f, 1.0f);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return this.e_() ? cM : super.b(pose);
    }

    public Type gP() {
        return Type.a(this.az.a(cz));
    }

    public void a(Type variant) {
        this.az.a(cz, variant.a());
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aG ? EntityFox.c(component, this.gP()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aG);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aG) {
            this.a(EntityFox.c(DataComponents.aG, value));
            return true;
        }
        return super.b(component, value);
    }

    Stream<EntityReference<EntityLiving>> hd() {
        return Stream.concat(this.az.a(cF).stream(), this.az.a(cG).stream());
    }

    void i(EntityLiving entity) {
        this.a(EntityReference.a(entity));
    }

    private void a(EntityReference<EntityLiving> entityReference) {
        if (this.az.a(cF).isPresent()) {
            this.az.a(cG, Optional.of(entityReference));
        } else {
            this.az.a(cF, Optional.of(entityReference));
        }
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Trusted", cN, this.hd().toList());
        output.a("Sleeping", this.gr());
        output.a("Type", Type.d, this.gP());
        output.a("Sitting", this.gQ());
        output.a("Crouching", this.cz());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.he();
        input.a("Trusted", cN).orElse(List.of()).forEach(this::a);
        this.D(input.a("Sleeping", false));
        this.a(input.a("Type", Type.d).orElse(Type.c));
        this.setSitting(input.a("Sitting", false), false);
        this.z(input.a("Crouching", false));
        if (this.ao() instanceof WorldServer) {
            this.gV();
        }
    }

    private void he() {
        this.az.a(cF, Optional.empty());
        this.az.a(cG, Optional.empty());
    }

    public boolean gQ() {
        return this.s(1);
    }

    public void x(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean fireEvent) {
        if (fireEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(1, sitting);
    }

    public boolean gR() {
        return this.s(64);
    }

    public void B(boolean faceplanted) {
        this.d(64, faceplanted);
    }

    public boolean hf() {
        return this.s(128);
    }

    public void C(boolean defending) {
        this.d(128, defending);
    }

    @Override
    public boolean gr() {
        return this.s(32);
    }

    public void D(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int flagId, boolean value) {
        if (value) {
            this.az.a(cA, (byte)(this.az.a(cA) | flagId));
        } else {
            this.az.a(cA, (byte)(this.az.a(cA) & ~flagId));
        }
    }

    private boolean s(int flagId) {
        return (this.az.a(cA) & flagId) != 0;
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.a && this.gn();
    }

    @Override
    public boolean h(ItemStack stack) {
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        return itemBySlot.f() || this.da > 0 && this.l(stack) && !this.l(itemBySlot);
    }

    private void m(ItemStack stack) {
        if (!stack.f() && !this.ao().B_()) {
            EntityItem itemEntity = new EntityItem(this.ao(), this.dP() + this.cj().g, this.dR() + 1.0, this.dV() + this.cj().i, stack);
            itemEntity.a(40);
            itemEntity.b((Entity)this);
            this.a(SoundEffects.lc, 1.0f, 1.0f);
            this.spawnAtLocation((WorldServer)this.ao(), itemEntity);
        }
    }

    private void n(ItemStack stack) {
        EntityItem itemEntity = new EntityItem(this.ao(), this.dP(), this.dR(), this.dV(), stack);
        this.spawnAtLocation((WorldServer)this.ao(), itemEntity);
    }

    @Override
    protected void a(WorldServer level, EntityItem entity) {
        ItemStack item = entity.e();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, entity, item.N() - 1, !this.h(item)).isCancelled()) {
            item = entity.e();
            int count = item.N();
            if (count > 1) {
                this.n(item.a(count - 1));
            }
            this.m(this.a(EnumItemSlot.a));
            this.a(entity);
            this.a(EnumItemSlot.a, item.a(1));
            this.g(EnumItemSlot.a);
            this.a((Entity)entity, item.N());
            entity.discard(EntityRemoveEvent.Cause.PICKUP);
            this.da = 0;
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.dy()) {
            boolean isInWater = this.by();
            if (isInWater || this.ag_() != null || this.ao().an()) {
                this.hg();
            }
            if (isInWater || this.gr()) {
                this.x(false);
            }
            if (this.gR() && this.ao().y.i() < 0.2f) {
                BlockPosition blockPos = this.dK();
                IBlockData blockState = this.ao().a_(blockPos);
                this.ao().c(2001, blockPos, Block.j(blockState));
            }
        }
        this.cX = this.cW;
        this.cW = this.gU() ? (this.cW += (1.0f - this.cW) * 0.4f) : (this.cW += (0.0f - this.cW) * 0.4f);
        this.cZ = this.cY;
        if (this.cz()) {
            this.cY += 0.2f;
            if (this.cY > 3.0f) {
                this.cY = 3.0f;
            }
        } else {
            this.cY = 0.0f;
        }
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aD);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).i(player);
    }

    public boolean gS() {
        return this.s(16);
    }

    public void y(boolean isPouncing) {
        this.d(16, isPouncing);
    }

    public boolean gT() {
        return this.cY == 3.0f;
    }

    public void z(boolean isCrouching) {
        this.d(4, isCrouching);
    }

    @Override
    public boolean cz() {
        return this.s(4);
    }

    public void A(boolean isInterested) {
        this.d(8, isInterested);
    }

    public boolean gU() {
        return this.s(8);
    }

    public float L(float partialTick) {
        return MathHelper.h(partialTick, this.cX, this.cW) * 0.11f * (float)Math.PI;
    }

    public float M(float partialTick) {
        return MathHelper.h(partialTick, this.cZ, this.cY);
    }

    @Override
    public boolean setTarget(@Nullable EntityLiving target, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityTargetEvent.TargetReason reason) {
        if (this.hf() && target == null) {
            this.C(false);
        }
        return super.setTarget(target, reason);
    }

    void hg() {
        this.D(false);
    }

    void hh() {
        this.A(false);
        this.z(false);
        this.x(false);
        this.D(false);
        this.C(false);
        this.B(false);
    }

    boolean hi() {
        return !this.gr() && !this.gQ() && !this.gR();
    }

    @Override
    public void T() {
        SoundEffect ambientSound = this.W();
        if (ambientSound == SoundEffects.kZ) {
            this.a(ambientSound, 2.0f, this.fD());
        } else {
            super.T();
        }
    }

    @Override
    public @Nullable SoundEffect W() {
        List<Entity> entitiesOfClass;
        if (this.gr()) {
            return SoundEffects.la;
        }
        if (!this.ao().ag() && this.as.i() < 0.1f && (entitiesOfClass = this.ao().a(EntityHuman.class, this.dj().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.kZ;
        }
        return SoundEffects.kU;
    }

    @Override
    public @Nullable SoundEffect h(DamageSource damageSource) {
        return SoundEffects.kY;
    }

    @Override
    public @Nullable SoundEffect fd() {
        return SoundEffects.kW;
    }

    boolean j(EntityLiving entity) {
        return this.hd().anyMatch(entityReference -> entityReference.b(entity));
    }

    @Override
    protected boolean shouldSkipLoot(EnumItemSlot slot) {
        return slot == EnumItemSlot.a;
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(WorldServer level, DamageSource damageSource) {
        EntityDeathEvent deathEvent;
        ItemStack itemBySlot = this.a(EnumItemSlot.a);
        boolean releaseMouth = false;
        if (!itemBySlot.f() && level.U().a(GameRules.D).booleanValue()) {
            this.a(level, itemBySlot);
            releaseMouth = true;
        }
        if ((deathEvent = super.dropAllDeathLoot(level, damageSource)) == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (releaseMouth) {
            this.a(EnumItemSlot.a, ItemStack.l);
        }
        return deathEvent;
    }

    public static boolean a(EntityFox fox, EntityLiving livingEntity) {
        double d2 = livingEntity.dV() - fox.dV();
        double d1 = livingEntity.dP() - fox.dP();
        double d22 = d2 / d1;
        int i2 = 6;
        for (int i1 = 0; i1 < 6; ++i1) {
            double d3 = d22 == 0.0 ? 0.0 : d2 * (double)((float)i1 / 6.0f);
            double d4 = d22 == 0.0 ? d1 * (double)((float)i1 / 6.0f) : d3 / d22;
            for (int i22 = 1; i22 < 4; ++i22) {
                if (fox.ao().a_(BlockPosition.a(fox.dP() + d4, fox.dR() + (double)i22, fox.dV() + d3)).v()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.55f * this.dk(), this.dF() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.gr()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gS() && !EntityFox.this.cz() && !EntityFox.this.gU() && !EntityFox.this.gR();
        }
    }

    class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.hi()) {
                super.a();
            }
        }
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type(0, "red");
        public static final /* enum */ Type b = new Type(1, "snow");
        public static final Type c;
        public static final INamable.a<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final int g;
        private final String h;
        private static final /* synthetic */ Type[] i;

        public static Type[] values() {
            return (Type[])i.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id, String name) {
            this.g = id;
            this.h = name;
        }

        @Override
        public String c() {
            return this.h;
        }

        public int a() {
            return this.g;
        }

        public static Type a(int id) {
            return f.apply(id);
        }

        public static Type a(Holder<BiomeBase> biome) {
            return biome.a(BiomeTags.ao) ? b : a;
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{a, b};
        }

        static {
            i = Type.b();
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
            e = ByteBufCodecs.a(f, Type::a);
        }
    }

    class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void d() {
            super.d();
            EntityFox.this.hh();
        }

        @Override
        public boolean b() {
            return EntityFox.this.by() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bN();
        }
    }

    class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            return EntityFox.this.gR();
        }

        @Override
        public boolean c() {
            return this.b() && this.a > 0;
        }

        @Override
        public void d() {
            this.a = this.a(40);
        }

        @Override
        public void e() {
            EntityFox.this.B(false);
        }

        @Override
        public void a() {
            --this.a;
        }
    }

    class n
    extends PathfinderGoalPanic {
        public n(double speedModifier) {
            super(EntityFox.this, speedModifier);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.hf() && super.h();
        }
    }

    class e
    extends PathfinderGoalBreed {
        public e(EntityFox this$0, double speedModifier) {
            super(this$0, speedModifier);
        }

        @Override
        public void d() {
            ((EntityFox)this.a).hh();
            ((EntityFox)this.c).hh();
            super.d();
        }

        @Override
        protected void g() {
            EntityFox fox = (EntityFox)this.a.a(this.b, (EntityAgeable)this.c);
            if (fox != null) {
                EntityPlayer loveCause = this.a.ha();
                EntityPlayer loveCause1 = this.c.ha();
                EntityPlayer serverPlayer = loveCause;
                if (loveCause != null) {
                    fox.i(loveCause);
                } else {
                    serverPlayer = loveCause1;
                }
                if (loveCause1 != null && loveCause != loveCause1) {
                    fox.i(loveCause1);
                }
                fox.d_(-24000);
                fox.b(this.a.dP(), this.a.dR(), this.a.dV(), 0.0f, 0.0f);
                int experience = this.a.ep().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(fox, this.a, this.c, loveCause, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    this.a.hc();
                    this.c.hc();
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (serverPlayer != null) {
                    serverPlayer.a(StatisticList.R);
                    CriterionTriggers.p.a(serverPlayer, this.a, this.c, fox);
                }
                this.a.d_(6000);
                this.c.d_(6000);
                this.a.hc();
                this.c.hc();
                this.b.addFreshEntityWithPassengers(fox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (experience > 0 && this.b.U().a(GameRules.D).booleanValue()) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dI(), Vec3D.c, experience, ExperienceOrb.SpawnReason.BREED, loveCause, fox));
                }
            }
        }
    }

    class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            if (EntityFox.this.gr()) {
                return false;
            }
            EntityLiving target = EntityFox.this.ag_();
            return target != null && target.cb() && cJ.test(target) && EntityFox.this.g((Entity)target) > 36.0 && !EntityFox.this.cz() && !EntityFox.this.gU() && !EntityFox.this.bM;
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.B(false);
        }

        @Override
        public void e() {
            EntityLiving target = EntityFox.this.ag_();
            if (target != null && EntityFox.a(EntityFox.this, target)) {
                EntityFox.this.A(true);
                EntityFox.this.z(true);
                EntityFox.this.N().n();
                EntityFox.this.J().a(target, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
            } else {
                EntityFox.this.A(false);
                EntityFox.this.z(false);
            }
        }

        @Override
        public void a() {
            EntityLiving target = EntityFox.this.ag_();
            if (target != null) {
                EntityFox.this.J().a(target, (float)EntityFox.this.ae(), (float)EntityFox.this.ac());
                if (EntityFox.this.g((Entity)target) <= 36.0) {
                    EntityFox.this.A(true);
                    EntityFox.this.z(true);
                    EntityFox.this.N().n();
                } else {
                    EntityFox.this.N().a((Entity)target, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean b() {
            if (!EntityFox.this.gT()) {
                return false;
            }
            EntityLiving target = EntityFox.this.ag_();
            if (target != null && target.cb()) {
                if (target.dh() != target.dg()) {
                    return false;
                }
                boolean isPathClear = EntityFox.a(EntityFox.this, target);
                if (!isPathClear) {
                    EntityFox.this.N().a((Entity)target, 0);
                    EntityFox.this.z(false);
                    EntityFox.this.A(false);
                }
                return isPathClear;
            }
            return false;
        }

        @Override
        public boolean c() {
            EntityLiving target = EntityFox.this.ag_();
            if (target != null && target.cb()) {
                double d2 = EntityFox.this.dN().h;
                return !(d2 * d2 < (double)0.05f && Math.abs(EntityFox.this.ee()) < 15.0f && EntityFox.this.aV() || EntityFox.this.gR());
            }
            return false;
        }

        @Override
        public boolean W_() {
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.t(true);
            EntityFox.this.y(true);
            EntityFox.this.A(false);
            EntityLiving target = EntityFox.this.ag_();
            if (target != null) {
                EntityFox.this.J().a(target, 60.0f, 30.0f);
                Vec3D vec3 = new Vec3D(target.dP() - EntityFox.this.dP(), target.dR() - EntityFox.this.dR(), target.dV() - EntityFox.this.dV()).d();
                EntityFox.this.k(EntityFox.this.dN().b(vec3.g * 0.8, 0.9, vec3.i * 0.8));
            }
            EntityFox.this.N().n();
        }

        @Override
        public void e() {
            EntityFox.this.z(false);
            EntityFox.this.cY = 0.0f;
            EntityFox.this.cZ = 0.0f;
            EntityFox.this.A(false);
            EntityFox.this.y(false);
        }

        @Override
        public void a() {
            EntityLiving target = EntityFox.this.ag_();
            if (target != null) {
                EntityFox.this.J().a(target, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gR()) {
                Vec3D deltaMovement = EntityFox.this.dN();
                if (deltaMovement.h * deltaMovement.h < (double)0.03f && EntityFox.this.ee() != 0.0f) {
                    EntityFox.this.w(MathHelper.i(0.2f, EntityFox.this.ee(), 0.0f));
                } else {
                    double d2 = deltaMovement.i();
                    double d1 = Math.signum(-deltaMovement.h) * Math.acos(d2 / deltaMovement.g()) * 180.0 / 3.1415927410125732;
                    EntityFox.this.w((float)d1);
                }
            }
            if (target != null && EntityFox.this.f((Entity)target) <= 2.0f) {
                EntityFox.this.c(o.a(EntityFox.this.ao()), (Entity)target);
            } else if (EntityFox.this.ee() > 0.0f && EntityFox.this.aV() && (float)EntityFox.this.dN().h != 0.0f && EntityFox.this.ao().a_(EntityFox.this.dK()).a(Blocks.ep)) {
                EntityFox.this.w(60.0f);
                EntityFox.this.g((EntityLiving)null);
                EntityFox.this.B(true);
            }
        }
    }

    class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double speedModifier) {
            super(EntityFox.this, speedModifier);
            this.c = net.minecraft.world.entity.animal.fox.EntityFox$s.b(100);
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.gr() && this.a.ag_() == null) {
                if (EntityFox.this.ao().an() && EntityFox.this.ao().k(this.a.dK())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockPos = this.a.dK();
                return EntityFox.this.ao().ag() && EntityFox.this.ao().k(blockPos) && !((WorldServer)EntityFox.this.ao()).e(blockPos) && this.h();
            }
            return false;
        }

        @Override
        public void d() {
            EntityFox.this.hh();
            super.d();
        }
    }

    class l
    extends PathfinderGoalMeleeAttack {
        public l(double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(EntityFox.this, speedModifier, followingTargetEvenIfNotSeen);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.c(l.a(this.a), (Entity)target);
                EntityFox.this.a(SoundEffects.kV, 1.0f, 1.0f);
            }
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
            super.d();
        }

        @Override
        public boolean b() {
            return !EntityFox.this.gQ() && !EntityFox.this.gr() && !EntityFox.this.cz() && !EntityFox.this.gR() && super.b();
        }
    }

    class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.fox.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.as.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean b() {
            return EntityFox.this.bN == 0.0f && EntityFox.this.bO == 0.0f && EntityFox.this.bP == 0.0f && (this.k() || EntityFox.this.gr());
        }

        @Override
        public boolean c() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.ao().ag() && this.h() && !this.i() && !EntityFox.this.aJ;
        }

        @Override
        public void e() {
            this.d = EntityFox.this.as.a(c);
            EntityFox.this.hh();
        }

        @Override
        public void d() {
            EntityFox.this.x(false);
            EntityFox.this.z(false);
            EntityFox.this.A(false);
            EntityFox.this.t(false);
            EntityFox.this.D(true);
            EntityFox.this.N().n();
            EntityFox.this.K().a(EntityFox.this.dP(), EntityFox.this.dR(), EntityFox.this.dV(), 0.0);
        }
    }

    static class h
    extends PathfinderGoalFollowParent {
        private final EntityFox d;

        public h(EntityFox fox, double speedModifier) {
            super(fox, speedModifier);
            this.d = fox;
        }

        @Override
        public boolean b() {
            return !this.d.hf() && super.b();
        }

        @Override
        public boolean c() {
            return !this.d.hf() && super.c();
        }

        @Override
        public void d() {
            this.d.hh();
            super.d();
        }
    }

    class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int interval) {
            super(EntityFox.this, interval);
        }

        @Override
        public void d() {
            EntityFox.this.hh();
            super.d();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        @Override
        public boolean c() {
            return super.c() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.gr() && !EntityFox.this.gQ() && !EntityFox.this.hf() && EntityFox.this.ag_() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double speedModifier, int searchRange, int verticalSearchRange) {
            super(EntityFox.this, speedModifier, searchRange, verticalSearchRange);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader level, BlockPosition pos) {
            IBlockData blockState = level.a_(pos);
            return blockState.a(Blocks.pg) && blockState.c(BlockSweetBerryBush.c) >= 2 || CaveVines.j_(blockState);
        }

        @Override
        public void a() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.as.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.lb, 1.0f, 1.0f);
            }
            super.a();
        }

        protected void o() {
            if (net.minecraft.world.entity.animal.fox.EntityFox$f.a(EntityFox.this.ao()).U().a(GameRules.F).booleanValue()) {
                IBlockData blockState = EntityFox.this.ao().a_(this.e);
                if (blockState.a(Blocks.pg)) {
                    this.b(blockState);
                } else if (CaveVines.j_(blockState)) {
                    this.a(blockState);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.a(EntityFox.this, state, EntityFox.this.ao(), this.e);
        }

        private void b(IBlockData state) {
            int ageValue = state.c(BlockSweetBerryBush.c);
            state.b(BlockSweetBerryBush.c, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1))) {
                return;
            }
            int i2 = 1 + EntityFox.this.ao().y.a(2) + (ageValue == 3 ? 1 : 0);
            ItemStack itemBySlot = EntityFox.this.a(EnumItemSlot.a);
            if (itemBySlot.f()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.za));
                --i2;
            }
            if (i2 > 0) {
                Block.a(EntityFox.this.ao(), this.e, new ItemStack(Items.za, i2));
            }
            EntityFox.this.a(SoundEffects.CK, 1.0f, 1.0f);
            EntityFox.this.ao().a(this.e, (IBlockData)state.b(BlockSweetBerryBush.c, 1), 2);
            EntityFox.this.ao().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean b() {
            return !EntityFox.this.gr() && super.b();
        }

        @Override
        public void d() {
            this.g = 0;
            EntityFox.this.x(false);
            super.d();
        }
    }

    class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean b() {
            if (!EntityFox.this.a(EnumItemSlot.a).f()) {
                return false;
            }
            if (EntityFox.this.ag_() != null || EntityFox.this.eK() != null) {
                return false;
            }
            if (!EntityFox.this.hi()) {
                return false;
            }
            if (EntityFox.this.ep().a(p.b(10)) != 0) {
                return false;
            }
            List<EntityItem> entitiesOfClass = EntityFox.this.ao().a(EntityItem.class, EntityFox.this.dj().c(8.0, 8.0, 8.0), cH);
            return !entitiesOfClass.isEmpty() && EntityFox.this.a(EnumItemSlot.a).f();
        }

        @Override
        public void a() {
            List<EntityItem> entitiesOfClass = EntityFox.this.ao().a(EntityItem.class, EntityFox.this.dj().c(8.0, 8.0, 8.0), cH);
            ItemStack itemBySlot = EntityFox.this.a(EnumItemSlot.a);
            if (itemBySlot.f() && !entitiesOfClass.isEmpty()) {
                EntityFox.this.N().a((Entity)entitiesOfClass.get(0), (double)1.2f);
            }
        }

        @Override
        public void d() {
            List<EntityItem> entitiesOfClass = EntityFox.this.ao().a(EntityItem.class, EntityFox.this.dj().c(8.0, 8.0, 8.0), cH);
            if (!entitiesOfClass.isEmpty()) {
                EntityFox.this.N().a((Entity)entitiesOfClass.get(0), (double)1.2f);
            }
        }
    }

    class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class<? extends EntityLiving> lookAtType, float lookDistance) {
            super(mob, lookAtType, lookDistance);
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gR() && !EntityFox.this.gU();
        }

        @Override
        public boolean c() {
            return super.c() && !EntityFox.this.gR() && !EntityFox.this.gU();
        }
    }

    class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean b() {
            return EntityFox.this.eK() == null && EntityFox.this.ep().i() < 0.02f && !EntityFox.this.gr() && EntityFox.this.ag_() == null && EntityFox.this.N().l() && !this.i() && !EntityFox.this.gS() && !EntityFox.this.cz();
        }

        @Override
        public boolean c() {
            return this.f > 0;
        }

        @Override
        public void d() {
            this.k();
            this.f = 2 + EntityFox.this.ep().a(3);
            EntityFox.this.x(true);
            EntityFox.this.N().n();
        }

        @Override
        public void e() {
            EntityFox.this.x(false);
        }

        @Override
        public void a() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.J().a(EntityFox.this.dP() + this.c, EntityFox.this.dT(), EntityFox.this.dV() + this.d, EntityFox.this.ae(), EntityFox.this.ac());
        }

        private void k() {
            double d2 = Math.PI * 2 * EntityFox.this.ep().j();
            this.c = Math.cos(d2);
            this.d = Math.sin(d2);
            this.e = this.a(80 + EntityFox.this.ep().a(20));
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        private @Nullable EntityLiving j;
        private @Nullable EntityLiving k;
        private int l;

        public a(Class<EntityLiving> targetType, @Nullable boolean mustSee, boolean mustReach, PathfinderTargetCondition.a selector) {
            super(EntityFox.this, targetType, 10, mustSee, mustReach, selector);
        }

        @Override
        public boolean b() {
            if (this.b > 0 && this.e.ep().a(this.b) != 0) {
                return false;
            }
            WorldServer serverLevel = net.minecraft.world.entity.animal.fox.EntityFox$a.a(EntityFox.this.ao());
            for (EntityReference<EntityLiving> entityReference : EntityFox.this.hd().toList()) {
                EntityLiving livingEntity = entityReference.a(serverLevel, EntityLiving.class);
                if (livingEntity == null) continue;
                this.k = livingEntity;
                this.j = livingEntity.eK();
                int lastHurtByMobTimestamp = livingEntity.eM();
                return lastHurtByMobTimestamp != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void d() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.eM();
            }
            EntityFox.this.a(SoundEffects.kT, 1.0f, 1.0f);
            EntityFox.this.C(true);
            EntityFox.this.hg();
            super.d();
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type variant) {
            super(false);
            this.a = variant;
        }
    }

    abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockPos = BlockPosition.a(EntityFox.this.dP(), EntityFox.this.dj().e, EntityFox.this.dV());
            return !EntityFox.this.ao().k(blockPos) && EntityFox.this.c(blockPos) >= 0.0f;
        }

        protected boolean i() {
            return !net.minecraft.world.entity.animal.fox.EntityFox$d.a(EntityFox.this.ao()).a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.dj().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class c
    implements PathfinderTargetCondition.a {
        @Override
        public boolean test(EntityLiving entity, WorldServer level) {
            EntityHuman player;
            if (entity instanceof EntityFox) {
                return false;
            }
            if (entity instanceof EntityChicken || entity instanceof EntityRabbit || entity instanceof EntityMonster) {
                return true;
            }
            boolean bl = entity instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entity).p() : (!(entity instanceof EntityHuman) || !(player = (EntityHuman)entity).au() && !player.ha()) && !EntityFox.this.j(entity) && !entity.gr() && !entity.cx();
            return bl;
        }
    }
}

