/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class Frog
extends EntityAnimal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Frog>>> cv = ImmutableList.of(SensorType.c, SensorType.f, SensorType.u, SensorType.s, SensorType.v);
    protected static final ImmutableList<MemoryModuleType<?>> cw = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.p, MemoryModuleType.P, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.C, MemoryModuleType.Y, MemoryModuleType.Z, MemoryModuleType.aa, MemoryModuleType.ab});
    private static final DataWatcherObject<Holder<FrogVariant>> cC = DataWatcher.a(Frog.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<OptionalInt> cD = DataWatcher.a(Frog.class, DataWatcherRegistry.u);
    private static final int cE = 5;
    private static final ResourceKey<FrogVariant> cF = FrogVariants.a;
    public final AnimationState cx = new AnimationState();
    public final AnimationState cz = new AnimationState();
    public final AnimationState cA = new AnimationState();
    public final AnimationState cB = new AnimationState();

    public Frog(EntityTypes<? extends EntityAnimal> type, World level) {
        super(type, level);
        this.co = new a(this);
        this.a(PathType.j, 4.0f);
        this.a(PathType.e, -1.0f);
        this.cp = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
    }

    protected BehaviorController.b<Frog> ew() {
        return BehaviorController.a(cw, cv);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return FrogAi.a(this.ew().a(dynamic));
    }

    public BehaviorController<Frog> ev() {
        return super.ev();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        IRegistry<FrogVariant> registry = this.eo().f(Registries.bh);
        builder.a(cC, VariantUtils.a(this.eo(), cF));
        builder.a(cD, OptionalInt.empty());
    }

    public void p() {
        this.az.a(cD, OptionalInt.empty());
    }

    public Optional<Entity> gP() {
        return this.az.a(cD).stream().mapToObj(this.ao()::a).filter(Objects::nonNull).findFirst();
    }

    public void H(Entity tongueTarget) {
        this.az.a(cD, OptionalInt.of(tongueTarget.aA()));
    }

    @Override
    public int ai() {
        return 35;
    }

    @Override
    public int ae() {
        return 5;
    }

    public Holder<FrogVariant> gQ() {
        return this.az.a(cC);
    }

    public void b(Holder<FrogVariant> variant) {
        this.az.a(cC, variant);
    }

    @Override
    public <T> @Nullable T a(DataComponentType<? extends T> component) {
        return component == DataComponents.aS ? Frog.c(component, this.gQ()) : super.a(component);
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        this.a(componentGetter, DataComponents.aS);
        super.a(componentGetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> component, T value) {
        if (component == DataComponents.aS) {
            this.b(Frog.c(DataComponents.aS, value));
            return true;
        }
        return super.b(component, value);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        VariantUtils.a(output, this.gQ());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        VariantUtils.a(input, Registries.bh).ifPresent(this::b);
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("frogBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        profilerFiller.a("frogActivityUpdate");
        FrogAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        if (this.ao().B_()) {
            this.cB.a(this.by() && !this.bB.d(), this.at);
        }
        super.g();
    }

    @Override
    public void a(DataWatcherObject<?> key) {
        if (Entity.aE.equals(key)) {
            EntityPose pose = this.aF();
            if (pose == EntityPose.g) {
                this.cx.a(this.at);
            } else {
                this.cx.a();
            }
            if (pose == EntityPose.i) {
                this.cz.a(this.at);
            } else {
                this.cz.a();
            }
            if (pose == EntityPose.j) {
                this.cA.a(this.at);
            } else {
                this.cA.a();
            }
        }
        super.a(key);
    }

    @Override
    protected void B(float partialTick) {
        float f2 = this.cx.b() ? 0.0f : Math.min(partialTick * 25.0f, 1.0f);
        this.bB.a(f2, 0.4f, this.e_() ? 3.0f : 1.0f);
    }

    @Override
    public void gX() {
        this.ao().a(null, this, SoundEffects.lB, SoundCategory.g, 2.0f, 1.0f);
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        Frog frog = EntityTypes.af.a(level, EntitySpawnReason.e);
        if (frog != null) {
            FrogAi.a(frog, level.G_());
        }
        return frog;
    }

    @Override
    public boolean e_() {
        return false;
    }

    @Override
    public void a_(boolean baby) {
    }

    @Override
    public void a(WorldServer level, EntityAnimal partner) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, partner);
        if (result.isCancelled()) {
            return;
        }
        this.finalizeSpawnChildFromBreeding(level, partner, null, result.getExperience());
        this.ev().a(MemoryModuleType.Z, Unit.a);
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        VariantUtils.a(SpawnContext.a(level, this.dK()), Registries.bh).ifPresent(this::b);
        FrogAi.a(this, level.G_());
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public static AttributeProvider.Builder gR() {
        return EntityAnimal.gW().a(GenericAttributes.x, 1.0).a(GenericAttributes.u, 10.0).a(GenericAttributes.d, 10.0).a(GenericAttributes.D, 1.0);
    }

    @Override
    public @Nullable SoundEffect W() {
        return SoundEffects.lz;
    }

    @Override
    public @Nullable SoundEffect h(DamageSource damageSource) {
        return SoundEffects.lC;
    }

    @Override
    public @Nullable SoundEffect fd() {
        return SoundEffects.lA;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.lF, 0.15f, 1.0f);
    }

    @Override
    public boolean db() {
        return false;
    }

    @Override
    protected int a(double fallDistance, float damageMultiplier) {
        return super.a(fallDistance, damageMultiplier) - 5;
    }

    @Override
    protected void a(Vec3D travelVector, double gravity, boolean isFalling, double previousY) {
        this.a(this.fM(), travelVector);
        this.a(EnumMoveType.a, this.dN());
        this.k(this.dN().c(0.9));
    }

    public static boolean i(EntityLiving entity) {
        EntitySlime slime;
        return (!(entity instanceof EntitySlime) || (slime = (EntitySlime)entity).gR() == 1) && entity.ay().a(TagsEntity.o);
    }

    @Override
    protected NavigationAbstract b(World level) {
        return new c(this, level);
    }

    @Override
    public @Nullable EntityLiving ag_() {
        return this.Q();
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aT);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.cv) && Frog.a(level, pos);
    }

    class a
    extends ControllerLook {
        a(EntityInsentient mob) {
            super(mob);
        }

        @Override
        protected boolean c() {
            return Frog.this.gP().isEmpty();
        }
    }

    static class c
    extends AmphibiousPathNavigation {
        c(Frog mob, World level) {
            super(mob, level);
        }

        @Override
        public boolean b(PathType pathType) {
            return pathType != PathType.k && super.b(pathType);
        }

        @Override
        protected Pathfinder a(int maxVisitedNodes) {
            this.o = new b(true);
            return new Pathfinder(this.o, maxVisitedNodes);
        }
    }

    static class b
    extends AmphibiousNodeEvaluator {
        private final BlockPosition.MutableBlockPosition a = new BlockPosition.MutableBlockPosition();

        public b(boolean prefersShallowSwimming) {
            super(prefersShallowSwimming);
        }

        @Override
        public PathPoint a() {
            return !this.c.by() ? super.a() : this.c(new BlockPosition(MathHelper.c(this.c.dj().a), MathHelper.c(this.c.dj().b), MathHelper.c(this.c.dj().c)));
        }

        @Override
        public PathType a(PathfindingContext context, int x2, int y2, int z2) {
            this.a.d(x2, y2 - 1, z2);
            IBlockData blockState = context.a(this.a);
            return blockState.a(TagsBlock.cg) ? PathType.b : super.a(context, x2, y2, z2);
        }
    }
}

