/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.jspecify.annotations.Nullable;

public class Goat
extends EntityAnimal {
    public static final EntitySize cv = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cC = 2;
    private static final int cD = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> cw = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> cx = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.aG, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.P, MemoryModuleType.L, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.aa});
    public static final int cz = 10;
    public static final double cA = 0.02;
    public static final double cB = (double)0.1f;
    private static final DataWatcherObject<Boolean> cE = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cF = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cG = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private static final boolean cH = false;
    private static final boolean cI = true;
    private static final boolean cJ = true;
    private boolean cK;
    private int cL;

    public Goat(EntityTypes<? extends Goat> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.N().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack p() {
        RandomSource randomSource = RandomSource.a(this.cY().hashCode());
        TagKey<Instrument> tagKey = this.hd() ? InstrumentTags.b : InstrumentTags.a;
        return this.ao().J_().f(Registries.bi).a(tagKey, randomSource).map(holder -> InstrumentItem.a(Items.yM, holder)).orElseGet(() -> new ItemStack(Items.yM));
    }

    protected BehaviorController.b<Goat> ew() {
        return BehaviorController.a(cx, cw);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.ew().a(dynamic));
    }

    public static AttributeProvider.Builder gP() {
        return EntityAnimal.gW().a(GenericAttributes.u, 10.0).a(GenericAttributes.x, 0.2f).a(GenericAttributes.d, 2.0);
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.h(GenericAttributes.d).a(1.0);
            this.gV();
        } else {
            this.h(GenericAttributes.d).a(2.0);
            this.gU();
        }
    }

    @Override
    protected int a(double fallDistance, float damageMultiplier) {
        return super.a(fallDistance, damageMultiplier) - 10;
    }

    @Override
    public SoundEffect W() {
        return this.hd() ? SoundEffects.mL : SoundEffects.mC;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.hd() ? SoundEffects.mO : SoundEffects.mF;
    }

    @Override
    public SoundEffect fd() {
        return this.hd() ? SoundEffects.mM : SoundEffects.mD;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.mT, 0.15f, 1.0f);
    }

    protected SoundEffect gQ() {
        return this.hd() ? SoundEffects.mQ : SoundEffects.mH;
    }

    public @Nullable Goat b(WorldServer level, EntityAgeable partner) {
        Goat goat = EntityTypes.am.a(level, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, level.G_());
            EntityAgeable ageableMob = level.G_().h() ? this : partner;
            boolean flag = ageableMob instanceof Goat && ((Goat)(goat1 = ageableMob)).hd() || level.G_().j() < 0.02;
            goat.x(flag);
        }
        return goat;
    }

    public BehaviorController<Goat> ev() {
        return super.ev();
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("goatBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        profilerFiller.a("goatActivityUpdate");
        GoatAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public int ae() {
        return 15;
    }

    @Override
    public void r(float rotation) {
        int maxHeadYRot = this.ae();
        float f2 = MathHelper.d(this.bC, rotation);
        float f1 = MathHelper.a(f2, (float)(-maxHeadYRot), (float)maxHeadYRot);
        super.r(this.bC + f1);
    }

    @Override
    protected void gX() {
        this.ao().a(null, this, this.hd() ? SoundEffects.mN : SoundEffects.mE, SoundCategory.g, 1.0f, MathHelper.b(this.ao().y, 0.8f, 1.2f));
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aF);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.sk) && !this.e_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent(player.ao(), player, this.dK(), this.dK(), null, itemInHand, Items.sq, hand);
            if (event.isCancelled()) {
                player.cn.b();
                return EnumInteractionResult.e;
            }
            player.a(this.gQ(), 1.0f, 1.0f);
            ItemStack itemStack = ItemLiquidUtil.a(itemInHand, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemStack);
            return EnumInteractionResult.a;
        }
        boolean isFood = this.j(itemInHand);
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a() && isFood) {
            this.gX();
        }
        return interactionResult;
    }

    @Override
    public GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        RandomSource random = level.G_();
        GoatAi.a(this, random);
        this.x(random.j() < 0.02);
        this.h();
        if (!this.e_() && random.i() < 0.1f) {
            DataWatcherObject<Boolean> entityDataAccessor = random.h() ? cF : cG;
            this.az.a(entityDataAccessor, false);
        }
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    @Override
    public EntitySize b(EntityPose pose) {
        return pose == EntityPose.g ? cv.a(this.eE()) : super.b(pose);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("IsScreamingGoat", this.hd());
        output.a("HasLeftHorn", this.gR());
        output.a("HasRightHorn", this.gS());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("IsScreamingGoat", false));
        this.az.a(cF, input.a("HasLeftHorn", true));
        this.az.a(cG, input.a("HasRightHorn", true));
    }

    @Override
    public void b(byte id) {
        if (id == 58) {
            this.cK = true;
        } else if (id == 59) {
            this.cK = false;
        } else {
            super.b(id);
        }
    }

    @Override
    public void d_() {
        this.cL = this.cK ? ++this.cL : (this.cL -= 2);
        this.cL = MathHelper.a(this.cL, 0, 20);
        super.d_();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cE, false);
        builder.a(cF, true);
        builder.a(cG, true);
    }

    public boolean gR() {
        return this.az.a(cF);
    }

    public boolean gS() {
        return this.az.a(cG);
    }

    public boolean gT() {
        boolean hasLeftHorn = this.gR();
        boolean hasRightHorn = this.gS();
        if (!hasLeftHorn && !hasRightHorn) {
            return false;
        }
        DataWatcherObject<Boolean> entityDataAccessor = !hasLeftHorn ? cG : (!hasRightHorn ? cF : (this.as.h() ? cF : cG));
        this.az.a(entityDataAccessor, false);
        Vec3D vec3 = this.dI();
        ItemStack itemStack = this.p();
        double d2 = MathHelper.b(this.as, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.as, 0.3f, 0.7f);
        double d22 = MathHelper.b(this.as, -0.2f, 0.2f);
        EntityItem itemEntity = new EntityItem(this.ao(), vec3.a(), vec3.b(), vec3.c(), itemStack, d2, d1, d22);
        return this.spawnAtLocation((WorldServer)this.ao(), itemEntity) != null;
    }

    public void gU() {
        this.az.a(cF, true);
        this.az.a(cG, true);
    }

    public void gV() {
        this.az.a(cF, false);
        this.az.a(cG, false);
    }

    public boolean hd() {
        return this.az.a(cE);
    }

    public void x(boolean isScreamingGoat) {
        this.az.a(cE, isScreamingGoat);
    }

    public float he() {
        return (float)this.cL / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess level, EntitySpawnReason spawnReason, BlockPosition pos, RandomSource random) {
        return level.a_(pos.e()).a(TagsBlock.co) && Goat.a(level, pos);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.ev();
        brain.a(MemoryModuleType.X, entity.dI());
        brain.b(MemoryModuleType.W);
        brain.b(MemoryModuleType.s);
        brain.b(MemoryModuleType.P);
        brain.a(Activity.r);
    }
}

