/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.golem;

import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.golem.CopperGolemAi;
import net.minecraft.world.entity.animal.golem.CopperGolemOxidationLevels;
import net.minecraft.world.entity.animal.golem.CopperGolemState;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.jspecify.annotations.Nullable;

public class CopperGolem
extends EntityGolem
implements ContainerUser,
IShearable {
    public static final long b = -2L;
    public static final long c = -1L;
    private static final int d = 504000;
    private static final int e = 552000;
    private static final int f = 200;
    private static final int cv = 240;
    private static final float cw = 10.0f;
    private static final float cx = 0.0058f;
    private static final int cy = 60;
    private static final int cz = 100;
    private static final DataWatcherObject<WeatheringCopper.a> cA = DataWatcher.a(CopperGolem.class, DataWatcherRegistry.H);
    private static final DataWatcherObject<CopperGolemState> cB = DataWatcher.a(CopperGolem.class, DataWatcherRegistry.I);
    private @Nullable BlockPosition cC;
    private @Nullable UUID cD;
    public long cE = -1L;
    private int cF = 0;
    private final AnimationState cG = new AnimationState();
    private final AnimationState cH = new AnimationState();
    private final AnimationState cI = new AnimationState();
    private final AnimationState cJ = new AnimationState();
    private final AnimationState cK = new AnimationState();
    public static final EnumItemSlot a = EnumItemSlot.h;

    public CopperGolem(EntityTypes<? extends EntityGolem> type, World level) {
        super(type, level);
        this.N().a(48.0f);
        this.N().e(true);
        this.gz();
        this.a(CopperGolemState.a);
        this.a(PathType.n, 16.0f);
        this.a(PathType.p, 16.0f);
        this.a(PathType.o, -1.0f);
        this.ev().a(MemoryModuleType.ae, this.ep().b(60, 100));
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.E().a(GenericAttributes.x, 0.2f).a(GenericAttributes.D, 1.0).a(GenericAttributes.u, 12.0);
    }

    public CopperGolemState p() {
        return this.az.a(cB);
    }

    public void a(CopperGolemState state) {
        this.az.a(cB, state);
    }

    public WeatheringCopper.a gP() {
        return this.az.a(cA);
    }

    public void a(WeatheringCopper.a weatherState) {
        this.az.a(cA, weatherState);
    }

    public void h(BlockPosition openedChestPos) {
        this.cC = openedChestPos;
    }

    public void gQ() {
        this.cC = null;
    }

    public AnimationState gR() {
        return this.cG;
    }

    public AnimationState gS() {
        return this.cH;
    }

    public AnimationState gT() {
        return this.cI;
    }

    public AnimationState gU() {
        return this.cJ;
    }

    public AnimationState gV() {
        return this.cK;
    }

    protected BehaviorController.b<CopperGolem> ew() {
        return CopperGolemAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return CopperGolemAi.a(this.ew().a(dynamic));
    }

    public BehaviorController<CopperGolem> ev() {
        return super.ev();
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cA, WeatheringCopper.a.a);
        builder.a(cB, CopperGolemState.a);
    }

    @Override
    public void a(ValueOutput output) {
        super.a(output);
        output.a("next_weather_age", this.cE);
        output.a("weather_state", WeatheringCopper.a.f, this.gP());
    }

    @Override
    public void a(ValueInput input) {
        super.a(input);
        this.cE = input.a("next_weather_age", -1L);
        this.a(input.a("weather_state", WeatheringCopper.a.f).orElse(WeatheringCopper.a.a));
    }

    @Override
    protected void a(WorldServer level) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("copperGolemBrain");
        this.ev().a(level, this);
        profilerFiller.c();
        profilerFiller.a("copperGolemActivityUpdate");
        CopperGolemAi.a(this);
        profilerFiller.c();
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (this.ao().B_()) {
            if (!this.gG()) {
                this.gX();
            }
        } else {
            this.a((WorldServer)this.ao(), this.ao().G_(), this.ao().au());
        }
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        WeatheringCopper.a weatherState;
        ItemStack mainHandItem;
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.f() && !(mainHandItem = this.fx()).f()) {
            BehaviorUtil.a((EntityLiving)this, mainHandItem, player.dI());
            this.a(EnumHand.a, ItemStack.l);
            return EnumInteractionResult.a;
        }
        World level = this.ao();
        if (itemInHand.a(Items.tZ) && this.a()) {
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, hand);
            }
            return EnumInteractionResult.a;
        }
        if (level.B_()) {
            return EnumInteractionResult.e;
        }
        if (itemInHand.a(Items.zf) && this.cE != -2L) {
            level.a((Entity)this, 3003, this.dK(), 0);
            this.cE = -2L;
            this.a(player, hand, itemInHand);
            return EnumInteractionResult.b;
        }
        if (itemInHand.a(TagsItem.cb) && this.cE == -2L) {
            level.a(null, this, SoundEffects.aL, this.dB(), 1.0f, 1.0f);
            level.a((Entity)this, 3004, this.dK(), 0);
            this.cE = -1L;
            itemInHand.a(1, (EntityLiving)player, hand.a());
            return EnumInteractionResult.b;
        }
        if (itemInHand.a(TagsItem.cb) && (weatherState = this.gP()) != WeatheringCopper.a.a) {
            level.a(null, this, SoundEffects.aL, this.dB(), 1.0f, 1.0f);
            level.a((Entity)this, 3005, this.dK(), 0);
            this.cE = -1L;
            this.az.a(cA, weatherState.b(), true);
            itemInHand.a(1, (EntityLiving)player, hand.a());
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    private void a(WorldServer level, RandomSource random, long gameTime) {
        if (this.cE != -2L) {
            if (this.cE == -1L) {
                this.cE = gameTime + (long)random.a(504000, 552000);
            } else {
                WeatheringCopper.a weatherState = this.az.a(cA);
                boolean flag = weatherState.equals(WeatheringCopper.a.d);
                if (gameTime >= this.cE && !flag) {
                    WeatheringCopper.a weatherState1 = weatherState.a();
                    boolean flag1 = weatherState1.equals(WeatheringCopper.a.d);
                    this.a(weatherState1);
                    long l2 = this.cE = flag1 ? 0L : this.cE + (long)random.a(504000, 552000);
                }
                if (flag && this.c((World)level)) {
                    this.h(level);
                }
            }
        }
    }

    private boolean c(World level) {
        return level.a_(this.dK()).l() && level.y.i() <= 0.0058f;
    }

    private void h(WorldServer level) {
        IBlockData newState;
        BlockPosition blockPos = this.dK();
        if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockPos, newState = (IBlockData)((IBlockData)Blocks.tD.m().b(CopperGolemStatueBlock.c, CopperGolemStatueBlock.a.values()[this.as.b(0, CopperGolemStatueBlock.a.values().length)])).b(CopperGolemStatueBlock.b, EnumDirection.a(this.ec())))) {
            return;
        }
        level.a(blockPos, newState, 3);
        TileEntity tileEntity = level.c_(blockPos);
        if (tileEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity copperGolemStatueBlockEntity = (CopperGolemStatueBlockEntity)tileEntity;
            copperGolemStatueBlockEntity.a(this);
            this.b(level);
            this.discard(null);
            this.a(SoundEffects.gM);
            if (this.S_()) {
                if (level.U().a(GameRules.k).booleanValue()) {
                    this.o();
                } else {
                    this.r();
                }
            }
        }
    }

    private void gX() {
        switch (this.p()) {
            case a: {
                this.cI.a();
                this.cH.a();
                this.cJ.a();
                this.cK.a();
                if (this.cF == this.at) {
                    this.cG.a(this.at);
                } else if (this.cF == 0) {
                    this.cF = this.at + this.as.b(200, 240);
                }
                if ((float)this.at != (float)this.cF + 10.0f) break;
                this.gY();
                this.cF = 0;
                break;
            }
            case b: {
                this.cG.a();
                this.cF = 0;
                this.cI.a();
                this.cJ.a();
                this.cK.a();
                this.cH.b(this.at);
                break;
            }
            case c: {
                this.cG.a();
                this.cF = 0;
                this.cH.a();
                this.cK.a();
                this.cJ.a();
                this.cI.b(this.at);
                break;
            }
            case d: {
                this.cG.a();
                this.cF = 0;
                this.cH.a();
                this.cI.a();
                this.cK.a();
                this.cJ.b(this.at);
                break;
            }
            case e: {
                this.cG.a();
                this.cF = 0;
                this.cH.a();
                this.cI.a();
                this.cJ.a();
                this.cK.b(this.at);
            }
        }
    }

    public void b(WeatheringCopper.a weatherState) {
        this.a(weatherState);
        this.gW();
    }

    @Override
    public @Nullable GroupDataEntity a(WorldAccess level, DifficultyDamageScaler difficulty, EntitySpawnReason spawnReason, @Nullable GroupDataEntity spawnGroupData) {
        this.gW();
        return super.a(level, difficulty, spawnReason, spawnGroupData);
    }

    public void gW() {
        this.a(SoundEffects.gS);
    }

    private void gY() {
        if (!this.bq()) {
            this.ao().a(this.dP(), this.dR(), this.dV(), this.gZ(), this.dB(), 1.0f, 1.0f, false);
        }
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return CopperGolemOxidationLevels.a(this.gP()).b();
    }

    @Override
    public SoundEffect fd() {
        return CopperGolemOxidationLevels.a(this.gP()).c();
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(CopperGolemOxidationLevels.a(this.gP()).d(), 1.0f, 1.0f);
    }

    private SoundEffect gZ() {
        return CopperGolemOxidationLevels.a(this.gP()).a();
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.75f * this.dk(), 0.0);
    }

    @Override
    public boolean a(ContainerOpenersCounter openersCounter, BlockPosition pos) {
        if (this.cC == null) {
            return false;
        }
        IBlockData blockState = this.ao().a_(this.cC);
        return this.cC.equals(pos) || blockState.b() instanceof BlockChest && blockState.c(BlockChest.d) != BlockPropertyChestType.a && BlockChest.b(this.cC, blockState).equals(pos);
    }

    @Override
    public double ar() {
        return 3.0;
    }

    @Override
    public void shear(WorldServer level, SoundCategory source, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.gT, source, 1.0f, 1.0f);
        this.a(a, ItemStack.l);
        for (ItemStack drop : drops) {
            this.forceDrops = true;
            this.a(level, drop, 1.5f);
            this.forceDrops = false;
        }
    }

    @Override
    public void a(WorldServer level, SoundCategory source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer serverLevel, ItemStack shears) {
        if (!this.a()) {
            return Collections.emptyList();
        }
        ObjectArrayList drops = new ObjectArrayList(1);
        drops.add(this.a(a).v());
        return drops;
    }

    @Override
    public boolean a() {
        return this.cb() && this.a(a).a(TagsItem.cs);
    }

    @Override
    protected void g(WorldServer level) {
        super.g(level);
        this.b(level);
    }

    @Override
    protected boolean actuallyHurt(WorldServer level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(level, damageSource, amount, event);
        if (!damageResult) {
            return false;
        }
        this.a(CopperGolemState.a);
        return true;
    }

    @Override
    public void a(WorldServer level, EntityLightning lightning) {
        super.a(level, lightning);
        UUID uuid = lightning.cY();
        if (!uuid.equals(this.cD)) {
            this.cD = uuid;
            WeatheringCopper.a weatherState = this.gP();
            if (weatherState != WeatheringCopper.a.a) {
                this.cE = -1L;
                this.az.a(cA, weatherState.b(), true);
            }
        }
    }
}

