/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.golem;

import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveTowardsTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalOfferFlower;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalStrollVillageGolem;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalDefendVillage;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;

public class EntityIronGolem
extends EntityGolem
implements IEntityAngerable {
    protected static final DataWatcherObject<Byte> d = DataWatcher.a(EntityIronGolem.class, DataWatcherRegistry.a);
    private static final int e = 25;
    private static final boolean f = false;
    private int cv;
    private int cw;
    private static final UniformInt cx = TimeRange.a(20, 39);
    private long cy;
    private @Nullable EntityReference<EntityLiving> cz;

    public EntityIronGolem(EntityTypes<? extends EntityIronGolem> type, World level) {
        super((EntityTypes<? extends EntityGolem>)type, level);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.cs.a(2, new PathfinderGoalMoveTowardsTarget(this, 0.9, 32.0f));
        this.cs.a(2, new PathfinderGoalStrollVillage((EntityCreature)this, 0.6, false));
        this.cs.a(4, new PathfinderGoalStrollVillageGolem(this, 0.6));
        this.cs.a(5, new PathfinderGoalOfferFlower(this));
        this.cs.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(8, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalDefendVillage(this));
        this.ct.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.ct.a(3, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 5, false, false, (entity, level) -> entity instanceof IMonster && !(entity instanceof EntityCreeper)));
        this.ct.a(4, new PathfinderGoalUniversalAngerReset<EntityIronGolem>(this, false));
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(d, (byte)0);
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.E().a(GenericAttributes.u, 100.0).a(GenericAttributes.x, 0.25).a(GenericAttributes.r, 1.0).a(GenericAttributes.d, 15.0).a(GenericAttributes.D, 1.0);
    }

    @Override
    protected int l(int air) {
        return air;
    }

    @Override
    protected void F(Entity entity) {
        if (entity instanceof IMonster && !(entity instanceof EntityCreeper) && this.ep().a(20) == 0) {
            this.setTarget((EntityLiving)entity, EntityTargetEvent.TargetReason.COLLISION);
        }
        super.F(entity);
    }

    @Override
    public void d_() {
        super.d_();
        if (this.cv > 0) {
            --this.cv;
        }
        if (this.cw > 0) {
            --this.cw;
        }
        if (!this.ao().B_()) {
            this.a((WorldServer)this.ao(), true);
        }
    }

    @Override
    public boolean bL() {
        return this.dN().j() > 2.500000277905201E-7 && this.as.a(5) == 0;
    }

    @Override
    public boolean a(EntityTypes<?> type) {
        return (!this.gR() || type != EntityTypes.cb) && type != EntityTypes.I && super.a(type);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("PlayerCreated", this.gR());
        this.b_(output);
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.y(input.a("PlayerCreated", false));
        this.a(this.ao(), input);
    }

    @Override
    public void c() {
        this.a(cx.a(this.as));
    }

    @Override
    public void b(long absoluteTime) {
        this.cy = absoluteTime;
    }

    @Override
    public long a() {
        return this.cy;
    }

    @Override
    public void a(@Nullable EntityReference<EntityLiving> target) {
        this.cz = target;
    }

    @Override
    public @Nullable EntityReference<EntityLiving> b() {
        return this.cz;
    }

    private float gS() {
        return (float)this.i(GenericAttributes.d);
    }

    @Override
    public boolean c(WorldServer level, Entity target) {
        this.cv = 10;
        level.a((Entity)this, (byte)4);
        float attackDamage = this.gS();
        float f2 = (int)attackDamage > 0 ? attackDamage / 2.0f + (float)this.as.a((int)attackDamage) : attackDamage;
        DamageSource damageSource = this.en().b(this);
        boolean flag = target.a(level, damageSource, f2);
        if (flag) {
            double d2;
            if (target instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)target;
                d2 = livingEntity.i(GenericAttributes.r);
            } else {
                d2 = 0.0;
            }
            double d3 = d2;
            double max = Math.max(0.0, 1.0 - d3);
            target.k(target.dN().b(0.0, (double)0.4f * max, 0.0));
            EnchantmentManager.a(level, target, damageSource);
        }
        this.a(SoundEffects.ps, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean a(WorldServer level, DamageSource damageSource, float amount) {
        Crackiness.a crackiness = this.p();
        boolean flag = super.a(level, damageSource, amount);
        if (flag && this.p() != crackiness) {
            this.a(SoundEffects.pt, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness.a p() {
        return Crackiness.a.a(this.eZ() / this.fq());
    }

    @Override
    public void b(byte id) {
        if (id == 4) {
            this.cv = 10;
            this.a(SoundEffects.ps, 1.0f, 1.0f);
        } else if (id == 11) {
            this.cw = 400;
        } else if (id == 34) {
            this.cw = 0;
        } else {
            super.b(id);
        }
    }

    public int gP() {
        return this.cv;
    }

    public void x(boolean offeringFlower) {
        if (offeringFlower) {
            this.cw = 400;
            this.ao().a((Entity)this, (byte)11);
        } else {
            this.cw = 0;
            this.ao().a((Entity)this, (byte)34);
        }
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return SoundEffects.pv;
    }

    @Override
    public SoundEffect fd() {
        return SoundEffects.pu;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.a(Items.qg)) {
            return EnumInteractionResult.e;
        }
        float health = this.eZ();
        this.d(25.0f);
        if (this.eZ() == health) {
            return EnumInteractionResult.e;
        }
        float f2 = 1.0f + (this.as.i() - this.as.i()) * 0.2f;
        this.a(SoundEffects.pw, 1.0f, f2);
        itemInHand.a(1, (EntityLiving)player);
        return EnumInteractionResult.a;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData block) {
        this.a(SoundEffects.px, 1.0f, 1.0f);
    }

    public int gQ() {
        return this.cw;
    }

    public boolean gR() {
        return (this.az.a(d) & 1) != 0;
    }

    public void y(boolean playerCreated) {
        byte b2 = this.az.a(d);
        if (playerCreated) {
            this.az.a(d, (byte)(b2 | 1));
        } else {
            this.az.a(d, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
    }

    @Override
    public boolean a(IWorldReader level) {
        BlockPosition blockPos = this.dK();
        BlockPosition blockPos1 = blockPos.e();
        IBlockData blockState = level.a_(blockPos1);
        if (!blockState.b((IBlockAccess)level, blockPos1, this) && !this.ao().paperConfig().entities.spawning.ironGolemsCanSpawnInAir) {
            return false;
        }
        for (int i2 = 1; i2 < 3; ++i2) {
            IBlockData blockState1;
            BlockPosition blockPos2 = blockPos.b(i2);
            if (SpawnerCreature.a(level, blockPos2, blockState1 = level.a_(blockPos2), blockState1.y(), EntityTypes.au)) continue;
            return false;
        }
        return SpawnerCreature.a(level, blockPos, level.a_(blockPos), FluidTypes.a.g(), EntityTypes.au) && level.f(this);
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.875f * this.dk(), this.dF() * 0.4f);
    }
}

