/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.golem;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntitySnowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.jspecify.annotations.Nullable;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte b = 16;
    private static final boolean c = true;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> type, World level) {
        super((EntityTypes<? extends EntityGolem>)type, level);
    }

    @Override
    protected void D() {
        this.cs.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.cs.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.cs.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.cs.a(4, new PathfinderGoalRandomLookaround(this));
        this.ct.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, (entity, level) -> entity instanceof IMonster));
    }

    public static AttributeProvider.Builder k() {
        return EntityInsentient.E().a(GenericAttributes.u, 4.0).a(GenericAttributes.x, 0.2f);
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(a, (byte)16);
    }

    @Override
    protected void a(ValueOutput output) {
        super.a(output);
        output.a("Pumpkin", this.p());
    }

    @Override
    protected void a(ValueInput input) {
        super.a(input);
        this.x(input.a("Pumpkin", true));
    }

    @Override
    public boolean fR() {
        return true;
    }

    @Override
    public void d_() {
        super.d_();
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            if (serverLevel.c().a(EnvironmentAttributes.K, this.dI()).booleanValue()) {
                this.a(serverLevel, this.en().d().knownCause(EntityDamageEvent.DamageCause.MELTING), 1.0f);
            }
            if (!serverLevel.U().a(GameRules.F).booleanValue()) {
                return;
            }
            IBlockData blockState = Blocks.ep.m();
            for (int i2 = 0; i2 < 4; ++i2) {
                int floor = MathHelper.c(this.dP() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int floor1 = MathHelper.c(this.dR());
                int floor2 = MathHelper.c(this.dV() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockPos = new BlockPosition(floor, floor1, floor2);
                if (!this.ao().a_(blockPos).l() || !blockState.a((IWorldReader)this.ao(), blockPos) || !CraftEventFactory.handleBlockFormEvent(this.ao(), blockPos, blockState, 3, this)) continue;
                this.ao().a(GameEvent.i, blockPos, GameEvent.a.a(this, blockState));
            }
        }
    }

    @Override
    public void a(EntityLiving target, float distanceFactor) {
        double d2 = target.dP() - this.dP();
        double d1 = target.dT() - (double)1.1f;
        double d22 = target.dV() - this.dV();
        double d3 = Math.sqrt(d2 * d2 + d22 * d22) * (double)0.2f;
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            ItemStack itemStack = new ItemStack(Items.so);
            IProjectile.a(new EntitySnowball(serverLevel, this, itemStack), serverLevel, itemStack, snowball -> snowball.d(d2, d1 + d3 - snowball.dR(), d22, 1.6f, 12.0f));
        }
        this.a(SoundEffects.BY, 1.0f, 0.4f / (this.ep().i() * 0.4f + 0.8f));
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemInHand = player.b(hand);
        if (itemInHand.a(Items.tZ) && this.a()) {
            World world = this.ao();
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                List<ItemStack> drops = this.generateDefaultDrops(serverLevel, itemInHand);
                PlayerShearEntityEvent event = CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemInHand, hand, drops);
                if (event != null) {
                    if (event.isCancelled()) {
                        return EnumInteractionResult.e;
                    }
                    drops = CraftItemStack.asNMSCopy(event.getDrops());
                }
                this.shear(serverLevel, SoundCategory.h, itemInHand, drops);
                this.a(GameEvent.M, (Entity)player);
                itemInHand.a(1, (EntityLiving)player, hand.a());
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void a(WorldServer level, SoundCategory source, ItemStack shears) {
        this.shear(level, source, shears, this.generateDefaultDrops(level, shears));
    }

    @Override
    public List<ItemStack> generateDefaultDrops(WorldServer level, ItemStack shears) {
        ObjectArrayList drops = new ObjectArrayList();
        this.a(level, LootTables.ba, shears, (arg_0, arg_1) -> EntitySnowman.lambda$generateDefaultDrops$2((List)drops, arg_0, arg_1));
        return drops;
    }

    @Override
    public void shear(WorldServer level, SoundCategory source, ItemStack shears, List<ItemStack> drops) {
        level.a(null, this, SoundEffects.BZ, source, 1.0f, 1.0f);
        this.x(false);
        drops.forEach(itemStack -> {
            this.forceDrops = true;
            this.a(level, (ItemStack)itemStack, this.dk());
            this.forceDrops = false;
        });
    }

    @Override
    public boolean a() {
        return this.cb() && this.p();
    }

    public boolean p() {
        return (this.az.a(a) & 0x10) != 0;
    }

    public void x(boolean pumpkinEquipped) {
        byte b2 = this.az.a(a);
        if (pumpkinEquipped) {
            this.az.a(a, (byte)(b2 | 0x10));
        } else {
            this.az.a(a, (byte)(b2 & 0xFFFFFFEF));
        }
    }

    @Override
    public @Nullable SoundEffect W() {
        return SoundEffects.BV;
    }

    @Override
    public @Nullable SoundEffect h(DamageSource damageSource) {
        return SoundEffects.BX;
    }

    @Override
    public @Nullable SoundEffect fd() {
        return SoundEffects.BW;
    }

    @Override
    public Vec3D B() {
        return new Vec3D(0.0, 0.75f * this.dk(), this.dF() * 0.4f);
    }

    private static /* synthetic */ void lambda$generateDefaultDrops$2(List drops, WorldServer ignored, ItemStack stack) {
        drops.add(stack);
    }
}

