/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.happyghast;

import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.happyghast.HappyGhastAi;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class HappyGhast
extends EntityAnimal {
    public static final float cv = 0.2375f;
    public static final int cw = 16;
    public static final int cx = 32;
    public static final int cz = 64;
    public static final int cA = 16;
    public static final int cB = 20;
    public static final int cC = 600;
    public static final int cD = 4;
    private static final int cF = 60;
    private static final int cG = 10;
    public static final float cE = 2.0f;
    private int cH = 0;
    private int cI;
    private static final DataWatcherObject<Boolean> cJ = DataWatcher.a(HappyGhast.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cK = DataWatcher.a(HappyGhast.class, DataWatcherRegistry.k);
    private static final float cL = 1.0f;

    public HappyGhast(EntityTypes<? extends HappyGhast> type, World level) {
        super((EntityTypes<? extends EntityAnimal>)type, level);
        this.cp = new EntityGhast.ControllerGhast(this, true, this::gR);
        this.co = new d();
    }

    private void s(int serverStillTimeout) {
        World world;
        if (this.cI <= 0 && serverStillTimeout > 0 && (world = this.ao()) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.e(this.dP(), this.dR(), this.dV());
            serverLevel.p().a.a(this, ClientboundEntityPositionSyncPacket.a(this));
        }
        this.cI = serverStillTimeout;
        this.he();
    }

    private NavigationAbstract c(World level) {
        return new a(this, level);
    }

    @Override
    protected void D() {
        this.cs.a(3, new c());
        this.cs.a(4, new PathfinderGoalTempt.a((EntityInsentient)this, 1.0, itemStack -> !this.am() && !this.e_() ? itemStack.a(TagsItem.aO) : itemStack.a(TagsItem.aN), false, 7.0));
        this.cs.a(5, new EntityGhast.PathfinderGoalGhastIdleMove(this, 16));
    }

    private void gS() {
        this.cp = new EntityGhast.ControllerGhast(this, true, this::gR);
        this.co = new d();
        this.cr = this.b(this.ao());
        World world = this.ao();
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.d((PathfinderGoal goal) -> true);
            this.D();
            this.ca.b(serverLevel, this);
            this.ca.a();
        }
    }

    private void gT() {
        this.cp = new ControllerMoveFlying(this, 180, true);
        this.co = new ControllerLook(this);
        this.cr = this.c(this.ao());
        this.s(0);
        this.d((PathfinderGoal goal) -> true);
    }

    @Override
    protected void h() {
        if (this.e_()) {
            this.gT();
        } else {
            this.gS();
        }
        super.h();
    }

    public static AttributeProvider.Builder p() {
        return EntityAnimal.gW().a(GenericAttributes.u, 20.0).a(GenericAttributes.G, 16.0).a(GenericAttributes.n, 0.05).a(GenericAttributes.x, 0.05).a(GenericAttributes.o, 16.0).a(GenericAttributes.j, 8.0);
    }

    @Override
    protected float c(float scale) {
        return Math.min(scale, 1.0f);
    }

    @Override
    protected void a(double y2, boolean onGround, IBlockData state, BlockPosition pos) {
    }

    @Override
    public boolean fl() {
        return false;
    }

    @Override
    public void m(Vec3D travelVector) {
        float f2 = (float)this.i(GenericAttributes.n) * 5.0f / 3.0f;
        this.a(travelVector, f2, f2, f2);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader level) {
        if (!level.A(pos)) {
            return 0.0f;
        }
        return level.A(pos.e()) && !level.A(pos.c(2)) ? 10.0f : 5.0f;
    }

    @Override
    public boolean ey() {
        return this.e_() || super.ey();
    }

    @Override
    protected boolean gN() {
        return false;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
    }

    @Override
    public float fD() {
        return 1.0f;
    }

    @Override
    public SoundCategory dB() {
        return SoundCategory.g;
    }

    @Override
    public int S() {
        int i2 = super.S();
        return this.cr() ? i2 * 6 : i2;
    }

    @Override
    public SoundEffect W() {
        return this.e_() ? SoundEffects.me : SoundEffects.ny;
    }

    @Override
    public SoundEffect h(DamageSource damageSource) {
        return this.e_() ? SoundEffects.mg : SoundEffects.nA;
    }

    @Override
    public SoundEffect fd() {
        return this.e_() ? SoundEffects.mf : SoundEffects.nz;
    }

    @Override
    public float fC() {
        return this.e_() ? 1.0f : 4.0f;
    }

    @Override
    public int aj() {
        return 1;
    }

    @Override
    public @Nullable EntityAgeable a(WorldServer level, EntityAgeable partner) {
        return EntityTypes.ai.a(level, EntitySpawnReason.e);
    }

    @Override
    public boolean gY() {
        return false;
    }

    @Override
    public float eE() {
        return this.e_() ? 0.2375f : 1.0f;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(TagsItem.aN);
    }

    @Override
    public boolean e(EnumItemSlot slot) {
        return slot != EnumItemSlot.g ? super.e(slot) : this.cb() && !this.e_();
    }

    @Override
    protected boolean f(EnumItemSlot slot) {
        return slot == EnumItemSlot.g;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult;
        if (this.e_()) {
            return super.b(player, hand);
        }
        ItemStack itemInHand = player.b(hand);
        if (!itemInHand.f() && (interactionResult = itemInHand.a(player, (EntityLiving)this, hand)).a()) {
            return interactionResult;
        }
        if (this.am() && !player.gA()) {
            this.g(player);
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    private void g(EntityHuman player) {
        if (!this.ao().B_()) {
            player.o(this);
        }
    }

    @Override
    protected void q(Entity passenger) {
        if (!this.cr()) {
            this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.ok, this.dB(), 1.0f, 1.0f);
        }
        super.q(passenger);
        if (!this.ao().B_()) {
            if (!this.hf()) {
                this.s(0);
            } else if (this.cI > 10) {
                this.s(10);
            }
        }
    }

    @Override
    protected boolean removePassenger(Entity passenger, boolean suppressCancellation) {
        if (!super.removePassenger(passenger, suppressCancellation)) {
            return false;
        }
        if (!this.ao().B_()) {
            this.s(10);
        }
        if (!this.cr()) {
            this.gE();
            this.ao().a(null, this.dP(), this.dR(), this.dV(), SoundEffects.oj, this.dB(), 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected boolean s(Entity passenger) {
        return this.dn().size() < 4;
    }

    @Override
    public @Nullable EntityLiving dl() {
        EntityLiving entityLiving;
        Entity entity;
        if (this.am() && !this.gR() && (entity = this.do()) instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            entityLiving = player;
        } else {
            entityLiving = super.dl();
        }
        return entityLiving;
    }

    @Override
    protected Vec3D b(EntityHuman player, Vec3D travelVector) {
        float f2 = player.bN;
        float f1 = 0.0f;
        float f22 = 0.0f;
        if (player.bP != 0.0f) {
            float cos = MathHelper.b((double)(player.ee() * ((float)Math.PI / 180)));
            float f3 = -MathHelper.a((double)(player.ee() * ((float)Math.PI / 180)));
            if (player.bP < 0.0f) {
                cos *= -0.5f;
                f3 *= -0.5f;
            }
            f22 = f3;
            f1 = cos;
        }
        if (player.fS()) {
            f22 += 0.5f;
        }
        return new Vec3D(f2, f22, f1).c((double)3.9f * this.i(GenericAttributes.n));
    }

    protected Vec2F i(EntityLiving entity) {
        return new Vec2F(entity.ee() * 0.5f, entity.ec());
    }

    @Override
    protected void a(EntityHuman player, Vec3D travelVector) {
        super.a(player, travelVector);
        Vec2F riddenRotation = this.i(player);
        float yRot = this.ec();
        float f2 = MathHelper.f(riddenRotation.k - yRot);
        float f1 = 0.08f;
        this.a(yRot += f2 * 0.08f, riddenRotation.j);
        this.bC = this.bE = yRot;
        this.ab = this.bE;
    }

    protected BehaviorController.b<HappyGhast> ew() {
        return HappyGhastAi.a();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HappyGhastAi.a(this.ew().a(dynamic));
    }

    @Override
    protected void a(WorldServer level) {
        if (this.e_()) {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a("happyGhastBrain");
            this.ca.a(level, this);
            profilerFiller.c();
            profilerFiller.a("happyGhastActivityUpdate");
            HappyGhastAi.a(this);
            profilerFiller.c();
        }
        this.gV();
        super.a(level);
    }

    @Override
    public void g() {
        super.g();
        if (!this.ao().B_()) {
            if (this.cH > 0) {
                --this.cH;
            }
            this.x(this.cH > 0);
            if (this.cI > 0) {
                if (this.at > 60) {
                    --this.cI;
                }
                this.s(this.cI);
            }
            if (this.hf()) {
                this.s(10);
            }
        }
    }

    @Override
    public void d_() {
        if (!this.ao().B_()) {
            this.c(this.gR());
        }
        super.d_();
        this.hd();
    }

    private int gU() {
        return !this.e_() && this.a(EnumItemSlot.g).f() ? 64 : 32;
    }

    private void gV() {
        if (!this.S_() && !this.cr()) {
            int happyGhastRestrictionRadius = this.gU();
            if (!this.gF() || !this.gC().a(this.dK(), (double)(happyGhastRestrictionRadius + 16)) || happyGhastRestrictionRadius != this.gD()) {
                this.a(this.dK(), happyGhastRestrictionRadius);
            }
        }
    }

    private void hd() {
        World world = this.ao();
        if (world instanceof WorldServer) {
            boolean flag;
            WorldServer serverLevel = (WorldServer)world;
            if (this.cb() && this.bw == 0 && this.fq() != this.eZ() && this.at % ((flag = this.bE() || serverLevel.w(this.dK()) != BiomeBase.Precipitation.a) ? 20 : 600) == 0) {
                this.d(1.0f);
            }
        }
    }

    @Override
    protected void a(DataWatcher.a builder) {
        super.a(builder);
        builder.a(cJ, false);
        builder.a(cK, false);
    }

    private void x(boolean leashHolder) {
        this.az.a(cJ, leashHolder);
    }

    public boolean gP() {
        return this.az.a(cJ);
    }

    private void he() {
        this.az.a(cK, this.cI > 0);
    }

    public boolean gQ() {
        return this.az.a(cK);
    }

    @Override
    public boolean dY() {
        return true;
    }

    @Override
    public Vec3D[] dX() {
        return Leashable.a(this, -0.03125, 0.4375, 0.46875, 0.03125);
    }

    @Override
    public Vec3D B() {
        return Vec3D.c;
    }

    @Override
    public double x() {
        return 10.0;
    }

    @Override
    public double w() {
        return 16.0;
    }

    @Override
    public void v() {
        super.v();
        this.K().g();
    }

    @Override
    public void a(Leashable leashHolder) {
        if (leashHolder.z()) {
            this.cH = 5;
        }
    }

    @Override
    public void a(ValueOutput output) {
        super.a(output);
        output.a("still_timeout", this.cI);
    }

    @Override
    public void a(ValueInput input) {
        super.a(input);
        this.s(input.a("still_timeout", 0));
    }

    public boolean gR() {
        return this.gQ() || this.cI > 0;
    }

    private boolean hf() {
        AxisAlignedBB boundingBox = this.dj();
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.a - 1.0, boundingBox.e - (double)1.0E-5f, boundingBox.c - 1.0, boundingBox.d + 1.0, boundingBox.e + boundingBox.c() / 2.0, boundingBox.f + 1.0);
        for (EntityHuman entityHuman : this.ao().E()) {
            Entity rootVehicle;
            if (entityHuman.au() || (rootVehicle = entityHuman.du()) instanceof HappyGhast || !aabb.d(rootVehicle.dI())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected EntityAIBodyControl I() {
        return new b();
    }

    @Override
    public boolean j(@Nullable Entity entity) {
        return !this.e_() && this.cb() && (this.ao().B_() && entity instanceof EntityHuman && entity.dI().h >= this.dj().e || this.cr() && entity instanceof HappyGhast || this.gR());
    }

    @Override
    public boolean em() {
        return !this.e_();
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dP(), this.dj().e, this.dV());
    }

    class d
    extends ControllerLook {
        d() {
            super(HappyGhast.this);
        }

        @Override
        public void a() {
            if (HappyGhast.this.gR()) {
                float f2 = net.minecraft.world.entity.animal.happyghast.HappyGhast$d.a(HappyGhast.this.ec());
                HappyGhast.this.v(HappyGhast.this.ec() - f2);
                HappyGhast.this.r(HappyGhast.this.ec());
            } else if (this.d > 0) {
                --this.d;
                double d2 = this.e - HappyGhast.this.dP();
                double d1 = this.g - HappyGhast.this.dV();
                HappyGhast.this.v(-((float)MathHelper.d(d2, d1)) * 57.295776f);
                HappyGhast.this.bE = HappyGhast.this.bC = HappyGhast.this.ec();
            } else {
                EntityGhast.a(this.a);
            }
        }

        public static float a(float degrees) {
            float f2 = degrees % 90.0f;
            if (f2 >= 45.0f) {
                f2 -= 90.0f;
            }
            if (f2 < -45.0f) {
                f2 += 90.0f;
            }
            return f2;
        }
    }

    static class a
    extends NavigationFlying {
        public a(HappyGhast ghast, World level) {
            super(ghast, level);
            this.e(false);
            this.a(true);
            this.a(48.0f);
        }

        @Override
        protected boolean a(Vec3D currentPos, Vec3D nextPos) {
            return net.minecraft.world.entity.animal.happyghast.HappyGhast$a.a(this.a, currentPos, nextPos, false);
        }
    }

    class c
    extends PathfinderGoalFloat {
        public c() {
            super(HappyGhast.this);
        }

        @Override
        public boolean b() {
            return !HappyGhast.this.gR() && super.b();
        }
    }

    class b
    extends EntityAIBodyControl {
        public b() {
            super(HappyGhast.this);
        }

        @Override
        public void a() {
            if (HappyGhast.this.cr()) {
                HappyGhast.this.bC = HappyGhast.this.bE = HappyGhast.this.ec();
            }
            super.a();
        }
    }
}

